/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.vo.adx.AdxPriceExploreDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxStatData {
    private static final Logger logger = LoggerFactory.getLogger(AdxStatData.class);

    public static Map<String, Double> updatePriceExploreList(List<AdxPriceExploreDo> priceExploreDoList, Map<String, Double> lastPriceExploreMap, Double minStepSize) {
        double stepSize;
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        if (minStepSize == null) {
            minStepSize = 0.1;
        }
        double upper = 5.0;
        double lower = 0.5;
        if (AssertUtil.isEmpty(lastPriceExploreMap)) {
            logger.info("updatePriceExploreList, lastPriceMap is empty, priceExploreDoList {}", priceExploreDoList);
            retMap.put("1", 1.5);
            retMap.put("2", 1.0);
            retMap.put("3", 1.5);
            retMap.put("4", 2.0);
            retMap.put("5", 2.5);
            retMap.put("6", 3.0);
            retMap.put("idx", 0.0);
            return retMap;
        }
        double bestEffect = Double.NEGATIVE_INFINITY;
        String bestKey = "-1";
        double random = Math.random();
        for (AdxPriceExploreDo levelDo : priceExploreDoList) {
            if (!AssertUtil.isNotEmpty((Object)levelDo) || levelDo.getLevel().equals("1")) continue;
            levelDo.setRandom(random);
            String key = levelDo.getLevel();
            Double effect = AdxPriceExploreDo.getEffect(levelDo);
            if (!AssertUtil.isNotEmpty((Object)effect) || !(effect > bestEffect)) continue;
            bestEffect = effect;
            bestKey = key;
        }
        if (bestKey.equals("-1")) {
            logger.info("updatePriceExploreList, data no confidence {}, {}", priceExploreDoList, lastPriceExploreMap);
            return lastPriceExploreMap;
        }
        double bestFactor = MathUtil.stdwithBoundary((double)lastPriceExploreMap.get(bestKey), (double)lower, (double)upper);
        double oldBase = lastPriceExploreMap.get("1");
        double idx = lastPriceExploreMap.getOrDefault("idx", 0.0);
        idx = bestFactor == oldBase ? (idx += 1.0) : 0.0;
        if (idx >= 4.0) {
            if (bestFactor >= 3.0) {
                stepSize = 5.0 * minStepSize;
                bestFactor -= 2.0 * stepSize;
                idx = 0.0;
            } else {
                stepSize = 2.0 * minStepSize;
            }
        } else {
            stepSize = MathUtil.stdwithBoundary((double)Math.abs(bestFactor - oldBase), (double)minStepSize, (double)1.0);
        }
        retMap.put("1", bestFactor);
        retMap.put("2", bestFactor - 2.0 * stepSize);
        retMap.put("3", bestFactor - stepSize);
        retMap.put("4", bestFactor);
        retMap.put("5", bestFactor + stepSize);
        retMap.put("6", bestFactor + 2.0 * stepSize);
        retMap.put("idx", idx);
        logger.info("updatePriceExploreList, curPriceMap {}, lastPriceMap{}, bestFactor{}, oldBase{}, stepSize{}, priceDoList{}", new Object[]{retMap, lastPriceExploreMap, bestFactor, oldBase, stepSize, priceExploreDoList});
        return retMap;
    }
}

