/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rtbbid2;

import cn.com.duiba.nezha.alg.alg.vo.adx.rtb.AdxRtbBidResultDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxRtbBidRequestDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtbBidAlg {
    private static final Logger logger = LoggerFactory.getLogger(RtbBidAlg.class);

    public static AdxRtbBidResultDo getRtbBidding(AdxRtbBidRequestDo bidRequestDo) {
        AdxRtbBidResultDo ret = new AdxRtbBidResultDo();
        try {
            Double price;
            if (!RtbBidAlg.valid(bidRequestDo) || bidRequestDo.getPriceType() != null && bidRequestDo.getPriceType() == 2) {
                RtbBidAlg.printBidReq(bidRequestDo);
            }
            Long resId = bidRequestDo.getResourceId();
            Long ideaId = bidRequestDo.getIdeaId();
            String appId = bidRequestDo.getAppId();
            Integer bidMode = bidRequestDo.getBidMode();
            Integer groupTag = bidRequestDo.getGroupTag();
            Integer priceType = Optional.ofNullable(bidRequestDo.getPriceType()).orElse(1);
            AdxFactorBaseDo factorBaseDo = Optional.ofNullable(bidRequestDo.getAdxFactorDo()).orElse(new AdxFactorBaseDo());
            double factor = factorBaseDo.getFactor();
            Double cpm = factorBaseDo.getCpm();
            cpm = Optional.ofNullable(cpm).orElse(327.0);
            Double preCtr = bidRequestDo.getPreCtr();
            Double statCtr = factorBaseDo.getStatCtr();
            Double ctr = MathUtil.mean((Double)preCtr, (Double)statCtr, (Double)0.9);
            ctr = Optional.ofNullable(ctr).orElse(0.0269);
            Double preLaunchPv = bidRequestDo.getPreLaunchPv();
            Double statLaunchPv = factorBaseDo.getLaunchPv();
            Double launchPv = MathUtil.mean((Double)preLaunchPv, (Double)statLaunchPv, (Double)0.9);
            launchPv = Optional.ofNullable(launchPv).orElse(1.025);
            Double arpu = factorBaseDo.getArpu();
            arpu = Optional.ofNullable(arpu).orElse(17.9);
            Double preClickValue = bidRequestDo.getClickValue();
            Double statClick = factorBaseDo.getClickValue();
            Double clickValue = MathUtil.mean((Double)preClickValue, (Double)statClick, (Double)0.9);
            clickValue = Optional.ofNullable(clickValue).orElse(18.4);
            Double cpc = priceType == 1 ? bidRequestDo.getCpc() : bidRequestDo.getDirectCpc();
            Double roi = MathUtil.division((Double)bidRequestDo.getRoi(), (Long)100L, (int)3);
            double cpcPrice = 0.0;
            if (priceType == 1) {
                Map<String, Double> priceMap = bidMode == 1 ? RtbBidAlg.getRoiPrice(groupTag, ctr, factor, launchPv, arpu, roi, clickValue) : RtbBidAlg.getCpcPrice(ctr, cpc, factor);
                price = priceMap.getOrDefault("price", 0.0);
                cpcPrice = priceMap.getOrDefault("cpcPrice", 0.0);
            } else {
                price = RtbBidAlg.getDirectPrice(ctr, cpc, factor, roi);
            }
            price = Math.min(price, 50.0 * cpm);
            ret.setAdxAlgoPrice(Math.round(price));
            ret.setCpc(Math.round(cpcPrice));
            ret.setArpu(arpu);
            ret.setClickValue(clickValue);
            ret.setCtr(ctr);
            ret.setPreCtr(preCtr);
            ret.setStatCtr(statCtr);
            ret.setLaunchPv(launchPv);
            ret.setPreLaunchPv(preLaunchPv);
            ret.setStatLaunchPv(statLaunchPv);
            ret.setFactor(factor);
        }
        catch (Exception e) {
            logger.error("RtbBidAlg.getRtbBidding error", (Throwable)e);
        }
        return ret;
    }

    public static Map<String, Double> getCpcPrice(Double ctr, Double cpc, double factor) {
        HashMap<String, Double> priceMap = new HashMap<String, Double>();
        double cpcPrice = cpc * factor * 100.0;
        double price = ctr * cpcPrice * 1000.0;
        priceMap.put("price", price);
        priceMap.put("cpcPrice", cpcPrice);
        return priceMap;
    }

    public static Double getDirectPrice(Double ctr, Double algoCpcPrice, double factor, Double roi) {
        return DataUtil.division((Double)(ctr * algoCpcPrice * factor * 1000.0), (Double)roi, (int)3);
    }

    public static Map<String, Double> getRoiPrice(Integer groupTag, Double ctr, double factor, Double launchPv, Double arpu, Double roi, Double clickValue) {
        HashMap<String, Double> priceMap = new HashMap<String, Double>();
        double cpcPrice = groupTag == 3 || groupTag == 2 ? launchPv * arpu * factor / roi : clickValue * factor / roi;
        double price = ctr * cpcPrice * 1000.0;
        priceMap.put("price", price);
        priceMap.put("cpcPrice", cpcPrice);
        return priceMap;
    }

    public static boolean valid(AdxRtbBidRequestDo bidRequestDo) {
        boolean ret = true;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{bidRequestDo, bidRequestDo.getPreCtr(), bidRequestDo.getPriceType()})) {
            return false;
        }
        if (bidRequestDo.getPriceType() == 1) {
            if (bidRequestDo.getBidMode() == null) {
                return false;
            }
            ret = bidRequestDo.getBidMode() == 1 ? bidRequestDo.getRoi() != null && bidRequestDo.getPreLaunchPv() != null : bidRequestDo.getCpc() != null;
        } else if (bidRequestDo.getPriceType() == 2) {
            ret = bidRequestDo.getDirectCpc() != null && bidRequestDo.getRoi() != null;
        }
        return ret;
    }

    public static void printBidReq(AdxRtbBidRequestDo bidRequestDo) {
        if (Math.random() < 0.1) {
            logger.info("bidRequestDo is not valid, groupTag{}, groupId{}, resourceId{}, ideaId{}, appId{}, priceType{}, bidMode{}, preCtr{}, roi{}, preLaunchPv{}, cpc{}, clickValue{}, directCpc:{}", new Object[]{bidRequestDo.getGroupTag(), bidRequestDo.getGroupId(), bidRequestDo.getResourceId(), bidRequestDo.getIdeaId(), bidRequestDo.getAppId(), bidRequestDo.getPriceType(), bidRequestDo.getBidMode(), bidRequestDo.getPreCtr(), bidRequestDo.getRoi(), bidRequestDo.getPreLaunchPv(), bidRequestDo.getCpc(), bidRequestDo.getClickValue(), bidRequestDo.getDirectCpc()});
        }
    }
}

