/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.kaihu;

import cn.com.duiba.nezha.alg.alg.vo.kaihu.KaiHuInputDo;
import cn.com.duiba.nezha.alg.alg.vo.kaihu.KaiHuResultDo;
import cn.com.duiba.nezha.alg.alg.vo.kaihu.RoiControlModel;
import cn.com.duiba.nezha.alg.alg.vo.kaihu.RoiControlParams;
import cn.com.duiba.nezha.alg.alg.vo.kaihu.RoiParamsDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;

public class KaiHuConvertFilterAlg {
    public static KaiHuResultDo getFilterResult(KaiHuInputDo kaiHuInputDo, RoiControlModel paramsModel) {
        KaiHuResultDo ret = new KaiHuResultDo();
        if (AssertUtil.isEmpty((Object)kaiHuInputDo)) {
            return ret;
        }
        Long slotId = kaiHuInputDo.getSlotId();
        RoiParamsDo roiParams = KaiHuConvertFilterAlg.getRFactor(slotId, paramsModel);
        Double rFactor = roiParams.getRFactor();
        int isBack = KaiHuConvertFilterAlg.getBackResult(kaiHuInputDo, rFactor);
        ret.setIsBack(isBack);
        ret.setRoiParams(roiParams);
        return ret;
    }

    public static RoiParamsDo getRFactor(Long slotId, RoiControlModel paramsModel) {
        RoiControlParams params;
        RoiParamsDo ret = new RoiParamsDo();
        Double rFactor = 1.0;
        String updateTime = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{paramsModel, slotId}) && (params = paramsModel.getRoiControlParams(slotId)).getCConf() != null && params.getCConf().booleanValue()) {
            rFactor = params.getRFactor();
            updateTime = params.getUpdateTime();
            if (rFactor == null) {
                rFactor = 1.0;
            }
        }
        ret.setRFactor(rFactor);
        ret.setUpdateTime(updateTime);
        return ret;
    }

    public static int getBackResult(KaiHuInputDo kaiHuInputDo, Double rFactor) {
        int ret = 0;
        Integer scene = kaiHuInputDo.getScene();
        Integer fee = kaiHuInputDo.getFee();
        Integer aFee = kaiHuInputDo.getAFee();
        Integer chargeType = kaiHuInputDo.getChargeType();
        Integer convertType = kaiHuInputDo.getConvertType();
        Integer subType = kaiHuInputDo.getSubType();
        Integer appTargetFee = kaiHuInputDo.getAppTargetFee();
        Double roi = kaiHuInputDo.getRoi();
        Long mcbIdTag = kaiHuInputDo.getMcbIdTag();
        Long orderSubTypeTag = kaiHuInputDo.getOrderSubTypeTag();
        if (roi == null || roi < 1.0) {
            roi = 1.5;
        }
        double p = 0.0;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{scene, convertType, subType}) && scene.equals(2) && convertType.equals(subType)) {
            if (AssertUtil.isNotEmpty((Object)chargeType) && chargeType.equals(1)) {
                p = 0.3;
            }
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{chargeType, aFee, appTargetFee, rFactor}) && chargeType.equals(2) && aFee > 1 && appTargetFee > 1) {
                p = (double)aFee.intValue() / (0.01 + (double)appTargetFee.intValue() * roi * rFactor);
            }
            ret = KaiHuConvertFilterAlg.getRepeatTimes(p, mcbIdTag, orderSubTypeTag);
        } else if (AssertUtil.isNotEmpty((Object)scene) && scene.equals(3) && AssertUtil.isAllNotEmpty((Object[])new Object[]{fee, appTargetFee, rFactor}) && fee > 1 && appTargetFee > 1) {
            p = (double)fee.intValue() / (0.01 + (double)appTargetFee.intValue() * roi * rFactor);
            ret = KaiHuConvertFilterAlg.getRepeatTimes(p, mcbIdTag, orderSubTypeTag);
        }
        return ret;
    }

    public static int getRepeatTimes(double p, Long mcbIdTag, Long orderSubTypeTag) {
        int ret = 0;
        if (orderSubTypeTag == null || orderSubTypeTag.equals(1L)) {
            ret = KaiHuConvertFilterAlg.getRepeatTimes(p);
        }
        if (ret > 1) {
            ret = 1;
        }
        return ret;
    }

    public static int getFilterResult2(Long advertId, Integer fee, Integer convertType, Integer chargeType, Integer appTargetFee, Double roi) {
        int ret = 0;
        if (roi == null) {
            roi = 1.5;
        }
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{fee, convertType, chargeType, appTargetFee})) {
            double p;
            if (chargeType == 1) {
                p = 0.5;
                ret = KaiHuConvertFilterAlg.getRepeatTimes(p);
            }
            if (fee > 1 && appTargetFee > 1) {
                p = (double)fee.intValue() / (0.01 + (double)appTargetFee.intValue() * roi);
                ret = KaiHuConvertFilterAlg.getRepeatTimes(p);
            }
        }
        if (ret > 1) {
            ret = 1;
        }
        return ret;
    }

    public static int getFilterResult(Long advertId, Integer aFee, Integer convertType, Integer chargeType, Integer subType, Integer appTargetFee, Double roi) {
        int ret = 0;
        if (roi == null) {
            roi = 1.5;
        }
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{aFee, convertType, chargeType, subType, appTargetFee})) {
            double p;
            if (chargeType.equals(1) && convertType.equals(subType)) {
                p = 0.5;
                ret = KaiHuConvertFilterAlg.getRepeatTimes(p);
            }
            if (chargeType.equals(2) && aFee > 1 && appTargetFee > 1 && convertType.equals(subType)) {
                p = (double)aFee.intValue() / (0.01 + (double)appTargetFee.intValue() * roi);
                ret = KaiHuConvertFilterAlg.getRepeatTimes(p);
            }
        }
        if (ret > 1) {
            ret = 1;
        }
        return ret;
    }

    public static int getRepeatTimes(double p) {
        int ret = 0;
        int p1 = (int)Math.floor(p);
        ret += p1;
        double p2 = p - (double)p1;
        if (Math.random() < p2) {
            ++ret;
        }
        return ret;
    }

    public static void main(String[] args) {
        HashMap<Integer, Integer> retMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < 10000; ++i) {
            int ret = KaiHuConvertFilterAlg.getFilterResult(74603L, 1000, 4, 2, 4, 2000, 1.5);
            retMap.put(ret, 1 + retMap.getOrDefault(ret, 0));
        }
        System.out.println("1," + JSON.toJSONString(retMap));
        HashMap<Integer, Integer> retMap2 = new HashMap<Integer, Integer>();
        for (int i = 0; i < 10000; ++i) {
            int ret = KaiHuConvertFilterAlg.getFilterResult2(74603L, 87, 0, 2, 1000, 1.2);
            retMap2.put(ret, 1 + retMap2.getOrDefault(ret, 0));
        }
        System.out.println("2," + JSON.toJSONString(retMap2));
    }
}

