package cn.com.duiba.nezha.alg.alg.dp;

import cn.com.duiba.nezha.alg.alg.vo.dp.DpRcmdDo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityMatchInfo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.DpFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.DpFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.FM;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author lijingzhe
 * @description Dp推荐接口
 * @date 2020/10/27
 */
public class DpRcmder {
    private static final Logger logger = LoggerFactory.getLogger(DpRcmder.class);

    /**
     * @author: lijingzhe
     * @date: 2020/11/5
     * @methodParameters: [dpFeatureDo]
     * @methodReturnType: java.util.Map<java.lang.String,java.lang.String>
     * @description: 特征日志解析，打日志
     */
    public static Map<String, String> featureParse(DpFeatureDo dpFeatureDo) {
        Map<String, String> dpFeatureMap = DpFeatureParse.generateDpFeatureMap(dpFeatureDo);
        Map<String, String> dynamicFeatureMap = DpFeatureParse.generateDpFeatureDynamic(dpFeatureDo);
        dynamicFeatureMap.putAll(dpFeatureMap);
        return dynamicFeatureMap;
    }

    /**
     * @author: lijingzhe
     * @date: 2020/11/5
     * @methodParameters: [model, dpMatchDo, dpFeatureDo]
     * @methodReturnType: cn.com.duiba.nezha.alg.alg.vo.dp.DpRcmdDo
     * @description: 预估本次活动是否参与并决定是否唤起deeplink
     */
    public static Boolean rcmd(FM model, List<ActivityMatchInfo> dpMatchDoList, DpFeatureDo dpFeatureDo) throws Exception{
        return isDeepLink(model, dpMatchDoList, dpFeatureDo);
    }

    /**
     * @author: lijingzhe
     * @date: 2020/11/5
     * @methodParameters: [model, dpMatchDoList, dpFeatureDo]
     * @methodReturnType: java.util.List<cn.com.duiba.nezha.alg.alg.vo.dp.DpRcmdDo>
     * @description: 推荐列表预估分
     */
    public static List<DpRcmdDo> recRank(FM model, List<ActivityMatchInfo> dpMatchDoList, DpFeatureDo dpFeatureDo) throws Exception {

        List<DpRcmdDo> rets = null;
        if(AssertUtil.isAnyEmpty(dpMatchDoList, dpFeatureDo)){
            logger.error("Actcmder recRank input params is null");
            return rets;
        }
        Map<Long, DpRcmdDo> dpMap = new HashMap<>();
        Map<Long, FeatureMapDo> featureDoMap = new HashMap<>();
        Map<String, String> staticFeatureMap = DpFeatureParse.generateDpFeatureMap(dpFeatureDo);
        for (ActivityMatchInfo activityMatchInfo : dpMatchDoList) {
            DpRcmdDo dpRcmdDo = new DpRcmdDo();
            dpRcmdDo.setActivityId(activityMatchInfo.getActivityId());
            dpRcmdDo.setRid(dpFeatureDo.getRid());
            Map<String, String> dynamicFeatureMap = DpFeatureParse.generateDpFeatureDynamic(dpFeatureDo, activityMatchInfo.getActivityId());
            dynamicFeatureMap.putAll(staticFeatureMap);
            dpRcmdDo.setFeatureMap(dynamicFeatureMap);
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(activityMatchInfo.getActivityId(), featureMapDo);
            dpMap.put(activityMatchInfo.getActivityId(), dpRcmdDo);
        }

        // 预估
        Map<Long, Double> preCTR = model.predictsNew(featureDoMap);
        for (Map.Entry<Long, Double> kv : preCTR.entrySet()) {
            Long activityId = kv.getKey();
            DpRcmdDo dpRcmdDo = dpMap.getOrDefault(activityId, new DpRcmdDo());
            dpRcmdDo.setScore(kv.getValue());
            dpMap.put(activityId,dpRcmdDo);
        }

        rets = dpMap.values().stream()
                .sorted(Comparator.comparing(DpRcmdDo::getScore).reversed())
                .collect(Collectors.toList());
        return rets;
    }

    /**
     * @author: lijingzhe
     * @date: 2020/11/5
     * @methodParameters: [activityId, dpRcmdDoList]
     * @methodReturnType: java.lang.Boolean
     * @description: 是否唤醒deepLink: 预出活动ID是否高于广告位平均参与率
     */
    public static Boolean isDeepLink( FM model, List<ActivityMatchInfo> dpMatchDoList, DpFeatureDo dpFeatureDo) throws Exception {
        Boolean ret = false;
        if(AssertUtil.isAnyEmpty(dpMatchDoList, dpFeatureDo)){
            logger.info("slotId {} Actcmder recRank input params is null",dpFeatureDo.getSlotId());
            return ret;
        }

        Map<Long, FeatureMapDo> featureDoMap = new HashMap<>();
        Map<String, String> staticFeatureMap = DpFeatureParse.generateDpFeatureMap(dpFeatureDo);
        Long activityId = dpFeatureDo.getActivityId();

        Double visitPv = 0.0;
        for (ActivityMatchInfo activityMatchInfo : dpMatchDoList) {
            if(activityMatchInfo.getActivityId() == activityId){
                visitPv = activityMatchInfo.getHisRequest().getSlotVal();
                break;
            }
        }

        // 降级走人工的活动ID不在候选集中，需要单独拎出来
        Map<String, String> dynamicFeatureMap = DpFeatureParse.generateDpFeatureDynamic(dpFeatureDo, activityId);
//        dynamicFeatureMap.putAll(staticFeatureMap);
        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(staticFeatureMap);
        featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
        featureDoMap.put(activityId, featureMapDo);
        // 预估
        Map<Long, Double> preCTR = model.predictsNew(featureDoMap);
        // 广告位+活动投放500以上置信，否则取活动
        Double joinRate = visitPv > 500 ? dpFeatureDo.getSlotJoinRate() : dpFeatureDo.getJoinRate();
        // true走活动，false走唤起
        if(preCTR.getOrDefault(activityId, 0.0) > joinRate){
            ret = true;
        }
        return ret;
    }

}
