package cn.com.duiba.nezha.alg.alg.dpa.intercept;

import cn.com.duiba.nezha.alg.alg.constant.DPAConstant;
import cn.com.duiba.nezha.alg.alg.vo.dpa.intercept.InterceptInfoDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.vo.CandidateInterceptDo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.concurrent.PriorityBlockingQueue;

import static cn.com.duiba.nezha.alg.common.model.activityrecommend.WilsonInterval.wilsonCalc;

/**
 * @author lijingzhe
 * @description 插件召回
 * @date 2020/9/2
 */
public class InterceptRecall {

    private static final Logger logger = LoggerFactory.getLogger(InterceptRecall.class);

    public static List<CandidateInterceptDo> match(List<InterceptInfoDo> interceptInfoDoList) {
        return wilMatch(interceptInfoDoList, DPAConstant.INTERCEPT_RECALL_TOPN, DPAConstant.INTERCEPT_RECALL_TOPK);
    }

    /**
     * @author: lijingzhe
     * @date: 2020/9/2
     * @methodParameters: [interceptInfoDos, topN, topK]
     * @methodReturnType: java.util.List<cn.com.duiba.nezha.alg.alg.vo.dpa.intercept.CandidateInterceptDo>
     * @description: 威尔逊置信热度召回
     */
    public static List<CandidateInterceptDo> wilMatch(List<InterceptInfoDo> interceptInfoDos, int topN, int topK) {
        if(AssertUtil.isAnyEmpty(interceptInfoDos)){
            logger.error("InterceptRecall wilMatch input params is null");
            return null;
        }
        List<CandidateInterceptDo> result = new ArrayList<>();
        Comparator<? super CandidateInterceptDo> iComparator = new Comparator<CandidateInterceptDo>() {
            @Override
            public int compare(CandidateInterceptDo o1, CandidateInterceptDo o2) {
                return o2.getMatchScore() > o1.getMatchScore() ? 1 : -1;
            }
        };
        Queue<CandidateInterceptDo> intercepts = new PriorityBlockingQueue<>(interceptInfoDos.size(), iComparator);
        Set<Long> ids = new HashSet<>();
        int supportIdLen = 0;
        for (InterceptInfoDo iid : interceptInfoDos) {
            CandidateInterceptDo candidateInterceptDo = new CandidateInterceptDo();
            candidateInterceptDo.setActivityId(iid.getActivityId());
            candidateInterceptDo.setSlotId(iid.getSlotId());
            candidateInterceptDo.setAppId(iid.getAppId());
            candidateInterceptDo.setCreateTime(iid.getCreateTime());
            candidateInterceptDo.setHisRequest(iid.getHisRequest());
            candidateInterceptDo.setHistClick(iid.getHistClick());
            candidateInterceptDo.setHisCost(iid.getHisCost());
            candidateInterceptDo.setHisEffect(iid.getHisEffect());

            // 冷启动扶持
            if(iid.getHisRequest().getGlobalVal() < DPAConstant.CONFIDENTREQUEST && System.currentTimeMillis() - iid.getCreateTime() < 3 * 24 * 3600 * 100){
                if(Math.random() < DPAConstant.INTERCEPT_PROB && supportIdLen < topK){
                    result.add(candidateInterceptDo);
                    ids.add(iid.getActivityId());
                    supportIdLen += 1;
                }
            }else{
                double w1 = DPAConstant.INTERCEPT_SLOT_WEIGHT * Math.min(iid.getHisRequest().getSlotVal()/DPAConstant.INTERCEPT_SLOT_CONFIDENT_REQUEST, 1);
                double w2 = DPAConstant.INTERCEPT_APP_WEIGHT * (1 - w1) * Math.min(iid.getHisRequest().getAppVal()/DPAConstant.INTERCEPT_APP_CONFIDENT_REQUEST, 1);
                double w3 = DPAConstant.INTERCEPT_GLOBAL_WEIGHT * (1 - w1 - w2) * Math.min(iid.getHisRequest().getGlobalVal()/DPAConstant.INTERCEPT_GLOBAL_CONFIDENT_REQUEST, 1);
                double matchScore = w1 * wilsonCalc(iid.getHisCost().getSlotVal()/100, iid.getHisRequest().getSlotVal()).lowerBound
                        + w2 * wilsonCalc(iid.getHisCost().getAppVal()/100, iid.getHisRequest().getAppVal()).lowerBound
                        + w3 * wilsonCalc(iid.getHisCost().getGlobalVal()/100, iid.getHisRequest().getGlobalVal()).lowerBound;
                candidateInterceptDo.setMatchScore(matchScore);
                intercepts.add(candidateInterceptDo);
            }
        }

        for (int i = 0; i < intercepts.size(); i++) {
            CandidateInterceptDo imd = intercepts.poll();
            if(result.size() < topN && !ids.contains(imd.getActivityId())){
                result.add(imd);
            }
        }
        return result;
    }
}
