/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.flowfilter;

import cn.com.duiba.nezha.alg.alg.adx.flowfilter.AdxFilterTask;
import cn.com.duiba.nezha.alg.alg.adx.flowfilter.AdxFilterTaskPlus;
import cn.com.duiba.nezha.alg.alg.adx.flowfilter.AdxFlowFiltering;
import cn.com.duiba.nezha.alg.alg.adx.flowfilter.LaunchPvFiltering;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFilterInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFlowInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FlowFilterRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FlowFilterResultDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxFlowFilterAlg {
    private static final Logger logger = LoggerFactory.getLogger(AdxFlowFilterAlg.class);

    public static FlowFilterResultDo adxFlowFiltering(FlowFilterRequestDo flowFilterRequestDo) {
        FlowFilterResultDo ret = new FlowFilterResultDo();
        try {
            Integer algoBidMode;
            Integer flowFilterLabel;
            if (AdxFlowFilterAlg.valid(flowFilterRequestDo).booleanValue() && AssertUtil.isAllNotEmpty((Object[])new Object[]{flowFilterLabel = (ret = AdxFlowFiltering.getFlowFiltering(flowFilterRequestDo)).getFlowFilterLabel(), algoBidMode = flowFilterRequestDo.getAlgoBidMode()}) && flowFilterLabel.equals(0) && algoBidMode.equals(2)) {
                FlowFilterResultDo launchPvRet = LaunchPvFiltering.getLaunchPvFiltering(flowFilterRequestDo);
                ret.setFlowFilterLabel(launchPvRet.getFlowFilterLabel());
                ret.setFilterType(launchPvRet.getFilterType());
                ret.setPreLaunchPv(launchPvRet.getPreLaunchPv());
            }
        }
        catch (Exception e) {
            logger.error("AdxFlowFilterAlg.adxFlowFiltering error:" + e);
        }
        return ret;
    }

    public static AdxFilterInfoDo adxFilterTask(AdxFlowInfoDo flowInfo, AdxFilterInfoDo lastFilterInfo) {
        AdxFilterInfoDo ret = null;
        try {
            ret = AdxFilterTask.getFilterInfo(flowInfo, lastFilterInfo);
        }
        catch (Exception e) {
            logger.error("AdxFlowFilterAlg.adxFilterTask error " + e);
        }
        return ret;
    }

    public static AdxFilterInfoDo adxFilterTaskPlus(AdxFlowInfoDo flowInfo, AdxFilterInfoDo lastFilterInfo) {
        AdxFilterInfoDo ret = null;
        try {
            ret = AdxFilterTaskPlus.getFilterInfo(flowInfo, lastFilterInfo);
        }
        catch (Exception e) {
            logger.error("AdxFlowFilterAlg.adxFilterTaskPlus error " + e);
        }
        return ret;
    }

    private static Boolean valid(FlowFilterRequestDo flowFilterRequestDo) {
        Boolean ret = true;
        if (flowFilterRequestDo == null) {
            logger.error("AdxFlowFilterAlg.adxFlowFiltering() input params valid , params flowFilterRequestDo is null");
            return false;
        }
        return ret;
    }
}

