/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.dp;

import cn.com.duiba.nezha.alg.alg.vo.dp.DpRcmdDo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityMatchInfo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.DpFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.DpFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.FM;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DpRcmder {
    private static final Logger logger = LoggerFactory.getLogger(DpRcmder.class);

    public static Map<String, String> featureParse(DpFeatureDo dpFeatureDo) {
        Map dpFeatureMap = DpFeatureParse.generateDpFeatureMap((DpFeatureDo)dpFeatureDo);
        Map dynamicFeatureMap = DpFeatureParse.generateDpFeatureDynamic((DpFeatureDo)dpFeatureDo);
        dynamicFeatureMap.putAll(dpFeatureMap);
        return dynamicFeatureMap;
    }

    public static Boolean rcmd(FM model, List<ActivityMatchInfo> dpMatchDoList, DpFeatureDo dpFeatureDo) throws Exception {
        return DpRcmder.isDeepLink(model, dpMatchDoList, dpFeatureDo);
    }

    public static List<DpRcmdDo> recRank(FM model, List<ActivityMatchInfo> dpMatchDoList, DpFeatureDo dpFeatureDo) throws Exception {
        List<DpRcmdDo> rets = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{dpMatchDoList, dpFeatureDo})) {
            logger.error("Actcmder recRank input params is null");
            return rets;
        }
        HashMap<Long, DpRcmdDo> dpMap = new HashMap<Long, DpRcmdDo>();
        HashMap<Long, FeatureMapDo> featureDoMap = new HashMap<Long, FeatureMapDo>();
        Map staticFeatureMap = DpFeatureParse.generateDpFeatureMap((DpFeatureDo)dpFeatureDo);
        for (ActivityMatchInfo activityMatchInfo : dpMatchDoList) {
            DpRcmdDo dpRcmdDo = new DpRcmdDo();
            dpRcmdDo.setActivityId(activityMatchInfo.getActivityId());
            dpRcmdDo.setRid(dpFeatureDo.getRid());
            Map dynamicFeatureMap = DpFeatureParse.generateDpFeatureDynamic((DpFeatureDo)dpFeatureDo, (Long)activityMatchInfo.getActivityId());
            dynamicFeatureMap.putAll(staticFeatureMap);
            dpRcmdDo.setFeatureMap(dynamicFeatureMap);
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(activityMatchInfo.getActivityId(), featureMapDo);
            dpMap.put(activityMatchInfo.getActivityId(), dpRcmdDo);
        }
        Map preCTR = model.predictsNew(featureDoMap);
        for (Map.Entry kv : preCTR.entrySet()) {
            Long activityId = (Long)kv.getKey();
            DpRcmdDo dpRcmdDo = dpMap.getOrDefault(activityId, new DpRcmdDo());
            dpRcmdDo.setScore((Double)kv.getValue());
            dpMap.put(activityId, dpRcmdDo);
        }
        rets = dpMap.values().stream().sorted(Comparator.comparing(DpRcmdDo::getScore).reversed()).collect(Collectors.toList());
        return rets;
    }

    public static Boolean isDeepLink(FM model, List<ActivityMatchInfo> dpMatchDoList, DpFeatureDo dpFeatureDo) throws Exception {
        Double joinRate;
        Boolean ret = false;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{dpMatchDoList, dpFeatureDo})) {
            logger.info("slotId {} Actcmder recRank input params is null", (Object)dpFeatureDo.getSlotId());
            return ret;
        }
        HashMap<Long, FeatureMapDo> featureDoMap = new HashMap<Long, FeatureMapDo>();
        Map staticFeatureMap = DpFeatureParse.generateDpFeatureMap((DpFeatureDo)dpFeatureDo);
        Long activityId = dpFeatureDo.getActivityId();
        Double visitPv = 0.0;
        for (ActivityMatchInfo activityMatchInfo : dpMatchDoList) {
            if (activityMatchInfo.getActivityId() != activityId.longValue()) continue;
            visitPv = activityMatchInfo.getHisRequest().getSlotVal();
            break;
        }
        Map dynamicFeatureMap = DpFeatureParse.generateDpFeatureDynamic((DpFeatureDo)dpFeatureDo, (Long)activityId);
        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(staticFeatureMap);
        featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
        featureDoMap.put(activityId, featureMapDo);
        Map preCTR = model.predictsNew(featureDoMap);
        Double d = joinRate = visitPv > 500.0 ? dpFeatureDo.getSlotJoinRate() : dpFeatureDo.getJoinRate();
        if (preCTR.getOrDefault(activityId, 0.0) > joinRate) {
            ret = true;
        }
        return ret;
    }
}

