package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxIdeaFeatureDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxBidRet;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxRecallDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.IdeaUnitDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.AdxFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

public class AdxRecommend {

    private static final Logger logger = LoggerFactory.getLogger(AdxRecommend.class);

    /**
     * 1.融合可投创意素材、优选素材、新素材
     * @param adIdeaDos 可投创意计划
     * @param recallDoMap 非dpa召回集
     * @param dpaRecallDoMap    非dpa召回集
     */
    public static void needPreIdeaId(List<AdIdeaDo> adIdeaDos, Map<Long, AdxRecallDo> recallDoMap, Map<Long, AdxRecallDo> dpaRecallDoMap) {

        if(AssertUtil.isAnyEmpty(adIdeaDos, recallDoMap, dpaRecallDoMap)) {
            logger.warn("AdxRecommend.needPreIdeaId params not valid");
            return;
        }

        for (AdIdeaDo adIdeaDo : adIdeaDos) {
            if(adIdeaDo == null || adIdeaDo.getUnitPutType() == 1) {continue;}    //人工创意不作创意素材召回
            Long styleId = adIdeaDo.getStyleId();
            AdxRecallDo adxRecallDo = adIdeaDo.isDpa() ? dpaRecallDoMap.get(styleId) : recallDoMap.get(styleId);
            Set<Long> recallSet = AdxRecallDo.getRecallSet(adxRecallDo);
            List<IdeaUnitDo> ideaUnitDos = adIdeaDo.getIdeaUnitDos().stream().filter(s -> recallSet.contains(s.getIdeaUnitId())).collect(Collectors.toList());
            adIdeaDo.setIdeaUnitDos(ideaUnitDos);
        }
    }

    /**
     * 2.特征生成，当前在algo-engine已存在特征生成逻辑，建议直接复用
     * cn.com.duiba.tuia.algo.engine.adx.builder.AdxBidBuilder#buildAdxIdeaFeatureDo
     * cn.com.duiba.tuia.algo.engine.adx.service.AdxRTBIdeaChoiceServiceImpl#getAdxFeatureDo
     *
     */
    public static Map<FeatureIndex, FeatureMapDo> getFeatureMap(List<AdxIdeaFeatureDo> adxIdeaFeatureDos, AdxFeatureDo adxFeatureDo) {
        Map<FeatureIndex, FeatureMapDo> featureMap = new HashMap<>();

        //1 非创意特征：静态特征解析
        Map<String, String> staticFeatureMap = AdxFeatureParse.generateFeatureMapStatic(adxFeatureDo);

        //2 创意特征：动态特征解析
        if (AssertUtil.isEmpty(adxIdeaFeatureDos)) {
            return featureMap;
        }
        for (AdxIdeaFeatureDo ideaDo : adxIdeaFeatureDos) {
            Long ideaId = ideaDo.getIdeaId();
            Long ideaUnitId = ideaDo.getIdeaUnitId();
            Long materialId = AdxStatData.nullToDefault(ideaDo.getMaterialId(), -1L);
            FeatureIndex featureIndex = new FeatureIndex(ideaId, ideaUnitId);

            AdxFeatureDo dynamicDo = new AdxFeatureDo();
            dynamicDo.setIdeaId(ideaId); // 创意ID f3010010
            dynamicDo.setButtonText(ideaDo.getButtonText()); // 按钮文字 f3010020
            dynamicDo.setIconH(ideaDo.getIconH()); // 创意图标高 f3010030
            dynamicDo.setIconW(ideaDo.getIconW()); // 创意图标宽 f3010040
            dynamicDo.setMjPicType(ideaDo.getMjPicType()); // 规格类型 f3010050
            dynamicDo.setIdeaPicH1(ideaDo.getIdeaPicH1()); // 创意图片高1 f3010060
            dynamicDo.setIdeaPicW1(ideaDo.getIdeaPicW1()); // 创意图片宽1 f3010070
            dynamicDo.setIdeaPicH2(ideaDo.getIdeaPicH2()); // 创意图片高2 f3010080
            dynamicDo.setIdeaPicW2(ideaDo.getIdeaPicW2()); // 创意图片宽2 f3010090
            dynamicDo.setIdeaPicH3(ideaDo.getIdeaPicH3()); // 创意图片高3 f3010100
            dynamicDo.setIdeaPicW3(ideaDo.getIdeaPicW3()); // 创意图片宽3 f3010110
            dynamicDo.setIdeaPicNum(ideaDo.getIdeaPicNum()); // 创意图片个数 f3010120
            dynamicDo.setStyleStandard(ideaDo.getStyleStandard()); // 广告样式规格 f3010130
            dynamicDo.setIdeaType(ideaDo.getIdeaType()); // 互动创意类型 f3010140
            dynamicDo.setPictureType(ideaDo.getPictureType()); //素材图片类型（1=图片 3=视频）f3030000
            dynamicDo.setMaterialId(materialId);
            dynamicDo.setPictureMaterialDo(ideaDo.getPictureMaterialDo()); //创意图片素材特征
            dynamicDo.setVideoMaterialDo(ideaDo.getVideoMaterialDo()); //创意视频素材特征

            //创意活动参与数据
            dynamicDo.setIdeaActAccCntDay(ideaDo.getIdeaActAccCntDay());
            dynamicDo.setIdeaActJoinCntDay(ideaDo.getIdeaActJoinCntDay());
            dynamicDo.setIdeaActAccCntWeek(ideaDo.getIdeaActAccCntWeek());
            dynamicDo.setIdeaActJoinCntWeek(ideaDo.getIdeaActJoinCntWeek());

            dynamicDo.setActIdeaActAccCntDay(ideaDo.getActIdeaActAccCntDay());
            dynamicDo.setActIdeaActJoinCntDay(ideaDo.getActIdeaActJoinCntDay());
            dynamicDo.setActIdeaActAccCntWeek(ideaDo.getActIdeaActAccCntWeek());
            dynamicDo.setActIdeaActJoinCntWeek(ideaDo.getActIdeaActJoinCntWeek());

//            //创意+分媒体行为特征
//            AdxStatsDo ideaAppStats = ideaAppStatsList.get(ideaId);
//            AdxIndexStatsDo ideaApp1DayInfo = AdxStatData.getAdxTimeIndex(ideaAppStats, "1day");
//            dynamicDo.setIdeaAppExpCntDay(ideaApp1DayInfo.getExpCnt()); //创意+百度appId 当天曝光次数
//            dynamicDo.setIdeaAppClickCntDay(ideaApp1DayInfo.getClickCnt()); //创意+百度appId 当天点击次数
//            dynamicDo.setIdeaAppAdCostDay(ideaApp1DayInfo.getAdvertConsume()); //创意+百度appId 当天广告消耗

            Map<String, String> dynamicFeatureMap = AdxFeatureParse.generateFeatureMapDynamic(dynamicDo, adxFeatureDo);

            //3 封装创意素材特征集合
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMap.put(featureIndex, featureMapDo);
        }

        return featureMap;
    }


    /**
     * 3.预估ctr、预估每pv发券
     */
    public static Map<FeatureIndex, Double> predict(Map<FeatureIndex, FeatureMapDo> featureMap,Model model, PredictType predictType) throws Exception {

        Map<FeatureIndex, Double> ret = new HashMap<>();

        if(AssertUtil.isAnyEmpty(featureMap, model, predictType)) {
            logger.warn("AdxRecommend.predict params is not valid");
            return ret;
        }

        if(predictType == PredictType.CTR) {
            ret = model.predictCtr(featureMap);
        }else if(predictType == PredictType.PVLAUNCH) {
            ret = model.predictLaunchPv(featureMap);
        }
        return ret;
    }

    /**
     * 4.粗排
     * 根据ctr排序，为每个计划选出TOP N创意
     * @param adIdeaDos
     * @param preCtrMap
     */
    public static void rawRank(List<AdIdeaDo> adIdeaDos, Map<FeatureIndex, Double> preCtrMap, Integer limitSize) {

        try{
            for(AdIdeaDo adIdeaDo : adIdeaDos) {
                Long adIdeaId = adIdeaDo.getIdeaId();
                List<IdeaUnitDo> ideaUnitDos =  adIdeaDo.getIdeaUnitDos()
                        .stream()
                        .sorted(Comparator.comparing(ideaUnitDo -> {
                            Long ideaUnitId = ((IdeaUnitDo)ideaUnitDo).getIdeaUnitId();
                            FeatureIndex featureIndex = new FeatureIndex(adIdeaId, ideaUnitId);
                            Double preCtr = preCtrMap.getOrDefault(featureIndex, 0D);
                            return preCtr;
                        }).reversed()).limit(limitSize)
                        .collect(Collectors.toList());
                adIdeaDo.setIdeaUnitDos(ideaUnitDos);
            }
        }catch (Exception e) {
            logger.error("AdxRecommend.rawRank error", e);
        }
    }

    /**
     * 6.出价
     */
    public static List<AdxBidRet> bidding(List<AdIdeaDo> adIdeaDos, AdxFactorDo adxFactorDo, String appId) {

        List<AdxBidRet> adxBidRets = null;

        try {
            adxBidRets = adIdeaDos.stream().map(adIdeaDo -> {
                Long ideaId = adIdeaDo.getIdeaId();
                Long resId = adIdeaDo.getResId();
                AdxFactorBaseDo factorBaseDo = adxFactorDo.getFactorBaseDo(resId, ideaId, appId);
                return AdxBid.buildAdxBidReq(adIdeaDo, factorBaseDo, appId);
            }).flatMap(Collection::stream).map(AdxBid :: bid).collect(Collectors.toList());
        }catch (Exception e) {
            logger.error("AdxRecommend.bidding", e);
        }

        return adxBidRets;
    }

    /**
     * 7.精排
     */
    public static List<AdxBidRet> fineRank(List<AdxBidRet> adxBidRets) {

        return adxBidRets.stream().sorted(Comparator.comparing(AdxBidRet :: getAdxAlgoPrice).reversed()).collect(Collectors.toList());
    }

    /**
     * 8.定时任务--离线召回
     * cn.com.duiba.nezha.alg.alg.adx.rcmd.AdxMaterialRecallAlg#adxMaterialRecall(cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxMaterialRecallReqDo)
     */

    /**
     * 9.定时任务--维稳
     * cn.com.duiba.nezha.alg.alg.adx.rtbbid2.AdxRoiFactor#run(cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorReqDo)
     */



}
