package cn.com.duiba.nezha.alg.alg.vo.adx.pd;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;


/**
 * 创意推荐出参对象
 */

@Data
public class AdxIdeaRcmdResultDo implements Serializable {

    private static final long serialVersionUID = -1648953353569010809L;

    /**
     * 推荐创意
     */
    private Long ideaId;

    /**
     * 推荐素材--创意推荐3.0
     */
    private Long materialId;

    /**
     * 创意+素材 点击率-预估
     */
    private Double preCtr;

    /**
     * 创意+素材 点击率-统计(近20min)
     */
    private Double statCtr;

    /**
     * 创意+素材 点击价值-预估(TF模型)
     */
    private Double preClickValue;

    /**
     * 创意+素材 点击价值-统计(近20min，分/单次点击)
     */
    private Double statClickValue;

    /**
     * 资源位统计CTR(近20min)
     */
    private Double statCtrResource;

    /**
     * 资源位统计点击价值(近20min，分/单次点击)
     */
    private Double statClickValueResource;

    /**
     * 创意素材特征字段
     */
    private Map<String,String> ideaFeatureMap;

    /**
     * 候选创意得分集合--创意推荐2.0
     */
    private String ideaScoreMap;

    /**
     * 模型融合收益--创意推荐2.0
     */
    private Double mergeRpm;

    /**
     * 模型预估收益--创意推荐2.0
     */
    private Double pRpm;

    /**
     * 模型统计收益--创意推荐2.0
     */
    private Double sRpm;

    /**
     * 放弃原因类型
     */
    private Long giveUpType;


    /**
     * 创意+百度appId 统计ctr
     */
    private Double ideaAppStatCtr;

    /**
     * 创意+百度appId 统计点击价值
     */
    private Double ideaAppStatCva;

    /**
     * 资源位+百度appId 统计ctr
     */
    private Double resoAppStatCtr;

    /**
     * 资源位+百度appId 统计点击价值
     */
    private Double resoAppStatCva;

}
