package cn.com.duiba.nezha.alg.alg.alg;

import cn.com.duiba.nezha.alg.alg.bidding.AutoBidding;
import cn.com.duiba.nezha.alg.alg.vo.AutoBiddingDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;

import java.util.List;

public class AutoBiddingAlg {


    /**
     * OCPA-分媒体自动目标转化出价
     *
     * @param autoBiddingDo
     * @return
     */
    public static AutoBiddingDo getFactor(AutoBiddingDo autoBiddingDo) {

        return AutoBidding.getFactor(autoBiddingDo);

    }


    /**
     * OCPA-分媒体自动目标转化出价-批量接口
     *
     * @param autoBiddingDoList
     * @return
     */
    public static List<AutoBiddingDo> getFactorBatch(List<AutoBiddingDo> autoBiddingDoList) {

        if (AssertUtil.isNotEmpty(autoBiddingDoList)) {
            autoBiddingDoList.stream().forEach(autoBiddingDo -> AutoBidding.getFactor(autoBiddingDo));
        }
        return autoBiddingDoList;

    }

}
