package cn.com.duiba.nezha.alg.alg.basepricecontrol;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;


public class BasePriceControl2 {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(BasePriceControl2.class);

    /**
     *
     * @param basePriceInfo
     * @param fee
     * @param params
     * @return
     */
    public static Double basePriceProb(BasePriceInfo basePriceInfo, Long fee, BasePriceParams2 params) {

        Double prob = 0.5;
        Double alpha = params.alpha;//0.1
        Double beta1 = params.beta1;//0.3
        Double beta2 = params.beta2;//4
        Double beta3 = params.beta3;//2


        if (AssertUtil.isAnyEmpty(basePriceInfo,fee)) {
            return prob;
        }

        if (Math.random()<0.001) {
            logger.info("params basePriceParams2:{}", params);}

        try {
            //  计算底价发券占比
            Map<String,Double> ratio = getBasePriceRatio(basePriceInfo);

            Double ratio5 = ratio.get("level5");
            Double ratio10 = ratio.get("level10");

            Double factor = MathBase.noiseSmoother(ratio5 * beta2 + ratio10 * beta3,0.01,0.4);

            prob = alpha + (1 - Math.min(fee,15.0)/15.0) * beta1 + factor;

            prob = DataUtil.formatDouble(prob, 3);

        } catch (Exception e) {
            logger.warn("getBasePriceRatio happend error,basePriceInfo={}", JSON.toJSONString(basePriceInfo), e);
        }

        return prob;
    }



    public static Map<String,Double> getBasePriceRatio(BasePriceInfo basePriceInfo){

        Map<String,Double> ret = new HashMap<>();
        //配置底价发券占比
        Double orientLevel5Ratio = 0.0;
        Double orientLevel10Ratio = 0.0;

        if (basePriceInfo.orientLaunchToday != null && basePriceInfo.orientLaunchToday > 0) {
            orientLevel5Ratio = (double) basePriceInfo.orientLevel5PriceLaunchToday / (double) basePriceInfo.orientLaunchToday;
            orientLevel10Ratio = (double) basePriceInfo.orientLevel10PriceLaunchToday / (double) basePriceInfo.orientLaunchToday;
        }

        ret.put("level5",orientLevel5Ratio);
        ret.put("level10",orientLevel10Ratio);

        return ret;
    }



    /**
     *
     * @param basePriceInfoMap
     * @param finalFeeMap
     * @param basePriceParams
     * @param <T>
     * @return
     */
    public static <T> Map<T, BasePriceResultNew> isGiveUp(Map<T, BasePriceInfo> basePriceInfoMap,
                                                    Map<T, Long> finalFeeMap,
                                                    BasePriceParams2 basePriceParams) {

        Map<T, BasePriceResultNew> ret = new HashMap<>();

        if (AssertUtil.isAnyEmpty(basePriceInfoMap)){
            return ret;
        }
        for (Map.Entry<T, BasePriceInfo> entry : basePriceInfoMap.entrySet()) {
            T key = entry.getKey();
            BasePriceInfo basePriceInfo = entry.getValue();
            Long finalFee = finalFeeMap.get(key);

            Double prob = basePriceProb(basePriceInfo,finalFee,basePriceParams);

            Random r = new Random();
            Double x = r.nextDouble();
            Boolean giveUp = false;
            if (finalFee <= 10 && x <= prob) {
                giveUp = true;
            }
            BasePriceResultNew result = new BasePriceResultNew();
            result.setGiveUpProb(prob);
            result.setIsGiveUp(giveUp);
            ret.put(key, result);

        }
        return ret;
    }

}

