package cn.com.duiba.nezha.alg.alg.recall.filter;

import cn.com.duiba.nezha.alg.alg.recall.data.AdInputDto;
import cn.com.duiba.nezha.alg.alg.recall.params.FilterParam;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

//给向量化召回通道选召回池
@Slf4j
public class VectorFilter {

    public static List<AdInputDto> filter(List<AdInputDto> adInputDtos, FilterParam filterParam) {
        List<AdInputDto> vectorRecallPool=new ArrayList<>();
        for (AdInputDto ad : adInputDtos) {
            if (filterParam.getVectorActiveReleaseTarget().contains(ad.getReleaseTarget()) && filterParam.getVectorActiveTrade().contains(ad.getNewTradeTagId())) {
                vectorRecallPool.add(ad);
            }
        }
        return vectorRecallPool;
    }

    public static void main(String[] args) {
        String pkStr="73672_178993,71121_173168,65521_176061,68810_178437,49829_178811,73041_177565,"+
                "67320_177930,67320_178039,68837_178357,62556_177938,67320_179069,72917_177183,73524_0,72764_177427,68810_177405," +
                "68810_178808,67320_178976,72260_178946,73639_0,73526_0,73363_0,72917_177492,68810_173191,68810_175292,72093_177812";
        List<String> strList= Arrays.asList(pkStr.split(","));
        List<AdInputDto> adInputDtos=new ArrayList<>();
        for (String s : strList) {
            AdInputDto ad=new AdInputDto();
            ad.setAdPkOnce(s);
            ad.setReleaseTarget(Math.random()>0.5?1:4);
            ad.setNewTradeTagId("15");
            adInputDtos.add(ad);
        }
        FilterParam f=new FilterParam();
        List<AdInputDto> a = VectorFilter.filter(adInputDtos, f);
        System.out.println(a);

    }
}
