package cn.com.duiba.nezha.alg.alg.title;

import cn.com.duiba.nezha.alg.alg.vo.title.FilterActTitleDo;
import cn.com.duiba.nezha.alg.alg.vo.title.PreSelectActTitleDo;
import cn.com.duiba.nezha.alg.alg.vo.title.RecallActTitleDo;
import cn.com.duiba.nezha.alg.alg.vo.title.RecallActTitleInfoDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

public class ActTitleRecaller {

    private static final Logger logger = LoggerFactory.getLogger(ActTitleRecaller.class);


    /**
     * 召回
     *
     * @param filterActTitleDoList
     * @param preSelectActTitleDoList
     * @return
     */

    public static RecallActTitleDo recall(List<FilterActTitleDo> filterActTitleDoList,
                                          List<PreSelectActTitleDo> preSelectActTitleDoList, boolean hasSubTitle) {
        RecallActTitleDo ret = null;

        List<RecallActTitleInfoDo> recallActTitleInfoDoList = new ArrayList<>();

        Set<Long> activityTitleIdSet = new HashSet<>();  //主标题集合
        Set<Long> activitySubTitleIdSet = new HashSet<>(); //副标题集合


        // 参数准备及合法校验

        if (AssertUtil.isEmpty(preSelectActTitleDoList)) {
            preSelectActTitleDoList = new ArrayList<>();
        }

        if (AssertUtil.isEmpty(filterActTitleDoList)) {
            logger.error("ActTitleRecaller.recall,input invalid,filterActTitleDoList is null");
            return ret;
        }


        // 海选 分组

        List<PreSelectActTitleDo> preSelectActTitleDoLastList = getLastSelectTitle(preSelectActTitleDoList);

//        System.out.println(JSON.toJSONString(preSelectActTitleDoLastList));

        int preSize = preSelectActTitleDoLastList.size();

        Map<String, PreSelectActTitleDo> selectMap = new HashMap<>();

        Map<Long, Long> selectMainTitleMap = new HashMap<>();
        Map<Long, Long> selectSubTitleMap = new HashMap<>();

        for (int i = 0; i < preSelectActTitleDoLastList.size(); i++) {

            PreSelectActTitleDo preSelectActTitleDo = preSelectActTitleDoLastList.get(i);

            if (preSelectActTitleDo != null) {
                Integer type = preSelectActTitleDo.getType();
                Long activityTitleId = preSelectActTitleDo.getActivityTitleId();
                Long activitySubTitleId = preSelectActTitleDo.getActivitySubTitleId();


                if (!selectValid(preSelectActTitleDo)) {
                    logger.warn("ActTitleRecaller.getTypeKey input invalid," + JSON.toJSONString(preSelectActTitleDo));
                    continue;
                }

                String key = getTypeKey(type, activityTitleId, activitySubTitleId);

                selectMap.put(key, preSelectActTitleDo);

                selectMainTitleMap.put(activityTitleId, selectMainTitleMap.getOrDefault(activityTitleId, 1L) + 1L);

                selectSubTitleMap.put(activitySubTitleId, selectSubTitleMap.getOrDefault(activitySubTitleId, 1L) + 1L);


            }

        }


        // 过滤：海选 || 新增
        for (int i = 0; i < filterActTitleDoList.size(); i++) {

            // 对象准备
            RecallActTitleInfoDo recallActTitleInfoDo = new RecallActTitleInfoDo();

            FilterActTitleDo filterActTitleDo = filterActTitleDoList.get(i);
            if (filterActTitleDo != null) {

                recallActTitleInfoDo.setActivityId(filterActTitleDo.getActivityId());
                recallActTitleInfoDo.setActivityPage(filterActTitleDo.getActivityPage());

                recallActTitleInfoDo.setActivityTitleId(filterActTitleDo.getActivityTitleId());
                recallActTitleInfoDo.setActivityTitleTagId(filterActTitleDo.getActivityTitleTagId());
                recallActTitleInfoDo.setActivityTitleName(filterActTitleDo.getActivityTitleName());

                recallActTitleInfoDo.setActivitySubTitleId(filterActTitleDo.getActivitySubTitleId());
                recallActTitleInfoDo.setActivitySubTitleTagId(filterActTitleDo.getActivitySubTitleTagId());
                recallActTitleInfoDo.setActivitySubTitleName(filterActTitleDo.getActivitySubTitleName());

                recallActTitleInfoDo.setIsNew(filterActTitleDo.getIsNew());
                recallActTitleInfoDo.setSubIsNew(filterActTitleDo.getSubIsNew());

                String key1 = getTypeKey(1, filterActTitleDo.getActivityTitleId(), filterActTitleDo.getActivitySubTitleId());
                String key2 = getTypeKey(2, filterActTitleDo.getActivityTitleId(), filterActTitleDo.getActivitySubTitleId());
                String key3 = getTypeKey(3, filterActTitleDo.getActivityTitleId(), filterActTitleDo.getActivitySubTitleId());


                //标题的海选类型, 1：活动海选
                if (selectMap.containsKey(key1)) {
                    recallActTitleInfoDo.setScore1(selectMap.get(key1).getScore());
                    recallActTitleInfoDo.setRank1(selectMap.get(key1).getRank());
                    recallActTitleInfoDo.setHasType(true);
                }
                //标题的海选类型, 2：皮肤海选
                if (selectMap.containsKey(key2)) {
                    recallActTitleInfoDo.setScore2(selectMap.get(key2).getScore());
                    recallActTitleInfoDo.setRank2(selectMap.get(key2).getRank());
                    recallActTitleInfoDo.setHasType(true);
                }

                //标题的海选类型, 3：广告位皮肤海选
                if (selectMap.containsKey(key3)) {
                    recallActTitleInfoDo.setScore3(selectMap.get(key3).getScore());
                    recallActTitleInfoDo.setRank3(selectMap.get(key3).getRank());
                    recallActTitleInfoDo.setHasType(true);
                }

                // 标题海选，主
                boolean isMainRecall = false;
                boolean isSubRecall = false;

                if(selectMainTitleMap.containsKey(filterActTitleDo.getActivityTitleId())){
                    isMainRecall=true;
                }

                // 标题海选，副

                if(selectMainTitleMap.containsKey(filterActTitleDo.getActivityTitleId())){
                    isSubRecall=true;
                }

                // 召回 主+副
                boolean isRecall = true;// 全部召回

                if (preSize > 0 && recallActTitleInfoDo.getHasType() != null && recallActTitleInfoDo.getHasType()) {
                    // 是否海选
                    isRecall = true;
                } else {
                    // 是否新增
                    if (recallActTitleInfoDo.getIsNew() != null && recallActTitleInfoDo.getIsNew().equals(1L)) {
                        isRecall = true;
                    }
                    if (recallActTitleInfoDo.getSubIsNew() != null && recallActTitleInfoDo.getSubIsNew().equals(1L)) {
                        isRecall = true;
                    }

                    // 主标题 且 副标题 在海选范围
                    if(isMainRecall && isSubRecall){
                        isRecall = true;
                    }
                }


                if (isRecall) {
                    recallActTitleInfoDoList.add(recallActTitleInfoDo);

                    if (recallActTitleInfoDo.getActivityTitleId() != null) {
                        activityTitleIdSet.add(recallActTitleInfoDo.getActivityTitleId());
                    }
                    if (recallActTitleInfoDo.getActivitySubTitleId() != null) {
                        activitySubTitleIdSet.add(recallActTitleInfoDo.getActivitySubTitleId());
                    }
                }


            }
        }


        // 封装返回结果

        System.out.println(JSON.toJSONString(recallActTitleInfoDoList));

        ret = new RecallActTitleDo();

        List<Long> activityTitleIdList = new ArrayList<>(activityTitleIdSet);  //主标题集合
        List<Long> activitySubTitleIdList = new ArrayList<>(activitySubTitleIdSet); //副标题集合

        ret.setRecallActTitleInfoDo(recallActTitleInfoDoList);
        ret.setActivityTitleIdList(activityTitleIdList);
        ret.setActivitySubTitleIdList(activitySubTitleIdList);

        return ret;
    }


    public static List<PreSelectActTitleDo> getLastSelectTitle(List<PreSelectActTitleDo> preSelectActTitleDoList) {
        List<PreSelectActTitleDo> ret = new ArrayList<>();
        Map<String, List<PreSelectActTitleDo>> groupMap = new HashMap<>();

        String lastDateTime = null;
        if (AssertUtil.isAllNotEmpty(preSelectActTitleDoList)) {
            for (int i = 0; i < preSelectActTitleDoList.size(); i++) {
                PreSelectActTitleDo preSelectActTitleDo = preSelectActTitleDoList.get(i);
                if (preSelectActTitleDo != null) {
                    String cDateTime =preSelectActTitleDo.getDt();

                    if (!groupMap.containsKey(cDateTime)) {
                        groupMap.put(cDateTime, new ArrayList<>());
                    }
                    groupMap.get(cDateTime).add(preSelectActTitleDo);


                    if (lastDateTime == null) {
                        lastDateTime = cDateTime;
                    } else if (lastDateTime.compareTo(cDateTime)<0) {
                        lastDateTime = cDateTime;
                    }
                }


            }
            ret = groupMap.get(lastDateTime);
        }





        return ret;
    }

    private static String getTypeKey(Integer type, Long activityTitleId, Long activitySubTitleId) {

        String ret = null;

        //标题的海选类型, 1：活动海选  2：皮肤海选  3、广告位皮肤海选


        if (type.equals(1)) {
            ret = "k1" + "-" + activityTitleId + "-" + activitySubTitleId;
        }
        if (type.equals(1)) {
            ret = "k2" + "-" + activityTitleId + "-" + activitySubTitleId;
        }

        if (type.equals(1)) {
            ret = "k3" + "-" + activityTitleId + "-" + activitySubTitleId;
        }


        return ret;
    }

    private static Boolean selectValid(PreSelectActTitleDo preSelectActTitleDo) {
        Boolean ret = true;
        if (preSelectActTitleDo == null) {
            ret = false;
            return ret;
        }

        if (preSelectActTitleDo.getType() == null || preSelectActTitleDo.getType() < 1 || preSelectActTitleDo.getType() > 3) {
            ret = false;
            return ret;
        }

        if (preSelectActTitleDo.getScore() == null || preSelectActTitleDo.getRank() == null) {
            ret = false;
            return ret;
        }


        return ret;

    }
}
