package cn.com.duiba.nezha.alg.alg.vo.adx.rtb;

import cn.com.duiba.nezha.alg.alg.vo.adx.AdxClickAndJoinDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxPredAdDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxPdControlDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.ClickValueRectifyDo;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * RTB互动-算法出价入参对象
 */

@Data
public class AdxRtbBidRequestDo implements Serializable {

    private static final long serialVersionUID = 517865253836379817L;

    /**
     * adx出价信息
     */
    private AdxDo adxDoInfo;

    /**
     * adx ROI控制信息
     */
    private AdxRoiControlDo adxRoiControlInfo;

    /**
     * cpc维稳信息
     */
    private CpcControlDo cpcControlInfo;

    /**
     * 预发券结果对象(预发券Top3列表)
     */
    private List<AdxPredAdDo> adxPredAdDoList;

    /**
     * 创意点击参与融合数据--定时任务缓存获取
     */
    private AdxClickAndJoinDo mergeAdxClickAndJoinDo;

    /**
     * 创意点击价值纠偏对象--定时任务缓存获取
     */
    private ClickValueRectifyDo clickValueRectify;

}
