package cn.com.duiba.nezha.alg.alg.adx.rcmd;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxIdeaParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxIdeaStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxResourceRcmdDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;


import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AdxIdeaRcmder {

    private static long ADX_MULTIPLIER = 10000000;

    /**
     * 定时任务 流量分配 main1
     *
     * @param ideaList              资源下，算法组创意集合（开启）
     * @param adxMinStatDoMap       创意统计数据 20分钟
     * @param adxDayStatDoMap       创意统计数据 3天
     * @param lastAdxResourceRcmdDo 上一次输出对象（资源位创意推荐对象）
     * @return
     */
    public static AdxResourceRcmdDo trafficAllocation(List<Long> ideaList,
                                                      Map<Long, AdxIdeaStatDo> adxMinStatDoMap,
                                                      Map<Long, AdxIdeaStatDo> adxDayStatDoMap,
                                                      AdxResourceRcmdDo lastAdxResourceRcmdDo) {

        AdxResourceRcmdDo ret = lastAdxResourceRcmdDo;


        //
        if (AssertUtil.isEmpty(ideaList)) {
            return ret;
        }

        //0 初始化
        if (ret == null) {
            ret = new AdxResourceRcmdDo();
        }

        if (ret.getIdeaParamsMap() == null) {
            ret.setIdeaParamsMap(new HashMap<>());
        }


        // 清除过期数据 1周以上
        Map<Long, AdxIdeaParamsDo> ideaStatParamsMap = ret.getIdeaParamsMap();

        if (AssertUtil.isNotEmpty(ideaStatParamsMap)) {

            Iterator<Map.Entry<Long, AdxIdeaParamsDo>> it = ideaStatParamsMap.entrySet().iterator();

            while (it.hasNext()) {
                Map.Entry<Long, AdxIdeaParamsDo> entry = it.next();

                Long ideaId = entry.getKey();
                AdxIdeaParamsDo parmasDo = entry.getValue();

                String lastUpdateTime = parmasDo.getLastUpdateTime();
                if (lastUpdateTime != null) {
                    Long delayMinutes = LocalDateUtil.getIntervalMinutes(lastUpdateTime, DateStyle.YYYYMMDDHHMMSS);

                    if (delayMinutes != null && delayMinutes > 60 * 24 * 7) {
                        it.remove();
                    }

                }
            }

        }


        //1 数据处理：置信、ctr等指标计算
        if (AssertUtil.isNotEmpty(adxMinStatDoMap)) {
            adxMinStatDoMap.forEach((ideaId, adxStatDo) -> AdxIdeaBaseRcmder.ideaStatCompute(adxStatDo));
        }

        if (AssertUtil.isNotEmpty(adxDayStatDoMap)) {
            adxDayStatDoMap.forEach((ideaId, adxStatDo) -> AdxIdeaBaseRcmder.ideaStatCompute(adxStatDo));
        }

//        System.out.println("JSON="+JSON.toJSONString(adxMinStatDoMap));

        //2 最优指标筛选
        AdxIdeaStatDo bestAdxMinIdeaStatDo = AdxIdeaBaseRcmder.getBestCtrAndProfitEcpm(ideaList, adxMinStatDoMap);
        AdxIdeaStatDo bestAdxDayIdeaStatDo = AdxIdeaBaseRcmder.getBestCtrAndProfitEcpm(ideaList, adxDayStatDoMap);


        //3 退出更新：实时数据均不置信（暂停投放 或 数据量级小）
        if (bestAdxMinIdeaStatDo == null || bestAdxMinIdeaStatDo.getCtr() == null) {

            return ret;
        }
//        System.out.println("4");
        //4 新权重分配 && 创意熔断
        System.out.println(4);
        Map<Long, Double> newWeightMap = new HashMap<>();

        Double oldWeightSum = 0.0;
        Double newWeightSum = 0.0;
        for (int i = 0, size = ideaList.size(); i < size; i++) {

            // 4.0 初始化
            Long ideaId = ideaList.get(i);
            AdxIdeaParamsDo adxIdeaParamsDo = ret.getIdeaParamsMap().get(ideaId);
            if (adxIdeaParamsDo == null) {
                adxIdeaParamsDo = new AdxIdeaParamsDo();
                adxIdeaParamsDo.setIdeaId(ideaId);
                adxIdeaParamsDo.setGiveUpRatio(0.0);
                ret.getIdeaParamsMap().put(ideaId, adxIdeaParamsDo);
            }


            AdxIdeaStatDo adxDayIdeaStatDo = adxDayStatDoMap.get(ideaId);
            AdxIdeaStatDo adxMinIdeaStatDo = adxMinStatDoMap.get(ideaId);


            // 4.0 新增 累计衰减 RPM
            AdxIdeaBaseRcmder.updateHistoryRpm(adxIdeaParamsDo, adxMinIdeaStatDo);


            adxIdeaParamsDo.setFused(false);

//            System.out.println(JSON.toJSONString(adxDayIdeaStatDo));

            // 4.1 权重分配、指标维度融合（CTR、pECPM）
            Double dayWeight = AdxIdeaBaseRcmder.getIdeaWeight(adxDayIdeaStatDo, bestAdxDayIdeaStatDo);
            Double minWeight = AdxIdeaBaseRcmder.getIdeaWeight(adxMinIdeaStatDo, bestAdxMinIdeaStatDo);

            // 4.2 权重时间维度融合
            Double currentMergeRatio = 0.5;
            if (adxMinIdeaStatDo != null && adxMinIdeaStatDo.getConfidence()) {
                currentMergeRatio = 0.5 + 0.4 * Math.min(adxMinIdeaStatDo.getAdvertConsume() / 500, 1.0);
            }
//            System.out.println(currentMergeRatio);
            Double newWeight = AdxIdeaBaseRcmder.getMergeWeight(minWeight, dayWeight, adxIdeaParamsDo.getHistoryTimes(), adxIdeaParamsDo.getCurrentTimes(), size + 0L, currentMergeRatio);

//            System.out.println(newWeight);

            // 4.3 全局 创意熔断
            if (adxDayIdeaStatDo != null && adxDayIdeaStatDo.getBid() != null && adxDayIdeaStatDo.getBid() > 10000) {
                // 有充足竞价、无曝光，熔断
                if (adxDayIdeaStatDo.getExp() == null || adxDayIdeaStatDo.getExp() == 0) {
                    adxIdeaParamsDo.setFused(true);
                    newWeight = 0.01;
                }

                // 有充足曝光、ROI差，熔断
                if (adxDayIdeaStatDo.getExp() != null
                        && adxDayIdeaStatDo.getExp() > 2000
                        && adxDayIdeaStatDo.getRoi() != null
                        && adxDayIdeaStatDo.getRoi() < 1.05
                        ) {
                    if (newWeight == null || newWeight <= 0.99) {
                        adxIdeaParamsDo.setFused(true);
                    }
                }

            }

            // 4.4 实时 较差创意控制消耗量级
            adxIdeaParamsDo.setCurrentRoi(null);
            Double giveUpLearnRatio = 0.3;
            if (adxMinIdeaStatDo != null && adxMinIdeaStatDo.getConfidence()) {

                adxIdeaParamsDo.setCurrentRoi(adxMinIdeaStatDo.getRoi());

                Double adxConsume = 0.0 + adxMinIdeaStatDo.getAdxConsume() / ADX_MULTIPLIER;

//                Double adxRoi = adxMinIdeaStatDo.getRoi();

                Double newGiveUpRatio = adxIdeaParamsDo.getGiveUpRatio();

                if (newGiveUpRatio == null) {
                    newGiveUpRatio = 0.0;
                }

                if (adxMinIdeaStatDo.getRoi() > 1.05) {
                    newGiveUpRatio = 0.0;
                }

//                System.out.println(adxMinIdeaStatDo.getProfitEcpm());
//                System.out.println(newGiveUpRatio);

                if (adxMinIdeaStatDo.getRoi() < 1.05) {

                    if (newGiveUpRatio < 0.05 && adxConsume > 400) {
                        newGiveUpRatio = 0.05;
                    }
                    Double pc = MathBase.noiseSmoother((adxConsume) / 400, 0.5, 2.0);
                    newGiveUpRatio = newGiveUpRatio * ((1 - giveUpLearnRatio) + giveUpLearnRatio * pc);
                }


                newGiveUpRatio = MathBase.noiseSmoother(newGiveUpRatio, 0.0, 0.8);

                adxIdeaParamsDo.setGiveUpRatio(newGiveUpRatio);
            }


            // 4.4累计权重
            newWeightMap.put(ideaId, newWeight);
            newWeightSum += newWeight;
            oldWeightSum += DataUtil.getValueOrDefault(adxIdeaParamsDo.getWeight(), 0.0);


        }
        System.out.println(6);
        //5 更新 && 归一化
        //公式 w=  lr * w_old+(1-lr) w_new

        for (
                int i = 0, size = ideaList.size();
                i < size; i++)

        {
            Long ideaId = ideaList.get(i);
            AdxIdeaParamsDo adxIdeaParamsDo = ret.getIdeaParamsMap().get(ideaId);


            Double finalWeight = AdxIdeaBaseRcmder.getUpdateWeight(adxIdeaParamsDo.getWeight(),
                    oldWeightSum,
                    newWeightMap.get(ideaId),
                    newWeightSum,
                    adxIdeaParamsDo.getLastUpdateTime());

            adxIdeaParamsDo.setWeight(finalWeight);
            adxIdeaParamsDo.setLastUpdateTime(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYYMMDDHHMMSS));

            adxIdeaParamsDo.setCurrentTimes(DataUtil.addLong(adxIdeaParamsDo.getCurrentTimes(), 1L));
            adxIdeaParamsDo.setHistoryTimes(DataUtil.addLong(adxIdeaParamsDo.getHistoryTimes(), 1L));

            if (adxIdeaParamsDo.isFused() != null && adxIdeaParamsDo.isFused() == true) {
                // 熔断
                adxIdeaParamsDo.setCurrentTimes(0L);

                adxIdeaParamsDo.setWeight(DataUtil.getValueOrDefault(adxIdeaParamsDo.getWeight(), 0.1) * 0.1);
            }
//            System.out.println("ideaid="+ideaId+",oldWeight=" + adxIdeaParamsDo.getWeight()+",newWeight="+newWeightMap.get(ideaId)+",finalWeight="+adxIdeaParamsDo.getWeight());
        }





        return ret;
    }


    /**
     * 创意推荐 main2
     *
     * @param validIdeaList     有效创意集合
     * @param adxResourceRcmdDo 资源位创意推荐对象
     * @return 创意
     */
    public static Long ideaRcmd(List<Long> validIdeaList, AdxResourceRcmdDo adxResourceRcmdDo) {


        Long ret = null;

        if (AssertUtil.isEmpty(validIdeaList)) {
            return ret;
        }

        //1 数据处理
        if (adxResourceRcmdDo == null) {
            adxResourceRcmdDo = new AdxResourceRcmdDo();
            adxResourceRcmdDo.setIdeaParamsMap(new HashMap<>());
        }


        //2 轮盘赌，随机推荐创意
        Map<Long, Double> map = new HashMap<>();
        Map<Long, Double> mapWithGiveUp = new HashMap<>();

        for (int i = 0, size = validIdeaList.size(); i < size; i++) {
            Long ideaId = validIdeaList.get(i);
            // 数据准备
            AdxIdeaParamsDo adxIdeaParamsDo = adxResourceRcmdDo.getIdeaParamsMap().get(ideaId);

            // 权重
            if (adxIdeaParamsDo == null || adxIdeaParamsDo.getWeight() == null) {
                // 默认权重
                map.put(ideaId, 1.0);
                mapWithGiveUp.put(ideaId, 1.0);
            } else {
                // 未熔断
                if (adxIdeaParamsDo.isFused() == null || !adxIdeaParamsDo.isFused()) {
                    map.put(ideaId, adxIdeaParamsDo.getWeight());

                    if (adxIdeaParamsDo.getGiveUpRatio() != null &&
                            adxIdeaParamsDo.getGiveUpRatio() >= 0 &&
                            Math.random() > adxIdeaParamsDo.getGiveUpRatio()) {
                        mapWithGiveUp.put(ideaId, adxIdeaParamsDo.getWeight());
                    }

                    if (adxIdeaParamsDo.getGiveUpRatio() == null) {
                        mapWithGiveUp.put(ideaId, adxIdeaParamsDo.getWeight());
                    }

                }


                // 熔断
                if (adxIdeaParamsDo.isFused() != null && adxIdeaParamsDo.isFused()) {
                    if (Math.random() > 0.9) {
                        mapWithGiveUp.put(ideaId, adxIdeaParamsDo.getWeight());
                    }
                }


            }

        }


//        System.out.println(JSON.toJSONString(mapWithGiveUp));

        ret = Roulette.doubleMap(mapWithGiveUp);

        //3 返回创意

//        if (ret == null) {
//            ret = validIdeaList.get(0);
//        }


        return ret;
    }


}
