/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.activity;

import cn.com.duiba.nezha.alg.alg.activity.ActivityInfo;
import cn.com.duiba.nezha.alg.alg.activity.ActivityParams;
import cn.com.duiba.nezha.alg.alg.activity.ActivityRcmdReq;
import cn.com.duiba.nezha.alg.alg.activity.ActivityRcmdRet;
import cn.com.duiba.nezha.alg.alg.activity.ActivitySubParams;
import cn.com.duiba.nezha.alg.alg.activity.ScoreDo;
import cn.com.duiba.nezha.alg.alg.activity.SlotInfo;
import cn.com.duiba.nezha.alg.alg.activity.Thompson;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.v2.ActivityFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.feature.vo.v2.ActFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.ContextFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.UserFeatureDoV2;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityRcmder {
    private static final Logger logger = LoggerFactory.getLogger(ActivityRcmder.class);
    private static String LOG_PRIFIX = "ActivityRcmder";
    private static HashMap<Long, String> sActMap = new HashMap();
    private static HashMap<Long, Long> dActMap = new HashMap();
    private static Random random = new Random();
    private static HashMap<Long, ActivityInfo> actWhiteList = new HashMap();
    private static HashMap<Long, SlotInfo> slotWhiteList = new HashMap();
    private static List testList = Arrays.asList(30942L, 30828L, 26497L, 30222L, 30784L, 31234L, 31352L, 31185L, 31475L, 31557L, 31545L, 30192L);

    public static Long getAlgRcmdType() {
        double rd = Math.random();
        if (rd <= 0.7) {
            return 1L;
        }
        if (rd <= 0.9) {
            return 2L;
        }
        return 3L;
    }

    public static Long getActType(Long activityId) {
        Long ret = null;
        ActivityInfo activityInfo = actWhiteList.get(activityId);
        if (activityInfo != null && activityInfo.getActType() != null) {
            ret = activityInfo.getActType();
        }
        return ret;
    }

    public static String getActTrade2(Long activityId) {
        String ret = null;
        ActivityInfo activityInfo = actWhiteList.get(activityId);
        if (activityInfo != null && activityInfo.getActTrade2() != null) {
            ret = activityInfo.getActTrade2();
        }
        return ret;
    }

    public static Long getDefActId(Long slotId) {
        Long ret = null;
        SlotInfo slotInfo = slotWhiteList.get(slotId);
        if (slotInfo != null && slotInfo.getDefActId() != null) {
            ret = slotInfo.getDefActId();
        }
        return ret;
    }

    public static Long getDefActType(Long slotId) {
        Long ret = null;
        SlotInfo slotInfo = slotWhiteList.get(slotId);
        if (slotInfo != null && slotInfo.getDefActType() != null) {
            ret = slotInfo.getDefActType();
        }
        return ret;
    }

    public static Map<Long, FeatureMapDo> getFeatureMap(List<ActivityRcmdReq> activityRcmdReqList, ContextFeatureDoV2 contextFeatureDoV2, UserFeatureDoV2 userFeatureDoV2) throws Exception {
        HashMap<Long, FeatureMapDo> featureMap = new HashMap<Long, FeatureMapDo>();
        Map staticFeatureMap = ActivityFeatureParse.generateFeatureMapStatic((ContextFeatureDoV2)contextFeatureDoV2, (UserFeatureDoV2)userFeatureDoV2);
        Long activityPage = Optional.ofNullable(contextFeatureDoV2.getActivityPage()).orElse(null);
        if (AssertUtil.isEmpty(activityRcmdReqList)) {
            logger.warn(LOG_PRIFIX + ".getFeatureMap activityRcmdReqList is null");
            return featureMap;
        }
        for (ActivityRcmdReq activityRcmdReq : activityRcmdReqList) {
            Long activityId = activityRcmdReq.getActivityId();
            if (activityPage == null) {
                activityPage = activityId;
            }
            activityRcmdReq.setActivityPage(activityPage);
            String str = JSON.toJSONString((Object)activityRcmdReq);
            ActFeatureDoV2 actFeatureDoV2 = (ActFeatureDoV2)JSON.parseObject((String)str, ActFeatureDoV2.class);
            Map dynamicFeatureMap = ActivityFeatureParse.generateFeatureMapDynamic((ActFeatureDoV2)actFeatureDoV2, (UserFeatureDoV2)userFeatureDoV2, (ContextFeatureDoV2)contextFeatureDoV2);
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMap.put(activityId, featureMapDo);
        }
        return featureMap;
    }

    public static Map<Long, Double> predict(Map<Long, FeatureMapDo> featureMapDoMap, DeepModelV2 deepModelV2, LocalTFModelV2 localTFModelV2) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{deepModelV2, localTFModelV2})) {
            return deepModelV2.predictWithLocalTFV2(featureMapDoMap, localTFModelV2);
        }
        return new HashMap<Long, Double>();
    }

    public static ActivityRcmdRet rcmd(List<ActivityRcmdReq> activityRcmdReqList, ActivityParams activityParams, Map<Long, Double> preEcpmMap, Long slotId, String appPkgTrade2, Long algRcmdType, Long dsm2A) throws Exception {
        List<ActivityRcmdRet> activityRcmdRetList = ActivityRcmder.getScore(activityRcmdReqList, activityParams, preEcpmMap, slotId, dsm2A, appPkgTrade2, algRcmdType);
        ActivityRcmdRet ret = ActivityRcmder.select(activityRcmdRetList, algRcmdType);
        return ret;
    }

    public static List<ActivityRcmdReq> recall(List<ActivityRcmdReq> activityRcmdReqList, String appPkgTrade2, Long slotId, Long algRcmdType, Set<Long> filterActSet) throws Exception {
        if (algRcmdType.equals(3L)) {
            return ActivityRcmder.recall2(activityRcmdReqList, filterActSet, appPkgTrade2);
        }
        if (algRcmdType.equals(2L)) {
            return ActivityRcmder.recallMade(activityRcmdReqList, appPkgTrade2, slotId, filterActSet);
        }
        return ActivityRcmder.recall1(activityRcmdReqList, appPkgTrade2, slotId, filterActSet);
    }

    public static List<ActivityRcmdReq> recall2(List<ActivityRcmdReq> activityRcmdReqList, Set<Long> filterActSet, String appPkgTrade2) throws Exception {
        ArrayList<ActivityRcmdReq> ret = new ArrayList<ActivityRcmdReq>();
        ArrayList retDef = new ArrayList();
        ArrayList retSpe = new ArrayList();
        ArrayList retOther = new ArrayList();
        for (int i = 0; i < activityRcmdReqList.size(); ++i) {
            ActivityRcmdReq activityRcmdReq = activityRcmdReqList.get(i);
            Long activityId = activityRcmdReq.getActivityId();
            String actTrade2 = ActivityRcmder.getActTrade2(activityId);
            if (appPkgTrade2 != null && appPkgTrade2.equals(actTrade2) || filterActSet.contains(activityId)) continue;
            ret.add(activityRcmdReq);
        }
        if (ret.isEmpty()) {
            ret.add(activityRcmdReqList.get(0));
        }
        return ret;
    }

    public static List<ActivityRcmdReq> recall1(List<ActivityRcmdReq> activityRcmdReqList, String appPkgTrade2, Long slotId, Set<Long> filterActSet) throws Exception {
        ArrayList<ActivityRcmdReq> ret = new ArrayList();
        Long dAct = ActivityRcmder.getDefActId(slotId);
        Long dActType = ActivityRcmder.getDefActType(slotId);
        boolean hasSpecAct = false;
        for (int i = 0; i < activityRcmdReqList.size(); ++i) {
            ActivityRcmdReq activityRcmdReq = activityRcmdReqList.get(i);
            Long activityId = activityRcmdReq.getActivityId();
            String actTrade2 = ActivityRcmder.getActTrade2(activityId);
            Long actType = ActivityRcmder.getActType(activityId);
            boolean recall = false;
            if (dAct != null && activityId.equals(dAct)) {
                recall = true;
            }
            if (appPkgTrade2 != null && appPkgTrade2.equals(actTrade2) && dActType != null && dActType.equals(actType)) {
                recall = true;
                hasSpecAct = true;
            }
            if (!recall || filterActSet.contains(activityId)) continue;
            ret.add(activityRcmdReq);
        }
        if (!hasSpecAct) {
            ret = activityRcmdReqList;
        }
        if (ret.isEmpty()) {
            ret.add(activityRcmdReqList.get(0));
        }
        return ret;
    }

    public static List<ActivityRcmdReq> recallMade(List<ActivityRcmdReq> activityRcmdReqList, String appPkgTrade2, Long slotId, Set<Long> filterActSet) throws Exception {
        ArrayList<ActivityRcmdReq> ret = new ArrayList();
        Long dAct = ActivityRcmder.getDefActId(slotId);
        Long dActType = ActivityRcmder.getDefActType(slotId);
        boolean hasSpecAct = false;
        for (int i = 0; i < activityRcmdReqList.size(); ++i) {
            ActivityRcmdReq activityRcmdReq = activityRcmdReqList.get(i);
            Long activityId = activityRcmdReq.getActivityId();
            String actTrade2 = ActivityRcmder.getActTrade2(activityId);
            Long actType = ActivityRcmder.getActType(activityId);
            boolean recall = false;
            if (appPkgTrade2 == null && dAct != null && activityId.equals(dAct)) {
                recall = true;
            }
            if (appPkgTrade2 != null && appPkgTrade2.equals(actTrade2) && dActType != null && dActType.equals(actType)) {
                recall = true;
                hasSpecAct = true;
            }
            if (!recall || filterActSet.contains(activityId)) continue;
            ret.add(activityRcmdReq);
        }
        if (!hasSpecAct) {
            ret = activityRcmdReqList;
        }
        if (ret.isEmpty()) {
            ret.add(activityRcmdReqList.get(0));
        }
        return ret;
    }

    private static ActivityRcmdRet select(List<ActivityRcmdRet> activityRcmdRetList, Long algRcmdType) throws Exception {
        ActivityRcmdRet ret = null;
        if (AssertUtil.isEmpty(activityRcmdRetList)) {
            logger.warn(LOG_PRIFIX + ".rank select is Empty,invaild");
            return ret;
        }
        activityRcmdRetList = activityRcmdRetList.stream().sorted(Comparator.comparing(ActivityRcmdRet::getScore).reversed()).collect(Collectors.toList());
        List activityRcmdRetList2 = activityRcmdRetList.stream().filter(rcmdRet -> !rcmdRet.isConf()).collect(Collectors.toList());
        if (algRcmdType.equals(1L) || algRcmdType.equals(3L)) {
            ret = activityRcmdRetList.get(0);
        } else if (algRcmdType.equals(2L)) {
            double rd = Math.random();
            if (activityRcmdRetList2.size() > 0 && rd <= 0.02) {
                int n = random.nextInt(activityRcmdRetList2.size());
                ret = (ActivityRcmdRet)activityRcmdRetList2.get(n);
            } else {
                ret = activityRcmdRetList.get(0);
            }
        } else {
            int n = random.nextInt(activityRcmdRetList.size());
            ret = activityRcmdRetList.get(n);
        }
        ret.setAlgRcmdType(algRcmdType);
        ArrayList<ScoreDo> scoreDoList = new ArrayList<ScoreDo>();
        for (int i = 0; i < activityRcmdRetList.size(); ++i) {
            ActivityRcmdRet activityRcmdRet;
            if (i >= 5 || (activityRcmdRet = activityRcmdRetList.get(i)) == null) continue;
            ScoreDo scoreDo = new ScoreDo();
            scoreDo.setActivityId(activityRcmdRet.getActivityId());
            scoreDo.setPreEcpm(activityRcmdRet.getPreEcpm());
            scoreDo.setScore(activityRcmdRet.getScore());
            if (activityRcmdRet.getActivitySubParams() != null) {
                scoreDo.setStatEcpm(activityRcmdRet.getActivitySubParams().getEcpm());
            }
            scoreDoList.add(scoreDo);
        }
        ret.setTopScoreDoList(scoreDoList);
        return ret;
    }

    private static List<ActivityRcmdRet> getScore(List<ActivityRcmdReq> activityRcmdReqList, ActivityParams activityParams, Map<Long, Double> preEcpmMap, Long slotId, Long dsm2A, String appPkgTrade2, Long algRcmdType) throws Exception {
        ArrayList<ActivityRcmdRet> ret = new ArrayList<ActivityRcmdRet>();
        if (AssertUtil.isEmpty(activityRcmdReqList)) {
            logger.warn(LOG_PRIFIX + ".getScore  activityRcmdReqList is Empty,invaild");
            return ret;
        }
        for (ActivityRcmdReq activityRcmdReq : activityRcmdReqList) {
            Long activityId = activityRcmdReq.getActivityId();
            Double preEcpm = 0.0011;
            if (preEcpmMap != null && preEcpmMap.get(activityId) != null) {
                preEcpm = preEcpmMap.get(activityId);
            }
            ActivitySubParams activitySubParams = null;
            ActivitySubParams slotSubParams = null;
            if (activityParams != null) {
                activitySubParams = activityParams.getFactor(activityId, dsm2A, slotId, appPkgTrade2);
                slotSubParams = activityParams.getFactor(-1L, dsm2A, slotId, appPkgTrade2);
            }
            boolean conf = activitySubParams != null && activitySubParams.getActReqCntPv() > 0L;
            Double score = ActivityRcmder.getScore(preEcpm, activitySubParams);
            if (algRcmdType.equals(2L)) {
                score = ActivityRcmder.getScore(activitySubParams, slotSubParams);
            }
            ActivityRcmdRet activityRcmdRet = new ActivityRcmdRet();
            activityRcmdRet.setActivityId(activityId);
            activityRcmdRet.setActivitySubParams(activitySubParams);
            activityRcmdRet.setScore(score);
            activityRcmdRet.setPreEcpm(preEcpm);
            activityRcmdRet.setConf(conf);
            ret.add(activityRcmdRet);
        }
        return ret;
    }

    private static Double getScore(double preEcpm, ActivitySubParams activitySubParams) {
        double ret = preEcpm;
        if (activitySubParams != null) {
            Double statEcpm = activitySubParams.getEcpm();
            Double statRatio = activitySubParams.getStatRatio();
            Double factor = activitySubParams.getFactor();
            if (statEcpm != null) {
                ret = Math.random() > statRatio ? preEcpm * 1.0 + statEcpm * 0.0 : statEcpm;
            }
            ret *= factor.doubleValue();
        }
        return ret;
    }

    private static Double getScore(ActivitySubParams actSubParams, ActivitySubParams slotSubParams) {
        long alpha = 10L;
        long beta = 1000L - alpha;
        if (slotSubParams != null) {
            long slotReqPv = slotSubParams.getActReqCntPv();
            long slotLandClickPv = slotSubParams.getLandpageClickPv();
            double slotRatio = DataUtil.division((Long)(slotLandClickPv + alpha), (Long)(slotReqPv + alpha + beta), (int)5);
            if (slotLandClickPv > 100L && slotReqPv >= slotLandClickPv) {
                slotRatio = DataUtil.division((Long)slotLandClickPv, (Long)slotReqPv, (int)5);
                alpha = DataUtil.double2Long((Double)DataUtil.division((Long)slotLandClickPv, (Long)10L));
            }
            beta = DataUtil.double2Long((Double)(DataUtil.division((Long)alpha, (Double)slotRatio) - (double)alpha));
        }
        if (actSubParams != null) {
            long actReqPv = actSubParams.getActReqCntPv();
            long actLandClickPv = actSubParams.getLandpageClickPv();
            alpha = actLandClickPv + alpha;
            beta = actReqPv + beta - actLandClickPv;
        }
        double ret = Thompson.betaSampler(alpha, beta);
        return DataUtil.formatDouble((Double)ret, (int)6);
    }

    public static void main(String[] args) {
        String actStr = "{\"actReqCntPv\":100,\"adClickPv\":13,\"alpha\":0,\"beta\":0,\"ecpm\":7.98149,\"expCntPv\":25,\"factor\":1.0,\"fee\":1293,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":2,\"statEcpm\":7.98149,\"statEcpm2\":0.0,\"statRatio\":0.0,\"targetConvertPv\":0,\"theoryFee\":0}";
        String slotStr = "{\"actReqCntPv\":164,\"adClickPv\":13,\"alpha\":0,\"beta\":0,\"ecpm\":7.83637,\"expCntPv\":25,\"factor\":1.0,\"fee\":1293,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":20,\"statEcpm\":7.83637,\"statEcpm2\":0.0,\"statRatio\":0.0,\"targetConvertPv\":0,\"theoryFee\":0}";
        ActivitySubParams actSubParams = (ActivitySubParams)JSON.parseObject((String)actStr, ActivitySubParams.class);
        ActivitySubParams slotSubParams = (ActivitySubParams)JSON.parseObject((String)slotStr, ActivitySubParams.class);
        Double score = ActivityRcmder.getScore(actSubParams, slotSubParams);
        System.out.println("score:" + score);
        for (int i = 0; i < 100; ++i) {
            System.out.println(ActivityRcmder.getScore(actSubParams, slotSubParams));
        }
    }

    static {
        actWhiteList.put(30942L, new ActivityInfo(30942L, 1L, null));
        actWhiteList.put(31143L, new ActivityInfo(31143L, 1L, "1"));
        actWhiteList.put(31346L, new ActivityInfo(31346L, 1L, "1"));
        actWhiteList.put(31144L, new ActivityInfo(31144L, 1L, "2"));
        actWhiteList.put(31145L, new ActivityInfo(31145L, 1L, "3"));
        actWhiteList.put(31146L, new ActivityInfo(31146L, 1L, "4"));
        actWhiteList.put(30828L, new ActivityInfo(30828L, 2L, null));
        actWhiteList.put(31184L, new ActivityInfo(31184L, 2L, "1"));
        actWhiteList.put(30998L, new ActivityInfo(30998L, 2L, "2"));
        actWhiteList.put(31101L, new ActivityInfo(31101L, 2L, "3"));
        actWhiteList.put(31307L, new ActivityInfo(31307L, 2L, "8"));
        actWhiteList.put(31308L, new ActivityInfo(31308L, 2L, "11"));
        actWhiteList.put(31183L, new ActivityInfo(31183L, 2L, "4"));
        actWhiteList.put(30222L, new ActivityInfo(30222L, 1L, null));
        slotWhiteList.put(417764L, new SlotInfo(417764L, 30942L, 1L));
        slotWhiteList.put(422622L, new SlotInfo(422622L, 30942L, 1L));
        slotWhiteList.put(404873L, new SlotInfo(404873L, 30828L, 2L));
        slotWhiteList.put(417855L, new SlotInfo(417855L, 30828L, 2L));
        slotWhiteList.put(423985L, new SlotInfo(423985L, 30222L, 1L));
        slotWhiteList.put(420877L, new SlotInfo(420877L, 30828L, 2L));
        slotWhiteList.put(404106L, new SlotInfo(404106L, 30828L, 2L));
    }
}

