/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxFlcFeatureDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxIdeaAdFeatureDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.parse.FeatureBaseParse;
import cn.com.duiba.nezha.alg.feature.parse.FeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.CandidateActivityDo;
import cn.com.duiba.nezha.alg.feature.vo.DmpFeature;
import cn.com.duiba.nezha.alg.feature.vo.MgTvFeature;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxFeatureParse {
    public static final int F_MAX_SIZE = 256;
    private static final Logger logger = LoggerFactory.getLogger(AdxFeatureParse.class);
    public static final Integer[] HUABEI_REGION = new Integer[]{80, 11, 12, 13, 14, 15};
    public static final Integer[] DONGBEI_REGION = new Integer[]{81, 21, 22, 23};
    public static final Integer[] HUADONG_REGION = new Integer[]{82, 31, 32, 33, 34, 35, 36, 37};
    public static final Integer[] HUAZHONG_REGION = new Integer[]{83, 41, 42, 43};
    public static final Integer[] HUANAN_REGION = new Integer[]{84, 44, 45, 46};
    public static final Integer[] XINAN_REGION = new Integer[]{85, 50, 51, 52, 53, 54};
    public static final Integer[] XIBEI_REGION = new Integer[]{86, 61, 62, 63, 64, 65};
    public static final Integer[] HMT_REGION = new Integer[]{87, 71, 8100, 8200};
    public static final Integer[] FIRST_TIER_CITY = new Integer[]{11, 12, 31, 50, 2101, 3201, 3202, 3205, 3301, 3302, 3702, 4101, 4201, 4301, 4401, 4403, 4419, 5101, 6101};
    public static final Integer[] SECOND_TIER_CITY = new Integer[]{1301, 1306, 1401, 2102, 2201, 2301, 3203, 3204, 3206, 3303, 3304, 3306, 3307, 3310, 3401, 3501, 3502, 3505, 3601, 3701, 3706, 3707, 4406, 4413, 4420, 4501, 5201, 5301, 6201, 6501};
    public static final Integer[] THIRD_TIER_CITY = new Integer[]{1309, 1303, 1502, 2202, 3207, 3209, 3305, 3412, 3509, 3611, 3708, 3703, 4114, 4110, 4210, 4307, 4306, 4407, 4408, 4601, 5107, 6104, 1304, 1302, 1501, 2306, 3212, 3210, 3403, 3407, 3503, 3607, 3609, 3713, 4103, 4107, 4108, 4206, 4304, 4302, 4452, 4412, 4503, 4602, 5203, 6301, 1310, 1305, 2103, 3208, 3213, 3211, 3411, 3402, 3506, 3604, 3717, 3710, 4113, 4115, 4211, 4205, 4303, 4451, 4405, 4404, 4502, 5106, 5303, 6401};
    public static final int[] cntBucket = new int[]{0, 1, 3, 5, 10, 15, 20};
    public static final double[] CTR_BUCKET = new double[]{0.001, 0.002, 0.003, 0.005, 0.007, 0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public static final double[] CVA_BUCKET = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 25.0, 30.0, 35.0, 40.0, 45.0, 50.0, 60.0, 70.0, 80.0, 90.0, 100.0};
    public static final double[] PV_LAUNCH = new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0};
    public static final double[] ACT_ACCESS_CNT = new double[]{4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0};
    public static final int[] ADVERT_EXP_CLICK_CNT = new int[]{200, 500, 1000, 3000, 5000, 8000, 12000, 20000, 30000, 50000, 80000, 120000, 180000};
    public static final int[] ACT_REQ_JOIN_CNT = new int[]{10, 50, 100, 500, 1000, 2000, 4000, 8000, 16000, 32000, 64000, 150000, 300000, 600000};
    public static final int[] ADV_EXP_CLK_CNT = new int[]{5, 20, 50, 100, 500, 1000, 2000, 4000, 8000, 16000, 32000, 64000, 128000, 200000};
    public static final int[] ADV_TRADE_EXP_CLK_CNT = new int[]{5, 20, 50, 100, 200, 400, 800, 2000, 5000, 8000, 12000, 30000, 50000, 100000};
    public static final double[] userCtrBucket = new double[]{0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public static final double[] userCvrBucket = new double[]{0.01, 0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public static final double[] userConBucket = new double[]{0.01, 0.05, 0.1, 0.5, 1.0, 3.0, 5.0, 10.0, 50.0, 100.0};
    public static final Map<String, Integer> videoChannelCodes = new HashMap<String, Integer>(){
        {
            this.put("aiqiyi--1", 0);
            this.put("aiqiyi-0", 1);
            this.put("aiqiyi-1", 2);
            this.put("aiqiyi-2", 3);
            this.put("aiqiyi-3", 4);
            this.put("aiqiyi-4", 5);
            this.put("aiqiyi-5", 6);
            this.put("aiqiyi-6", 7);
            this.put("aiqiyi-7", 8);
            this.put("aiqiyi-8", 9);
            this.put("aiqiyi-9", 10);
            this.put("aiqiyi-10", 11);
            this.put("aiqiyi-11", 12);
            this.put("aiqiyi-12", 13);
            this.put("aiqiyi-13", 14);
            this.put("aiqiyi-14", 15);
            this.put("aiqiyi-15", 16);
            this.put("aiqiyi-16", 17);
            this.put("aiqiyi-17", 18);
            this.put("aiqiyi-18", 19);
            this.put("aiqiyi-19", 20);
            this.put("aiqiyi-20", 21);
            this.put("aiqiyi-21", 22);
            this.put("aiqiyi-22", 23);
            this.put("aiqiyi-23", 24);
            this.put("aiqiyi-24", 25);
            this.put("aiqiyi-25", 26);
            this.put("aiqiyi-26", 27);
            this.put("aiqiyi-27", 28);
            this.put("aiqiyi-28", 29);
            this.put("aiqiyi-29", 30);
            this.put("aiqiyi-30", 31);
            this.put("aiqiyi-31", 32);
            this.put("aiqiyi-32", 33);
            this.put("aiqiyi-33", 34);
            this.put("aiqiyi-34", 35);
            this.put("aiqiyi-89", 36);
            this.put("aiqiyi-91", 37);
            this.put("aiqiyi-92", 38);
            this.put("aiqiyi-96", 39);
            this.put("aiqiyi-97", 40);
            this.put("aiqiyi-99", 41);
            this.put("aiqiyi-8198", 42);
            this.put("aiqiyi-30001", 43);
            this.put("aiqiyi-30002", 44);
            this.put("aiqiyi-30003", 45);
            this.put("aiqiyi-30004", 46);
            this.put("aiqiyi-30005", 47);
            this.put("aiqiyi-30006", 48);
            this.put("aiqiyi-30007", 49);
            this.put("aiqiyi-30008", 50);
            this.put("aiqiyi-30009", 51);
            this.put("aiqiyi-30010", 52);
            this.put("aiqiyi-30011", 53);
            this.put("aiqiyi-30012", 54);
            this.put("aiqiyi-30013", 55);
            this.put("aiqiyi-30014", 56);
            this.put("aiqiyi-30015", 57);
            this.put("aiqiyi-30016", 58);
            this.put("aiqiyi-30017", 59);
            this.put("aiqiyi-30018", 60);
            this.put("aiqiyi-30019", 61);
            this.put("aiqiyi-30020", 62);
            this.put("aiqiyi-30021", 63);
            this.put("aiqiyi-30022", 64);
            this.put("aiqiyi-30030", 65);
            this.put("aiqiyi-40000", 66);
            this.put("aiqiyi-40001", 67);
            this.put("aiqiyi-40002", 68);
            this.put("aiqiyi-40004", 69);
            this.put("aiqiyi-49999", 70);
            this.put("aiqiyi-50000", 71);
            this.put("aiqiyi-50001", 72);
            this.put("aiqiyi-70001", 73);
            this.put("aiqiyi-70002", 74);
            this.put("aiqiyi-70003", 75);
            this.put("mango-0", 100);
            this.put("mango-1", 101);
            this.put("mango-2", 102);
            this.put("mango-3", 103);
            this.put("mango-20", 104);
            this.put("mango-50", 105);
            this.put("mango-51", 106);
            this.put("mango-99", 107);
            this.put("mango-104", 108);
            this.put("mango-105", 109);
            this.put("mango-106", 110);
            this.put("mango-111", 111);
            this.put("mango-115", 112);
            this.put("mango-116", 113);
            this.put("mango-117", 114);
            this.put("mango-118", 115);
            this.put("mango-120", 116);
        }
    };

    public static Map<String, String> generateFeatureMapStatic(AdxFeatureDo cf, AdxStatsDo resoAppStats) {
        HashMap<String, String> retMap = new HashMap<String, String>(256);
        try {
            if (cf != null) {
                cf.setCurrentCreatTime(AdxFeatureParse.getStringToTimeStamp());
                retMap.put("f1010010", DataUtil.Long2String((Long)cf.getGroupId()));
                retMap.put("f1010020", DataUtil.Integer2String((Integer)cf.getAdxType()));
                retMap.put("f2010010", DataUtil.Long2String((Long)cf.getResourceId()));
                retMap.put("f2010020", DataUtil.Integer2String((Integer)cf.getAdvertType()));
                retMap.put("f2010030", DataUtil.Integer2String((Integer)cf.getPosType()));
                retMap.put("f2010050", cf.getSpecCode());
                retMap.put("f2010060", cf.getAppSlotId());
                retMap.put("f2010061", cf.getExternalAppId());
                retMap.put("f2010062", cf.getExternalAppTrade());
                retMap.put("f3020000", DataUtil.Integer2String((Integer)cf.getPmpType()));
                retMap.put("f3020010", DataUtil.Long2String((Long)cf.getDealId()));
                retMap.put("f3020020", DataUtil.Long2String((Long)cf.getPrice()));
                retMap.put("f4010010", cf.getUa());
                retMap.put("f4010020", cf.getIp());
                retMap.put("f4010021", cf.getIpUsageType());
                retMap.put("f4010030", DataUtil.Long2String((Long)cf.getAreaCode()));
                Long regionLevel = AdxFeatureParse.getRegionLevel(cf.getAreaCode());
                retMap.put("f4010031", DataUtil.Long2String((Long)regionLevel));
                Long tierCityLevel = AdxFeatureParse.getTierCityLevel(cf.getAreaCode());
                retMap.put("f4010032", DataUtil.Long2String((Long)tierCityLevel));
                retMap.put("f4010050", cf.getMake());
                retMap.put("f4010060", cf.getModel());
                retMap.put("f4010070", cf.getOs());
                retMap.put("f4010071", cf.getOsv());
                retMap.put("f4010080", cf.getCarrier());
                retMap.put("f4010091", DataUtil.Integer2String((Integer)cf.getTuiaConnectionType()));
                Integer hour = AdxFeatureParse.getTimeStampToHour(cf.getCurrentCreatTime());
                retMap.put("f4010121", DataUtil.Integer2String((Integer)hour));
                Integer weekDay = AdxFeatureParse.getTimeStampToWeekDay(cf.getCurrentCreatTime());
                retMap.put("f4010122", DataUtil.Integer2String((Integer)weekDay));
                retMap.put("f5010050", cf.getImei());
                retMap.put("f6010010", cf.getAppName());
                retMap.put("f6010020", cf.getAppBundle());
                retMap.put("f6010070", cf.getGeoCity());
                retMap.put("f6010090", cf.getTagId());
                retMap.put("f6010100", DataUtil.Integer2String((Integer)cf.getTagIndex()));
                retMap.put("f6010101", cf.getPos());
                Set matType = cf.getMatType();
                if (matType != null) {
                    retMap.put("f6010102", matType.toString());
                }
                MgTvFeature mgTvFeature = Optional.ofNullable(cf.getMgTvFeature()).orElse(new MgTvFeature());
                DmpFeature dmpFeature = Optional.ofNullable(cf.getDmpFeature()).orElse(new DmpFeature());
                retMap.put("f5010010", FeatureBaseParse.getDmpSexData((String)dmpFeature.getSex(), (String)cf.getGender()));
                retMap.put("f5010030", FeatureBaseParse.getDmpData((String)dmpFeature.getAge(), (String)cf.getYob()));
                retMap.put("f5010031", dmpFeature.getMarry());
                Long imeiDayBidTimes = AdxFeatureParse.getImeiDayTimes(cf.getImei(), 50L, cf.getImeiDayBidTimes());
                Long imeiDayBid = FeatureBaseParse.getCntLevel((Long)dmpFeature.getImeiDayBidTimes(), (Long)50L);
                retMap.put("f5010060", DataUtil.Long2String((Long)FeatureBaseParse.getDmpData((Long)imeiDayBid, (Long)imeiDayBidTimes)));
                Long imeiDayExpTimes = AdxFeatureParse.getImeiDayTimes(cf.getImei(), 7L, cf.getImeiDayExpTimes());
                Long imeiDayExp = FeatureBaseParse.getCntLevel((Long)dmpFeature.getImeiDayExpTimes(), (Long)7L);
                retMap.put("f5010070", DataUtil.Long2String((Long)FeatureBaseParse.getDmpData((Long)imeiDayExp, (Long)imeiDayExpTimes)));
                Long resoDayBidTimes = AdxFeatureParse.getResoDayTimes(cf.getResourceId(), cf.getImei(), 50L, cf.getResoDayBidTimes());
                Long resoDayBid = FeatureBaseParse.getCntLevel((Long)dmpFeature.getResoDayBidTimes(), (Long)50L);
                retMap.put("f5010080", DataUtil.Long2String((Long)FeatureBaseParse.getDmpData((Long)resoDayBid, (Long)resoDayBidTimes)));
                Long resoDayExpTimes = AdxFeatureParse.getResoDayTimes(cf.getResourceId(), cf.getImei(), 7L, cf.getResoDayExpTimes());
                Long resoDayExp = FeatureBaseParse.getCntLevel((Long)dmpFeature.getResoDayExpTimes(), (Long)7L);
                retMap.put("f5010090", DataUtil.Long2String((Long)FeatureBaseParse.getDmpData((Long)resoDayExp, (Long)resoDayExpTimes)));
                retMap.put("f5010100", cf.getNewSex());
                retMap.put("f5010110", DataUtil.Integer2String((Integer)cf.getDeviceRequestLevel()));
                String userBasicTags = FeatureBaseParse.getDmpData((String)dmpFeature.getUserBasicTags(), (String)cf.getUserTagsList());
                retMap.put("f7020009", Optional.ofNullable(dmpFeature.getAppList()).orElse(""));
                retMap.put("f7020010", cf.getAppList());
                retMap.put("f7040050", FeatureParse.bucket((Integer)dmpFeature.getWeekActivityRequest(), (int[])cntBucket).toString());
                retMap.put("f7040060", FeatureParse.bucket((Integer)dmpFeature.getDayActivityRequest(), (int[])cntBucket).toString());
                retMap.put("f7040070", dmpFeature.getPeriodActivityRequest());
                retMap.put("f7040080", FeatureParse.bucket((Integer)dmpFeature.getWeekActivityJoin(), (int[])cntBucket).toString());
                retMap.put("f7040090", FeatureParse.bucket((Integer)dmpFeature.getDayActivityJoin(), (int[])cntBucket).toString());
                retMap.put("f7040100", dmpFeature.getPeriodActivityJoin());
                retMap.put("f7040110", dmpFeature.getPeriodLaunchTrade());
                retMap.put("f7040120", dmpFeature.getClickLaunchTrade() == null ? null : dmpFeature.getClickLaunchTrade().toString());
                retMap.put("f7040130", dmpFeature.getPeriodClickTrade());
                retMap.put("f7040140", dmpFeature.getEffectClickTrade() == null ? null : dmpFeature.getEffectClickTrade().toString());
                AdxIndexStatDo resoApp2DayInfo = Optional.ofNullable(resoAppStats.getLast2DayStat()).orElse(new AdxIndexStatDo());
                Long resoApp2dayExp = resoApp2DayInfo.getExp();
                retMap.put("f309010", DataUtil.Long2String((Long)resoApp2dayExp));
                Long resoApp2dayClick = resoApp2DayInfo.getClick();
                retMap.put("f309020", DataUtil.Long2String((Long)resoApp2dayClick));
                Long reso2dayFlcActClick = resoApp2DayInfo.getFlcActClick();
                retMap.put("f309030", DataUtil.Long2String((Long)reso2dayFlcActClick));
                Double reso2dayCtr = FeatureBaseParse.getWilsonScore((Long)resoApp2dayClick, (Long)resoApp2dayExp);
                retMap.put("f309040", DataUtil.double2String((Double)reso2dayCtr));
                Double reso2dayCvr = FeatureBaseParse.getWilsonScore((Long)reso2dayFlcActClick, (Long)resoApp2dayClick);
                retMap.put("f309050", DataUtil.double2String((Double)reso2dayCvr));
                AdxIndexStatDo resodaystat = Optional.ofNullable(resoAppStats.getResoDayStat()).orElse(new AdxIndexStatDo());
                retMap.put("f3016010", DataUtil.Long2String((Long)resodaystat.getExp()));
                retMap.put("f3016011", DataUtil.Long2String((Long)resodaystat.getActivityRequest()));
                retMap.put("f3016012", DataUtil.Long2String((Long)resodaystat.getActiviyJoin()));
                retMap.put("f3016013", DataUtil.Long2String((Long)resodaystat.getAdvertClick()));
                AdxIndexStatDo reso1daystat = Optional.ofNullable(resoAppStats.getReso1DayStat()).orElse(new AdxIndexStatDo());
                retMap.put("f3016014", DataUtil.Long2String((Long)reso1daystat.getExp()));
                retMap.put("f3016015", DataUtil.Long2String((Long)reso1daystat.getActivityRequest()));
                retMap.put("f3016016", DataUtil.Long2String((Long)reso1daystat.getActiviyJoin()));
                retMap.put("f3016017", DataUtil.Long2String((Long)reso1daystat.getAdvertClick()));
                AdxIndexStatDo reso7daystat = Optional.ofNullable(resoAppStats.getReso7DayStat()).orElse(new AdxIndexStatDo());
                retMap.put("f3016018", DataUtil.Long2String((Long)reso7daystat.getExp()));
                retMap.put("f3016019", DataUtil.Long2String((Long)reso7daystat.getActivityRequest()));
                retMap.put("f3016020", DataUtil.Long2String((Long)reso7daystat.getActiviyJoin()));
                retMap.put("f3016021", DataUtil.Long2String((Long)reso7daystat.getAdvertClick()));
                AdxIndexStatDo reso14daystat = Optional.ofNullable(resoAppStats.getReso14DayStat()).orElse(new AdxIndexStatDo());
                retMap.put("f3016022", DataUtil.Long2String((Long)reso14daystat.getExp()));
                retMap.put("f3016023", DataUtil.Long2String((Long)reso14daystat.getActivityRequest()));
                retMap.put("f3016024", DataUtil.Long2String((Long)reso14daystat.getActiviyJoin()));
                retMap.put("f3016025", DataUtil.Long2String((Long)reso14daystat.getAdvertClick()));
            }
        }
        catch (Exception e) {
            logger.error("AdxFeatureParse.generateFeatureMapStatic error:" + e);
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(AdxIdeaAdFeatureDo adxIdeaAdFeatureDo, AdxFeatureDo cf, AdxFeatureDo staticCf) {
        HashMap<String, String> retMap = new HashMap<String, String>(256);
        try {
            if (cf != null) {
                retMap.put("f3010010", DataUtil.Long2String((Long)cf.getIdeaId()));
                retMap.put("f3011000", DataUtil.Long2String((Long)cf.getIdeaUnitId()));
                retMap.put("f3010060", DataUtil.Integer2String((Integer)cf.getIdeaPicH1()));
                retMap.put("f3010070", DataUtil.Integer2String((Integer)cf.getIdeaPicW1()));
                retMap.put("f3010140", DataUtil.Integer2String((Integer)cf.getIdeaType()));
                List videoList = cf.getVideoMaterialDo();
                String videoMaterialId = FeatureBaseParse.getMaterialFeature((List)videoList, (String)"materialId");
                retMap.put("f3030011", videoMaterialId);
                retMap.put("f3010146", DataUtil.Long2String((Long)adxIdeaAdFeatureDo.getIdeaExpDay()));
                retMap.put("f3010158", DataUtil.Long2String((Long)adxIdeaAdFeatureDo.getIdeaActAccCntDay()));
                retMap.put("f3010159", DataUtil.Long2String((Long)adxIdeaAdFeatureDo.getIdeaActJoinCntDay()));
                retMap.put("f3010147", DataUtil.Long2String((Long)adxIdeaAdFeatureDo.getIdeaCoupClkpvDay()));
                retMap.put("f3010148", DataUtil.Long2String((Long)adxIdeaAdFeatureDo.getIdeaExp1Day()));
                retMap.put("f3010149", DataUtil.Long2String((Long)adxIdeaAdFeatureDo.getIdeaActAcc1Day()));
                retMap.put("f3010150", DataUtil.Long2String((Long)adxIdeaAdFeatureDo.getIdeaActJoin1Day()));
                retMap.put("f3010151", DataUtil.Long2String((Long)adxIdeaAdFeatureDo.getIdeaCoupClkpv1Day()));
                retMap.put("f3010152", DataUtil.Long2String((Long)adxIdeaAdFeatureDo.getIdeaExp7Day()));
                retMap.put("f3010160", DataUtil.Long2String((Long)adxIdeaAdFeatureDo.getIdeaActAccCntWeek()));
                retMap.put("f3010161", DataUtil.Long2String((Long)adxIdeaAdFeatureDo.getIdeaActJoinCntWeek()));
                retMap.put("f3010153", DataUtil.Long2String((Long)adxIdeaAdFeatureDo.getIdeaCoupClkpv7Day()));
                retMap.put("f3010154", DataUtil.Long2String((Long)adxIdeaAdFeatureDo.getIdeaExp14Day()));
                retMap.put("f3010155", DataUtil.Long2String((Long)adxIdeaAdFeatureDo.getIdeaActAcc14Day()));
                retMap.put("f3010156", DataUtil.Long2String((Long)adxIdeaAdFeatureDo.getIdeaActJoin14Day()));
                retMap.put("f3010157", DataUtil.Long2String((Long)adxIdeaAdFeatureDo.getIdeaCoupClkpv14Day()));
                String ideaAppId = FeatureBaseParse.getIdCrossValue((Long)cf.getIdeaId(), (String)staticCf.getAppName());
                retMap.put("f3060010", ideaAppId);
                Long ideaAppExpCntDay = cf.getIdeaAppExpCntDay();
                retMap.put("f3060011", DataUtil.Long2String((Long)AdxFeatureParse.bucket(ideaAppExpCntDay, ADV_EXP_CLK_CNT)));
                Long ideaAppClickCntDay = cf.getIdeaAppClickCntDay();
                retMap.put("f3060012", DataUtil.Long2String((Long)AdxFeatureParse.bucket(ideaAppClickCntDay, ADV_EXP_CLK_CNT)));
                Long ideaAppAdCostDay = cf.getIdeaAppAdCostDay();
                retMap.put("f3060013", DataUtil.Long2String((Long)AdxFeatureParse.bucket(ideaAppAdCostDay, ADV_EXP_CLK_CNT)));
                Double ideaAppCtr = FeatureBaseParse.getWilsonScore((Long)ideaAppClickCntDay, (Long)ideaAppExpCntDay);
                Long ideaAppLaunchCntDay = cf.getIdeaAppLaunchCntDay();
                retMap.put("f3060016", DataUtil.Long2String((Long)AdxFeatureParse.bucket(ideaAppLaunchCntDay, ADV_EXP_CLK_CNT)));
                Long ideaAppAdClickCntDay = cf.getIdeaAppAdClickCntDay();
                retMap.put("f3060017", DataUtil.Long2String((Long)AdxFeatureParse.bucket(ideaAppAdClickCntDay, ADV_EXP_CLK_CNT)));
                Long ideaAppCtrLevel = FeatureBaseParse.bucket((Double)ideaAppCtr, (double[])CTR_BUCKET);
                retMap.put("f3060014", DataUtil.Long2String((Long)ideaAppCtrLevel));
                Double ideaAppCva = DataUtil.division((Long)ideaAppAdCostDay, (Long)ideaAppClickCntDay);
                Long ideaAppCvaLevel = FeatureBaseParse.bucket((Double)ideaAppCva, (double[])CVA_BUCKET);
                retMap.put("f3060015", DataUtil.Long2String((Long)ideaAppCvaLevel));
                Double accCntDay = MathUtil.log((Long)cf.getIdeaActAccCntDay());
                Double joinCntDay = MathUtil.log((Long)cf.getIdeaActJoinCntDay());
                Double accCntWeek = MathUtil.log((Long)cf.getIdeaActAccCntWeek());
                Double joinCntWeek = MathUtil.log((Long)cf.getIdeaActJoinCntWeek());
                retMap.put("f3010141", DataUtil.Long2String((Long)FeatureBaseParse.bucket((Double)accCntDay, (double[])ACT_ACCESS_CNT)));
                retMap.put("f3010142", DataUtil.Long2String((Long)FeatureBaseParse.bucket((Double)joinCntDay, (double[])ACT_ACCESS_CNT)));
                retMap.put("f3010143", DataUtil.Long2String((Long)FeatureBaseParse.bucket((Double)accCntWeek, (double[])ACT_ACCESS_CNT)));
                retMap.put("f3010144", DataUtil.Long2String((Long)FeatureBaseParse.bucket((Double)joinCntWeek, (double[])ACT_ACCESS_CNT)));
                Double pvLaunch = DataUtil.division((Long)cf.getIdeaActJoinCntDay(), (Long)cf.getIdeaActAccCntDay());
                Long pvLaunchLevel = FeatureBaseParse.bucket((Double)pvLaunch, (double[])PV_LAUNCH);
                retMap.put("f3010145", DataUtil.Long2String((Long)pvLaunchLevel));
                Long idea2dayExp = cf.getIdea2dExp();
                retMap.put("f308010", DataUtil.Long2String((Long)idea2dayExp));
                Long idea2dayClick = cf.getIdea2dClick();
                retMap.put("f307020", DataUtil.Long2String((Long)idea2dayClick));
                Long idea2dayFlcClick = cf.getIdea2dFlcClick();
                retMap.put("f307030", DataUtil.Long2String((Long)idea2dayFlcClick));
                Double flc2dayCtr = FeatureBaseParse.getWilsonScore((Long)idea2dayClick, (Long)idea2dayExp);
                retMap.put("f307040", DataUtil.double2String((Double)flc2dayCtr));
                Double flc2dayCvr = FeatureBaseParse.getWilsonScore((Long)idea2dayFlcClick, (Long)idea2dayClick);
                retMap.put("f307050", DataUtil.double2String((Double)flc2dayCvr));
                AdxFlcFeatureDo adxFlcFeatureDo = adxIdeaAdFeatureDo.getAdxFlcFeatureDo();
                if (null != adxFlcFeatureDo) {
                    Map<String, String> flcFeatureMap = AdxFeatureParse.generateFlcFeatureMap(adxFlcFeatureDo);
                    retMap.putAll(flcFeatureMap);
                }
            }
        }
        catch (Exception e) {
            logger.error("AdxFeatureParse.generateFeatureMapDynamic error:", (Throwable)e);
        }
        return retMap;
    }

    public static Map<String, String> generateFlcFeatureMap(AdxFlcFeatureDo adxFlcFeatureDo) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        retMap.put("f101001", String.valueOf(adxFlcFeatureDo.getFlcAdvertId()));
        retMap.put("f106001", adxFlcFeatureDo.getAdvertAccount());
        retMap.put("f660001", adxFlcFeatureDo.getOperatingNewTrade());
        retMap.put("f102001", adxFlcFeatureDo.getAdvertIndustryLabel());
        AdxStatsDo adxFlcStatsDo = Optional.ofNullable(adxFlcFeatureDo.getAdxStatsDo()).orElse(new AdxStatsDo());
        AdxIndexStatDo flc2DaysStat = Optional.ofNullable(adxFlcStatsDo.getLast2DayStat()).orElse(new AdxIndexStatDo());
        Long flc2dayExp = flc2DaysStat.getExp();
        retMap.put("f307010", DataUtil.Long2String((Long)flc2dayExp));
        Long flc2dayClick = flc2DaysStat.getClick();
        retMap.put("f307020", DataUtil.Long2String((Long)flc2dayClick));
        Long flc2dayFlcActClick = flc2DaysStat.getFlcActClick();
        retMap.put("f307030", DataUtil.Long2String((Long)flc2dayFlcActClick));
        Double flc2dayCtr = FeatureBaseParse.getWilsonScore((Long)flc2dayClick, (Long)flc2dayExp);
        retMap.put("f307040", DataUtil.double2String((Double)flc2dayCtr));
        Double flc2dayCvr = FeatureBaseParse.getWilsonScore((Long)flc2dayFlcActClick, (Long)flc2dayClick);
        retMap.put("f307050", DataUtil.double2String((Double)flc2dayCvr));
        return retMap;
    }

    public static Map<String, String> generateActivityFeatureMapDynamic(CandidateActivityDo cf, Map<String, String> staticCf) {
        HashMap<String, String> retMap = new HashMap<String, String>(256);
        try {
            if (cf != null) {
                retMap.put("f331001", DataUtil.Long2String((Long)cf.getSkinId()));
                retMap.put("f354001", cf.getSkinFeature().getComponentSkinCategory());
                retMap.put("f354004", DataUtil.Long2String((Long)AdxFeatureParse.bucket(cf.getSkinFeature().getComponentSkinHistClick(), userCtrBucket)));
                retMap.put("f354005", DataUtil.Long2String((Long)AdxFeatureParse.bucket(cf.getSkinFeature().getComponentSkinWeekClick(), userCtrBucket)));
                retMap.put("f354006", DataUtil.Long2String((Long)AdxFeatureParse.bucket(cf.getSkinFeature().getComponentSkinDayClick(), userCtrBucket)));
                retMap.put("f354007", DataUtil.Long2String((Long)AdxFeatureParse.bucket(cf.getSkinFeature().getComponentSkinHistOrder(), userCvrBucket)));
                retMap.put("f354008", DataUtil.Long2String((Long)AdxFeatureParse.bucket(cf.getSkinFeature().getComponentSkinWeekOrder(), userCvrBucket)));
                retMap.put("f354009", DataUtil.Long2String((Long)AdxFeatureParse.bucket(cf.getSkinFeature().getComponentSkinDayOrder(), userCvrBucket)));
                retMap.put("f354013", DataUtil.Long2String((Long)AdxFeatureParse.bucket(cf.getSkinFeature().getSkinHistConsumer(), userConBucket)));
                retMap.put("f354010", DataUtil.Long2String((Long)AdxFeatureParse.bucket(cf.getSkinFeature().getSkinWeekConsumer(), userConBucket)));
                retMap.put("f354011", DataUtil.Long2String((Long)AdxFeatureParse.bucket(cf.getSkinFeature().getSkinDayConsumer(), userConBucket)));
                retMap.put("f301001", DataUtil.Long2String((Long)cf.getActivityId()));
                retMap.put("f341002", DataUtil.Long2String((Long)AdxFeatureParse.bucket(cf.getRoutineActFeature().getRoutineActHistClick(), userCtrBucket)));
                retMap.put("f341003", DataUtil.Long2String((Long)AdxFeatureParse.bucket(cf.getRoutineActFeature().getRoutineActWeekClick(), userCtrBucket)));
                retMap.put("f341004", DataUtil.Long2String((Long)AdxFeatureParse.bucket(cf.getRoutineActFeature().getRoutineActHistOrder(), userCvrBucket)));
                retMap.put("f341005", DataUtil.Long2String((Long)AdxFeatureParse.bucket(cf.getRoutineActFeature().getRoutineActWeekOrder(), userCvrBucket)));
                JSONObject routineActTradeVisitTime = DataUtil.stringToJson((String)("{" + cf.getRoutineActFeature().getRoutineActTradeVisitTime() + "}"));
                retMap.put("f341006", AdxFeatureParse.getCategoryJsonByBucket(routineActTradeVisitTime, cntBucket));
                JSONObject routineActTradeClickTime = DataUtil.stringToJson((String)("{" + cf.getRoutineActFeature().getRoutineActTradeClickTime() + "}"));
                retMap.put("f341007", AdxFeatureParse.getCategoryJsonByBucket(routineActTradeClickTime, cntBucket));
                retMap.put("f341008", cf.getRoutineActFeature().getRoutineActActType());
                retMap.put("f341009", DataUtil.Long2String((Long)AdxFeatureParse.bucket(cf.getRoutineActFeature().getRoutineActHistConsumer(), userConBucket)));
                retMap.put("f341010", DataUtil.Long2String((Long)AdxFeatureParse.bucket(cf.getRoutineActFeature().getRoutineActWeekConsumer(), userConBucket)));
                retMap.put("f341011", DataUtil.Long2String((Long)AdxFeatureParse.bucket(cf.getRoutineActFeature().getRoutineActDayConsumer(), userConBucket)));
            }
        }
        catch (Exception e) {
            logger.error("AdxFeatureParse.generateActivityFeatureMapDynamic error:", (Throwable)e);
        }
        return retMap;
    }

    public static Long bucket(Double value, double[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (!(value <= bound)) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Long bucket(Integer value, int[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                int bound = bucketList[i];
                if (value > bound) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Long bucket(Long value, int[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                int bound = bucketList[i];
                if (value > (long)bound) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static String getCategoryJsonByBucket(JSONObject actMap, int[] buckets) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{actMap})) {
            return null;
        }
        ArrayList<Long> tmp = new ArrayList<Long>();
        try {
            for (String cKey : actMap.keySet()) {
                Integer cateKey = Integer.parseInt(cKey);
                Integer cateValue = actMap.getInteger(cKey);
                long value = (long)(cateKey * buckets.length) + AdxFeatureParse.bucket(cateValue, buckets);
                tmp.add(value);
            }
        }
        catch (Exception e) {
            return null;
        }
        return StringUtils.join(tmp, (String)",");
    }

    public static Integer getTimeStampToHour(Long timeStamp) {
        LocalDateTime localDate;
        Date date;
        Integer ret = null;
        if (timeStamp != null && (date = new Date(timeStamp)) != null && (localDate = LocalDateUtil.dateToLocal((Date)date)) != null) {
            ret = LocalDateUtil.getHour((LocalDateTime)localDate);
        }
        return ret;
    }

    public static Integer getTimeStampToWeekDay(Long timeStamp) {
        LocalDateTime localDate;
        Date date;
        Integer ret = null;
        if (timeStamp != null && (date = new Date(timeStamp)) != null && (localDate = LocalDateUtil.dateToLocal((Date)date)) != null) {
            ret = LocalDateUtil.getDayOfWeek((LocalDateTime)localDate);
        }
        return ret;
    }

    public static Long getStringToTimeStamp() {
        Long ret = null;
        String currentTime = LocalDateUtil.getCurrentLocalDateTime((String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        if (currentTime != null) {
            ret = LocalDateUtil.getTimeMillis((String)currentTime, (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        }
        return ret;
    }

    public static String getFloat2String(Float src) {
        String ret = null;
        if (src != null) {
            ret = Float.toString(src.floatValue());
        }
        return ret;
    }

    public static Long getObject2Long(Object src) {
        Long ret = null;
        if (AssertUtil.isNotEmpty((Object)src)) {
            ret = DataUtil.string2Long((String)String.valueOf(src));
        }
        return ret;
    }

    public static Long getIdeaExpTime(Long ideaId, Map<Long, Object> expTimeMap) {
        Long ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{ideaId, expTimeMap})) {
            Long cnt = AdxFeatureParse.getObject2Long(expTimeMap.get(ideaId));
            ret = cnt == null || cnt < 1L ? Long.valueOf(0L) : (cnt <= 7L ? cnt : Long.valueOf(-1L));
        }
        return ret;
    }

    public static Long getRegionLevel(Long areaCode) {
        Long ret = null;
        if (AssertUtil.isNotEmpty((Object)areaCode)) {
            int area = DataUtil.toInt((Long)areaCode);
            if (areaCode >= 1000L && areaCode != 8100L && areaCode != 8200L) {
                area = DataUtil.toInt((Long)(areaCode / 100L));
            }
            if (Arrays.asList(HUABEI_REGION).contains(area)) {
                ret = 80L;
            } else if (Arrays.asList(DONGBEI_REGION).contains(area)) {
                ret = 81L;
            } else if (Arrays.asList(HUADONG_REGION).contains(area)) {
                ret = 82L;
            } else if (Arrays.asList(HUAZHONG_REGION).contains(area)) {
                ret = 83L;
            } else if (Arrays.asList(HUANAN_REGION).contains(area)) {
                ret = 84L;
            } else if (Arrays.asList(XINAN_REGION).contains(area)) {
                ret = 85L;
            } else if (Arrays.asList(XIBEI_REGION).contains(area)) {
                ret = 86L;
            } else if (Arrays.asList(HMT_REGION).contains(area)) {
                ret = 87L;
            }
        }
        return ret;
    }

    public static Long getTierCityLevel(Long areaCode) {
        Long ret = null;
        if (AssertUtil.isNotEmpty((Object)areaCode)) {
            int area = DataUtil.toInt((Long)areaCode);
            if (Arrays.asList(FIRST_TIER_CITY).contains(area)) {
                ret = 1L;
            } else if (Arrays.asList(SECOND_TIER_CITY).contains(area)) {
                ret = 2L;
            } else if (Arrays.asList(THIRD_TIER_CITY).contains(area)) {
                ret = 3L;
            }
        }
        return ret;
    }

    public static Long getImeiDayTimes(String imei, Long timesLimit, Map<String, Long> timesMap) {
        Long ret = 0L;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{imei, timesMap})) {
            Long cnt = timesMap.get(imei);
            ret = cnt == null || cnt < 1L ? Long.valueOf(0L) : (cnt <= timesLimit ? cnt : Long.valueOf(99L));
        }
        return ret;
    }

    public static Long getResoDayTimes(Long resoId, String imei, Long timesLimit, Map<String, Long> timesMap) {
        Long ret = 0L;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{imei, resoId, timesMap})) {
            String statKey = DataUtil.Long2String((Long)resoId) + "_" + imei;
            Long cnt = timesMap.get(statKey);
            ret = cnt == null || cnt < 1L ? Long.valueOf(0L) : (cnt <= timesLimit ? cnt : Long.valueOf(99L));
        }
        return ret;
    }

    public static String getLastEqualStatus(String currentId1, String currentId2, String lastId) {
        Integer ret = 0;
        String currentId = null;
        if (AssertUtil.isNotEmpty((String)currentId1) && AssertUtil.isEmpty((String)currentId2)) {
            currentId = currentId1;
        } else if (AssertUtil.isNotEmpty((String)currentId2) && AssertUtil.isEmpty((String)currentId1)) {
            currentId = currentId2;
        } else if (AssertUtil.isAllNotEmpty((Object[])new Object[]{currentId1, currentId2})) {
            currentId = currentId1 + "," + currentId2;
        }
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{currentId, lastId})) {
            ret = currentId.equals(lastId) ? 1 : 0;
        } else if (AssertUtil.isAllEmpty((Object[])new Object[]{currentId, lastId})) {
            ret = null;
        }
        return DataUtil.Integer2String((Integer)ret);
    }

    public static String getFeatureCross(String str0, String str1) {
        String tmp_str0 = str0 == null ? "un" : str0;
        String tmp_str1 = str1 == null ? "un" : str1;
        String ret = tmp_str0 + "_" + tmp_str1;
        return ret;
    }

    public static String getCategoryActLevelByBucket(Map<Long, Long> actMap, int[] buckets) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{actMap, buckets})) {
            return null;
        }
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;
        ArrayList<Long> tmp = new ArrayList<Long>();
        try {
            for (Map.Entry<Long, Long> entry : actMap.entrySet()) {
                Long cateKey = entry.getKey();
                Long cateValue = entry.getValue();
                long value = cateKey * (long)limit + FeatureParse.bucket((Long)cateValue, (int[])buckets);
                tmp.add(value);
            }
        }
        catch (Exception e) {
            return null;
        }
        return StringUtils.join(tmp, (String)",");
    }
}

