/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.api.facade;

import cn.com.duiba.nezha.alg.api.dto.base.BaseAdvertDTO;
import cn.com.duiba.nezha.alg.api.dto.base.BaseRequestDTO;
import cn.com.duiba.nezha.alg.api.dto.base.BaseResult;
import cn.com.duiba.nezha.alg.api.facade.TemplateFacade;
import cn.com.duiba.nezha.alg.common.util.TypeKit;
import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTemplateFacade<Advert extends BaseAdvertDTO, Request extends BaseRequestDTO, Result extends BaseResult>
implements TemplateFacade<Advert, Request, Result> {
    private static final Logger log = LoggerFactory.getLogger(AbstractTemplateFacade.class);

    protected Result newResult() {
        return (Result)((BaseResult)TypeKit.newActualInstance(this.getClass(), (int)2));
    }

    protected Result newResult(Advert advert) {
        BaseResult result = (BaseResult)TypeKit.newActualInstance(this.getClass(), (int)2);
        result.setAdvertId(advert.getAdvertId());
        result.setPackageId(advert.getPackageId());
        return (Result)result;
    }

    public List<Result> execute(List<Advert> adverts, Request request) {
        if (CollectionUtils.isEmpty(adverts)) {
            return Collections.emptyList();
        }
        return adverts.stream().map(advert -> this.doExecute(advert, request)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Map<String, Result> execute(Map<String, Advert> adverts, Request request) {
        if (MapUtils.isEmpty(adverts)) {
            return Collections.emptyMap();
        }
        return adverts.values().stream().map(advert -> {
            Result result = this.doExecute(advert, request);
            if (result != null) {
                if (result.getAdvertId() == null) {
                    result.setAdvertId(advert.getAdvertId());
                }
                if (result.getPackageId() == null) {
                    result.setPackageId(advert.getPackageId());
                }
            }
            return result;
        }).filter(Objects::nonNull).collect(Collectors.toMap(BaseResult::buildKey, e -> e, (o, n) -> n));
    }

    public Result execute(Advert advert, Request request) {
        try {
            return this.doExecute(advert, request);
        }
        catch (Exception e) {
            log.warn("\u6a21\u677f\u63a5\u53e3\u65b9\u6cd5\u5f02\u5e38 advert={}, request={}", new Object[]{JSON.toJSONString(advert), JSON.toJSONString(request), e});
            return null;
        }
    }

    protected Result doExecute(Advert advert, Request request) {
        return null;
    }

    protected Map<String, Result> transformAdverts(Map<String, Advert> adverts) {
        if (MapUtils.isEmpty(adverts)) {
            return Collections.emptyMap();
        }
        return adverts.values().stream().filter(Objects::nonNull).map(advert -> {
            Result result = this.newResult();
            result.setAdvertId(advert.getAdvertId());
            result.setPackageId(advert.getPackageId());
            return result;
        }).collect(Collectors.toMap(BaseResult::buildKey, e -> e, (o, n) -> n));
    }
}

