/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.base;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;

public class MathBase {
    public static Boolean equals(Long a, Long b) {
        Boolean ret = false;
        if (AssertUtil.isAllEmpty((Object[])new Object[]{a, b})) {
            ret = true;
        } else if (AssertUtil.isAnyEmpty((Object[])new Object[]{a, b})) {
            ret = false;
        } else if (a.equals(b)) {
            ret = true;
        }
        return ret;
    }

    public static Double noiseSmoother(Double point, Double lowerLimit, Double upperLimit) {
        Double ret = point;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{upperLimit, lowerLimit})) {
            return ret;
        }
        if (point != null) {
            ret = point > upperLimit ? upperLimit : (point < lowerLimit ? lowerLimit : point);
        }
        return ret;
    }

    public static Double getConfidenceWeight(Long value, double[] bucketList, double[] weightList, double defaultValue) {
        Double valueD = null;
        if (value != null) {
            valueD = (double)value.longValue() + 0.0;
        }
        return MathBase.getConfidenceWeight(valueD, bucketList, weightList, defaultValue);
    }

    public static Double getConfidenceWeight(Double value, double[] bucketList, double[] weightList, double defaultValue) {
        Double ret = defaultValue;
        if (value != null && bucketList != null && bucketList.length > 0 && weightList != null && weightList.length == bucketList.length) {
            double lastWeight = weightList[0];
            double lastBound = bucketList[0];
            int size = bucketList.length;
            for (int i = 0; i < size; ++i) {
                double curWeight = weightList[i];
                double curBound = bucketList[i];
                double bound = bucketList[i];
                if (value <= bound) {
                    if (i > 0) {
                        ret = lastWeight + (curWeight - lastWeight) * (value - lastBound) / (curBound - lastBound);
                        break;
                    }
                    ret = weightList[0];
                    break;
                }
                if (i == size - 1) {
                    ret = weightList[size - 1];
                }
                lastWeight = weightList[i];
                lastBound = bucketList[i];
            }
        }
        return DataUtil.formatDouble((Double)ret, (int)3);
    }

    public static Double getConfidenceWeight(double value, double[] bucketList, double[] weightList) {
        return MathBase.getConfidenceWeight(value, bucketList, weightList, 0.0);
    }

    public static Double sigmoidWithZoomAndIntervalMap(double x, double lowerLimit, double upperLimit, double zoom) {
        return lowerLimit + (upperLimit - lowerLimit) * MathBase.sigmoidWithZoom(x, zoom);
    }

    public static Double sigmoidWithZoom(double x, double zoom) {
        return MathBase.sigmoid(x * zoom);
    }

    public static Double sigmoid(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    public static long getLongValue(Long value) {
        if (value == null) {
            return 0L;
        }
        return value;
    }
}

