package cn.com.duiba.nezha.alg.api.facade.recall.channel;

import cn.com.duiba.nezha.alg.api.dto.recall.ColdStartAdvertDTO;
import cn.com.duiba.nezha.alg.api.dto.recall.ColdStartRequest;
import cn.com.duiba.nezha.alg.api.dto.recall.RecallChannelResult;
import cn.com.duiba.nezha.alg.api.facade.recall.RecallChannelFacade;

import java.util.Map;

/**
 * 冷启动召回
 * @author lijicong
 * @since 2021-08-17
 */
public interface ColdStartRecallChannelFacade extends RecallChannelFacade<ColdStartAdvertDTO, ColdStartRequest> {


    /**
     * 新广告冷启动的特殊定向策略
     * 冷启动完整的功能是分两部分做的：召回层只负责组合智能匹配；跑量策略层对召回的组合进行具体的策略处理(涉及提权、CVR异常监控等)
     * @param adverts
     * @param coldStartRequest
     * @return
     */
    @Override
    Map<String, RecallChannelResult> execute(Map<String, ColdStartAdvertDTO> adverts, ColdStartRequest coldStartRequest);
}
