package cn.com.duiba.nezha.alg.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author lijicong
 * @since 2021-08-18
 */
public abstract class RecallEnums {

    @Getter
    @AllArgsConstructor
    public enum RecallChannelType {
        Heat(1, "热度召回"),
        InterestLabel(2, "兴趣标签召回"),
        Vector(3, "向量召回"),
        ActSequence(4, "行为序列召回"),
        Graph(5, "图召回"),
        Explore(6, "探索召回"),
        ColdStart(7, "新广告冷启动召回"),
        IndustryGeneral(8, "广告行业泛化召回"),
        Random(9, "随机召回"),
        AppIndustryGeneral(10, "媒体行业泛化召回"),
        AppColdStart(11, "新媒体冷启动召回"),
        collFilter(12, "协同过滤召回"),
        ;

        private final Integer code;
        private final String desc;

        public static Map<Integer, RecallChannelType> map = Arrays.stream(RecallChannelType.values())
                .collect(Collectors.toMap(RecallChannelType::getCode, e -> e));

        public static RecallChannelType of(Integer code) {
            return map.get(code);
        }

        public boolean is(Integer code) {
            return this.code.equals(code);
        }
    }

}
