package cn.com.duiba.nezha.alg.api.facade.recall.channel;

import cn.com.duiba.nezha.alg.api.dto.recall.HeatRequest;
import cn.com.duiba.nezha.alg.api.dto.recall.HeatAdvertDTO;
import cn.com.duiba.nezha.alg.api.dto.recall.RecallChannelResult;
import cn.com.duiba.nezha.alg.api.facade.recall.RecallChannelFacade;

import java.util.Map;

/**
 * 热度召回
 * @author lijicong
 * @since 2021-08-17
 */
public interface HeatRecallChannelFacade extends RecallChannelFacade<HeatAdvertDTO, HeatRequest> {
    
    /**
     * 热度召回
     *
     * 根据广告位从redis中相应的键下获取各维度的热点数据；
     * 对不同维度的热点数据进行融合、截断(topN、指标>XX)，生成最后的热度召回列表返回给nezha
     * @param adverts
     * @param heatRecalRequest
     * @return
     */
    @Override
    Map<String, RecallChannelResult> execute(Map<String, HeatAdvertDTO> adverts, HeatRequest heatRecalRequest);
}
