package cn.com.duiba.nezha.alg.api.facade.recall;

import cn.com.duiba.nezha.alg.api.dto.recall.RecallChannelResult;
import cn.com.duiba.nezha.alg.api.enums.RecallEnums.RecallChannelType;

import java.util.Map;

public interface MergeRecallChannelFacade {

    /**
     * 各召回通道融合结果，用于后续排序、跑量、控本等流程
     * @param param
     * @return 数据格式：{参竞配置：{通道code：得分score}}（eg:{74603_181105:{1:0.82, 2:0.33, 3:0.6, 4:null, 5:0.9, 6:null, 7:null},
     *                                                    75638_183618:{1:0.82, 2:0.33, 3:0.6, 4:null, 5:0.9, 6:null, 7:null},
     *                                                    ... ...}）
     */
    Map<String, Map<RecallChannelType, Double>> merge(Map<RecallChannelType, Map<String, RecallChannelResult>> param);

}
