/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.api.model.util;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.DataType;
import org.tensorflow.SavedModelBundle;
import org.tensorflow.Tensor;
import org.tensorflow.Tensors;
import org.tensorflow.framework.TensorInfo;

public class WuWuTFUtils {
    private static final Logger logger = LoggerFactory.getLogger(WuWuTFUtils.class);

    public static SavedModelBundle loadModel(String modelPath, String version) {
        String path = Paths.get(modelPath, version).toString();
        logger.info("local model path =" + path);
        SavedModelBundle bundle = SavedModelBundle.load((String)path, (String[])new String[]{"serve"});
        return bundle;
    }

    public static Long getLastVersion(String path) throws Exception {
        Long ret = null;
        File file = new File(path);
        if (file.isDirectory()) {
            File[] listFiles = file.listFiles();
            for (int i = 0; i < Objects.requireNonNull(listFiles).length; ++i) {
                File f = listFiles[i];
                String fName = f.getName();
                if (!StringUtils.isNumeric((String)fName)) continue;
                long version = Long.parseLong(fName);
                if (ret != null && ret >= version) continue;
                ret = version;
            }
        }
        return ret;
    }

    public static Tensor<?> listToTensor(List<String> input, TensorInfo inputInfo) {
        org.tensorflow.framework.DataType dtype = inputInfo.getDtype();
        int inputSize = input.size();
        if (dtype == org.tensorflow.framework.DataType.DT_FLOAT) {
            float[] arrayInput = new float[inputSize];
            for (int i = 0; i < input.size(); ++i) {
                String s = input.get(i);
                float inputWithType = 0.0f;
                if (s != null) {
                    try {
                        inputWithType = Float.parseFloat(s);
                    }
                    catch (NumberFormatException e) {
                        logger.warn("listToTensor exception", (Throwable)e);
                    }
                }
                arrayInput[i] = inputWithType;
            }
            return Tensors.create((float[])arrayInput);
        }
        if (dtype == org.tensorflow.framework.DataType.DT_STRING) {
            byte[][] arrayInput = new byte[inputSize][];
            for (int i = 0; i < input.size(); ++i) {
                String s = input.get(i);
                String inputWithType = "";
                if (s != null) {
                    inputWithType = s;
                }
                arrayInput[i] = inputWithType.getBytes(StandardCharsets.UTF_8);
            }
            return Tensors.create((byte[][])arrayInput);
        }
        return null;
    }

    public static <T> T[][] tensorToArray(Tensor<T> tensorResult) {
        long[] tensorShape = tensorResult.shape();
        if (DataType.STRING == tensorResult.dataType()) {
            byte[][][] byteListResult = new byte[(int)tensorShape[0]][(int)tensorShape[1]][];
            tensorResult.copyTo((Object)byteListResult);
            String[][] listResult = new String[(int)tensorShape[0]][(int)tensorShape[1]];
            for (int p = 0; p < byteListResult.length; ++p) {
                for (int q = 0; q < byteListResult[p].length; ++q) {
                    listResult[p][q] = new String(byteListResult[p][q], StandardCharsets.UTF_8);
                }
            }
            return listResult;
        }
        if (DataType.FLOAT == tensorResult.dataType()) {
            float[][] listResult = new float[(int)tensorShape[0]][(int)tensorShape[1]];
            tensorResult.copyTo((Object)listResult);
            Float[][] listResult1 = new Float[(int)tensorShape[0]][(int)tensorShape[1]];
            for (int i = 0; i < listResult1.length; ++i) {
                for (int j = 0; j < listResult1[i].length; ++j) {
                    listResult1[i][j] = Float.valueOf(listResult[i][j]);
                }
            }
            return listResult1;
        }
        return null;
    }
}

