/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.api.model;

import cn.com.duiba.nezha.alg.api.model.E2ELocalTFModel;
import cn.com.duiba.nezha.alg.api.model.util.E2ETFUtils;
import cn.com.duiba.nezha.alg.api.model.util.TensorflowUtils;
import com.alibaba.fastjson.JSON;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.nashorn.internal.ir.debug.ObjectSizeCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.DataType;
import org.tensorflow.SavedModelBundle;
import org.tensorflow.Session;
import org.tensorflow.Tensor;
import org.tensorflow.Tensors;
import org.tensorflow.framework.MetaGraphDef;
import org.tensorflow.framework.SignatureDef;
import org.tensorflow.framework.TensorInfo;

public class AdxLocalTFModel {
    private static final Logger logger = LoggerFactory.getLogger(E2ELocalTFModel.class);
    private static final String SIGNATURE_DEF = "serving_default";
    private SavedModelBundle bundle;
    private String path;
    private Long version;
    private Map<String, TensorInfo> inputSpecMap;
    private Map<String, TensorInfo> outputSpecMap;

    public void loadLatestModel(String path) throws Exception {
        Long lastVersion = E2ETFUtils.getLastVersion(path);
        SavedModelBundle bundle = E2ETFUtils.loadModel(path, lastVersion + "");
        logger.info("loadModel ,path=" + path + "with version=" + lastVersion);
        this.setModel(bundle);
        this.path = path;
        this.version = lastVersion;
    }

    public void close() throws Exception {
        if (this.bundle != null) {
            logger.info("close model  ,path=" + this.path + "with version=" + this.version);
            logger.info("bundle.size before close :" + ObjectSizeCalculator.getObjectSize((Object)this.bundle));
            this.bundle.close();
            this.bundle = null;
        }
    }

    private void setModel(SavedModelBundle bundle) throws Exception {
        this.bundle = bundle;
        this.inputSpecMap = this.getInputSpecMap(bundle);
        this.outputSpecMap = this.getOutputSpecMap(bundle);
    }

    private Map<String, TensorInfo> getInputSpecMap(SavedModelBundle bundle) throws Exception {
        SignatureDef sig = MetaGraphDef.parseFrom((byte[])bundle.metaGraphDef()).getSignatureDefOrThrow(SIGNATURE_DEF);
        return sig.getInputsMap();
    }

    private Map<String, TensorInfo> getOutputSpecMap(SavedModelBundle bundle) throws Exception {
        SignatureDef sig = MetaGraphDef.parseFrom((byte[])bundle.metaGraphDef()).getSignatureDefOrThrow(SIGNATURE_DEF);
        return sig.getOutputsMap();
    }

    private <T1> Map<String, Tensor<?>> preprocessInput(List<T1> sampleKeyList, Map<T1, Map<String, String>> sampleWithFeatureMap) {
        HashMap formattedInput = new HashMap();
        for (String featureKey : this.inputSpecMap.keySet()) {
            TensorInfo inputInfo = this.inputSpecMap.get(featureKey);
            String tfInputKey = inputInfo.getName();
            ArrayList<String> oneFeatureList = new ArrayList<String>();
            for (T1 sampleKey : sampleKeyList) {
                Map<String, String> featureMap = sampleWithFeatureMap.get(sampleKey);
                oneFeatureList.add(featureMap.getOrDefault(featureKey, null));
            }
            Tensor<?> oneFeatureTensor = AdxLocalTFModel.listToTensor(oneFeatureList, inputInfo);
            formattedInput.put(tfInputKey, oneFeatureTensor);
        }
        return formattedInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private <T> Map<String, T[][]> executeTfGraph(Map<String, Tensor<?>> formattedInput) {
        HashMap<String, T[][]> resultMap;
        List result = null;
        try {
            void var7_10;
            ArrayList<String> outputKeyList = new ArrayList<String>();
            ArrayList<String> outputTfKeyList = new ArrayList<String>();
            for (String string : this.outputSpecMap.keySet()) {
                outputKeyList.add(string);
                outputTfKeyList.add(this.outputSpecMap.get(string).getName());
            }
            Session.Runner runner = this.bundle.session().runner();
            for (String inputTfKey : formattedInput.keySet()) {
                runner.feed(inputTfKey, formattedInput.get(inputTfKey));
            }
            for (String outputTfKey : outputTfKeyList) {
                runner.fetch(outputTfKey);
            }
            result = runner.run();
            resultMap = new HashMap<String, T[][]>();
            boolean bl = false;
            while (var7_10 < outputKeyList.size()) {
                Tensor tensorResult = (Tensor)result.get((int)var7_10);
                resultMap.put((String)outputKeyList.get((int)var7_10), this.tensorToArray(tensorResult));
                ++var7_10;
            }
        }
        finally {
            TensorflowUtils.closeQuitely(formattedInput.values());
            TensorflowUtils.closeQuitely(result);
        }
        return resultMap;
    }

    private <T1, T2> Map<String, Map<T1, T2[]>> formatOutputs(List<T1> sampleKeyList, Map<String, T2[][]> rawOutputs) {
        HashMap<String, Map<T1, T2[]>> resultMap = new HashMap<String, Map<T1, T2[]>>();
        ArrayList<String> outputKeyList = new ArrayList<String>(this.outputSpecMap.keySet());
        for (String outputKey : outputKeyList) {
            HashMap<T1, T2[]> outputMap = new HashMap<T1, T2[]>();
            for (int i = 0; i < sampleKeyList.size(); ++i) {
                T2[] oneOutputs = rawOutputs.get(outputKey)[i];
                outputMap.put(sampleKeyList.get(i), oneOutputs);
            }
            resultMap.put(outputKey, outputMap);
        }
        return resultMap;
    }

    public <T1, T2> Map<String, Map<T1, T2[]>> predict(Map<T1, Map<String, String>> sampleWithFeatureMap) {
        ArrayList<T1> sampleKeyList = new ArrayList<T1>(sampleWithFeatureMap.keySet());
        Map<String, Tensor<?>> formattedInput = this.preprocessInput(sampleKeyList, sampleWithFeatureMap);
        Map<String, T2[][]> rawOutputs = this.executeTfGraph(formattedInput);
        Map<String, Map<T1, T2[]>> predResults = this.formatOutputs(sampleKeyList, rawOutputs);
        return predResults;
    }

    public static Tensor<?> listToTensor(List<String> input, TensorInfo inputInfo) {
        org.tensorflow.framework.DataType dtype = inputInfo.getDtype();
        int inputSize = input.size();
        if (dtype == org.tensorflow.framework.DataType.DT_FLOAT) {
            float[] arrayInput = new float[inputSize];
            for (int i = 0; i < input.size(); ++i) {
                String s = input.get(i);
                float inputWithType = 0.0f;
                if (s != null) {
                    try {
                        inputWithType = Float.parseFloat(s);
                    }
                    catch (NumberFormatException e) {
                        logger.warn("listToTensor exception", (Throwable)e);
                    }
                }
                arrayInput[i] = inputWithType;
            }
            return Tensors.create((float[])arrayInput);
        }
        if (dtype == org.tensorflow.framework.DataType.DT_STRING) {
            byte[][] arrayInput = new byte[inputSize][];
            for (int i = 0; i < input.size(); ++i) {
                String s = input.get(i);
                String inputWithType = "";
                if (s != null) {
                    inputWithType = s;
                }
                arrayInput[i] = inputWithType.getBytes(StandardCharsets.UTF_8);
            }
            return Tensors.create((byte[][])arrayInput);
        }
        return null;
    }

    private <T> T[][] tensorToArray(Tensor<?> tensorResult) {
        long[] tensorShape = tensorResult.shape();
        if (DataType.STRING == tensorResult.dataType()) {
            byte[][][] byteListResult = new byte[(int)tensorShape[0]][(int)tensorShape[1]][];
            tensorResult.copyTo((Object)byteListResult);
            String[][] listResult = new String[(int)tensorShape[0]][(int)tensorShape[1]];
            for (int p = 0; p < byteListResult.length; ++p) {
                for (int q = 0; q < byteListResult[p].length; ++q) {
                    listResult[p][q] = new String(byteListResult[p][q], StandardCharsets.UTF_8);
                }
            }
            return listResult;
        }
        if (DataType.FLOAT == tensorResult.dataType()) {
            float[][] listResult = new float[(int)tensorShape[0]][(int)tensorShape[1]];
            tensorResult.copyTo((Object)listResult);
            Float[][] listResult1 = new Float[(int)tensorShape[0]][(int)tensorShape[1]];
            for (int i = 0; i < listResult1.length; ++i) {
                for (int j = 0; j < listResult1[i].length; ++j) {
                    listResult1[i][j] = Float.valueOf(listResult[i][j]);
                }
            }
            return listResult1;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        AdxLocalTFModel adxLocalTFModel = new AdxLocalTFModel();
        adxLocalTFModel.loadLatestModel("/Users/panhangyi/mid-adx-esmm-ctclk-phy-v2");
        String str = "{\"f309040\":\"0.0\",\"f414004\":\"0\",\"f3010010\":\"32545\",\"f5020101\":\"0\",\"f5020103\":\"0\",\"f309050\":\"0.0\",\"f5020102\":\"0\",\"f5020105\":\"1000\",\"f5020104\":\"1000\",\"f5020106\":\"1000\",\"f413004\":\"0\",\"f2010010\":\"2636\",\"f5020010\":\"0\",\"f1010020\":\"44\",\"f7040050\":\"0\",\"f3016024\":\"221290\",\"f3016025\":\"120527\",\"f3016022\":\"1261178\",\"f4010010\":\"Mozilla/5.0 (iPhone; CPU iPhone OS 15_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148 MicroMessenger/8.0.28(0x18001c2c) NetType/4G Language/zh_CN\",\"f3016023\":\"457932\",\"f7040060\":\"0\",\"f409004\":\"0\",\"f3016020\":\"113899\",\"f3010161\":\"113899\",\"f3016021\":\"62498\",\"f3010160\":\"234457\",\"f5020030\":\"0\",\"f4010121\":\"15\",\"f5010110\":\"1\",\"f2010060\":\"411143\",\"f410004\":\"0\",\"f5020020\":\"0\",\"f4010122\":\"7\",\"f4010030\":\"0\",\"f7040080\":\"0\",\"f3010144\":\"9\",\"f3010143\":\"10\",\"f3010142\":\"7\",\"f3010141\":\"8\",\"f5020050\":\"0\",\"f3010149\":\"78286\",\"f3010148\":\"220104\",\"f0001\":\"15\",\"f3010147\":\"7173\",\"f3010146\":\"69150\",\"f3010145\":\"7\",\"f0003\":\"1\",\"f0002\":\"7\",\"f5010135\":\"\",\"f3016013\":\"7778\",\"f5010134\":\"\",\"f3016014\":\"220104\",\"f5010133\":\"\",\"f3016011\":\"25292\",\"f3016012\":\"12710\",\"f3016017\":\"23726\",\"f3016018\":\"666218\",\"f7040090\":\"0\",\"f3016015\":\"78286\",\"f5010136\":\"\",\"f3016016\":\"39700\",\"f3010155\":\"457932\",\"f3010154\":\"1261178\",\"f3010153\":\"62498\",\"f3010152\":\"666218\",\"f3010151\":\"23726\",\"f5020040\":\"0\",\"f3010150\":\"39700\",\"f3016010\":\"75969\",\"f3010159\":\"11655\",\"f3010158\":\"23170\",\"f3010157\":\"120527\",\"f6060011\":\"0\",\"f3010156\":\"221290\",\"f6060012\":\"0\",\"f6060013\":\"0\",\"f6060014\":\"1\",\"f6060015\":\"1\",\"f3016019\":\"234457\",\"f5010010\":\"010105\",\"f0309\":\"0\",\"f0308\":\"0\",\"f0307\":\"0\",\"f411004\":\"0\",\"f5020070\":\"0\",\"f3030011\":\"\",\"f0302\":\"0\",\"f0301\":\"0\",\"f0306\":\"0\",\"f0305\":\"0\",\"f0304\":\"0\",\"f0303\":\"0\",\"f5010036\":\"0\",\"f5010035\":\"0\",\"f5010034\":\"0\",\"f5010033\":\"0\",\"f5020060\":\"0\",\"f6010102\":\"[1]\",\"f4010070\":\"3\",\"f5020090\":\"0\",\"f0320\":\"0\",\"f307040\":\"0.0\",\"f0203\":\"0\",\"f0324\":\"0\",\"f0202\":\"0\",\"f0323\":\"0\",\"f0201\":\"0\",\"f0322\":\"0\",\"f0321\":\"0\",\"f0327\":\"0\",\"f0326\":\"0\",\"f0204\":\"0\",\"f0325\":\"0\",\"f0319\":\"0\",\"f0318\":\"0\",\"f5020080\":\"0\",\"f3060017\":\"1\",\"f3060016\":\"1\",\"f307050\":\"0.0\",\"f3060013\":\"1\",\"f5010050\":\"8e3H3Ny3GBDTLn3T\",\"f0313\":\"0\",\"f3060012\":\"1\",\"f0312\":\"0\",\"f3060015\":\"1\",\"f0311\":\"0\",\"f3060014\":\"1\",\"f0310\":\"0\",\"f0317\":\"0\",\"f0316\":\"0\",\"f3060011\":\"1\",\"f0315\":\"0\",\"f0314\":\"0\",\"f4010091\":\"0\",\"f1010010\":\"190\",\"f5010060\":\"0\",\"f3020000\":\"0\",\"f5010079\":\"0\",\"f5010078\":\"0\",\"f5010077\":\"0\",\"f5030101\":\"190&1000\",\"f5030102\":\"2636&1000\",\"f5030103\":\"32545&1000\",\"f4010080\":\"0\",\"f5010070\":\"0\",\"f5010076\":\"0\",\"f5010075\":\"0\",\"f5010074\":\"0\",\"f6010090\":\"411143\",\"f5010082\":\"0\",\"f5010081\":\"0\",\"f5010080\":\"0\",\"f412004\":\"0\",\"f5010090\":\"0\"}";
        HashMap featureMap = (HashMap)JSON.parseObject((String)str, HashMap.class);
        HashMap<Long, HashMap> sample = new HashMap<Long, HashMap>();
        sample.put(123L, featureMap);
        Map predict = adxLocalTFModel.predict(sample);
        System.out.println(predict);
    }

    public SavedModelBundle getBundle() {
        return this.bundle;
    }

    public String getPath() {
        return this.path;
    }

    public Long getVersion() {
        return this.version;
    }

    public Map<String, TensorInfo> getInputSpecMap() {
        return this.inputSpecMap;
    }

    public Map<String, TensorInfo> getOutputSpecMap() {
        return this.outputSpecMap;
    }

    public void setBundle(SavedModelBundle bundle) {
        this.bundle = bundle;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public void setInputSpecMap(Map<String, TensorInfo> inputSpecMap) {
        this.inputSpecMap = inputSpecMap;
    }

    public void setOutputSpecMap(Map<String, TensorInfo> outputSpecMap) {
        this.outputSpecMap = outputSpecMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdxLocalTFModel)) {
            return false;
        }
        AdxLocalTFModel other = (AdxLocalTFModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SavedModelBundle this$bundle = this.getBundle();
        SavedModelBundle other$bundle = other.getBundle();
        if (this$bundle == null ? other$bundle != null : !this$bundle.equals(other$bundle)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Map<String, TensorInfo> this$inputSpecMap = this.getInputSpecMap();
        Map<String, TensorInfo> other$inputSpecMap = other.getInputSpecMap();
        if (this$inputSpecMap == null ? other$inputSpecMap != null : !((Object)this$inputSpecMap).equals(other$inputSpecMap)) {
            return false;
        }
        Map<String, TensorInfo> this$outputSpecMap = this.getOutputSpecMap();
        Map<String, TensorInfo> other$outputSpecMap = other.getOutputSpecMap();
        return !(this$outputSpecMap == null ? other$outputSpecMap != null : !((Object)this$outputSpecMap).equals(other$outputSpecMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdxLocalTFModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SavedModelBundle $bundle = this.getBundle();
        result = result * 59 + ($bundle == null ? 43 : $bundle.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Map<String, TensorInfo> $inputSpecMap = this.getInputSpecMap();
        result = result * 59 + ($inputSpecMap == null ? 43 : ((Object)$inputSpecMap).hashCode());
        Map<String, TensorInfo> $outputSpecMap = this.getOutputSpecMap();
        result = result * 59 + ($outputSpecMap == null ? 43 : ((Object)$outputSpecMap).hashCode());
        return result;
    }

    public String toString() {
        return "AdxLocalTFModel(bundle=" + this.getBundle() + ", path=" + this.getPath() + ", version=" + this.getVersion() + ", inputSpecMap=" + this.getInputSpecMap() + ", outputSpecMap=" + this.getOutputSpecMap() + ")";
    }
}

