/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.api.model;

import cn.com.duiba.nezha.alg.api.model.util.NumberUtil;
import cn.com.duiba.nezha.alg.api.model.util.TensorflowUtils;
import com.google.common.primitives.Floats;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.DataType;
import org.tensorflow.SavedModelBundle;
import org.tensorflow.Session;
import org.tensorflow.Tensor;
import org.tensorflow.framework.MetaGraphDef;
import org.tensorflow.framework.SignatureDef;
import org.tensorflow.framework.TensorInfo;

public class LocalTFModel {
    private static final Logger logger = LoggerFactory.getLogger(LocalTFModel.class);
    private static String SIGNATURE_DEF = "serving_default";
    private SavedModelBundle bundle;
    private String path;
    private String version;
    private Map<String, TensorInfo> inputSpecMap;
    private Map<String, TensorInfo> outputSpecMap;

    public void setModel(SavedModelBundle bundle) throws Exception {
        this.bundle = bundle;
        this.inputSpecMap = this.getInputSpecMap(bundle, SIGNATURE_DEF);
        this.outputSpecMap = this.getOutputSpecMap(bundle, SIGNATURE_DEF);
    }

    public void loadModel(String path) throws Exception {
        Long lastVersion = this.getLastVersion(path);
        this.loadModel(path, lastVersion + "");
    }

    public Long getLastVersion(String path) throws Exception {
        Long ret = null;
        File file = new File(path);
        if (file.isDirectory()) {
            File[] listFiles = file.listFiles();
            for (int i = 0; i < Objects.requireNonNull(listFiles).length; ++i) {
                File f = listFiles[i];
                String fName = f.getName();
                if (!NumberUtil.isNumber(fName)) continue;
                long version = Long.parseLong(fName);
                if (ret != null && ret >= version) continue;
                ret = version;
            }
        }
        return ret;
    }

    public void loadModel(String path, String version) throws Exception {
        logger.info("loadModel ,path=" + path + "with version=" + version);
        SavedModelBundle bundle = TensorflowUtils.loadModel(path, version);
        this.setModel(bundle);
        this.path = path;
        this.version = version;
    }

    public void close() throws Exception {
        if (this.bundle != null) {
            logger.info("close model, path=" + this.path + "with version=" + this.version);
            this.bundle.close();
            this.bundle = null;
        }
    }

    public Map<String, TensorInfo> getInputSpecMap(SavedModelBundle bundle, String SIGNATURE_DEF) throws Exception {
        SignatureDef sig = MetaGraphDef.parseFrom((byte[])bundle.metaGraphDef()).getSignatureDefOrThrow(SIGNATURE_DEF);
        return sig.getInputsMap();
    }

    public Map<String, TensorInfo> getOutputSpecMap(SavedModelBundle bundle, String SIGNATURE_DEF) throws Exception {
        SignatureDef sig = MetaGraphDef.parseFrom((byte[])bundle.metaGraphDef()).getSignatureDefOrThrow(SIGNATURE_DEF);
        return sig.getOutputsMap();
    }

    public Map<String, Tensor<?>> preprocessInput(Map<String, String> featureMap) {
        HashMap inputTensorMap = new HashMap();
        for (String inputKey : this.inputSpecMap.keySet()) {
            Tensor tensorInput;
            Object arrayInput;
            TensorInfo inputInfo = this.inputSpecMap.get(inputKey);
            String featureKey = inputInfo.getName();
            if (inputInfo.getDtype() == org.tensorflow.framework.DataType.DT_FLOAT) {
                float rawInput = 0.0f;
                try {
                    rawInput = Float.parseFloat(featureMap.getOrDefault(inputKey, "0.0"));
                }
                catch (NumberFormatException e) {
                    logger.warn("LocalTFModel.preprocessInput exception", (Throwable)e);
                }
                arrayInput = new float[][]{{rawInput}};
                tensorInput = Tensor.create((Object)arrayInput, Float.class);
                inputTensorMap.put(featureKey, tensorInput);
                continue;
            }
            String rawInput = featureMap.getOrDefault(inputKey, "");
            if (rawInput == null) {
                rawInput = "";
            }
            arrayInput = new byte[][][]{new byte[][]{rawInput.getBytes(StandardCharsets.UTF_8)}};
            tensorInput = Tensor.create((Object)arrayInput, String.class);
            inputTensorMap.put(featureKey, tensorInput);
        }
        return inputTensorMap;
    }

    public List<?> tensorToList(Tensor tensorResult) {
        long[] tensorShape = tensorResult.shape();
        if (DataType.STRING == tensorResult.dataType()) {
            byte[][][] byteListResult = new byte[(int)tensorShape[0]][(int)tensorShape[1]][];
            tensorResult.copyTo((Object)byteListResult);
            String[][] listResult = new String[(int)tensorShape[0]][(int)tensorShape[1]];
            for (int p = 0; p < byteListResult.length; ++p) {
                for (int q = 0; q < byteListResult[p].length; ++q) {
                    listResult[p][q] = new String(byteListResult[p][q], StandardCharsets.UTF_8);
                }
            }
            return Arrays.asList(listResult[0]);
        }
        if (DataType.FLOAT == tensorResult.dataType()) {
            float[][] listResult = new float[(int)tensorShape[0]][(int)tensorShape[1]];
            tensorResult.copyTo((Object)listResult);
            return Floats.asList((float[])listResult[0]);
        }
        return null;
    }

    public Map<String, List<?>> predict(Map<String, String> featureMap) {
        Map<String, Tensor<?>> inputTensorMap = this.preprocessInput(featureMap);
        ArrayList<String> outputNameList = new ArrayList<String>();
        for (String string : this.outputSpecMap.keySet()) {
            outputNameList.add(this.outputSpecMap.get(string).getName());
        }
        Session.Runner runner = this.bundle.session().runner();
        for (String inputKey : inputTensorMap.keySet()) {
            runner.feed(inputKey, inputTensorMap.get(inputKey));
        }
        for (String outputName : outputNameList) {
            runner.fetch(outputName);
        }
        List list = runner.run();
        HashMap resultMap = new HashMap();
        for (int i = 0; i < outputNameList.size(); ++i) {
            Tensor tensor = (Tensor)list.get(i);
            resultMap.put((String)outputNameList.get(i), this.tensorToList(tensor));
        }
        for (Tensor<?> tensor : inputTensorMap.values()) {
            tensor.close();
        }
        for (Tensor tensor : list) {
            tensor.close();
        }
        return resultMap;
    }

    public static void main(String[] args) throws Exception {
        byte[][][] arrayInput = new byte[][][]{new byte[][]{"asdfasdfd".getBytes("UTF-8")}};
        String path = "/Users/butcher/Desktop/dssmV01";
        LocalTFModel model = new LocalTFModel();
        model.loadModel(path);
        HashMap<String, String> featureMap = new HashMap<String, String>();
        String colStr = "f451001\tf451002\tf506001\tf507001\tf507003\tf509001\tf509002\tf505001\tf509004\tf501001\tf8330021\tf8300011\tf8300021\tf8300041\tf8310011\tf8310021\tf8310041\tf205002\tf201001\tf108001\tf503001\tf502001\tf502003\tf502002\tafee\tad_pk";
        String valStr = "0119010101\t01020301\t3\t1\tAndroid6.0.1\tvivoy55a\tvivo\t1100-1699\t2016\tAndroid\t78465,78752,73920,77698,77250,78407,77419,78446,73714,77975,77463,78326,78393,78553,78072,77498,78173,78364,76831,78174\t78465,78752,77698,77250,78407,78446,73714,77975,77463,78326,78393,78553,78072,77498,78173,76831,78174\t41283,41540,40232,40363,39724,37839,37297,41236,40855,40951,39767,41400,41465,41435\t16,21,15\t78393\t37297\t16\t268\t82239\t401503\t4403\t0\t16\t2\t7.13\t78553_191877\t";
        String[] colList = colStr.split("\t");
        String[] valList = valStr.split("\t");
        for (int i = 0; i < colList.length - 1; ++i) {
            featureMap.put(colList[i], valList[i]);
        }
        Map<String, List<?>> result = model.predict(featureMap);
        System.out.println(result);
    }

    public SavedModelBundle getBundle() {
        return this.bundle;
    }

    public String getPath() {
        return this.path;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, TensorInfo> getInputSpecMap() {
        return this.inputSpecMap;
    }

    public Map<String, TensorInfo> getOutputSpecMap() {
        return this.outputSpecMap;
    }

    public void setBundle(SavedModelBundle bundle) {
        this.bundle = bundle;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setInputSpecMap(Map<String, TensorInfo> inputSpecMap) {
        this.inputSpecMap = inputSpecMap;
    }

    public void setOutputSpecMap(Map<String, TensorInfo> outputSpecMap) {
        this.outputSpecMap = outputSpecMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalTFModel)) {
            return false;
        }
        LocalTFModel other = (LocalTFModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SavedModelBundle this$bundle = this.getBundle();
        SavedModelBundle other$bundle = other.getBundle();
        if (this$bundle == null ? other$bundle != null : !this$bundle.equals(other$bundle)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Map<String, TensorInfo> this$inputSpecMap = this.getInputSpecMap();
        Map<String, TensorInfo> other$inputSpecMap = other.getInputSpecMap();
        if (this$inputSpecMap == null ? other$inputSpecMap != null : !((Object)this$inputSpecMap).equals(other$inputSpecMap)) {
            return false;
        }
        Map<String, TensorInfo> this$outputSpecMap = this.getOutputSpecMap();
        Map<String, TensorInfo> other$outputSpecMap = other.getOutputSpecMap();
        return !(this$outputSpecMap == null ? other$outputSpecMap != null : !((Object)this$outputSpecMap).equals(other$outputSpecMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LocalTFModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SavedModelBundle $bundle = this.getBundle();
        result = result * 59 + ($bundle == null ? 43 : $bundle.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Map<String, TensorInfo> $inputSpecMap = this.getInputSpecMap();
        result = result * 59 + ($inputSpecMap == null ? 43 : ((Object)$inputSpecMap).hashCode());
        Map<String, TensorInfo> $outputSpecMap = this.getOutputSpecMap();
        result = result * 59 + ($outputSpecMap == null ? 43 : ((Object)$outputSpecMap).hashCode());
        return result;
    }

    public String toString() {
        return "LocalTFModel(bundle=" + this.getBundle() + ", path=" + this.getPath() + ", version=" + this.getVersion() + ", inputSpecMap=" + this.getInputSpecMap() + ", outputSpecMap=" + this.getOutputSpecMap() + ")";
    }
}

