package cn.com.duiba.nezha.alg.api.model.util;

import lombok.Data;
import org.tensorflow.framework.DataType;

/***
 * 预估的结果类
 * TODO 这里已经完全不知道该使用一个方法返回结果，因为结果可能是String，也可能是String的数组
 */
@Data
public class E2EPredResult {
    private String name;
    private Class type;
    private Boolean isArray;
    private Float floatResult;
    private String stringResult;
    private Float[] floatsResult;
    private String[] stringsResult;

    public E2EPredResult(String name) {
        this.setName(name);
    }

    public void setSingleResult(Object result, DataType dtype) {
        if (dtype == DataType.DT_FLOAT) {
            this.setFloatResult((Float) result);
            this.setType(Float.class);
        } else if (dtype == DataType.DT_STRING) {
            this.setStringResult((String) result);
            this.setType(String.class);
        }
        this.setIsArray(false);
    }

    public void setArrayResult(Object[] result, DataType dtype) {
        if (dtype == DataType.DT_FLOAT) {
            this.setFloatsResult((Float[]) result);
            this.setType(Float.class);
        } else if (dtype == DataType.DT_STRING) {
            this.setStringsResult((String[]) result);
            this.setType(String.class);
        }
        this.setIsArray(true);
    }

}
