package cn.com.duiba.nezha.alg.common.model.deeptarget;

import cn.com.duiba.nezha.alg.api.vo.PreDcvrStatInfo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static cn.com.duiba.nezha.alg.common.model.deeptarget.DeepTargetControl.getConfidenceWeight;

public class DeepAdjustFactor {


    private static final Logger logger = LoggerFactory.getLogger(cn.com.duiba.nezha.alg.common.model.deeptarget.DeepAdjustFactor.class);


    static class Constant {

        static double THRESHOLD = 0;//后端转化个数置信阈值
    }


    /**
     * 计算加价因子
     * @param preDcvrStatInfo
     * @param preDcvr
     * @param preCvr
     * @return
     */
    public static double deepAdjustFactor(PreDcvrStatInfo preDcvrStatInfo,
                                          Double preDcvr,
                                          Double preCvr,
                                          Long adDeepConvert,
                                          Double minFactor,
                                          Double maxFactor) {


        double factor = 1.0;
        if(AssertUtil.isAnyEmpty(preDcvrStatInfo,preDcvr)){
            return factor;
        }

        if( adDeepConvert == null || adDeepConvert < Constant.THRESHOLD){
            return factor;
        }
        Double mergeMean = preDcvrStatInfo.getMergeMean();//指数衰减加权融均值
        Double mergeSD = preDcvrStatInfo.getMergeSD();//指数衰减加权融标准差

        minFactor = minFactor != null ? minFactor : 0.85;
        maxFactor = maxFactor != null ? maxFactor : 1.2;

        if(mergeMean != null && mergeSD != null && preDcvr != null && preDcvr > 0.0) {

            double level1 = Math.max(mergeMean - 3 * mergeSD,0.0);
            double level2 = Math.max(mergeMean - 2 * mergeSD,0.0);
            double level3 = Math.max(mergeMean - mergeSD,0.0);
            double level4 = Math.min(mergeMean + mergeSD,1.0);
            double level5 = Math.min(mergeMean + 2 * mergeSD,1.0);
            double level6 = Math.min(mergeMean + 3 * mergeSD,1.0);

            double step_0 = (1.0 - minFactor) / 2;
            double step_1 = (maxFactor - 1.0) / 2;


            double[] bucket = {0, level2, level3, mergeMean, level4, level5, 1.0};
            double[] weight = {minFactor, minFactor, minFactor+step_0, 1.0, 1.0+step_1, maxFactor, maxFactor};

            double factor0 = getConfidenceWeight(preDcvr, bucket, weight, 1.0);
            double limit = mergeMean != 0  ? preDcvr/mergeMean : 1.0;
            if(limit >= 1){
                factor = Math.min(factor0,limit);
            } else {
                factor = Math.max(factor0,limit);
            }

        }

        return factor;

    }


    public static void main(String[] args) {
        PreDcvrStatInfo preDcvrStatInfo = new PreDcvrStatInfo();
        preDcvrStatInfo.setMergeMean(0.2);
        preDcvrStatInfo.setMergeSD(0.05);
        double ret = deepAdjustFactor(preDcvrStatInfo,0.1,0.2,5000L,0.85,null);
        System.out.println(ret);

    }

}

