/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.feedback;

import cn.com.duiba.nezha.alg.common.model.pacing.OrientInfo;
import cn.com.duiba.nezha.alg.common.model.pacing.TrusteeshipParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedBack {
    private static final Logger logger = LoggerFactory.getLogger(FeedBack.class);

    public static String autoManageFeedBack(OrientInfo orient, TrusteeshipParams trusteeshipParams, Double blackRealse) {
        Long targetAfee = orient.getTarget() != 0L ? orient.getTarget() : 1L;
        Long importantAppAfee = orient.getImportantAppAfee();
        Long target = importantAppAfee != null ? importantAppAfee : targetAfee;
        Double orientCostG1d = orient.getOrientCostG1d() != null ? orient.getOrientCostG1d() : 0.0;
        Double orientConvert = orient.getOrientConvertG1d();
        Double orientConfidence = orientCostG1d / (double)(target * 5L);
        Double orientCostConvert = orientConvert != 0.0 && orientCostG1d != 0.0 ? orientCostG1d / orientConvert : (double)target.longValue();
        Double orientCostConvertbias = orientConvert != 0.0 ? orientCostConvert / (double)target.longValue() : orientCostG1d / (double)target.longValue();
        Integer releaseTarget = orient.getReleaseTarget();
        Double slotOrientationCost = orient.getSlotOrientationCost() != null ? orient.getSlotOrientationCost() : 0.0;
        Double slotOrientationConvert = orient.getSlotOrientationConvert() != null ? orient.getSlotOrientationConvert() : 0.0;
        Double slotOrientationConfidence = slotOrientationCost / (double)(target * 5L);
        Double slotOrientationCostConvert = slotOrientationCost != 0.0 && slotOrientationConvert != 0.0 ? slotOrientationCost / slotOrientationConvert : (double)target.longValue();
        Double slotOrientationCostConvertBias = slotOrientationConvert != 0.0 ? slotOrientationCostConvert / (double)target.longValue() : slotOrientationCost / (double)target.longValue();
        Double slotAdvertCost = orient.getSlotAdvertCost() != null ? orient.getSlotAdvertCost() : 0.0;
        Double slotAdvertConvert = orient.getSlotAdvertConvert() != null ? orient.getSlotAdvertConvert() : 0.0;
        Double slotAdvertConfidence = slotAdvertCost / (double)(target * 5L);
        Double slotAdvertCostConvert = slotAdvertCost != 0.0 && slotAdvertConvert != 0.0 ? slotAdvertCost / slotAdvertConvert : (double)target.longValue();
        Double slotAdvertCostConvertBias = slotAdvertConvert != 0.0 ? slotAdvertCostConvert / (double)target.longValue() : slotAdvertCost / (double)target.longValue();
        String label = "";
        if (releaseTarget == 1) {
            TrusteeshipParams.ReleaseTarget1FeedBackParams feedBackparams1 = trusteeshipParams.getReleaseTarget1feedBackParams();
            if (orientCostG1d > feedBackparams1.getFuse1OrientCostG1dFactor() && orientCostG1d > (double)(5L * target) && orientConvert == 0.0) {
                label = "fuse1";
            } else if (orientCostG1d > feedBackparams1.getFuse2OrientCostG1dFactor() && orientCostConvertbias > feedBackparams1.getFuseOrientCostConvertBiasFactor()) {
                label = "fuse2";
            } else {
                if (slotAdvertConfidence >= feedBackparams1.getwSlotOrientationConfidenceFactor() && slotAdvertCostConvertBias <= Math.max(feedBackparams1.getwSlotOrientationCostConvertBiasFactor() / orientCostConvertbias, 1.0)) {
                    label = "w";
                }
                if (slotOrientationConfidence >= feedBackparams1.getwSlotOrientationConfidenceFactor() && slotOrientationCostConvertBias <= Math.max(feedBackparams1.getwSlotOrientationCostConvertBiasFactor() / orientCostConvertbias, 1.0)) {
                    label = "w";
                }
                if (orientConfidence >= feedBackparams1.getbOrientConfidenceFactor() && orientCostConvertbias > feedBackparams1.getbOrientCostConvertBiasFactor() && slotOrientationConfidence >= feedBackparams1.getbSlotOrientationConfidenceFactor() && slotOrientationCostConvertBias > blackRealse * Math.max(1.2, feedBackparams1.getbSlotOrientationCostConvertBiasFactor() / (orientCostConvertbias * orientCostConvertbias))) {
                    label = "b";
                }
            }
        } else if (releaseTarget == 2) {
            TrusteeshipParams.ReleaseTarget2FeedBackParams feedBackparams2 = trusteeshipParams.getReleaseTarget2feedBackParams();
            if (orientCostG1d > feedBackparams2.getFuse1OrientCostG1dFactor() && orientCostG1d > (double)(5L * target) && orientConvert == 0.0) {
                label = "fuse1";
            } else if (orientCostG1d > feedBackparams2.getFuse2OrientCostG1dFactor() && orientCostConvertbias > feedBackparams2.getFuseOrientCostConvertBiasFactor()) {
                label = "fuse2";
            } else {
                if (slotOrientationConfidence >= feedBackparams2.getwSlotOrientationConfidenceFactor() && slotOrientationCostConvertBias <= Math.max(feedBackparams2.getwSlotOrientationCostConvertBiasFactor() / orientCostConvertbias, 1.0)) {
                    label = "w";
                }
                if (slotAdvertConfidence >= feedBackparams2.getwSlotOrientationConfidenceFactor() && slotAdvertCostConvertBias <= Math.max(feedBackparams2.getwSlotOrientationCostConvertBiasFactor() / orientCostConvertbias, 1.0)) {
                    label = "w";
                }
                if (orientConfidence >= feedBackparams2.getbOrientConfidenceFactor() && orientCostConvertbias > feedBackparams2.getbOrientCostConvertBiasFactor() && slotOrientationConfidence >= feedBackparams2.getbSlotOrientationConfidenceFactor() && slotOrientationCostConvertBias > blackRealse * Math.max(1.2, feedBackparams2.getbSlotOrientationCostConvertBiasFactor() / (orientCostConvertbias * orientCostConvertbias))) {
                    label = "b";
                }
            }
        } else {
            TrusteeshipParams.ReleaseTarget3FeedBackParams feedBackparams3 = trusteeshipParams.getReleaseTarget3feedBackParams();
            if (orientCostG1d > feedBackparams3.getFuse1OrientCostG1dFactor() && orientCostG1d > (double)(5L * target) && orientConvert == 0.0) {
                label = "fuse1";
            } else if (orientCostG1d > feedBackparams3.getFuse2OrientCostG1dFactor() && orientCostConvertbias > feedBackparams3.getFuseOrientCostConvertBiasFactor()) {
                label = "fuse2";
            } else {
                if (slotOrientationConfidence >= feedBackparams3.getwSlotOrientationConfidenceFactor() && slotOrientationCostConvertBias <= Math.max(feedBackparams3.getwSlotOrientationCostConvertBiasFactor() / orientCostConvertbias, 1.0)) {
                    label = "w";
                }
                if (slotAdvertConfidence >= feedBackparams3.getwSlotOrientationConfidenceFactor() && slotAdvertCostConvertBias <= Math.max(feedBackparams3.getwSlotOrientationCostConvertBiasFactor() / orientCostConvertbias, 1.0)) {
                    label = "w";
                }
                if (orientConfidence >= feedBackparams3.getbOrientConfidenceFactor() && orientCostConvertbias > feedBackparams3.getbOrientCostConvertBiasFactor() && slotOrientationConfidence >= feedBackparams3.getbSlotOrientationConfidenceFactor() && slotOrientationCostConvertBias > blackRealse * Math.max(1.2, feedBackparams3.getbSlotOrientationCostConvertBiasFactor() / (orientCostConvertbias * orientCostConvertbias))) {
                    label = "b";
                }
            }
        }
        return label;
    }
}

