package cn.com.duiba.nezha.alg.common.model.activityrecommend;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import junit.framework.TestCase;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.*;

public class ActivityRec40Test extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        System.out.println();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        System.out.println();
    }

    public void testBayesianBandit() throws Exception {
        //读取本地模拟文件,alg=40
        String alg40Path="/Users/lijingzhe/codes/duiba_sql/activityIds";
        //读取本地模拟文件,alg=45
        String alg45Path="/Users/lijingzhe/codes/duiba_sql/activityIds45";
        BufferedReader alg40R = null, alg45R = null;
        String alg40js = "",alg45js = "";
        try {
            FileInputStream alg40Fs = new FileInputStream(alg40Path);
            FileInputStream alg45Fs = new FileInputStream(alg45Path);
            InputStreamReader alg40Ir = new InputStreamReader(alg40Fs, "UTF-8");
            InputStreamReader alg45Ir = new InputStreamReader(alg45Fs, "UTF-8");
            alg40R = new BufferedReader(alg40Ir);
            alg45R = new BufferedReader(alg45Ir);
            String alg40 = null, alg45 = null;
            while ((alg40 = alg40R.readLine()) != null) {
                alg40js += alg40;
            }
            alg40R.close();
            while((alg45 = alg45R.readLine()) != null) {
                alg45js += alg45;
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (alg40R != null || alg45R != null) {
                try {
                    alg40R.close();
                    alg45R.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        JSONArray alg40Ja = JSON.parseArray(alg40js);
        JSONArray alg45Ja = JSON.parseArray(alg45js);
        List<ActivityMatchInfo> actDs40 = new ArrayList<>();
        List<ActivityRankInfo> actMs40 = new ArrayList<>();
        for (int i = 0; i < alg40Ja.size(); i++) {
            ActivityMatchInfo actD = alg40Ja.getJSONObject(i).toJavaObject(ActivityMatchInfo.class);
            actDs40.add(actD);
            ActivityRankInfo actM = new ActivityRankInfo();
            actM.slotId = actD.slotId;
            actM.activityId = actD.activityId;
            actM.appId = actD.appId;
            actMs40.add(actM);
        }

        int requests = 10000;
        List<ActivityMatchInfo> actDs45 = new ArrayList<>();
        List<ActivityRankInfo> actMs45 = new ArrayList<>();
        Map<String,Integer> dMap = new HashMap<>();
        for (int i = 0; i < alg45Ja.size(); i++) {
            ActivityMatchInfo actD = alg45Ja.getJSONObject(i).toJavaObject(ActivityMatchInfo.class);
            actDs45.add(actD);
            ActivityRankInfo actM = new ActivityRankInfo();
            actM.slotId = actD.slotId;
            actM.activityId = actD.activityId;
            actM.appId = actD.appId;
            actMs45.add(actM);
        }

        //单元测试 alg45
        Map<Long,Integer> map40 = new HashMap<>();
        Map<Long,AlgCond> aMap = new HashMap<>();
        Map<Long,ActivityMatchInfo> ams = new HashMap<>();
        for (int i=0;i<requests;i++) {
            RankResult ret = ActivityRec40.select(actMs40, actDs40);
            for(ActivityMatchInfo ads : actDs40){
                ams.put(ads.activityId, ads);
            }
            AlgCond ac = new AlgCond();
            ac.setActivityId(ret.activityModel.activityId);
            ac.setAlgCnt(aMap.getOrDefault(ret.activityModel.activityId,new AlgCond()).getAlgCnt()+1);
            double uc = ams.get(ret.activityModel.activityId).hisRequest.slotVal > 0 ? ams.get(ret.activityModel.activityId).hisCost.slotVal/(100*ams.get(ret.activityModel.activityId).hisRequest.slotVal):0;
            double uck = ams.get(ret.activityModel.activityId).hisRequest.slotVal > 0 ? ams.get(ret.activityModel.activityId).hisClick.slotVal/ams.get(ret.activityModel.activityId).hisRequest.slotVal:0;
            double cvr = ams.get(ret.activityModel.activityId).hisClick.slotVal > 0 ? ams.get(ret.activityModel.activityId).hisEffect.slotVal/ams.get(ret.activityModel.activityId).hisClick.slotVal:0;
            ac.setUvCost(uc);
            ac.setUvClick(uck);
            ac.setCvr(cvr);
            aMap.put(ret.activityModel.activityId,ac);
            map40.put(ret.activityModel.activityId, map40.getOrDefault(ret.activityModel.activityId,0) + 1);
        }
        double aUC = 0;
        double aUCK = 0;
        double aEf = 0;
        for (Map.Entry<Long, AlgCond> ace : aMap.entrySet()) {
            aUC += ace.getValue().getAlgCnt()/requests * ace.getValue().getUvCost();
            aUCK += ace.getValue().getAlgCnt()/requests * ace.getValue().getUvClick();
            aEf += ace.getValue().getAlgCnt() * ace.getValue().getUvClick() * ace.getValue().getCvr();
        }
        double aCVR = aEf/(aUCK*requests);
        double aUR = aUCK * aCVR;

        //单元测试 alg45
        Map<Long,Integer> map45 = new HashMap<>();
        Map<String,Integer> dcMap = new HashMap<>();
        List<SlotAlgRecInfo> saris = new ArrayList<>();
        Map<Long,SlotAlgRecInfo> sarisMap = new HashMap<>();
        Map<Long,AlgCond> acMap = new HashMap<>();
        Map<Long,ActivityMatchInfo> amis = new HashMap<>();
        double baseUC = 0;
        double baseUCK = 0;
        double baseCVR = 0;
        double baseUR = 0;

        for (int i=0;i<requests;i++) {
            RankResult ret = ActivityRec45.select(actMs45, actDs45, saris);
            for(ActivityMatchInfo ads : actDs45){
                amis.put(ads.activityId, ads);
            }
            baseUC = ret.getActivityModel().getUvCost()/100;
            baseUCK = ret.getActivityModel().getUvClick();
            baseCVR = ret.getActivityModel().getCvr();
            baseUR = baseUCK * baseCVR;

            if(i==0){
                System.out.println("activityId:"+ret.activityModel.activityId+",uvCost:"+ret.activityModel.uvCost+",uvClick:"+ret.activityModel.uvClick+",cvr:"+ret.activityModel.cvr);
            }
            dcMap.put(ret.activityModel.activityId +"," + ret.activityModel.strategyType, dcMap.getOrDefault(ret.activityModel.activityId +"," + ret.activityModel.strategyType,0)+1);
            SlotAlgRecInfo sari = new SlotAlgRecInfo();
            sari.setAlgVersion("alg45");
            sari.setSlotId(ret.activityModel.slotId);
            sari.setActivityId(ret.activityModel.activityId);
            sari.setAlgCnt(sarisMap.getOrDefault(ret.activityModel.activityId, new SlotAlgRecInfo()).algCnt+1);
            sarisMap.put(ret.activityModel.activityId,sari);
            saris = new ArrayList<>(sarisMap.values());
            AlgCond ac = new AlgCond();
            ac.setActivityId(ret.activityModel.activityId);
            ac.setAlgCnt(acMap.getOrDefault(ret.activityModel.activityId,new AlgCond()).getAlgCnt()+1);
            double uc = amis.get(ret.activityModel.activityId).hisRequest.slotVal > 0 ? amis.get(ret.activityModel.activityId).hisCost.slotVal/(100*amis.get(ret.activityModel.activityId).hisRequest.slotVal):0;
            double uck = amis.get(ret.activityModel.activityId).hisRequest.slotVal > 0 ? amis.get(ret.activityModel.activityId).hisClick.slotVal/amis.get(ret.activityModel.activityId).hisRequest.slotVal:0;
            double cvr = amis.get(ret.activityModel.activityId).hisClick.slotVal > 0 ? amis.get(ret.activityModel.activityId).hisEffect.slotVal/amis.get(ret.activityModel.activityId).hisClick.slotVal:0;
            ac.setUvCost(uc);
            ac.setUvClick(uck);
            ac.setCvr(cvr);
            acMap.put(ret.activityModel.activityId,ac);
            map45.put(ret.activityModel.activityId, map45.getOrDefault(ret.activityModel.activityId,0) + 1);
            if(i==requests-1){
                System.out.println("activityId:"+ret.activityModel.activityId+",uvCost:"+ret.activityModel.uvCost+",uvClick:"+ret.activityModel.uvClick+",cvr:"+ret.activityModel.cvr);
            }
        }
        double algUC = 0;
        double algUCK = 0;
        double algEf = 0;
        for (Map.Entry<Long, AlgCond> ace : acMap.entrySet()) {
            algUC += ace.getValue().getAlgCnt()/requests * ace.getValue().getUvCost();
            algUCK += ace.getValue().getAlgCnt()/requests * ace.getValue().getUvClick();
            algEf += ace.getValue().getAlgCnt() * ace.getValue().getUvClick() * ace.getValue().getCvr();
        }
        double algCVR = algEf/(algUCK*requests);
        double algUR = algUCK * algCVR;

        System.out.println("alg40:" + map40);
        System.out.println("alg45:" + map45);
        System.out.println("d:" + dMap);
        System.out.println("dc:" + dcMap);
        System.out.println("a:"+aUC+","+aUCK+","+aCVR+","+aUR);
        System.out.println("alg:"+algUC+","+algUCK+","+algCVR+","+algUR);
        System.out.println("base:"+baseUC+","+baseUCK+","+baseCVR+","+baseUR);
    }
}
