package cn.com.duiba.nezha.alg.common.model.pacing;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

import static cn.com.duiba.nezha.alg.common.model.feedback.FeedBack.autoManageFeedBack;


public class SlotRecommender {

    private static final Logger logger = LoggerFactory.getLogger(SlotRecommender.class);

    public static Map<ResultType, Collection<AdvertOrientInfo>> recommend(Collection<OrientInfo> orientlist, Long slotId, TrusteeshipParams trusteeshipParams) {

        Set<AdvertOrientInfo> orientSet = new HashSet<>();
        Set<AdvertOrientInfo> fuseSet1 = new HashSet<>();
        Set<AdvertOrientInfo> fuseSet2 = new HashSet<>();
        Set<AdvertOrientInfo> recommendListSet = new HashSet<>();
        Set<AdvertOrientInfo> shieldListSet = new HashSet<>();

        TrusteeshipParams.ReleaseTarget1SlotRecommendParams releaseTarget1slotRecommendParams=trusteeshipParams.getReleaseTarget1slotRecommendParams();
        TrusteeshipParams.ReleaseTarget2SlotRecommendParams releaseTarget2slotRecommendParams=trusteeshipParams.getReleaseTarget2slotRecommendParams();
        TrusteeshipParams.ReleaseTarget3SlotRecommendParams releaseTarget3slotRecommendParams=trusteeshipParams.getReleaseTarget3slotRecommendParams();


        if (Math.random()<0.00001) {
            logger.info("params slotRecommendParams:{}", trusteeshipParams);
        }

        for (OrientInfo orient : orientlist) {

            //配置基本数据
            Integer manageType=orient.manageType;//系统托管方式 //自动模式：2  优投模式：3
            Integer releaseTarget=orient.releaseTarget!=null?orient.releaseTarget:3;  //投放目标  1：消耗优先  2：成本优先  3：均衡   默认为均衡模式
            Integer chargeType = orient.chargeType;  //计费方式
            Integer cvrType=orient.cvrType;     //后端类型 0：落地页 1： 2 3
            Long target = orient.target!=0?orient.target:1;  //目标成本
            Long importantAppAfee=orient.importantAppAfee;   //重点媒体转化出价  默认null
            Long fee = orient.fee; //出价


            Map<String,Double> recommendParamsMap=new HashMap<String,Double>();
            if (releaseTarget==1){
                recommendParamsMap.put("startFactor",releaseTarget1slotRecommendParams.getStartFactor());
                recommendParamsMap.put("cpaBiasRatioFactor",releaseTarget1slotRecommendParams.getCpaBiasRatioFactor());
                recommendParamsMap.put("cpaOrientRatioFactor",releaseTarget1slotRecommendParams.getCpaOrientRatioFactor());
                recommendParamsMap.put("cpaBiasThresholdFactor",releaseTarget1slotRecommendParams.getCpaBiasThresholdFactor());
                recommendParamsMap.put("cpcTargetRatioFactor",releaseTarget1slotRecommendParams.getCpcTargetRatioFactor());
                recommendParamsMap.put("cpcOrientRatioFactor",releaseTarget1slotRecommendParams.getCpcOrientRatioFactor());
                recommendParamsMap.put("cpcBiasThresholdFactor",releaseTarget1slotRecommendParams.getCpcBiasThresholdFactor());
                recommendParamsMap.put("cpaHisCorrCoeffRatioFactor",releaseTarget1slotRecommendParams.getCpaHisCorrCoeffRatioFactor());
                recommendParamsMap.put("cpaHisCorrCoeffThreshod",releaseTarget1slotRecommendParams.getCpaHisCorrCoeffThreshod());
                recommendParamsMap.put("cpaNotHisCorrCoeffThreshod",releaseTarget1slotRecommendParams.getCpaNotHisCorrCoeffThreshod());
                recommendParamsMap.put("cpcHisCorrCoeffThreshod",releaseTarget1slotRecommendParams.getCpcHisCorrCoeffThreshod());
                recommendParamsMap.put("cpcNotHisCorrCoeffThreshod",releaseTarget1slotRecommendParams.getCpcNotHisCorrCoeffThreshod());

            }else if(releaseTarget==2 || manageType==3){
                recommendParamsMap.put("startFactor",releaseTarget2slotRecommendParams.getStartFactor());
                recommendParamsMap.put("cpaBiasRatioFactor",releaseTarget2slotRecommendParams.getCpaBiasRatioFactor());
                recommendParamsMap.put("cpaOrientRatioFactor",releaseTarget2slotRecommendParams.getCpaOrientRatioFactor());
                recommendParamsMap.put("cpaBiasThresholdFactor",releaseTarget2slotRecommendParams.getCpaBiasThresholdFactor());
                recommendParamsMap.put("cpcTargetRatioFactor",releaseTarget2slotRecommendParams.getCpcTargetRatioFactor());
                recommendParamsMap.put("cpcOrientRatioFactor",releaseTarget2slotRecommendParams.getCpcOrientRatioFactor());
                recommendParamsMap.put("cpcBiasThresholdFactor",releaseTarget2slotRecommendParams.getCpcBiasThresholdFactor());
                recommendParamsMap.put("cpaHisCorrCoeffRatioFactor",releaseTarget2slotRecommendParams.getCpaHisCorrCoeffRatioFactor());
                recommendParamsMap.put("cpaHisCorrCoeffThreshod",releaseTarget2slotRecommendParams.getCpaHisCorrCoeffThreshod());
                recommendParamsMap.put("cpaNotHisCorrCoeffThreshod",releaseTarget2slotRecommendParams.getCpaNotHisCorrCoeffThreshod());
                recommendParamsMap.put("cpcHisCorrCoeffThreshod",releaseTarget2slotRecommendParams.getCpcHisCorrCoeffThreshod());
                recommendParamsMap.put("cpcNotHisCorrCoeffThreshod",releaseTarget2slotRecommendParams.getCpcNotHisCorrCoeffThreshod());

            }else{
                recommendParamsMap.put("startFactor",releaseTarget3slotRecommendParams.getStartFactor());
                recommendParamsMap.put("cpaBiasRatioFactor",releaseTarget3slotRecommendParams.getCpaBiasRatioFactor());
                recommendParamsMap.put("cpaOrientRatioFactor",releaseTarget3slotRecommendParams.getCpaOrientRatioFactor());
                recommendParamsMap.put("cpaBiasThresholdFactor",releaseTarget3slotRecommendParams.getCpaBiasThresholdFactor());
                recommendParamsMap.put("cpcTargetRatioFactor",releaseTarget3slotRecommendParams.getCpcTargetRatioFactor());
                recommendParamsMap.put("cpcOrientRatioFactor",releaseTarget3slotRecommendParams.getCpcOrientRatioFactor());
                recommendParamsMap.put("cpcBiasThresholdFactor",releaseTarget3slotRecommendParams.getCpcBiasThresholdFactor());
                recommendParamsMap.put("cpaHisCorrCoeffRatioFactor",releaseTarget3slotRecommendParams.getCpaHisCorrCoeffRatioFactor());
                recommendParamsMap.put("cpaHisCorrCoeffThreshod",releaseTarget3slotRecommendParams.getCpaHisCorrCoeffThreshod());
                recommendParamsMap.put("cpaNotHisCorrCoeffThreshod",releaseTarget3slotRecommendParams.getCpaNotHisCorrCoeffThreshod());
                recommendParamsMap.put("cpcHisCorrCoeffThreshod",releaseTarget3slotRecommendParams.getCpcHisCorrCoeffThreshod());
                recommendParamsMap.put("cpcNotHisCorrCoeffThreshod",releaseTarget3slotRecommendParams.getCpcNotHisCorrCoeffThreshod());

            }

            Map<String,Double> candidateMap=new HashMap<String,Double>();
            if (orient.cvrSet!=null &&  orient.biasSet!=null) {
                candidateMap.put("statCvr0", orient.cvrSet.get(0));
                candidateMap.put("statCvr1", orient.cvrSet.get(1));
                candidateMap.put("statCvr2", orient.cvrSet.get(2));
                candidateMap.put("statCvr3", orient.cvrSet.get(3));
                candidateMap.put("statCvr4", orient.cvrSet.get(4));
                candidateMap.put("cvrBias0", orient.biasSet.get(0));
                candidateMap.put("cvrBias1", orient.biasSet.get(1));
                candidateMap.put("cvrBias2", orient.biasSet.get(2));
                candidateMap.put("cvrBias3", orient.biasSet.get(3));
                candidateMap.put("cvrBias4", orient.biasSet.get(4));
            }
            if (Math.random()<0.001) {
                logger.info("OrientInfo slotId:{} advertId:{} orientId:{} OrientInfo:{}", slotId,orient.advertId,orient.orientId,orient);
            }

            Double orientCostG1d = orient.orientCostG1d != null ? orient.orientCostG1d : 0.0;             //配置消耗
            Double orientCostG7d = orient.orientCostG7d != null ? orient.orientCostG7d : 0.0;             //配置消耗

            //配置维度数据
            Double orientConvert = orient.orientConvertG1d;
            Double orientCostConvert = (orientConvert != 0 && orientCostG1d != 0) ? orientCostG1d / orientConvert : target;       //配置当天实际成本
            Double orientCostConvertbias = (orientConvert != 0) ? orientCostConvert / target : orientCostG1d / target;        //配置当天实际成本与目标成本偏差
            Double orientConfidence = orientCostG1d/(target*5);

            //广告位+配置粒度数据
            Double slotOrientationCost=orient.slotOrientationCost!=null?orient.slotOrientationCost:0.0;          //广告位+配置粒度消耗
            Double slotOrientationConvert=orient.slotOrientationConvert!=null?orient.slotOrientationConvert:0.0;   //广告位+配置粒度转化量
            Double slotOrientationConfidence=slotOrientationCost/(target*5);  //广告位+配置粒度置信度
            Double slotOrientationCostConvert=(slotOrientationCost!=0 && slotOrientationConvert!=0)?slotOrientationCost/slotOrientationConvert:target;  //广告位+配置粒度实时成本
            Double slotOrientationCostConvertBias=(slotOrientationConvert!=0) ? slotOrientationCostConvert / target : slotOrientationCost / target;

            //广告位+广告粒度数据
            Double slotAdvertCost=orient.slotAdvertCost!=null?orient.slotAdvertCost:0.0;          //广告位+配置粒度消耗
            Double slotAdvertConvert=orient.slotAdvertConvert!=null?orient.slotAdvertConvert:0.0;   //广告位+配置粒度转化量
            Double slotAdvertConfidence=slotAdvertCost/(target*5);  //广告位+配置粒度置信度
            Double slotAdvertCostConvert=(slotAdvertCost!=0 && slotAdvertConvert!=0)?slotAdvertCost/slotAdvertConvert:target;  //广告位+配置粒度实时成本
            Double slotAdvertCostConvertBias=(slotAdvertConvert!=0) ? slotAdvertCostConvert / target : slotAdvertCost / target;

            //媒体+配置粒度数据
            Double appOrientationCost=orient.appOrientationCost!=null?orient.appOrientationCost:0.0;          //媒体+配置粒度消耗
            Double appOrientationConvert=orient.appOrientationConvert!=null?orient.appOrientationConvert:0.0;   //媒体+配置粒度转化量
            Double appOrientationConfidence=appOrientationCost/(target*5);  //广告位+配置粒度置信度
            Double appOrientationCostConvert=(appOrientationCost!=0 && appOrientationConvert!=0)?appOrientationCost/appOrientationConvert:target;  //媒体+配置粒度实时成本
            Double appOrientationCostConvertBias=(appOrientationConvert!=0) ? appOrientationCostConvert / target : appOrientationCost / target;  //媒体+配置粒度实时成本偏差

            Double appOrientCvrDay=orient.appOrientCvrDay!=null ? orient.appOrientCvrDay : 0;


            Random r = new Random();
            Double x = r.nextDouble();
            double p_convert_cost = 0.0;
            double biasRatio = 0.0;
            double biasThreshold = 0.0;
            double orientRatio = 0.0;
            double targetRatio = 0.0;
            double corrCoefRatio = 1.0;
            double corrCoefThreshod0 = 1.0;
            double corrCoefThreshod1 = 1.0;

            double startRatio = (orientCostG7d < 5 * target) ? recommendParamsMap.get("startFactor") : 1; //启动时减缓消耗速度控制因子


            //自救相关参数
            Double blackRealse = 1.0;
            Double reorient = 1.0;
            Double orientRatioWeight = 1.0;

            if (orient.helpMeasureResult != null && orient.helpMeasureResult.isExpand != null && orient.helpMeasureResult.isExpand == true) {
                blackRealse = orient.helpMeasureResult.isBlackRealse;
                reorient = orient.helpMeasureResult.isReorient;
                orientRatioWeight = orient.helpMeasureResult.orientRatioWeight;
                logger.info("isExpand blackRealse:{} reorient:{} orientRatioWeight:{}", blackRealse,reorient,orientRatioWeight);

            }
            if (Math.random()<0.00001) {
                logger.info("params slotRecommendParams:{}", trusteeshipParams);
            }

            String feedBackLabel=autoManageFeedBack(orient,trusteeshipParams,blackRealse);

            if (!"".equals(feedBackLabel) && Math.random()<0.02) {
                logger.info("slot_blackset slotId:{} advertId:{} orientId:{} feedBackLabel:{}", slotId,orient.advertId,orient.orientId,feedBackLabel);
            }
            //熔断开关

            Boolean isFuse=("fuse1".equals(feedBackLabel) || "fuse2".equals(feedBackLabel)) & !orient.fuseWhite;

            if ("fuse1".equals(feedBackLabel)){fuseSet1.add(new AdvertOrientInfo(orient.advertId,orient.orientId));}
            else if ("fuse2".equals(feedBackLabel)){fuseSet2.add(new AdvertOrientInfo(orient.advertId,orient.orientId));}

            if (isFuse) {
                logger.info("fuseInfo fuseOrientInfo:{}",orient);
            }
            Double cost20d=orient.cost20d;
            Double cost7d=orient.cost7d;
            Double confidence=(cost20d!=null) ? cost20d/(5*target):null;
            Double confidenceCF=(cost7d!=null) ? cost7d/(5*target):null;
            Double cvr=candidateMap.get("statCvr"+cvrType);
            Double bias=candidateMap.get("cvrBias"+cvrType);
            Double correlationCoefficient = orient.correlationCoefficient;

            //人群标签信息
            List<TagInfo> TagAd = (orient.tagRtPerformance != null) ? orient.tagRtPerformance.get("advert") : null;
            List<TagInfo> TagPkg = (orient.tagRtPerformance != null) ? orient.tagRtPerformance.get("orientation") : null;
            List<TagInfo> TagAppAd = (orient.tagRtPerformance != null) ? orient.tagRtPerformance.get("appAdvert") : null;
            List<TagInfo> TagAppPkg = (orient.tagRtPerformance != null) ? orient.tagRtPerformance.get("appOrientation") : null;
            Double statAdCtr = (orient.statAdCtr != null) ? orient.statAdCtr : 1.0;
            Double statAdCvr = (orient.statAdCvr != null) ? orient.statAdCvr : 1.0;


            //////////ocpc
            if (chargeType == 2 ) {

                AdvertOrientInfo advertOrientInfo = new AdvertOrientInfo(orient.advertId, orient.orientId, new HashSet<Integer>());

                if (confidence != null && bias!=null && !isFuse) {
                    //选配置
                    biasRatio = (orientCostConvertbias != 0) ? recommendParamsMap.get("cpaBiasRatioFactor") / (orientCostConvertbias * orientCostConvertbias) : recommendParamsMap.get("cpaBiasRatioFactor");
                    orientRatio = (orientCostConvertbias != 0) ? recommendParamsMap.get("cpaOrientRatioFactor") / (orientCostConvertbias * orientCostConvertbias * orientCostConvertbias) : recommendParamsMap.get("cpaOrientRatioFactor");
                    orientRatio = (orientCostConvertbias > 1.7) ? 0 : orientRatio;
                    biasThreshold = Math.max((recommendParamsMap.get("cpaBiasThresholdFactor") * confidence + 1) * biasRatio * startRatio, 1);

                    //重点媒体默认定向
                    if (importantAppAfee != null && !importantAppAfee.equals(target)) {
                        Set matchTypeSet = advertOrientInfo.getMatchType();
                        matchTypeSet.add(0);
                    }

                    //有历史数据
                    if (confidence != null && confidence > 0 && bias > 0 && bias <= biasThreshold * reorient) {
                        Set matchTypeSet = advertOrientInfo.getMatchType();
                        matchTypeSet.add(1);
                        if (manageType == 3) {
                            recommendListSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId, slotOrientationCostConvertBias, slotOrientationCost));
                        }
                    }

                    //无历史数据，离线控制候选集数量，线上控制定向概率和反馈黑白名单，成本偏差太大定向概率为0
                    if (confidence != null && confidence == 0 && x < orientRatio * orientRatioWeight) {
                        Set matchTypeSet = advertOrientInfo.getMatchType();
                        matchTypeSet.add(2);
                        if (manageType == 3) {
                            recommendListSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId, slotOrientationCostConvertBias, slotOrientationCost));
                        }
                    }
                }


                if (confidenceCF != null && correlationCoefficient != null && !isFuse) {
                    //添加到参数
                    corrCoefRatio = (orientCostConvertbias!=0)?recommendParamsMap.get("cpaHisCorrCoeffRatioFactor")*(orientCostConvertbias * orientCostConvertbias*orientCostConvertbias):recommendParamsMap.get("cpaHisCorrCoeffRatioFactor");
                    corrCoefThreshod0 = Math.max(Math.min(corrCoefRatio / (recommendParamsMap.get("cpaHisCorrCoeffThreshod")* Math.sqrt(confidenceCF)) / startRatio,0.9),0.01);
                    corrCoefThreshod1 = Math.max(Math.min(corrCoefRatio / recommendParamsMap.get("cpaNotHisCorrCoeffThreshod")/ startRatio,1),0.05);

                    //有历史数据，协同
                    if (confidenceCF > 0 && correlationCoefficient > 0 && correlationCoefficient >= corrCoefThreshod0 / reorient) {
                        Set matchTypeSet = advertOrientInfo.getMatchType();
                        matchTypeSet.add(3);
                        if (manageType == 3) {
                            recommendListSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId, slotOrientationCostConvertBias, slotOrientationCost));
                        }
                    }

                    //无历史数据，协同
                    if (confidenceCF == 0 && correlationCoefficient > 0 && correlationCoefficient >= corrCoefThreshod1 / orientRatioWeight) {
                        Set matchTypeSet = advertOrientInfo.getMatchType();
                        matchTypeSet.add(4);
                        if (manageType == 3) {
                            recommendListSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId, slotOrientationCostConvertBias, slotOrientationCost));
                        }
                    }
                }

                //利用人群标签的匹配
                if (TagAd != null && TagPkg != null) {
                     for (TagInfo tagAdInfo: TagAd){
                         if (tagAdInfo.curClkCnt > 0 && tagAdInfo.curConvCnt > 10 && (double)tagAdInfo.curConvCnt/tagAdInfo.curClkCnt > statAdCvr &&
                                 (double)tagAdInfo.curCost/tagAdInfo.curConvCnt < target){
                             Set matchTypeSet = advertOrientInfo.getMatchType();
                             matchTypeSet.add(5);
                             if (Math.random()<0.01) {
                                 logger.info("slotRecommend tagAdInfo:{}, statAdCvr {}", tagAdInfo, statAdCvr);
                             }
                         }
                     }
                    for (TagInfo tagPkgInfo: TagPkg){
                        if (tagPkgInfo.curClkCnt > 0 && tagPkgInfo.curConvCnt > 5 && (double)tagPkgInfo.curConvCnt/tagPkgInfo.curClkCnt > statAdCvr &&
                                (double)tagPkgInfo.curCost/tagPkgInfo.curConvCnt < target){
                            Set matchTypeSet = advertOrientInfo.getMatchType();
                            matchTypeSet.add(5);
                            if (Math.random()<0.01) {
                                logger.info("slotRecommend tagPkgInfo:{}, statAdCvr {}", tagPkgInfo, statAdCvr);
                            }
                        }
                    }
                }

                //利用APP_TAG的匹配
                if (TagAppAd != null && TagAppPkg != null) {
                    for (TagInfo tagAppAdInfo: TagAppAd){
                        if (tagAppAdInfo.curClkCnt > 0 && tagAppAdInfo.curConvCnt > 10 && (double)tagAppAdInfo.curConvCnt/tagAppAdInfo.curClkCnt > statAdCvr &&
                                (double)tagAppAdInfo.curCost/tagAppAdInfo.curConvCnt < target){
                            Set matchTypeSet = advertOrientInfo.getMatchType();
                            matchTypeSet.add(6);
                            if (Math.random()<0.01) {
                                logger.info("slotRecommend tagAppAdInfo:{}, statAdCvr {}", tagAppAdInfo, statAdCvr);
                            }
                        }
                    }
                    for (TagInfo tagAppPkgInfo: TagAppPkg){
                        if (tagAppPkgInfo.curClkCnt > 0 && tagAppPkgInfo.curConvCnt > 5 && (double)tagAppPkgInfo.curConvCnt/tagAppPkgInfo.curClkCnt > statAdCvr &&
                                (double)tagAppPkgInfo.curCost/tagAppPkgInfo.curConvCnt < target){
                            Set matchTypeSet = advertOrientInfo.getMatchType();
                            matchTypeSet.add(6);
                            if (Math.random()<0.01) {
                                logger.info("slotRecommend tagAppPkgInfo:{}, statAdCvr {}", tagAppPkgInfo, statAdCvr);
                            }
                        }
                    }
                }

                if(advertOrientInfo.getMatchType().size() > 0){
                orientSet.add(advertOrientInfo);
                }
            }

            ////////cpc
            else if (chargeType == 1 && confidence!=null && cvr!=null  && !isFuse) {
                recommendParamsMap.put("startFactor",releaseTarget1slotRecommendParams.getStartFactor());
                recommendParamsMap.put("cpcTargetRatioFactor",releaseTarget1slotRecommendParams.getCpcTargetRatioFactor());
                recommendParamsMap.put("cpcOrientRatioFactor",releaseTarget1slotRecommendParams.getCpcOrientRatioFactor());
                recommendParamsMap.put("cpcBiasThresholdFactor",releaseTarget1slotRecommendParams.getCpcBiasThresholdFactor());
                //选配置
                targetRatio = (orientCostConvertbias!=0)?recommendParamsMap.get("cpcTargetRatioFactor")/(orientCostConvertbias * orientCostConvertbias):recommendParamsMap.get("cpcTargetRatioFactor");
                orientRatio = (orientCostConvertbias!=0)?recommendParamsMap.get("cpcOrientRatioFactor")/(orientCostConvertbias * orientCostConvertbias * orientCostConvertbias):recommendParamsMap.get("cpcOrientRatioFactor");
                orientRatio=(orientCostConvertbias>1.5)?0:orientRatio;
                biasThreshold = Math.max((recommendParamsMap.get("cpcBiasThresholdFactor")*confidence+1) * targetRatio * startRatio,1);
                p_convert_cost = (cvr!=0)?fee / cvr:1000000.0;

                //广告维度历史数据
                if (confidence > 0 && p_convert_cost <= biasThreshold * target) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                    if (manageType==3) {recommendListSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId,slotOrientationCostConvertBias,slotOrientationCost));}

                }

                //无数据
                if (confidence == 0 && p_convert_cost < biasThreshold * target && x < orientRatio) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                    if (manageType==3) {recommendListSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId,slotOrientationCostConvertBias,slotOrientationCost));}

                }

            }

            //根据正负反馈进行删减
            if ("w".equals(feedBackLabel)){
                orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                if (manageType==3) {
                    recommendListSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId,appOrientationCostConvertBias,appOrientationCost));
                }
            }
            if ("b".equals(feedBackLabel)){
                orientSet.remove(new AdvertOrientInfo(orient.advertId, orient.orientId));
                if (manageType==2 && appOrientationConfidence>1 && appOrientationCostConvertBias>2) {
                    shieldListSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId,appOrientationCostConvertBias,appOrientationCost));
                }
            }

        }

        Set<AdvertOrientInfo> orientPackageList = new HashSet<>();
        for (OrientInfo orientInfo : orientlist) {
            orientPackageList.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
        }

        orientPackageList.removeAll(orientSet);
        orientPackageList.removeAll(shieldListSet);//黑名单不用传给智能匹配

        Map<ResultType, Collection<AdvertOrientInfo>> map = new HashMap<>();
        map.put(ResultType.ONTARGET, orientSet);
        map.put(ResultType.GIVEUP, orientPackageList);
        map.put(ResultType.FUSE1, fuseSet1);
        map.put(ResultType.FUSE2, fuseSet2);
        map.put(ResultType.ORIENT, recommendListSet);
        map.put(ResultType.SHIELD, shieldListSet);

        if (Math.random()<0.002) {
            logger.info("ResultType ResultType:{} slotId:{}", map,slotId);
        }

        return map;
    }
}
