package cn.com.duiba.nezha.alg.common.model.pacing;

import java.util.Objects;

public class TagInfo {

    Long advertId;
    Long orientId;
    Long appId;
    String tagId; // 标签id

    Long curClkCnt=0L; // 当天点击量
    Long curConvCnt=0L; // 当天转化量
    Long curCost=0L; // 当天消耗量

    public TagInfo() {
    }

    public TagInfo(Long advertId, Long orientId, String tagId, Long curClkCnt, Long curConvCnt, Long curCost) {
        this.advertId = advertId;
        this.orientId = orientId;
        this.tagId = tagId;
        this.curClkCnt = curClkCnt;
        this.curConvCnt = curConvCnt;
        this.curCost = curCost;
    }

    public TagInfo(Long advertId, Long orientId, Long appId, String tagId, Long curClkCnt, Long curConvCnt, Long curCost) {
        this.advertId = advertId;
        this.orientId = orientId;
        this.appId = appId;
        this.tagId = tagId;
        this.curClkCnt = curClkCnt;
        this.curConvCnt = curConvCnt;
        this.curCost = curCost;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getOrientId() {
        return orientId;
    }

    public void setOrientId(Long orientId) {
        this.orientId = orientId;
    }

    public String getTagId() {
        return tagId;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }

    public Long getCurClkCnt() {
        return curClkCnt;
    }

    public void setCurClkCnt(Long curClkCnt) {
        this.curClkCnt = curClkCnt;
    }

    public Long getCurConvCnt() {
        return curConvCnt;
    }

    public void setCurConvCnt(Long curConvCnt) {
        this.curConvCnt = curConvCnt;
    }

    public Long getCurCost() {
        return curCost;
    }

    public void setCurCost(Long curCost) {
        this.curCost = curCost;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof TagInfo)) return false;
        TagInfo tagInfo = (TagInfo) o;
        return getAdvertId().equals(tagInfo.getAdvertId()) &&
                Objects.equals(getOrientId(), tagInfo.getOrientId()) &&
                getAppId().equals(tagInfo.getAppId()) &&
                getTagId().equals(tagInfo.getTagId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getAdvertId(), getOrientId(), getAppId(), getTagId());
    }

    @Override
    public String toString() {
        return "TagInfo{" +
                "advertId=" + advertId +
                ", orientId=" + orientId +
                ", appId=" + appId +
                ", tagId='" + tagId + '\'' +
                ", curClkCnt=" + curClkCnt +
                ", curConvCnt=" + curConvCnt +
                ", curCost=" + curCost +
                '}';
    }
}
