package cn.com.duiba.nezha.alg.common.model.activityselectconversionforms;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/**
 * @author lijingzhe
 * @description 活动推荐算法4.0
 * @date 2019/8/12
 */
public class ActivitySelectPool {
    public static List<ActivityInfoModel> match (List<ActivityInfoModel> actModel, List<ActivityInfoData> actData, List<ActivityInfoAdWithType> actAd) {
        return null;
    }

    public static SelectActivityResult select(List<ActivityModel> actModel, List<ActivityData> actData, double gama) {

        SelectActivityResult selectActivityResult = new SelectActivityResult();

        //1.判断列表长度，不一致抛异常
        if (actModel.size() == 0 || actData.size() == 0) {
            return null;
        }
        if (actModel.size() != actData.size()) {
            selectActivityResult.activityModel = actModel.get(0);
            selectActivityResult.sameCostActivitiesInfoList = null;
            return selectActivityResult; //todo 抛异常
        }
        List<ActivityModel> actModelCopy = sortByIdAndSourceModelBack(actModel);  //广告id倒排
        List<ActivityData> actDataCopy = sortByIdAndSourceDataBack(actData);
        //活动 id 对不上返回空
        for (int i = 0; i < actModelCopy.size(); ++i) {
            long activityIdMode = actModelCopy.get(i).activityId;
            long activityIdData = actDataCopy.get(i).activityId;
            if (activityIdMode != activityIdData) {
                selectActivityResult.activityModel = actModel.get(0);
                selectActivityResult.sameCostActivitiesInfoList = null;
                return selectActivityResult; // todo 抛异常
            }
            actModelCopy.get(i).changeScore = actDataCopy.get(i).changeScore;
        }

        return null;
    }

    private static List<ActivityModel> sortByIdAndSourceModelBack(List<ActivityModel> acts){
        List<ActivityModel> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityModel>() {
            public int compare(ActivityModel act1, ActivityModel act2) {
                if(act1.activityId > act2.activityId) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });
        return actCopy;

    }

    private static List<ActivityData> sortByIdAndSourceDataBack(List<ActivityData> acts){

        List<ActivityData> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityData>() {
            public int compare(ActivityData act1, ActivityData act2) {
                if(act1.activityId > act2.activityId) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });
        return actCopy;
    }
}
