package cn.com.duiba.nezha.alg.common.model.activityrecommend;

import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author lijingzhe
 * @description 活动推荐算法4.0
 * @date 2019/8/12
 */
public class ActivityRec40 {

    private static final Logger logger=LoggerFactory.getLogger(ActivityRec40.class);

    static class Constant {
        static double MIN_REWARD=0.1;
        static double DECAY=0.99;
        // 海选召回的数量
        static int SEARANK_TOPN=30;
        static int EXCELLENT_TOPN=20;
    }

    static class RankInfo {
        double grpm;
        double gexp;
        double hrpm;
        double hexp;
        double arpm;
        double aexp;
    }

    static class MatchInfo {
        double score=0;
        ActivityMatchInfo act;
    }

    static class SelectInfoDetail {
        int index;
        ArrayList<SelectPoolInfo> condi;
        double maxChangeScore;
        int strategyType;
    }

    /**
     *功能描述 海选分(每pv消耗)降序排
     * @author lijingzhe
     * @date 2019/8/20
     * @param
     * @return
     */
    public static Comparator<MatchInfo> iComparator=new Comparator<MatchInfo>() {
        @Override
        public int compare(MatchInfo c1, MatchInfo c2) {
            return (int) (c2.score - c1.score >= 0 ? 1 : -1);
        }
    };

    /**
     *功能描述 归一化得分降序排
     * @author lijingzhe
     * @date 2019/8/21
     * @param
     * @return
     */
    public static Comparator<MatchInfo> normComparator=new Comparator<MatchInfo>() {
        @Override
        public int compare(MatchInfo m1, MatchInfo m2) {
            return (int) (m2.act.score - m1.act.score >= 0 ? 1 : -1);
        }
    };

    /**
     *功能描述 4.0优化：
     * 1)海选增加归一化优质活动召回
     * 2)海选每pv券点击召回->每pv消耗召回
     * @author lijingzhe
     * @date 2019/9/9
     * @param actData, actAds, exActs
     * @return java.util.List<cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityMatchInfo>
     */
    public static List<ActivityMatchInfo> match (List<ActivityInfoData> actData, List<ActivityInfoAd> actAds, List<NormInfo> exActs) {
        int topn=Constant.SEARANK_TOPN;
        int exTopN=Constant.EXCELLENT_TOPN;
        // 海选集初始化
        List<ActivityMatchInfo> result=new ArrayList<>();
        // 可投活动封装
        List<ActivityMatchInfo> actModel=new ArrayList<ActivityMatchInfo>();
        // 按融合券点击降序活动队列
        Queue<MatchInfo> candis=new PriorityQueue<>(actData.size(), iComparator);
        // 按券点击降序活动队列
        Queue<MatchInfo> slotCandis=new PriorityQueue<>(actData.size(), iComparator);
        // 按归一化score降序活动队列
        Queue<MatchInfo> normCandis=new PriorityQueue<>(exTopN, normComparator);
        // 活动维度最近三天已投放过广告数据
        HashMap<Long, ActivityInfoAd> adHashMap=new HashMap<Long, ActivityInfoAd>();
        for(ActivityInfoAd ad : actAds){
            adHashMap.put(ad.getActivityId(), ad);
        }

        // 优质活动详情数据
        Map<Long, NormInfo> exHashMap=new HashMap<>();
        for(NormInfo exAct : exActs){
            exHashMap.put(exAct.getActivityId(), exAct);
        }

        //优质活动id集合
        Set<Long> actIds=new HashSet<>(exHashMap.keySet());
        //广告位下投放过活动id集合
        Set<Long> hisActIds=new HashSet<>(actData.stream().map(ActivityInfoData::getActivityId).collect(Collectors.toSet()));

        // 海选池活动id占位
        HashSet<Long> idset=new HashSet();

        for (ActivityInfoData act : actData) {
            try {
                // 封装数据
                ActivityMatchInfo actM=fillData(act, actIds, exHashMap);
                actModel.add(actM);

                // 新活动试投，上架时间小于3天
                if (actM.hisRequest.globalVal < 100) {
                    if (System.currentTimeMillis() - act.createTime < 3 * 24 * 60 * 60 * 1000) {
                        if (Math.random() < 0.0001) {
                            result.add(actM);
                            topn--;
                            idset.add(actM.activityId);
                        }
                    } else if (actData.size() > topn) {
                        if (Math.random() < 0.00001) {
                            result.add(actM);
                            topn--;
                            idset.add(actM.activityId);
                        }
                    }
                }

                //计算matchscore
                double slotScore=WilsonInterval.wilsonCalc(actM.hisRequest.slotVal, actM.hisRequest.slotVal).lowerBound;
                double globalScore=WilsonInterval.wilsonCalc(actM.hisRequest.globalVal, actM.hisRequest.globalVal).lowerBound;
                double appScore=WilsonInterval.wilsonCalc(actM.hisRequest.appVal, actM.hisRequest.appVal).lowerBound;
                double matchscore=0;

                double sconfidence=Math.min(actM.hisRequest.slotVal / 100, 1);
                double aconfidence=Math.min(actM.hisRequest.appVal / 100, 1);
                double gconfidence=Math.min(actM.hisRequest.globalVal / 1000, 1);

                matchscore=sconfidence * slotScore
                       +(1 - sconfidence) * aconfidence * appScore * 0.9
                       +(1 - sconfidence - (1 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);

                double changeScore=0.0d;
                ActivityCvrInfo activityChangeValNew=new ActivityCvrInfo();

                if (adHashMap.containsKey(act.activityId)) {
                    activityChangeValNew=calChangeScoreMergeAbsolute(adHashMap.getOrDefault(act.activityId, new ActivityInfoAd()));
                    changeScore=activityChangeValNew.changeScoreMerge;
                }

                actM.changeScore=changeScore;
                actM.activityChangeVal=activityChangeValNew;

                MatchInfo info=new MatchInfo();
                info.act=actM;
                info.score=matchscore;
                // 归一化
                if(actM.isExcellent){
                    // 已投放过的优质活动召回
                    normCandis.add(info);
                }else{
                    // 融合每pv消耗召回
                    candis.add(info);
                    //广告位请求数大于99 或点击大于5
                    if (sconfidence > 0.99 || actM.hisClick.slotVal > 5) {
                        MatchInfo info2=new MatchInfo();
                        info2.act=actM;
                        //分数是消耗除以请求数
                        info2.score=actM.hisRequest.slotVal > 0 ? actM.hisCost.slotVal /(100 * actM.hisRequest.slotVal) : 0;
                        // 广告位每pv消耗召回
                        slotCandis.add(info2);
                    }
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }

        int slotSize=slotCandis.size();
        for (int i=0; i < 10 && i < slotSize; i++) {
            ActivityMatchInfo act= slotCandis.poll().act;
            if(idset.contains(act.activityId))
                continue;
            result.add(act);
            idset.add(act.activityId);
            topn-- ;
        }

        int size=candis.size();
        int resultSize=result.size() ;

        for (int i=0; resultSize < topn && i < size; i++) {
            ActivityMatchInfo act= candis.poll().act;
            if(idset.contains(act.activityId))
                continue;
            result.add(act);
            idset.add(act.activityId);
            resultSize=result.size();
            topn-- ;
        }

        // 未在特定广告位有历史投放记录的活动
        for(NormInfo exAct : exActs){
            if(!hisActIds.contains(exAct.getActivityId())){
                MatchInfo mci=new MatchInfo();
                ActivityMatchInfo aim=new ActivityMatchInfo();
                aim.setAppId(actData.get(0).getAppId());
                aim.setSlotId(actData.get(0).getSlotId());
                aim.setActivityId(exAct.getActivityId());
                aim.setnPvClick(exAct.getnPvClick());
                aim.setnPvCost(exAct.getnPvCost());
                aim.setnCvrForm(exAct.getnFormCvr());
                aim.setnCvrNotForm(exAct.getnNotFormCvr());
                aim.setnCvr(exAct.getnCvr());
                aim.setScore(exAct.getScore());
                aim.setExcellent(true);
                mci.score=exAct.getScore();
                mci.act=aim;
                normCandis.add(mci);
            }
        }

        for (int i=0; i < exTopN && i < normCandis.size(); i++) {
            MatchInfo candisInfo= normCandis.poll();
            if(idset.contains(candisInfo.act.activityId))
                continue;
            result.add(candisInfo.act);
            idset.add(candisInfo.act.activityId);
            topn--;
        }

        return result;
    }

    /**
     *功能描述 4.0优化：
     * 1)归一化优化
     * 2)由消耗分相近推转化分最高的活动修改为推消耗分最高的活动
     * @author lijingzhe
     * @date 2019/9/9
     * @param actModel, actData
     * @return cn.com.duiba.nezha.alg.common.model.activityrecommend.RankResult
     */
    public static RankResult select(List<ActivityRankInfo> actModel, List<ActivityMatchInfo> actData) {

        RankResult rankResult=new RankResult();

        //判断列表长度，不一致抛异常
        if (actModel.size() == 0 || actData.size() == 0) {
            return null;
        }

        if (actModel.size() != actData.size()) {
            rankResult.activityModel=actModel.get(0);
            rankResult.similarCostActivitiesInfo=null;
            return rankResult; //todo 抛异常
        }
        //活动id倒排
        List<ActivityRankInfo> actModelCopy =
                actModel.stream()
                        .sorted(Comparator.comparing(ActivityRankInfo::getActivityId).reversed())
                        .collect(Collectors.toList());
        List<ActivityMatchInfo> actDataCopy =
                actData.stream()
                        .sorted(Comparator.comparing(ActivityMatchInfo::getActivityId).reversed())
                        .collect(Collectors.toList());

        //活动 id 对不上返回空
        for (int i=0; i < actModelCopy.size(); ++i) {
            long activityIdMode=actModelCopy.get(i).activityId;
            long activityIdData=actDataCopy.get(i).activityId;
            if (activityIdMode != activityIdData) {
                rankResult.activityModel=actModel.get(0);
                rankResult.similarCostActivitiesInfo=null;
                return rankResult; // todo 抛异常
            }

            actModelCopy.get(i).changeScore=actDataCopy.get(i).changeScore;
            actModelCopy.get(i).isExcellent=actDataCopy.get(i).isExcellent;
            actModelCopy.get(i).nPvClick=actDataCopy.get(i).nPvClick;
            actModelCopy.get(i).nPvCost=actDataCopy.get(i).nPvCost;
            actModelCopy.get(i).score=actDataCopy.get(i).score;
            actModelCopy.get(i).subType=actDataCopy.get(i).subType;
        }

        // 活动访问pv
        ArrayList<Double> requests=new ArrayList<>();
        // 每pv消耗收益
        ArrayList<Double> rewards=new ArrayList<>();
        ArrayList<Double> counts=new ArrayList<>();
        // 贝塔分布alpha和beta
        ArrayList<Double> alphas=new ArrayList<>();
        ArrayList<Double> betas=new ArrayList<>();
        // 转化分
        ArrayList<Double> changeScores=new ArrayList<>();
        ArrayList<Long> activityIds=new ArrayList<>();
        ArrayList<Long> activityTypes=new ArrayList<>();
        // 每pv消耗
        ArrayList<Double> grpms=new ArrayList<>();
        ArrayList<Double> arpms=new ArrayList<>();
        ArrayList<Double> hrpms=new ArrayList<>();
        // 是否是优质活动
        ArrayList<Boolean> excellents=new ArrayList<>();
        ArrayList<Integer> subTypes=new ArrayList<>();
        // 归一化score
        ArrayList<Double> scores=new ArrayList<>();
        List<ActivityRankInfo> candiList=new ArrayList<>();

        double decay=Constant.DECAY;

        int size=0;

        HashMap<Long, RankInfo> mMap=new HashMap();
        double maxG=Constant.MIN_REWARD, maxH=Constant.MIN_REWARD, maxA=Constant.MIN_REWARD;
        double minG=0, minH=Constant.MIN_REWARD, minA=Constant.MIN_REWARD;
        ActivityRankInfo result=new ActivityRankInfo();

        try {
            for (int i=0;i<actDataCopy.size();++i) {
                RankInfo info=mMap.containsKey(actDataCopy.get(i).activityId) ? mMap.get(actDataCopy.get(i).activityId) : new RankInfo();
                // 全局每pv消耗
                double grpm=actDataCopy.get(i).hisRequest.globalVal > 0 ? actDataCopy.get(i).hisCost.globalVal / actDataCopy.get(i).hisRequest.globalVal : 0;
                info.grpm=grpm;
                info.gexp=actDataCopy.get(i).hisRequest.globalVal;
                maxG=Math.max(grpm, maxG);

                // 媒体每pv消耗
                double arpm = actDataCopy.get(i).hisRequest.appVal > 0 ?
                        actDataCopy.get(i).hisCost.appVal / actDataCopy.get(i).hisRequest.appVal : 0;
                info.arpm=arpm;
                info.aexp=actDataCopy.get(i).hisRequest.appVal;
                if (info.aexp > 100) {
                    maxA=Math.max(arpm, maxA);
                }
                minA=Math.min(arpm, minA);

                // 广告位每pv消耗
                double hrpm=actDataCopy.get(i).hisRequest.slotVal > 0 ? actDataCopy.get(i).hisCost.slotVal / actDataCopy.get(i).hisRequest.slotVal : 0;
                info.hrpm=hrpm;
                info.hexp=actDataCopy.get(i).hisRequest.slotVal;
                if(info.hexp > 100) {
                    maxH=Math.max(hrpm, maxH);
                }
                minH=Math.min(hrpm, minH);

                mMap.put(actDataCopy.get(i).activityId, info);
            }

            for (int i=0;i<actDataCopy.size();++i) {
                requests.add(actDataCopy.get(i).hisRequest.slotVal);
                double hrpm=mMap.get(actDataCopy.get(i).activityId).hrpm;
                double arpm=mMap.get(actDataCopy.get(i).activityId).arpm;
                double grpm=mMap.get(actDataCopy.get(i).activityId).grpm;
                hrpms.add(hrpm);
                arpms.add(arpm);
                grpms.add(grpm);
                excellents.add(actDataCopy.get(i).isExcellent);
                subTypes.add(actDataCopy.get(i).subType);
                scores.add(actDataCopy.get(i).score);

                double reward=Constant.MIN_REWARD;
                double sconfidence=Math.min(actDataCopy.get(i).hisRequest.slotVal / 100, 1);
                double aconfidence=Math.min(actDataCopy.get(i).hisRequest.appVal / 100, 1);

                reward=sconfidence * normlize( hrpm * 0.8, maxH, 0.8) +
                        (1 - sconfidence) * aconfidence * normlize(arpm * 0.7, maxA, 0.7) +
                        (1 - sconfidence - (1 - sconfidence) * aconfidence) * normlize(grpm * 0.5, maxG, 0.6);

                reward=reward * reward;

                reward=Math.max(reward, 0);

                actModelCopy.get(i).reward=actModelCopy.get(i).reward * decay+reward;
                actModelCopy.get(i).count=actModelCopy.get(i).count * decay+1.0;
                actModelCopy.get(i).alpha=1.5+actModelCopy.get(i).reward;
                actModelCopy.get(i).beta=2.0+(actModelCopy.get(i).count - actModelCopy.get(i).reward);

                rewards.add(actModelCopy.get(i).reward);
                counts.add(actModelCopy.get(i).count);
                alphas.add(actModelCopy.get(i).alpha);
                betas.add(actModelCopy.get(i).beta);
                activityIds.add(actModelCopy.get(i).activityId);
                activityTypes.add(actModelCopy.get(i).activityType);
                changeScores.add(actModelCopy.get(i).changeScore);
                candiList.add(actModelCopy.get(i));
            }

            int numMachines=candiList.size();
            SelectInfoDetail selectInfoDetail =
                    selectMachineWithChangeScore(alphas, betas, activityTypes
                            , activityIds,changeScores,numMachines, hrpms,
                            arpms, grpms, requests, excellents, subTypes, scores);

            int selectedActivityIndex=selectInfoDetail.index;
            result=candiList.get(selectedActivityIndex);
            result.strategyType=selectInfoDetail.strategyType;
            double maxChangeScore=selectInfoDetail.maxChangeScore;

            List<SimilarCostActivitiesInfo> sameCostActivitiesInfoList=new ArrayList<>();
            //消耗分相近的活动信息
            ArrayList<SelectPoolInfo> sameCostcondi=selectInfoDetail.condi;
            if(sameCostcondi.size() > 0){
                double selectedActivityReward=sameCostcondi.get(0).getReward();
                int sameCostActivityCnt=sameCostcondi.size();

                for (SelectPoolInfo selectInfo:sameCostcondi){

                    SimilarCostActivitiesInfo sameCostActivitiesInfo=new SimilarCostActivitiesInfo();

                    Long activityId=selectInfo.getActivityId();
                    Long activityType=selectInfo.getActivityType();

                    int ifSelected=0;
                    if (selectInfo.getIndex() == selectedActivityIndex){
                        ifSelected=1;
                    }

                    int index=selectInfo.getIndex();

                    double mabReward=selectInfo.getReward();
                    double changeScore=selectInfo.getChangeScore();
                    double hrpm=selectInfo.getHrpm();
                    double arpm=selectInfo.getArpm();
                    double grpm=selectInfo.getGrpm();
                    int subType=selectInfo.getSubType();
                    boolean excellent=selectInfo.isExcellent();

                    //计算与最优的差异
                    double diffReward= selectInfo.getReward()-selectedActivityReward;
                    double diffChangeScore=selectInfo.getChangeScore() - maxChangeScore;

                    //封装
                    sameCostActivitiesInfo.activityId=activityId;
                    sameCostActivitiesInfo.sameActivityCnt=sameCostActivityCnt;
                    sameCostActivitiesInfo.activityType=activityType;
                    sameCostActivitiesInfo.ifSelected=ifSelected;
                    sameCostActivitiesInfo.mabReward=mabReward;
                    sameCostActivitiesInfo.changeScore=changeScore;
                    sameCostActivitiesInfo.index=index;
                    sameCostActivitiesInfo.hrpm=hrpm;
                    sameCostActivitiesInfo.arpm=arpm;
                    sameCostActivitiesInfo.grpm=grpm;
                    sameCostActivitiesInfo.diffReward=diffReward;
                    sameCostActivitiesInfo.diffChangeScore=diffChangeScore;
                    sameCostActivitiesInfo.subType=subType;
                    sameCostActivitiesInfo.isExcellent=excellent;
                    sameCostActivitiesInfoList.add(sameCostActivitiesInfo);
                }
            }

            rankResult.activityModel=result;
            rankResult.similarCostActivitiesInfo=sameCostActivitiesInfoList;

            mMap.clear();

            return rankResult;
        }catch (Exception e)
        {
            e.printStackTrace();
            logger.error(e.getMessage(), e);
            logger.error("error, size:{},candi:{},list:{},", size, JSON.toJSONString(candiList), JSON.toJSONString(result));
        }

        return null;
    }


    /**
     *功能描述 融合表单类和非表单类cvr
     *
     * @author lijingzhe
     * @date 2019/9/9
     * @param ad
     * @return cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityCvrInfo
     */
    public static ActivityCvrInfo calChangeScoreMergeAbsolute(ActivityInfoAd ad) {

        double changeScoreMerge=0.0;

        //直接用总转化除以总点击
        double changeScoreForms =ad.sumClickForms > 0 ? ad.sumEffectPVForms/ad.sumClickForms: 0 ;
        double changeScoreNotForms=ad.sumClickNotForms > 0 ? ad.sumEffectPVNotForms/ad.sumClickNotForms: 0 ;

        double rand=Math.random();

        // 优选考虑表单类转化率
        if (ad.sumEffectPVForms >=1 ) {
            changeScoreMerge=changeScoreForms;

        } else if ( 0 < ad.sumClickForms && ad.sumClickForms < 100 ) {
            double w1=ad.sumClickForms / 100.0 / 0.2;
            double w2=5 - w1;
            changeScoreMerge=0.01 * w2 * 0.06;
        } else if (ad.sumClickForms >= 100 ) {
            changeScoreMerge=0.06 / ad.sumClickForms;

        } else if (changeScoreNotForms > 0 ) {
            changeScoreMerge=changeScoreNotForms * 0.000001;

        }  else if (rand <= 0.000001 ) {
            changeScoreMerge=Math.random();
        }

        //输出 转化得分明细
        ActivityCvrInfo  activityChangeVal= new ActivityCvrInfo() ;

        activityChangeVal.sumClickForms=ad.sumClickForms;
        activityChangeVal.sumEffectPVForms=ad.sumEffectPVForms;

        activityChangeVal.sumClickNotForms=ad.sumClickNotForms;
        activityChangeVal.sumEffectPVNotForms=ad.sumEffectPVNotForms;

        activityChangeVal.changeScoreForms= changeScoreForms;
        activityChangeVal.changeScoreNotForms= changeScoreNotForms;

        activityChangeVal.changeScoreMerge=changeScoreMerge;
        //结果输出
        return activityChangeVal ;

    }

    public static double normlize(double val, double max, double limit) {
        double norm=Math.min(val * limit / max, limit);
        return norm;
    }

    /**
     *功能描述 标准化到区间[lower,upper]
     * @author lijingzhe
     * @date 2019/8/22
     * @param val, min, max, lower, upper
     * @return double
     */
    public static double normlize(double val, double min, double max,
                                  double lower, double upper) {
        double norm =
                upper > lower && upper <= 1 && lower >= 0 ?
                        (upper - lower) * (val - min) / (max - min)+lower :
                        0.6 * (val - min) / (max - min)+0.2 ;
        return norm;
    }

    /**
     *功能描述 去除卡包分，直接发券活动暂时不处理
     * @author lijingzhe
     * @date 2019/8/22
     * @param alphas, betas, subTypes, activityIds, changeScores, numMachines, gama
     * @return cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.ActivitySelectPool.SelectInfoDetail
     */
    private static SelectInfoDetail selectMachineWithChangeScore(List<Double> alphas, List<Double> betas,List<Long> activityTypes,List<Long> activityIds,List<Double> changeScores, int numMachines,List<Double> hrpms, List<Double> arpms, List<Double> grpms, List<Double> requests, List<Boolean> excellents, List<Integer> subTypes, List<Double> scores) {
        SelectInfoDetail selectInfoDetail=new SelectInfoDetail();
        ArrayList<SelectPoolInfo> sinfos=new ArrayList();
        for (int i=0; i < numMachines; i++) {
            if(activityTypes.get(i) != 21){
                double theta=BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
                SelectPoolInfo sinfo=new SelectPoolInfo();
                sinfo.setReward(theta);
                sinfo.setActivityType(activityTypes.get(i));
                sinfo.setIndex(i);
                sinfo.setActivityId(activityIds.get(i));
                sinfo.setChangeScore(changeScores.get(i));
                sinfo.setHrpm(hrpms.get(i));
                sinfo.setArpm(arpms.get(i));
                sinfo.setGrpm(grpms.get(i));
                sinfo.setRequest(requests.get(i));
                sinfo.setExcellent(excellents.get(i));
                sinfo.setScores(scores.get(i));
                sinfo.setExcellent(excellents.get(i));
                sinfo.setSubType(subTypes.get(i));
                sinfos.add(sinfo);
            }
        }

        if(sinfos.size() > 0){
            // 非卡包活动转化分最高活动
            List<SelectPoolInfo> condi=sinfos.stream()
                    .sorted(Comparator.comparing(SelectPoolInfo::getChangeScore).reversed())
                    .collect(Collectors.toList());
            double maxChangeScore=condi.get(0).getChangeScore();

            List<SelectPoolInfo> ranks=sinfos.stream()
                    .sorted(Comparator.comparing(SelectPoolInfo::getReward).reversed())
                    .collect(Collectors.toList());

            // 投放次数<100的活动，海选扶持
            List<SelectPoolInfo> supportAct =
                    sinfos.stream().filter(e->e.isExcellent() && e.getRequest() < 100).collect(Collectors.toList());
            if(Math.random() < 0.1 && supportAct.size() > 0){
                selectInfoDetail.condi=new ArrayList<>(supportAct.subList(0,Math.min(supportAct.size(),5)));
                selectInfoDetail.index=supportAct.get(new Random().nextInt(supportAct.size())).getIndex();
                selectInfoDetail.maxChangeScore=maxChangeScore;
                selectInfoDetail.strategyType=1;
                return selectInfoDetail;
            }
            // 投放次数>=100 && 投放次数<=500的活动，海选兜底
            for (int i=0; i < ranks.size(); i++) {
                if(ranks.get(i).getRequest() >= 100 && ranks.get(i).getRequest() <= 500 && i > 0){
                    // 排名top 2-5 每个活动以1%概率随机投
                    if(ranks.get(i).isExcellent() == true && i < 5 && Math.random() < 0.01){
                        selectInfoDetail.condi=
                                new ArrayList<>(ranks.subList(0, Math.min(ranks.size(),5)));
                        selectInfoDetail.index=ranks.get(i).getIndex();
                        selectInfoDetail.maxChangeScore=maxChangeScore;
                        selectInfoDetail.strategyType=2;
                        return selectInfoDetail;
                    }else if(ranks.get(i).isExcellent() == true && i < 20 && Math.random() < 0.001){
                        selectInfoDetail.condi=
                                new ArrayList<>(ranks.subList(0, Math.min(ranks.size(),5)));
                        selectInfoDetail.index=ranks.get(i).getIndex();
                        selectInfoDetail.maxChangeScore=maxChangeScore;
                        selectInfoDetail.strategyType=3;
                        return selectInfoDetail;
                    }
                }
            }

            //转化分相近的每个活动信息
            selectInfoDetail.condi=new ArrayList<>(ranks.subList(0, Math.min(ranks.size(),5)));
            //最优活动索引
            selectInfoDetail.index=ranks.get(0).getIndex();
            //最大转化分
            selectInfoDetail.maxChangeScore=maxChangeScore;
            selectInfoDetail.strategyType=4;
            return selectInfoDetail;
        }else{
            selectInfoDetail.index=0;
            selectInfoDetail.maxChangeScore=changeScores.get(0);
            selectInfoDetail.condi=new ArrayList<>();
            selectInfoDetail.strategyType=0;
            return selectInfoDetail;
        }
    }

    /**
     *功能描述 封装海选数据
     * @author lijingzhe
     * @date 2019/8/23
     * @param act, actIds, exHashMap
     * @return cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.ActivityMatchInfo
     */
    private static ActivityMatchInfo fillData(ActivityInfoData act, Set<Long> actIds, Map<Long, NormInfo> exHashMap){
        ActivityMatchInfo actM=new ActivityMatchInfo();
        actM.activityId=act.activityId;
        actM.slotId=act.slotId;
        actM.appId=act.appId;

        actM.hisClick=new ActivityVal();
        actM.hisClick.globalVal=act.click.globalVal;
        actM.hisClick.appVal=act.click.appVal;
        actM.hisClick.slotVal=act.click.slotVal;

        actM.hisCost=new ActivityVal();
        actM.hisCost.globalVal=act.cost.globalVal;
        actM.hisCost.appVal=act.cost.appVal;
        actM.hisCost.slotVal=act.cost.slotVal;

        actM.hisRequest=new ActivityVal();
        actM.hisRequest.globalVal=act.request.globalVal;
        actM.hisRequest.appVal=act.request.appVal;
        actM.hisRequest.slotVal=act.request.slotVal;

        actM.subType=act.subType;
        actM.isExcellent=actIds.contains(act.activityId);
        actM.nPvClick=exHashMap.getOrDefault(act.activityId,new NormInfo()).getnPvClick();
        actM.nPvCost=exHashMap.getOrDefault(act.activityId, new NormInfo()).getnPvCost();
        actM.nCvrForm=exHashMap.getOrDefault(act.activityId, new NormInfo()).getnFormCvr();
        actM.nCvrNotForm=exHashMap.getOrDefault(act.activityId, new NormInfo()).getnNotFormCvr();
        actM.nCvr=exHashMap.getOrDefault(act.activityId, new NormInfo()).getnCvr();
        actM.score=exHashMap.getOrDefault(act.activityId, new NormInfo()).getScore();

        return actM;
    }

}
