package cn.com.duiba.nezha.alg.common.model.activityrecommend;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import junit.framework.TestCase;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActivityRec40Test extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        System.out.println();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        System.out.println();
    }

    public void testBayesianBandit() throws Exception {
        //读取本地模拟文件
        String Path="C:\\duiba\\files\\data\\activity.txt";
        BufferedReader reader = null;
        String laststr = "";
        try {
            FileInputStream fileInputStream = new FileInputStream(Path);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, "UTF-8");
            reader = new BufferedReader(inputStreamReader);
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                laststr += tempString;
            }
            reader.close();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        JSONArray jsonArray = JSON.parseArray(laststr);
        List<ActivityMatchInfo> actDs = new ArrayList<>();
        List<ActivityRankInfo> actMs = new ArrayList<>();
        for (int i = 0; i < jsonArray.size(); i++) {
            ActivityMatchInfo actD = jsonArray.getJSONObject(i).toJavaObject(ActivityMatchInfo.class);
            actDs.add(actD);
            ActivityRankInfo actM = new ActivityRankInfo();
            actM.slotId = actD.slotId;
            actM.activityId = actD.activityId;
            actM.appId = actD.appId;
            actMs.add(actM);
        }

        //单元测试
        Map<Long,Integer> map = new HashMap<>();

        ActivityRankInfo result=new ActivityRankInfo();
        for (int i=0;i<10000;i++) {
            RankResult ret = ActivityRec40.select(actMs, actDs);
            System.out.println(i + " select result:" + ret.activityModel.toString());
            map.put(ret.activityModel.activityId, map.getOrDefault(ret.activityModel.activityId,0) + 1);
        }

        System.out.println(map);
    }
}
