/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.activityrecommend;

import cn.com.duiba.nezha.alg.common.model.activityrecommend.WilsonPair;

public class WilsonInterval {
    public static WilsonPair wilsonCalc(double numerator, double denominator) {
        if (denominator == 0.0) {
            return new WilsonPair(0.0, 0.0);
        }
        numerator = numerator > denominator ? denominator : numerator;
        double z = 1.6;
        double phat = numerator / denominator;
        double denorm = 1.0 + z * z / denominator;
        double enum1 = phat + z * z / (2.0 * denominator);
        double enum2 = z * Math.sqrt(phat * (1.0 - phat) / denominator + z * z / (4.0 * denominator * denominator));
        return new WilsonPair((enum1 - enum2) / denorm, (enum1 + enum2) / denorm);
    }

    public static WilsonPair wilsonCalc97(double numerator, double denominator) {
        if (denominator == 0.0) {
            return new WilsonPair(0.0, 0.0);
        }
        numerator = numerator > denominator ? denominator : numerator;
        double z = 2.2;
        double phat = numerator / denominator;
        double denorm = 1.0 + z * z / denominator;
        double enum1 = phat + z * z / (2.0 * denominator);
        double enum2 = z * Math.sqrt(phat * (1.0 - phat) / denominator + z * z / (4.0 * denominator * denominator));
        return new WilsonPair((enum1 - enum2) / denorm, (enum1 + enum2) / denorm);
    }

    public static void main(String[] args) {
        double slotScore = WilsonInterval.wilsonCalc((double)5.0, (double)5.0).lowerBound;
        double appScore = WilsonInterval.wilsonCalc((double)1666.0, (double)120000.0).lowerBound;
        double globalScore = WilsonInterval.wilsonCalc((double)3333.0, (double)24000.0).lowerBound;
        double coef = 0.0;
        double matchscore = 0.0;
        double sconfidence = 1.0;
        double aconfidence = Math.min(0, 1);
        matchscore = sconfidence * slotScore + (1.0 - sconfidence) * aconfidence * appScore * 0.9 + (1.0 - (1.0 - sconfidence) * aconfidence) * globalScore * 0.8;
        System.out.print(slotScore);
    }
}

