/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.util;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Murmurs {
    public static Long hash(byte[] key) {
        ByteBuffer buf = ByteBuffer.wrap(key);
        int seed = 305441741;
        ByteOrder byteOrder = buf.order();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        long m = -4132994306676758123L;
        int r = 47;
        long h = (long)seed ^ (long)buf.remaining() * m;
        while (buf.remaining() >= 8) {
            long k = buf.getLong();
            k *= m;
            k ^= k >>> r;
            h ^= (k *= m);
            h *= m;
        }
        if (buf.remaining() > 0) {
            ByteBuffer finish = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
            finish.put(buf).rewind();
            h ^= finish.getLong();
            h *= m;
        }
        h ^= h >>> r;
        h *= m;
        h ^= h >>> r;
        buf.order(byteOrder);
        return h;
    }

    public static Long hash(String key) {
        return Murmurs.hash(key.getBytes());
    }

    public static BigDecimal readUnsignedLong(long value) {
        if (value >= 0L) {
            return new BigDecimal(value);
        }
        long lowValue = value & Long.MAX_VALUE;
        return BigDecimal.valueOf(lowValue).add(BigDecimal.valueOf(Long.MAX_VALUE)).add(BigDecimal.valueOf(1L));
    }

    public static BigDecimal hashUnsigned(String key) {
        return Murmurs.readUnsignedLong(Murmurs.hash(key));
    }

    public static BigDecimal hashUnsigned(byte[] key) {
        return Murmurs.readUnsignedLong(Murmurs.hash(key));
    }
}

