/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.materialrecommend;

import cn.com.duiba.nezha.alg.common.model.materialrecommend.Constant;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.MaterialDataInfo;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.MaterialMatchInfo;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.MaterialNormInfo;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.MaterialRankInfo;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.MaterialVal;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.RankInfo;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.WilsonInterval;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.WilsonPair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AlgUtils {
    public static Comparator<? super MatchInfo> iComparator = new Comparator<MatchInfo>(){

        @Override
        public int compare(MatchInfo o1, MatchInfo o2) {
            return o2.score >= o1.score ? 1 : -1;
        }
    };
    public static Comparator<? super MatchInfo> normComparator = new Comparator<MatchInfo>(){

        @Override
        public int compare(MatchInfo o1, MatchInfo o2) {
            return o2.mat.score >= o1.score ? 1 : -1;
        }
    };

    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }

    public static List<MaterialRankInfo> getSingleOptCandis(List<RankInfo> ris, List<MaterialMatchInfo> matchInfoList, List<MaterialRankInfo> materialModelList, String oppAlg, int hthr, int athr) {
        ArrayList<Double> exposures = new ArrayList<Double>();
        ArrayList<Double> rewards = new ArrayList<Double>();
        ArrayList<Double> counts = new ArrayList<Double>();
        ArrayList<Double> alphas = new ArrayList<Double>();
        ArrayList<Double> betas = new ArrayList<Double>();
        ArrayList<Long> materialIds = new ArrayList<Long>();
        ArrayList<Double> grpms = new ArrayList<Double>();
        ArrayList<Double> arpms = new ArrayList<Double>();
        ArrayList<Double> hrpms = new ArrayList<Double>();
        ArrayList<Double> ctrs = new ArrayList<Double>();
        ArrayList<Double> ucas = new ArrayList<Double>();
        ArrayList<Double> pvCosts = new ArrayList<Double>();
        ArrayList<Boolean> excellents = new ArrayList<Boolean>();
        ArrayList<Double> scores = new ArrayList<Double>();
        ArrayList<MaterialRankInfo> candis = new ArrayList<MaterialRankInfo>();
        HashMap<Long, Material> mMap = new HashMap<Long, Material>();
        double maxG = Constant.MIN_REWARD;
        double maxH = Constant.MIN_REWARD;
        double maxA = Constant.MIN_REWARD;
        double minG = 0.0;
        double minH = Constant.MIN_REWARD;
        double minA = Constant.MIN_REWARD;
        double oppH = 0.0;
        double oppA = 0.0;
        double oppG = 0.0;
        for (int i = 0; i < matchInfoList.size(); ++i) {
            Material ml = mMap.getOrDefault(matchInfoList.get(i).getMaterialId(), new Material());
            if (oppAlg.equals(Constant.ALG_CTR)) {
                ml.grpm = oppG = matchInfoList.get((int)i).exposureCnt.getGlobalVal() > 0.0 ? matchInfoList.get((int)i).clickCnt.getGlobalVal() / matchInfoList.get((int)i).exposureCnt.getGlobalVal() : 0.0;
                ml.gexp = matchInfoList.get((int)i).exposureCnt.getGlobalVal();
                maxG = Math.max(oppG, maxG);
                ml.arpm = oppA = matchInfoList.get((int)i).exposureCnt.getAppVal() > 0.0 ? matchInfoList.get((int)i).clickCnt.getAppVal() / matchInfoList.get((int)i).exposureCnt.getAppVal() : 0.0;
                ml.aexp = matchInfoList.get((int)i).exposureCnt.getAppVal();
                if (ml.aexp > (double)athr) {
                    maxA = Math.max(oppA, maxA);
                }
                minA = Math.min(oppA, minA);
                ml.hrpm = oppH = matchInfoList.get((int)i).exposureCnt.getSlotVal() > 0.0 ? matchInfoList.get((int)i).clickCnt.getSlotVal() / matchInfoList.get((int)i).exposureCnt.getSlotVal() : 0.0;
                ml.hexp = matchInfoList.get((int)i).exposureCnt.getSlotVal();
                if (ml.hexp > (double)hthr) {
                    maxH = Math.max(oppH, maxH);
                }
                minH = Math.min(oppH, minH);
            } else if (oppAlg.equals(Constant.ALG_UC)) {
                ml.grpm = oppG = matchInfoList.get((int)i).exposureCnt.getGlobalVal() > 0.0 ? matchInfoList.get((int)i).cost.getGlobalVal() / (100.0 * matchInfoList.get((int)i).exposureCnt.getGlobalVal()) : 0.0;
                ml.gexp = matchInfoList.get((int)i).exposureCnt.getGlobalVal();
                maxG = Math.max(oppG, maxG);
                ml.arpm = oppA = matchInfoList.get((int)i).exposureCnt.getAppVal() > 0.0 ? matchInfoList.get((int)i).cost.getAppVal() / (100.0 * matchInfoList.get((int)i).exposureCnt.getAppVal()) : 0.0;
                ml.aexp = matchInfoList.get((int)i).exposureCnt.getAppVal();
                if (ml.aexp > (double)athr) {
                    maxA = Math.max(oppA, maxA);
                }
                minA = Math.min(oppA, minA);
                ml.hrpm = oppH = matchInfoList.get((int)i).exposureCnt.getSlotVal() > 0.0 ? matchInfoList.get((int)i).cost.getSlotVal() / (100.0 * matchInfoList.get((int)i).exposureCnt.getSlotVal()) : 0.0;
                ml.hexp = matchInfoList.get((int)i).exposureCnt.getSlotVal();
                if (ml.hexp > (double)hthr) {
                    maxH = Math.max(oppH, maxH);
                }
                minH = Math.min(oppH, minH);
            }
            mMap.put(matchInfoList.get(i).getMaterialId(), ml);
        }
        double ctr = matchInfoList.get((int)0).ctr;
        double uc = matchInfoList.get((int)0).uc / 100.0;
        double uca = matchInfoList.get((int)0).uca / 100.0;
        for (int i = 0; i < matchInfoList.size(); ++i) {
            double sCtr = matchInfoList.get((int)i).exposureCnt.getSlotVal() > 0.0 ? matchInfoList.get((int)i).clickCnt.getSlotVal() / matchInfoList.get((int)i).exposureCnt.getSlotVal() : 0.0;
            double sUca = matchInfoList.get((int)i).request.getSlotVal() > 0.0 ? matchInfoList.get((int)i).cost.getSlotVal() / (100.0 * matchInfoList.get((int)i).request.getSlotVal()) : 0.0;
            double sUc = matchInfoList.get((int)i).exposureCnt.getSlotVal() > 0.0 ? matchInfoList.get((int)i).cost.getSlotVal() / (100.0 * matchInfoList.get((int)i).exposureCnt.getSlotVal()) : 0.0;
            ctrs.add(sCtr);
            ucas.add(sUca);
            pvCosts.add(sUc);
            exposures.add(matchInfoList.get((int)i).exposureCnt.getSlotVal());
            double hrpm = ((Material)mMap.get((Object)Long.valueOf((long)matchInfoList.get((int)i).getMaterialId()))).hrpm;
            double arpm = ((Material)mMap.get((Object)Long.valueOf((long)matchInfoList.get((int)i).getMaterialId()))).arpm;
            double grpm = ((Material)mMap.get((Object)Long.valueOf((long)matchInfoList.get((int)i).getMaterialId()))).grpm;
            hrpms.add(hrpm);
            arpms.add(arpm);
            grpms.add(grpm);
            excellents.add(matchInfoList.get((int)i).isExcellent);
            scores.add(matchInfoList.get((int)i).score);
            double reward = Constant.MIN_REWARD;
            double sconfidence = Math.min(matchInfoList.get((int)i).exposureCnt.getSlotVal() / (double)hthr, 1.0);
            double aconfidence = Math.min(matchInfoList.get((int)i).exposureCnt.getAppVal() / (double)athr, 1.0);
            reward = sconfidence * AlgUtils.normlize(hrpm * 0.8, maxH, 0.8) + (1.0 - sconfidence) * aconfidence * AlgUtils.normlize(arpm * 0.7, maxA, 0.7) + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * AlgUtils.normlize(grpm * 0.5, maxG, 0.6);
            reward *= reward;
            reward = Math.max(reward, 0.0);
            materialModelList.get((int)i).reward = materialModelList.get((int)i).reward * Constant.DECAY + reward;
            materialModelList.get((int)i).count = materialModelList.get((int)i).count * Constant.DECAY + 1.0;
            materialModelList.get((int)i).alpha = 1.5 + materialModelList.get((int)i).reward;
            materialModelList.get((int)i).beta = 2.0 + (materialModelList.get((int)i).count - materialModelList.get((int)i).reward);
            rewards.add(materialModelList.get((int)i).reward);
            counts.add(materialModelList.get((int)i).count);
            alphas.add(materialModelList.get((int)i).alpha);
            betas.add(materialModelList.get((int)i).beta);
            materialIds.add(materialModelList.get((int)i).materialId);
            candis.add(materialModelList.get(i));
        }
        mMap.clear();
        AlgUtils.getSinfos(ris, candis.size(), alphas, betas, materialIds, exposures, excellents, scores, ctrs, pvCosts, ucas, ctr, uc, uca);
        return candis;
    }

    public static MaterialDetail selectMultiOptInfo(List<RankInfo> ris, List<MaterialMatchInfo> matchInfoList, List<MaterialRankInfo> materialModelList, String oppAlg) {
        MaterialDetail md = new MaterialDetail();
        if (ris.size() > 0) {
            long excellentCnt = ris.stream().filter(e -> e.isExcellent()).count();
            double avgFcProb = excellentCnt > 0L ? Constant.EXCELLENT_FC_PROB / (double)excellentCnt : 0.0;
            List ranks = ris.stream().sorted(Comparator.comparing(RankInfo::getReward).reversed()).collect(Collectors.toList());
            for (int i = 0; i < ranks.size(); ++i) {
                if (((RankInfo)ranks.get(i)).getExposure() < (double)Constant.EXPOSURE_THRESHOLD) {
                    if (((RankInfo)ranks.get(i)).isExcellent()) {
                        if (Math.random() < avgFcProb) {
                            md.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                            md.index = ((RankInfo)ranks.get(i)).getIndex();
                            md.strategyType = 1;
                            break;
                        }
                    } else if (i > 0 && i < 5 && Math.random() < Constant.CTR_FC_PROB / 4.0) {
                        md.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                        md.index = ((RankInfo)ranks.get(i)).getIndex();
                        md.strategyType = 1;
                        break;
                    }
                } else if (((RankInfo)ranks.get(i)).getExposure() <= (double)Constant.DD_THRESHOLD) {
                    if (((RankInfo)ranks.get(i)).isExcellent() && i > 1 && i < 5 && Math.random() < Constant.DD_PROB_HIGH / 4.0) {
                        md.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                        md.index = ((RankInfo)ranks.get(i)).getIndex();
                        md.strategyType = 2;
                        break;
                    }
                    if (((RankInfo)ranks.get(i)).isExcellent() && i < 15 && Math.random() < Constant.DD_PROB_MID / 10.0) {
                        md.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                        md.index = ((RankInfo)ranks.get(i)).getIndex();
                        md.strategyType = 3;
                        break;
                    }
                }
                int feeMark = matchInfoList.get(0).getFeeMark();
                if (!(((RankInfo)ranks.get(i)).getCtr() >= 0.95 * ((RankInfo)ranks.get(i)).getsCtr())) continue;
                if (((RankInfo)ranks.get(i)).getPvCost() >= 0.95 * ((RankInfo)ranks.get(i)).getsPvCost()) {
                    md.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                    if (feeMark == 1 && ((RankInfo)ranks.get(i)).getUca() >= 0.95 * ((RankInfo)ranks.get(i)).getSuca()) {
                        md.index = ((RankInfo)ranks.get(i)).getIndex();
                        md.strategyType = 7;
                        break;
                    }
                    md.index = ((RankInfo)ranks.get(i)).getIndex();
                    md.strategyType = 4;
                    break;
                }
                if (oppAlg.equals(Constant.ALG_CTR) && ((RankInfo)ranks.get(i)).getCtr() > 1.2 * ((RankInfo)ranks.get(i)).getsCtr()) {
                    if (!(((RankInfo)ranks.get(i)).getPvCost() < 0.8 * ((RankInfo)ranks.get(i)).getsPvCost())) continue;
                    md = AlgUtils.getPairWise(matchInfoList, materialModelList, oppAlg);
                    break;
                }
                if (!oppAlg.equals(Constant.ALG_UC) || !(((RankInfo)ranks.get(i)).getPvCost() > 1.2 * ((RankInfo)ranks.get(i)).getsPvCost()) || !(((RankInfo)ranks.get(i)).getCtr() < 0.8 * ((RankInfo)ranks.get(i)).getsCtr())) continue;
                md = AlgUtils.getPairWise(matchInfoList, materialModelList, oppAlg);
            }
            if (md == null || md.strategyType == 0) {
                List rkf = ranks.stream().filter(e -> e.getPvCost() >= 0.8 * e.getsPvCost()).collect(Collectors.toList());
                md.index = ((RankInfo)ranks.get(0)).getIndex();
                md.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                md.strategyType = 6;
            }
        } else {
            md.index = 0;
            md.condi = new ArrayList();
            md.strategyType = 0;
        }
        return md;
    }

    public static MaterialDetail getPairWise(List<MaterialMatchInfo> matchInfoList, List<MaterialRankInfo> materialModelList, String oppAlg) {
        MaterialDetail md = new MaterialDetail();
        int feeMark = matchInfoList.get(0).getFeeMark();
        ArrayList<RankInfo> ris = new ArrayList<RankInfo>();
        String oppAlgN = oppAlg.equals(Constant.ALG_CTR) ? Constant.ALG_UC : Constant.ALG_CTR;
        List<MaterialRankInfo> mris = AlgUtils.getSingleOptCandis(ris, matchInfoList, materialModelList, oppAlgN, 100, 100);
        if (mris.size() > 0) {
            List uc_ranks = ris.stream().sorted(Comparator.comparing(RankInfo::getReward).reversed()).collect(Collectors.toList());
            md.condi = new ArrayList(uc_ranks.subList(0, Math.min(uc_ranks.size(), 5)));
            if (feeMark == 1) {
                List uca_ranks = uc_ranks.stream().filter(e -> e.getUca() >= 0.95 * e.getSuca()).collect(Collectors.toList());
                md.index = ((RankInfo)uca_ranks.get(0)).getIndex();
                md.strategyType = 8;
            } else {
                md.index = ((RankInfo)uc_ranks.get(0)).getIndex();
                md.strategyType = 5;
            }
        }
        return md;
    }

    public static void getSinfos(List<RankInfo> ris, int numMachines, ArrayList<Double> alphas, ArrayList<Double> betas, ArrayList<Long> materialIds, ArrayList<Double> exposures, ArrayList<Boolean> excellents, ArrayList<Double> scores, ArrayList<Double> ctrs, ArrayList<Double> pvCosts, ArrayList<Double> ucas, double ctr, double uc, double uca) {
        for (int i = 0; i < numMachines; ++i) {
            double theta = AlgUtils.BetaDist(alphas.get(i), betas.get(i));
            RankInfo rankInfo = new RankInfo();
            rankInfo.setReward(theta);
            rankInfo.setIndex(i);
            rankInfo.setMaterialId(materialIds.get(i));
            rankInfo.setExposure(exposures.get(i));
            rankInfo.setExcellent(excellents.get(i));
            rankInfo.setScores(scores.get(i));
            rankInfo.setCtr(ctrs.get(i));
            rankInfo.setUca(ucas.get(i));
            rankInfo.setPvCost(pvCosts.get(i));
            rankInfo.setsCtr(ctr);
            rankInfo.setSuca(uca);
            rankInfo.setsPvCost(uc);
            ris.add(rankInfo);
        }
    }

    public static MaterialMatchInfo fillData(MaterialDataInfo mat, Set<Long> sckIds, Map<Long, MaterialNormInfo> exHashMap) {
        MaterialMatchInfo sckM = new MaterialMatchInfo();
        sckM.slotId = mat.slotId;
        sckM.appId = mat.appId;
        sckM.materialId = mat.materialId;
        sckM.feeMark = mat.feeMark;
        sckM.setExcellent(sckIds.contains(mat.materialId));
        sckM.exposureCnt = new MaterialVal();
        sckM.exposureCnt.setAlgSlotVal(mat.exposureCnt.getAlgSlotVal());
        sckM.exposureCnt.setSlotVal(mat.exposureCnt.getSlotVal());
        sckM.exposureCnt.setAppVal(mat.exposureCnt.getAppVal());
        sckM.exposureCnt.setGlobalVal(mat.exposureCnt.getGlobalVal());
        sckM.clickCnt = new MaterialVal();
        sckM.clickCnt.setAlgSlotVal(mat.clickCnt.getAlgSlotVal());
        sckM.clickCnt.setSlotVal(mat.clickCnt.getSlotVal());
        sckM.clickCnt.setAppVal(mat.clickCnt.getAppVal());
        sckM.clickCnt.setGlobalVal(mat.clickCnt.getGlobalVal());
        sckM.request = new MaterialVal();
        sckM.request.setAlgSlotVal(mat.request.getAlgSlotVal());
        sckM.request.setSlotVal(mat.request.getSlotVal());
        sckM.request.setAppVal(mat.request.getAppVal());
        sckM.request.setGlobalVal(mat.request.getGlobalVal());
        sckM.cost = new MaterialVal();
        sckM.cost.setAlgSlotVal(mat.cost.getAlgSlotVal());
        sckM.cost.setSlotVal(mat.cost.getSlotVal());
        sckM.cost.setAppVal(mat.cost.getAppVal());
        sckM.cost.setGlobalVal(mat.cost.getGlobalVal());
        sckM.nCtr = exHashMap.getOrDefault(mat.getMaterialId(), new MaterialNormInfo()).getnCtr();
        sckM.nPvCost = exHashMap.getOrDefault(mat.getMaterialId(), new MaterialNormInfo()).getnPvCost();
        sckM.score = exHashMap.getOrDefault(mat.getMaterialId(), new MaterialNormInfo()).getScore();
        return sckM;
    }

    public static double getMatchScore(MaterialVal num, MaterialVal den, Double thr1, Double thr2, Boolean isUC) {
        double slotScore = WilsonInterval.wilsonCalc((double)num.getSlotVal(), (double)den.getSlotVal()).lowerBound;
        double globalScore = WilsonInterval.wilsonCalc((double)num.getGlobalVal(), (double)den.getGlobalVal()).lowerBound;
        double appScore = WilsonInterval.wilsonCalc((double)num.getAppVal(), (double)den.getAppVal()).lowerBound;
        if (isUC.booleanValue()) {
            slotScore = WilsonInterval.wilsonCalc((double)num.getSlotVal(), (double)(den.getSlotVal() / 100.0)).lowerBound;
            globalScore = WilsonInterval.wilsonCalc((double)num.getGlobalVal(), (double)(den.getGlobalVal() / 100.0)).lowerBound;
            appScore = WilsonInterval.wilsonCalc((double)num.getAppVal(), (double)(den.getAppVal() / 100.0)).lowerBound;
        }
        double sconfidence = Math.min(den.getSlotVal() / thr1, 1.0);
        double aconfidence = Math.min(den.getAppVal() / thr1, 1.0);
        double gconfidence = Math.min(den.getGlobalVal() / thr2, 1.0);
        double matchscore = sconfidence * slotScore + (1.0 - sconfidence) * aconfidence * appScore * 0.9 + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);
        return matchscore;
    }

    public static WilsonPair wilsonCalc(double numerator, double denominator) {
        if (denominator == 0.0) {
            return new WilsonPair(0.0, 0.0);
        }
        numerator = numerator > denominator ? denominator : numerator;
        double z = 1.6;
        double phat = numerator / denominator;
        double denorm = 1.0 + z * z / denominator;
        double enum1 = phat + z * z / (2.0 * denominator);
        double enum2 = z * Math.sqrt(phat * (1.0 - phat) / denominator + z * z / (4.0 * denominator * denominator));
        return new WilsonPair((enum1 - enum2) / denorm, (enum1 + enum2) / denorm);
    }

    public static double BetaDist(double alpha, double beta) {
        double a = alpha + beta;
        double b = Math.sqrt((a - 2.0) / (2.0 * alpha * beta - a));
        if (Math.min(alpha, beta) <= 1.0) {
            b = Math.max(1.0 / alpha, 1.0 / beta);
        }
        double c = alpha + 1.0 / b;
        double W = 0.0;
        boolean reject = true;
        while (reject) {
            double U1 = Math.random();
            double U2 = Math.random();
            double V = b * Math.log(U1 / (1.0 - U1));
            W = alpha * Math.exp(V);
            reject = a * Math.log(a / (beta + W)) + c * V - Math.log(4.0) < Math.log(U1 * U1 * U2);
        }
        return W / (beta + W);
    }

    static class MaterialDetail {
        int index;
        ArrayList<RankInfo> condi;
        int strategyType;

        MaterialDetail() {
        }
    }

    static class MatchInfo {
        double score;
        MaterialMatchInfo mat;

        MatchInfo() {
        }
    }

    static class Material {
        double grpm;
        double gexp;
        double hrpm;
        double hexp;
        double arpm;
        double aexp;

        Material() {
        }
    }
}

