/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.pacing;

import cn.com.duiba.nezha.alg.common.model.feedback.FeedBack;
import cn.com.duiba.nezha.alg.common.model.pacing.AdvertOrientInfo;
import cn.com.duiba.nezha.alg.common.model.pacing.OrientInfo;
import cn.com.duiba.nezha.alg.common.model.pacing.ResultType;
import cn.com.duiba.nezha.alg.common.model.pacing.TagInfo;
import cn.com.duiba.nezha.alg.common.model.pacing.TrusteeshipParams;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotRecommender {
    private static final Logger logger = LoggerFactory.getLogger(SlotRecommender.class);

    public static Map<ResultType, Collection<AdvertOrientInfo>> recommend(Collection<OrientInfo> orientlist, Long slotId, TrusteeshipParams trusteeshipParams, Integer flowType) {
        HashSet<AdvertOrientInfo> orientSet = new HashSet<AdvertOrientInfo>();
        HashSet<AdvertOrientInfo> fuseSet1 = new HashSet<AdvertOrientInfo>();
        HashSet<AdvertOrientInfo> fuseSet2 = new HashSet<AdvertOrientInfo>();
        HashSet<AdvertOrientInfo> recommendListSet = new HashSet<AdvertOrientInfo>();
        HashSet<AdvertOrientInfo> shieldListSet = new HashSet<AdvertOrientInfo>();
        TrusteeshipParams.ReleaseTarget1SlotRecommendParams releaseTarget1slotRecommendParams = trusteeshipParams.getReleaseTarget1slotRecommendParams();
        TrusteeshipParams.ReleaseTarget2SlotRecommendParams releaseTarget2slotRecommendParams = trusteeshipParams.getReleaseTarget2slotRecommendParams();
        TrusteeshipParams.ReleaseTarget3SlotRecommendParams releaseTarget3slotRecommendParams = trusteeshipParams.getReleaseTarget3slotRecommendParams();
        if (Math.random() < 1.0E-5) {
            logger.info("params slotRecommendParams:{}", (Object)trusteeshipParams);
        }
        for (OrientInfo orientInfo : orientlist) {
            String feedBackLabel;
            Integer manageType = orientInfo.manageType;
            Integer releaseTarget = orientInfo.releaseTarget != null ? orientInfo.releaseTarget : 3;
            Integer chargeType = orientInfo.chargeType;
            Integer cvrType = orientInfo.cvrType;
            Long target = orientInfo.target != 0L ? orientInfo.target : 1L;
            Long importantAppAfee = orientInfo.importantAppAfee;
            Long fee = orientInfo.fee;
            HashMap<String, Double> recommendParamsMap = new HashMap<String, Double>();
            if (releaseTarget == 1) {
                recommendParamsMap.put("startFactor", releaseTarget1slotRecommendParams.getStartFactor());
                recommendParamsMap.put("cpaBiasRatioFactor", releaseTarget1slotRecommendParams.getCpaBiasRatioFactor());
                recommendParamsMap.put("cpaOrientRatioFactor", releaseTarget1slotRecommendParams.getCpaOrientRatioFactor());
                recommendParamsMap.put("cpaBiasThresholdFactor", releaseTarget1slotRecommendParams.getCpaBiasThresholdFactor());
                recommendParamsMap.put("cpcTargetRatioFactor", releaseTarget1slotRecommendParams.getCpcTargetRatioFactor());
                recommendParamsMap.put("cpcOrientRatioFactor", releaseTarget1slotRecommendParams.getCpcOrientRatioFactor());
                recommendParamsMap.put("cpcBiasThresholdFactor", releaseTarget1slotRecommendParams.getCpcBiasThresholdFactor());
                recommendParamsMap.put("cpaHisCorrCoeffRatioFactor", releaseTarget1slotRecommendParams.getCpaHisCorrCoeffRatioFactor());
                recommendParamsMap.put("cpaHisCorrCoeffThreshod", releaseTarget1slotRecommendParams.getCpaHisCorrCoeffThreshod());
                recommendParamsMap.put("cpaNotHisCorrCoeffThreshod", releaseTarget1slotRecommendParams.getCpaNotHisCorrCoeffThreshod());
                recommendParamsMap.put("cpcHisCorrCoeffThreshod", releaseTarget1slotRecommendParams.getCpcHisCorrCoeffThreshod());
                recommendParamsMap.put("cpcNotHisCorrCoeffThreshod", releaseTarget1slotRecommendParams.getCpcNotHisCorrCoeffThreshod());
            } else if (releaseTarget == 2 || manageType == 3) {
                recommendParamsMap.put("startFactor", releaseTarget2slotRecommendParams.getStartFactor());
                recommendParamsMap.put("cpaBiasRatioFactor", releaseTarget2slotRecommendParams.getCpaBiasRatioFactor());
                recommendParamsMap.put("cpaOrientRatioFactor", releaseTarget2slotRecommendParams.getCpaOrientRatioFactor());
                recommendParamsMap.put("cpaBiasThresholdFactor", releaseTarget2slotRecommendParams.getCpaBiasThresholdFactor());
                recommendParamsMap.put("cpcTargetRatioFactor", releaseTarget2slotRecommendParams.getCpcTargetRatioFactor());
                recommendParamsMap.put("cpcOrientRatioFactor", releaseTarget2slotRecommendParams.getCpcOrientRatioFactor());
                recommendParamsMap.put("cpcBiasThresholdFactor", releaseTarget2slotRecommendParams.getCpcBiasThresholdFactor());
                recommendParamsMap.put("cpaHisCorrCoeffRatioFactor", releaseTarget2slotRecommendParams.getCpaHisCorrCoeffRatioFactor());
                recommendParamsMap.put("cpaHisCorrCoeffThreshod", releaseTarget2slotRecommendParams.getCpaHisCorrCoeffThreshod());
                recommendParamsMap.put("cpaNotHisCorrCoeffThreshod", releaseTarget2slotRecommendParams.getCpaNotHisCorrCoeffThreshod());
                recommendParamsMap.put("cpcHisCorrCoeffThreshod", releaseTarget2slotRecommendParams.getCpcHisCorrCoeffThreshod());
                recommendParamsMap.put("cpcNotHisCorrCoeffThreshod", releaseTarget2slotRecommendParams.getCpcNotHisCorrCoeffThreshod());
            } else {
                recommendParamsMap.put("startFactor", releaseTarget3slotRecommendParams.getStartFactor());
                recommendParamsMap.put("cpaBiasRatioFactor", releaseTarget3slotRecommendParams.getCpaBiasRatioFactor());
                recommendParamsMap.put("cpaOrientRatioFactor", releaseTarget3slotRecommendParams.getCpaOrientRatioFactor());
                recommendParamsMap.put("cpaBiasThresholdFactor", releaseTarget3slotRecommendParams.getCpaBiasThresholdFactor());
                recommendParamsMap.put("cpcTargetRatioFactor", releaseTarget3slotRecommendParams.getCpcTargetRatioFactor());
                recommendParamsMap.put("cpcOrientRatioFactor", releaseTarget3slotRecommendParams.getCpcOrientRatioFactor());
                recommendParamsMap.put("cpcBiasThresholdFactor", releaseTarget3slotRecommendParams.getCpcBiasThresholdFactor());
                recommendParamsMap.put("cpaHisCorrCoeffRatioFactor", releaseTarget3slotRecommendParams.getCpaHisCorrCoeffRatioFactor());
                recommendParamsMap.put("cpaHisCorrCoeffThreshod", releaseTarget3slotRecommendParams.getCpaHisCorrCoeffThreshod());
                recommendParamsMap.put("cpaNotHisCorrCoeffThreshod", releaseTarget3slotRecommendParams.getCpaNotHisCorrCoeffThreshod());
                recommendParamsMap.put("cpcHisCorrCoeffThreshod", releaseTarget3slotRecommendParams.getCpcHisCorrCoeffThreshod());
                recommendParamsMap.put("cpcNotHisCorrCoeffThreshod", releaseTarget3slotRecommendParams.getCpcNotHisCorrCoeffThreshod());
            }
            HashMap<String, Double> candidateMap = new HashMap<String, Double>();
            if (orientInfo.cvrSet != null && orientInfo.biasSet != null) {
                candidateMap.put("statCvr0", orientInfo.cvrSet.get(0));
                candidateMap.put("statCvr1", orientInfo.cvrSet.get(1));
                candidateMap.put("statCvr2", orientInfo.cvrSet.get(2));
                candidateMap.put("statCvr3", orientInfo.cvrSet.get(3));
                candidateMap.put("statCvr4", orientInfo.cvrSet.get(4));
                candidateMap.put("cvrBias0", orientInfo.biasSet.get(0));
                candidateMap.put("cvrBias1", orientInfo.biasSet.get(1));
                candidateMap.put("cvrBias2", orientInfo.biasSet.get(2));
                candidateMap.put("cvrBias3", orientInfo.biasSet.get(3));
                candidateMap.put("cvrBias4", orientInfo.biasSet.get(4));
            }
            if (Math.random() < 1.0E-5) {
                logger.info("OrientInfo slotId:{} advertId:{} orientId:{} OrientInfo:{}", new Object[]{slotId, orientInfo.advertId, orientInfo.orientId, orientInfo});
            }
            Double orientCostG1d = orientInfo.orientCostG1d != null ? orientInfo.orientCostG1d : 0.0;
            Double orientCostG7d = orientInfo.orientCostG7d != null ? orientInfo.orientCostG7d : 0.0;
            Double orientConvert = orientInfo.orientConvertG1d;
            Double orientCostConvert = orientConvert != 0.0 && orientCostG1d != 0.0 ? orientCostG1d / orientConvert : (double)target.longValue();
            Double orientCostConvertbias = orientConvert != 0.0 ? orientCostConvert / (double)target.longValue() : orientCostG1d / (double)target.longValue();
            Double orientConfidence = orientCostG1d / (double)(target * 5L);
            Double slotOrientationCost = orientInfo.slotOrientationCost != null ? orientInfo.slotOrientationCost : 0.0;
            Double slotOrientationConvert = orientInfo.slotOrientationConvert != null ? orientInfo.slotOrientationConvert : 0.0;
            Double slotOrientationConfidence = slotOrientationCost / (double)(target * 5L);
            Double slotOrientationCostConvert = slotOrientationCost != 0.0 && slotOrientationConvert != 0.0 ? slotOrientationCost / slotOrientationConvert : (double)target.longValue();
            Double slotOrientationCostConvertBias = slotOrientationConvert != 0.0 ? slotOrientationCostConvert / (double)target.longValue() : slotOrientationCost / (double)target.longValue();
            Double slotAdvertCost = orientInfo.slotAdvertCost != null ? orientInfo.slotAdvertCost : 0.0;
            Double slotAdvertConvert = orientInfo.slotAdvertConvert != null ? orientInfo.slotAdvertConvert : 0.0;
            Double slotAdvertConfidence = slotAdvertCost / (double)(target * 5L);
            Double slotAdvertCostConvert = slotAdvertCost != 0.0 && slotAdvertConvert != 0.0 ? slotAdvertCost / slotAdvertConvert : (double)target.longValue();
            Double slotAdvertCostConvertBias = slotAdvertConvert != 0.0 ? slotAdvertCostConvert / (double)target.longValue() : slotAdvertCost / (double)target.longValue();
            Double appOrientationCost = orientInfo.appOrientationCost != null ? orientInfo.appOrientationCost : 0.0;
            Double appOrientationConvert = orientInfo.appOrientationConvert != null ? orientInfo.appOrientationConvert : 0.0;
            Double appOrientationConfidence = appOrientationCost / (double)(target * 5L);
            Double appOrientationCostConvert = appOrientationCost != 0.0 && appOrientationConvert != 0.0 ? appOrientationCost / appOrientationConvert : (double)target.longValue();
            Double appOrientationCostConvertBias = appOrientationConvert != 0.0 ? appOrientationCostConvert / (double)target.longValue() : appOrientationCost / (double)target.longValue();
            Double appOrientCvrDay = orientInfo.appOrientCvrDay != null ? orientInfo.appOrientCvrDay : 0.0;
            Random r = new Random();
            Double x = r.nextDouble();
            double p_convert_cost = 0.0;
            double biasRatio = 0.0;
            double biasThreshold = 0.0;
            double orientRatio = 0.0;
            double targetRatio = 0.0;
            double corrCoefRatio = 1.0;
            double corrCoefThreshod0 = 1.0;
            double corrCoefThreshod1 = 1.0;
            double startRatio = orientCostG7d < (double)(5L * target) ? (Double)recommendParamsMap.get("startFactor") : 1.0;
            Double blackRealse = 1.0;
            Double reorient = 1.0;
            Double orientRatioWeight = 1.0;
            if (orientInfo.helpMeasureResult != null && orientInfo.helpMeasureResult.isExpand != null && orientInfo.helpMeasureResult.isExpand.booleanValue()) {
                blackRealse = orientInfo.helpMeasureResult.isBlackRealse;
                reorient = orientInfo.helpMeasureResult.isReorient;
                orientRatioWeight = orientInfo.helpMeasureResult.orientRatioWeight;
            }
            if (!"".equals(feedBackLabel = FeedBack.autoManageFeedBack(orientInfo, trusteeshipParams, blackRealse)) && Math.random() < 0.02) {
                logger.info("slot_blackset slotId:{} advertId:{} orientId:{} feedBackLabel:{}", new Object[]{slotId, orientInfo.advertId, orientInfo.orientId, feedBackLabel});
            }
            Boolean isFuse = ("fuse1".equals(feedBackLabel) || "fuse2".equals(feedBackLabel)) & orientInfo.fuseWhite == false;
            if ("fuse1".equals(feedBackLabel)) {
                fuseSet1.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
            } else if ("fuse2".equals(feedBackLabel)) {
                fuseSet2.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
            }
            if (isFuse.booleanValue()) {
                logger.info("fuseInfo fuseOrientInfo:{}", (Object)orientInfo);
            }
            Double cost20d = orientInfo.cost20d;
            Double cost7d = orientInfo.cost7d;
            Double confidence = cost20d != null ? Double.valueOf(cost20d / (double)(5L * target)) : null;
            Double confidenceCF = cost7d != null ? Double.valueOf(cost7d / (double)(5L * target)) : null;
            Double cvr = (Double)candidateMap.get("statCvr" + cvrType);
            Double bias = (Double)candidateMap.get("cvrBias" + cvrType);
            Double correlationCoefficient = orientInfo.correlationCoefficient;
            List<TagInfo> TagAd = orientInfo.tagRtPerformance != null ? orientInfo.tagRtPerformance.get("advert") : null;
            List<TagInfo> TagPkg = orientInfo.tagRtPerformance != null ? orientInfo.tagRtPerformance.get("orientation") : null;
            List<TagInfo> TagAppAd = orientInfo.tagRtPerformance != null ? orientInfo.tagRtPerformance.get("appAdvert") : null;
            List<TagInfo> TagAppPkg = orientInfo.tagRtPerformance != null ? orientInfo.tagRtPerformance.get("appOrientation") : null;
            Double statAdCtr = orientInfo.statAdCtr != null ? orientInfo.statAdCtr : 1.0;
            Double statAdCvr = orientInfo.statAdCvr != null ? orientInfo.statAdCvr : 1.0;
            Double statAdAppCvr = orientInfo.statAdAppCvr != null ? orientInfo.statAdAppCvr : 1.0;
            Double preCvr = orientInfo.preCvr != null ? orientInfo.preCvr : 0.0;
            String newTrade = orientInfo.newTrade != null ? orientInfo.newTrade : "";
            Integer SELECT_FLOW_TYPE = 1;
            String SELECT_AD_TRADE = "\u65b0\u95fb\u8d44\u8baf,\u5e94\u7528\u5206\u53d1,\u6e38\u620f,\u7406\u8d22,\u7535\u5546\u5e73\u53f0,\u89c6\u9891,\u8d37\u6b3e";
            String EXCLUDE_AD_TRADE = "JF,JF";
            Double LEVEL_1_CPA_BIAS = 1.1;
            Double LEVEL_2_CPA_BIAS = 1.25;
            Double MIN_CVR_THRESHOLD = 0.02;
            Double MIN_BCVR_THRESHOLD = 0.009;
            if (chargeType == 2) {
                Set<Integer> matchTypeSet;
                Set<Integer> matchTypeSet2;
                AdvertOrientInfo advertOrientInfo = new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId, new HashSet<Integer>());
                if (flowType > 0 && !EXCLUDE_AD_TRADE.contains(newTrade)) {
                    Set<Integer> matchTypeSet22 = advertOrientInfo.getMatchType();
                    if (orientCostConvertbias < LEVEL_1_CPA_BIAS) {
                        matchTypeSet22.add(10);
                        recommendListSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId, slotOrientationCostConvertBias, slotOrientationCost));
                    } else if (orientCostConvertbias < LEVEL_2_CPA_BIAS) {
                        double cvrBias = preCvr / statAdAppCvr;
                        if ((cvrType == 0 && preCvr > MIN_CVR_THRESHOLD || cvrType > 0 && preCvr > MIN_BCVR_THRESHOLD) && Math.random() < SlotRecommender.getTargetProb(cvrBias)) {
                            matchTypeSet22.add(11);
                            recommendListSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId, slotOrientationCostConvertBias, slotOrientationCost));
                        }
                    }
                }
                if (confidence != null && bias != null && !isFuse.booleanValue()) {
                    biasRatio = orientCostConvertbias != 0.0 ? (Double)recommendParamsMap.get("cpaBiasRatioFactor") / (orientCostConvertbias * orientCostConvertbias) : (Double)recommendParamsMap.get("cpaBiasRatioFactor");
                    orientRatio = orientCostConvertbias != 0.0 ? (Double)recommendParamsMap.get("cpaOrientRatioFactor") / (orientCostConvertbias * orientCostConvertbias * orientCostConvertbias) : (Double)recommendParamsMap.get("cpaOrientRatioFactor");
                    orientRatio = orientCostConvertbias > 1.7 ? 0.0 : orientRatio;
                    biasThreshold = Math.max(((Double)recommendParamsMap.get("cpaBiasThresholdFactor") * confidence + 1.0) * biasRatio * startRatio, 1.0);
                    if (importantAppAfee != null && !importantAppAfee.equals(target)) {
                        matchTypeSet2 = advertOrientInfo.getMatchType();
                        matchTypeSet2.add(0);
                    }
                    if (confidence != null && confidence > 0.0 && bias > 0.0 && bias <= biasThreshold * reorient) {
                        matchTypeSet2 = advertOrientInfo.getMatchType();
                        matchTypeSet2.add(1);
                        if (manageType == 3) {
                            recommendListSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId, slotOrientationCostConvertBias, slotOrientationCost));
                        }
                    }
                    if (confidence != null && confidence == 0.0 && x < orientRatio * orientRatioWeight) {
                        matchTypeSet2 = advertOrientInfo.getMatchType();
                        matchTypeSet2.add(2);
                        if (manageType == 3) {
                            recommendListSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId, slotOrientationCostConvertBias, slotOrientationCost));
                        }
                    }
                }
                if (confidenceCF != null && correlationCoefficient != null && !isFuse.booleanValue()) {
                    corrCoefRatio = orientCostConvertbias != 0.0 ? (Double)recommendParamsMap.get("cpaHisCorrCoeffRatioFactor") * (orientCostConvertbias * orientCostConvertbias * orientCostConvertbias) : (Double)recommendParamsMap.get("cpaHisCorrCoeffRatioFactor");
                    corrCoefThreshod0 = Math.max(Math.min(corrCoefRatio / ((Double)recommendParamsMap.get("cpaHisCorrCoeffThreshod") * Math.sqrt(confidenceCF)) / startRatio, 0.9), 0.01);
                    corrCoefThreshod1 = Math.max(Math.min(corrCoefRatio / (Double)recommendParamsMap.get("cpaNotHisCorrCoeffThreshod") / startRatio, 1.0), 0.05);
                    if (confidenceCF > 0.0 && correlationCoefficient > 0.0 && correlationCoefficient >= corrCoefThreshod0 / reorient) {
                        matchTypeSet2 = advertOrientInfo.getMatchType();
                        matchTypeSet2.add(3);
                        if (manageType == 3) {
                            recommendListSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId, slotOrientationCostConvertBias, slotOrientationCost));
                        }
                    }
                    if (confidenceCF == 0.0 && correlationCoefficient > 0.0 && correlationCoefficient >= corrCoefThreshod1 / orientRatioWeight) {
                        matchTypeSet2 = advertOrientInfo.getMatchType();
                        matchTypeSet2.add(4);
                        if (manageType == 3) {
                            recommendListSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId, slotOrientationCostConvertBias, slotOrientationCost));
                        }
                    }
                }
                if (TagAd != null && TagPkg != null) {
                    for (TagInfo tagAdInfo : TagAd) {
                        if (tagAdInfo.getTagType() == 1) {
                            if (tagAdInfo.curClkCnt <= 0L || tagAdInfo.curConvCnt <= 10L || !((double)tagAdInfo.curConvCnt.longValue() / (double)tagAdInfo.curClkCnt.longValue() > statAdCvr) || !((double)tagAdInfo.curCost.longValue() / (double)tagAdInfo.curConvCnt.longValue() < (double)target.longValue())) continue;
                            matchTypeSet = advertOrientInfo.getMatchType();
                            matchTypeSet.add(5);
                            if (!(Math.random() < 0.001)) continue;
                            logger.info("slotRecommend tagAdInfo:{}, statAdCvr {}", (Object)tagAdInfo, (Object)statAdCvr);
                            continue;
                        }
                        if (tagAdInfo.getTagType() != 0 || !(orientCostConvertbias < 1.2)) continue;
                        matchTypeSet = advertOrientInfo.getMatchType();
                        matchTypeSet.add(7);
                        if (!(Math.random() < 1.0E-4)) continue;
                        logger.info("slotRecommend tagAdInfo:{}, orientCostConvertbias: {}", (Object)tagAdInfo, (Object)orientCostConvertbias);
                    }
                    for (TagInfo tagPkgInfo : TagPkg) {
                        if (tagPkgInfo.getTagType() == 1) {
                            if (tagPkgInfo.curClkCnt <= 0L || tagPkgInfo.curConvCnt <= 5L || !((double)tagPkgInfo.curConvCnt.longValue() / (double)tagPkgInfo.curClkCnt.longValue() > statAdCvr) || !((double)tagPkgInfo.curCost.longValue() / (double)tagPkgInfo.curConvCnt.longValue() < (double)target.longValue())) continue;
                            matchTypeSet = advertOrientInfo.getMatchType();
                            matchTypeSet.add(5);
                            if (!(Math.random() < 0.001)) continue;
                            logger.info("slotRecommend tagPkgInfo:{}, statAdCvr {}", (Object)tagPkgInfo, (Object)statAdCvr);
                            continue;
                        }
                        if (tagPkgInfo.getTagType() != 0 || !(orientCostConvertbias < 1.2)) continue;
                        matchTypeSet = advertOrientInfo.getMatchType();
                        matchTypeSet.add(7);
                        if (!(Math.random() < 1.0E-4)) continue;
                        logger.info("slotRecommend tagPkgInfo:{}, orientCostConvertbias: {}", (Object)tagPkgInfo, (Object)orientCostConvertbias);
                    }
                }
                if (TagAppAd != null && TagAppPkg != null) {
                    for (TagInfo tagAppAdInfo : TagAppAd) {
                        if (tagAppAdInfo.getTagType() == 1) {
                            if (tagAppAdInfo.curClkCnt <= 0L || tagAppAdInfo.curConvCnt <= 5L || !((double)tagAppAdInfo.curConvCnt.longValue() / (double)tagAppAdInfo.curClkCnt.longValue() > statAdCvr) || !((double)tagAppAdInfo.curCost.longValue() / (double)tagAppAdInfo.curConvCnt.longValue() < (double)target.longValue())) continue;
                            matchTypeSet = advertOrientInfo.getMatchType();
                            matchTypeSet.add(6);
                            if (!(Math.random() < 0.001)) continue;
                            logger.info("slotRecommend tagAppAdInfo:{}, statAdCvr {}", (Object)tagAppAdInfo, (Object)statAdCvr);
                            continue;
                        }
                        if (tagAppAdInfo.getTagType() != 0 || !(orientCostConvertbias < 1.2)) continue;
                        matchTypeSet = advertOrientInfo.getMatchType();
                        matchTypeSet.add(8);
                        if (!(Math.random() < 1.0E-4)) continue;
                        logger.info("slotRecommend tagAppAdInfo:{}, orientCostConvertbias {}", (Object)tagAppAdInfo, (Object)orientCostConvertbias);
                    }
                    for (TagInfo tagAppPkgInfo : TagAppPkg) {
                        if (tagAppPkgInfo.getTagType() == 1) {
                            if (tagAppPkgInfo.curClkCnt <= 0L || tagAppPkgInfo.curConvCnt <= 2L || !((double)tagAppPkgInfo.curConvCnt.longValue() / (double)tagAppPkgInfo.curClkCnt.longValue() > statAdCvr) || !((double)tagAppPkgInfo.curCost.longValue() / (double)tagAppPkgInfo.curConvCnt.longValue() < (double)target.longValue())) continue;
                            matchTypeSet = advertOrientInfo.getMatchType();
                            matchTypeSet.add(6);
                            if (!(Math.random() < 0.001)) continue;
                            logger.info("slotRecommend tagAppPkgInfo:{}, statAdCvr {}", (Object)tagAppPkgInfo, (Object)statAdCvr);
                            continue;
                        }
                        if (tagAppPkgInfo.getTagType() != 0 || !(orientCostConvertbias < 1.2)) continue;
                        matchTypeSet = advertOrientInfo.getMatchType();
                        matchTypeSet.add(8);
                        if (!(Math.random() < 1.0E-4)) continue;
                        logger.info("slotRecommend tagAppPkgInfo:{}, orientCostConvertbias {}", (Object)tagAppPkgInfo, (Object)orientCostConvertbias);
                    }
                }
                if (advertOrientInfo.getMatchType().size() > 0) {
                    orientSet.add(advertOrientInfo);
                }
            } else if (chargeType == 1 && confidence != null && cvr != null && !isFuse.booleanValue()) {
                recommendParamsMap.put("startFactor", releaseTarget1slotRecommendParams.getStartFactor());
                recommendParamsMap.put("cpcTargetRatioFactor", releaseTarget1slotRecommendParams.getCpcTargetRatioFactor());
                recommendParamsMap.put("cpcOrientRatioFactor", releaseTarget1slotRecommendParams.getCpcOrientRatioFactor());
                recommendParamsMap.put("cpcBiasThresholdFactor", releaseTarget1slotRecommendParams.getCpcBiasThresholdFactor());
                targetRatio = orientCostConvertbias != 0.0 ? (Double)recommendParamsMap.get("cpcTargetRatioFactor") / (orientCostConvertbias * orientCostConvertbias) : (Double)recommendParamsMap.get("cpcTargetRatioFactor");
                orientRatio = orientCostConvertbias != 0.0 ? (Double)recommendParamsMap.get("cpcOrientRatioFactor") / (orientCostConvertbias * orientCostConvertbias * orientCostConvertbias) : (Double)recommendParamsMap.get("cpcOrientRatioFactor");
                orientRatio = orientCostConvertbias > 1.5 ? 0.0 : orientRatio;
                biasThreshold = Math.max(((Double)recommendParamsMap.get("cpcBiasThresholdFactor") * confidence + 1.0) * targetRatio * startRatio, 1.0);
                double d = p_convert_cost = cvr != 0.0 ? (double)fee.longValue() / cvr : 1000000.0;
                if (confidence > 0.0 && p_convert_cost <= biasThreshold * (double)target.longValue()) {
                    orientSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
                    if (manageType == 3) {
                        recommendListSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId, slotOrientationCostConvertBias, slotOrientationCost));
                    }
                }
                if (confidence == 0.0 && p_convert_cost < biasThreshold * (double)target.longValue() && x < orientRatio) {
                    orientSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
                    if (manageType == 3) {
                        recommendListSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId, slotOrientationCostConvertBias, slotOrientationCost));
                    }
                }
            }
            if ("w".equals(feedBackLabel)) {
                orientSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
                if (manageType == 3) {
                    recommendListSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId, appOrientationCostConvertBias, appOrientationCost));
                }
            }
            if (!"b".equals(feedBackLabel)) continue;
            orientSet.remove(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
            if (manageType != 2 || !(appOrientationConfidence > 1.0) || !(appOrientationCostConvertBias > 2.0)) continue;
            shieldListSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId, appOrientationCostConvertBias, appOrientationCost));
        }
        HashSet<AdvertOrientInfo> orientPackageList = new HashSet<AdvertOrientInfo>();
        for (OrientInfo orientInfo : orientlist) {
            orientPackageList.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
        }
        orientPackageList.removeAll(orientSet);
        orientPackageList.removeAll(shieldListSet);
        HashMap<ResultType, Collection<AdvertOrientInfo>> hashMap = new HashMap<ResultType, Collection<AdvertOrientInfo>>();
        hashMap.put(ResultType.ONTARGET, orientSet);
        hashMap.put(ResultType.GIVEUP, orientPackageList);
        hashMap.put(ResultType.FUSE1, fuseSet1);
        hashMap.put(ResultType.FUSE2, fuseSet2);
        hashMap.put(ResultType.ORIENT, recommendListSet);
        hashMap.put(ResultType.SHIELD, shieldListSet);
        if (Math.random() < 0.002) {
            logger.info("ResultType ResultType:{} slotId:{}", hashMap, (Object)slotId);
        }
        return hashMap;
    }

    public static double getTargetProb(double bias) {
        double prob = 0.0;
        if (bias > 0.3 && bias <= 1.0) {
            prob = 0.7;
        } else if (bias > 1.0 && bias < 1.3) {
            prob = 2.8 - 2.0 * bias;
        } else if (bias >= 1.3 && bias < 2.0) {
            prob = Math.pow(0.2, bias);
        }
        return prob;
    }
}

