/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.util;

import java.util.BitSet;

public class BloomFilter {
    private static final int BIT_SIZE = 0x20000000;
    private static final int[] seeds = new int[]{3, 5, 7, 11, 13, 31, 37, 61};
    private BitSet bits = new BitSet(0x20000000);
    private Hash[] func = new Hash[seeds.length];

    public BloomFilter() {
        for (int i = 0; i < seeds.length; ++i) {
            this.func[i] = new Hash(0x20000000, seeds[i]);
        }
    }

    public void addValue(String value) {
        if (value != null) {
            for (Hash f : this.func) {
                this.bits.set(f.hash(value), true);
            }
        }
    }

    public boolean contains(String value) {
        if (value == null) {
            return false;
        }
        boolean ret = true;
        for (Hash f : this.func) {
            ret = ret && this.bits.get(f.hash(value));
        }
        return ret;
    }

    public static class Hash {
        private int size;
        private int seed;

        public Hash(int cap, int seed) {
            this.size = cap;
            this.seed = seed;
        }

        public int hash(String value) {
            int result = 0;
            int len = value.length();
            for (int i = 0; i < len; ++i) {
                result = this.seed * result + value.charAt(i);
            }
            return this.size - 1 & result;
        }
    }
}

