/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.roipid;

import cn.com.duiba.nezha.alg.common.model.roipid.PIDControlInfo;
import cn.com.duiba.nezha.alg.common.model.roipid.StatInfo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoiPidRectify {
    private static final Logger logger = LoggerFactory.getLogger(RoiPidRectify.class);

    public static List<StatInfo> getPriceFactorRectify(PIDControlInfo pidControlInfo, List<StatInfo> infos, double orientTargetCpa, double budget, int mode) {
        if (AssertUtil.isAnyEmpty(infos, pidControlInfo)) {
            return infos;
        }
        ArrayList<StatInfo> result = new ArrayList<StatInfo>();
        double costDay = pidControlInfo.costDay.longValue();
        double convertDay = pidControlInfo.convertDay.longValue();
        double targetCpa = pidControlInfo.targetCpa;
        double actualCpaDay = convertDay > 0.0 ? costDay / convertDay : costDay;
        double biasDay = targetCpa > 0.0 ? actualCpaDay / targetCpa : 1.0;
        for (StatInfo info : infos) {
            double actual;
            info.factor1 = info.factor;
            double d = actual = info.sumConv > 0.0 ? info.sumFee / info.sumConv : orientTargetCpa;
            if (info.id.contains("DEFAULT")) {
                double factor;
                double bias;
                double d2 = bias = orientTargetCpa > 0.0 ? actual / orientTargetCpa : 1.0;
                if ((bias <= 1.1 || biasDay <= 1.1) && info.factor < 1.0) {
                    info.factor = factor = Math.max(1.0, Math.min(1.1, info.factor * 1.1));
                }
                if (info.factor < 0.8 / bias) {
                    info.factor = factor = info.factor * 1.1;
                }
            }
            if (info.id.contains("APP") || info.id.contains("SLOT")) {
                double factor;
                double appbias;
                double appTargetCpa = info.appTargetCpa;
                double d3 = appbias = appTargetCpa > 0.0 ? actual / appTargetCpa : 1.0;
                if (appbias <= 1.1 && info.factor < 1.0) {
                    info.factor = factor = Math.min(1.1, info.factor * 1.1);
                }
                if (appbias <= 0.9 && info.factor < 1.5) {
                    info.factor = factor = info.factor * 1.05;
                }
            }
            result.add(info);
        }
        return result;
    }

    public static void main(String[] args) {
        RoiPidRectify re = new RoiPidRectify();
        String str = "{\"convertDay\":100,\"convertHour\":2,\"convertLastHour\":3,\"costDay\":14190,\"costHour\":2,\"costLastHour\":3,\"factor\":0.6,\"lastFactorExplorationDo\":{\"fa\nctorExploreMap\":{\"0\":0.999999,\"1\":1.0,\"2\":1.0},\"factorFlowRateMap\":{\"0\":0.0,\"1\":0.101,\"2\":0.901}},\"targetCpa\":10000.0}";
        JSONObject object = JSON.parseObject((String)str);
        PIDControlInfo pidControlDoInfo = (PIDControlInfo)JSONObject.parseObject((String)str, PIDControlInfo.class);
        String str1 = "[{\"click7d\":0.0,\"conv7d\":0.0,\"factor\":0.85,\"fee7d\":0.0,\"id\":\"DEFAULT\",\"lastSumConv\":0.0,\"lastSumFee\":0.0,\"parentFactor\":0.9999999999999998,\"sumClick\":207.0,\"sumConv\":22.0,\"sumFee\":21000.0},{\"click7d\":0.0,\"conv7d\":0.0,\"factor\":0.9,\"fee7d\":0.0,\"id\":\"APP\",\"lastSumConv\":0.0,\"lastSumFee\":0.0,\"parentFactor\":0.9999999999999998,\"sumClick\":200.0,\"sumConv\":22.0,\"sumFee\":10000.0,\"appTargetCpa\":500.0},{\"click7d\":0.0,\"conv7d\":0.0,\"factor\":1.0,\"fee7d\":0.0,\"id\":\"TAG_02.12.0001-0_68657\",\"lastSumConv\":0.0,\"lastSumFee\":0.0,\"parentFactor\":0.9999999999999998,\"sumClick\":207.0,\"sumConv\":22.0,\"sumFee\":13940.0}]";
        List statInfos = JSONObject.parseArray((String)str1, StatInfo.class);
        List<StatInfo> ret = RoiPidRectify.getPriceFactorRectify(pidControlDoInfo, statInfos, 1000.0, 0.0, 4);
        for (StatInfo f : ret) {
            System.err.println(JSON.toJSONString((Object)f));
        }
    }
}

