/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.activityrecommend;

import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityCvrInfo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityInfoAd;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityInfoData;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityMatchInfo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityRankInfo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityVal;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.BetaDistribution;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.NormInfo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.RankResult;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.SelectPoolInfo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.SimilarCostActivitiesInfo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.WilsonInterval;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityRec45 {
    private static final Logger logger = LoggerFactory.getLogger(ActivityRec45.class);
    public static Comparator<MatchInfo> iComparator = new Comparator<MatchInfo>(){

        @Override
        public int compare(MatchInfo c1, MatchInfo c2) {
            return c2.score - c1.score >= 0.0 ? 1 : -1;
        }
    };
    public static Comparator<MatchInfo> normComparator = new Comparator<MatchInfo>(){

        @Override
        public int compare(MatchInfo m1, MatchInfo m2) {
            return m2.act.score - m1.act.score >= 0.0 ? 1 : -1;
        }
    };

    public static List<ActivityMatchInfo> match(List<ActivityInfoData> actData, List<ActivityInfoAd> actAds, List<NormInfo> exActs) {
        int i;
        int topn = Constant.RECALL_SUC_TOPN + Constant.RECALL_GUC_TOPN + Constant.RECALL_GUCK_TOPN + Constant.RECALL_SUCK_TOPN + Constant.RECALL_GCVR_TOPN + Constant.RECALL_SCVR_TOPN + Constant.RECALL_CVR_TOPN + Constant.RECALL_CVR_TOPN + Constant.RECALL_UR_TOPN;
        int exTopN = Constant.EXCELLENT_TOPN;
        ArrayList<ActivityMatchInfo> result = new ArrayList<ActivityMatchInfo>();
        ArrayList<ActivityMatchInfo> actModel = new ArrayList<ActivityMatchInfo>();
        PriorityQueue<MatchInfo> gCandisUC = new PriorityQueue<MatchInfo>(actData.size(), iComparator);
        PriorityQueue<MatchInfo> sCandisUC = new PriorityQueue<MatchInfo>(actData.size(), iComparator);
        PriorityQueue<MatchInfo> gCandisUCK = new PriorityQueue<MatchInfo>(actData.size(), iComparator);
        PriorityQueue<MatchInfo> sCandisUCK = new PriorityQueue<MatchInfo>(actData.size(), iComparator);
        PriorityQueue<MatchInfo> gCandisCVR = new PriorityQueue<MatchInfo>(actData.size(), iComparator);
        PriorityQueue<MatchInfo> sCandisCVR = new PriorityQueue<MatchInfo>(actData.size(), iComparator);
        PriorityQueue<MatchInfo> candisCVR = new PriorityQueue<MatchInfo>(actData.size(), iComparator);
        PriorityQueue<MatchInfo> candisUR = new PriorityQueue<MatchInfo>(actData.size(), iComparator);
        PriorityQueue<MatchInfo> normCandis = new PriorityQueue<MatchInfo>(exTopN, normComparator);
        HashMap<Long, ActivityInfoAd> adHashMap = new HashMap<Long, ActivityInfoAd>();
        double form_click_cnt = 0.0;
        double notForm_click_cnt = 0.0;
        double click_cnt = 0.0;
        double form_effect_cnt = 0.0;
        double notForm_effect_cnt = 0.0;
        double effect_cnt = 0.0;
        for (ActivityInfoAd ad : actAds) {
            adHashMap.put(ad.getActivityId(), ad);
            click_cnt += (form_click_cnt += ad.getSumClickForms()) + (notForm_click_cnt += ad.getSumClickNotForms());
            effect_cnt += (form_effect_cnt += ad.getSumEffectPVForms()) + (notForm_effect_cnt += ad.getSumEffectPVNotForms());
        }
        double cvr = click_cnt > 0.0 ? effect_cnt / click_cnt : 0.0;
        double formCvrBias = form_effect_cnt < form_click_cnt ? WilsonInterval.wilsonCalc((double)form_effect_cnt, (double)form_click_cnt).lowerBound : WilsonInterval.wilsonCalc((double)form_click_cnt, (double)form_click_cnt).lowerBound;
        double notFormCvrBias = notForm_effect_cnt < notForm_click_cnt ? WilsonInterval.wilsonCalc((double)notForm_effect_cnt, (double)notForm_click_cnt).lowerBound : WilsonInterval.wilsonCalc((double)notForm_click_cnt, (double)notForm_click_cnt).lowerBound;
        double cvrBias = formCvrBias + 0.2 * notFormCvrBias;
        double requests = 0.0;
        double costs = 0.0;
        double clicks = 0.0;
        for (ActivityInfoData act2 : actData) {
            requests += act2.getRequest().slotVal;
            costs += act2.getCost().slotVal;
            clicks += act2.getClick().slotVal;
        }
        double uc = costs / requests;
        double uck = clicks / requests;
        HashMap<Long, NormInfo> exHashMap = new HashMap<Long, NormInfo>();
        if (exActs != null) {
            for (NormInfo exAct : exActs) {
                exHashMap.put(exAct.getActivityId(), exAct);
            }
        }
        HashSet<Long> actIds = new HashSet<Long>(exHashMap.keySet());
        HashSet hisActIds = new HashSet(actData.stream().map(ActivityInfoData::getActivityId).collect(Collectors.toSet()));
        HashSet<Long> idset = new HashSet<Long>();
        for (ActivityInfoData activityInfoData : actData) {
            try {
                ActivityMatchInfo actM = ActivityRec45.fillData(activityInfoData, actIds, exHashMap);
                actM.setUvCost(uc);
                actM.setUvClick(uck);
                actM.setCvr(cvr);
                actM.setCvrBias(cvrBias);
                actModel.add(actM);
                if (actM.hisRequest.globalVal < 100.0) {
                    if (System.currentTimeMillis() - activityInfoData.createTime < 259200000L) {
                        if (Math.random() < 1.0E-4) {
                            result.add(actM);
                            --topn;
                            idset.add(actM.activityId);
                        }
                    } else if (actData.size() > topn && Math.random() < 1.0E-5) {
                        result.add(actM);
                        --topn;
                        idset.add(actM.activityId);
                    }
                } else if (actM.hisRequest.globalVal < 500.0 && actM.hisEffect.globalVal < 5.0 && Math.random() < 0.001) {
                    result.add(actM);
                    --topn;
                    idset.add(actM.activityId);
                }
                double wuc = ActivityRec45.getMatchScore(actM.hisCost, actM.hisRequest, 100.0, 1000.0, true);
                double wuck = ActivityRec45.getMatchScore(actM.hisClick, actM.hisRequest, 100.0, 1000.0, false);
                double wcvr = ActivityRec45.getMatchScore(actM.hisEffect, actM.hisClick, 100.0, 400.0, false);
                double changeScore = 0.0;
                ActivityCvrInfo activityChangeValNew = new ActivityCvrInfo();
                if (adHashMap.containsKey(activityInfoData.activityId)) {
                    activityChangeValNew = ActivityRec45.calChangeScoreMergeAbsolute(adHashMap.getOrDefault(activityInfoData.activityId, new ActivityInfoAd()), cvrBias);
                    changeScore = activityChangeValNew.changeScoreMerge;
                }
                actM.changeScore = changeScore;
                actM.activityChangeVal = activityChangeValNew;
                if (actM.isExcellent) {
                    MatchInfo emi = new MatchInfo();
                    emi.act = actM;
                    emi.score = actM.score;
                    normCandis.add(emi);
                    continue;
                }
                MatchInfo wucmi = new MatchInfo();
                wucmi.act = actM;
                wucmi.score = wuc;
                gCandisUC.add(wucmi);
                MatchInfo wuckmi = new MatchInfo();
                wuckmi.act = actM;
                wuckmi.score = wuck;
                gCandisUCK.add(wuckmi);
                MatchInfo wcvrmi = new MatchInfo();
                wcvrmi.act = actM;
                wcvrmi.score = wcvr;
                gCandisCVR.add(wcvrmi);
                MatchInfo rcvrmi = new MatchInfo();
                rcvrmi.act = actM;
                rcvrmi.score = actM.hisEffect.slotVal / actM.hisClick.slotVal;
                candisCVR.add(rcvrmi);
                MatchInfo urmi = new MatchInfo();
                urmi.act = actM;
                urmi.score = actM.hisEffect.slotVal / actM.hisRequest.slotVal;
                candisUR.add(urmi);
                if (actM.hisRequest.slotVal > 99.0 || actM.hisClick.slotVal > 5.0) {
                    MatchInfo ucmi = new MatchInfo();
                    ucmi.act = actM;
                    ucmi.score = actM.hisCost.slotVal / (100.0 * actM.hisRequest.slotVal);
                    sCandisUC.add(ucmi);
                    MatchInfo uckmi = new MatchInfo();
                    uckmi.act = actM;
                    uckmi.score = actM.hisClick.slotVal / actM.hisRequest.slotVal;
                    sCandisUCK.add(uckmi);
                }
                if (!(actM.hisClick.slotVal > 99.0) && !(actM.hisEffect.slotVal > 5.0)) continue;
                MatchInfo cvrmi = new MatchInfo();
                cvrmi.act = actM;
                cvrmi.score = actM.hisEffect.slotVal / actM.hisClick.slotVal;
                sCandisCVR.add(cvrmi);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        for (i = 0; i < Constant.RECALL_SUC_TOPN && i < sCandisUC.size(); ++i) {
            ActivityMatchInfo activityMatchInfo = ((MatchInfo)sCandisUC.poll()).act;
            if (idset.contains(activityMatchInfo.activityId)) continue;
            result.add(activityMatchInfo);
            idset.add(activityMatchInfo.activityId);
            --topn;
        }
        for (i = 0; i < Constant.RECALL_GUC_TOPN && i < gCandisUC.size(); ++i) {
            ActivityMatchInfo activityMatchInfo = ((MatchInfo)gCandisUC.poll()).act;
            if (idset.contains(activityMatchInfo.activityId)) continue;
            result.add(activityMatchInfo);
            idset.add(activityMatchInfo.activityId);
            --topn;
        }
        for (i = 0; i < Constant.RECALL_SUCK_TOPN && i < sCandisUCK.size(); ++i) {
            ActivityMatchInfo activityMatchInfo = ((MatchInfo)sCandisUCK.poll()).act;
            if (idset.contains(activityMatchInfo.activityId)) continue;
            result.add(activityMatchInfo);
            idset.add(activityMatchInfo.activityId);
            --topn;
        }
        for (i = 0; i < Constant.RECALL_GUCK_TOPN && i < gCandisUCK.size(); ++i) {
            ActivityMatchInfo activityMatchInfo = ((MatchInfo)gCandisUCK.poll()).act;
            if (idset.contains(activityMatchInfo.activityId)) continue;
            result.add(activityMatchInfo);
            idset.add(activityMatchInfo.activityId);
            --topn;
        }
        for (i = 0; i < Constant.RECALL_SCVR_TOPN && i < sCandisCVR.size(); ++i) {
            ActivityMatchInfo activityMatchInfo = ((MatchInfo)sCandisCVR.poll()).act;
            if (idset.contains(activityMatchInfo.activityId)) continue;
            result.add(activityMatchInfo);
            idset.add(activityMatchInfo.activityId);
            --topn;
        }
        for (i = 0; i < Constant.RECALL_GCVR_TOPN && i < gCandisCVR.size(); ++i) {
            ActivityMatchInfo activityMatchInfo = ((MatchInfo)gCandisCVR.poll()).act;
            if (idset.contains(activityMatchInfo.activityId)) continue;
            result.add(activityMatchInfo);
            idset.add(activityMatchInfo.activityId);
            --topn;
        }
        for (i = 0; i < Constant.RECALL_CVR_TOPN && i < candisCVR.size(); ++i) {
            ActivityMatchInfo activityMatchInfo = ((MatchInfo)candisCVR.poll()).act;
            if (idset.contains(activityMatchInfo.activityId)) continue;
            result.add(activityMatchInfo);
            idset.add(activityMatchInfo.activityId);
            --topn;
        }
        for (i = 0; i < Constant.RECALL_UR_TOPN && i < candisUR.size(); ++i) {
            ActivityMatchInfo activityMatchInfo = ((MatchInfo)candisUR.poll()).act;
            if (idset.contains(activityMatchInfo.activityId)) continue;
            result.add(activityMatchInfo);
            idset.add(activityMatchInfo.activityId);
            --topn;
        }
        if (exActs != null) {
            for (NormInfo normInfo : exActs) {
                if (hisActIds.contains(normInfo.getActivityId())) continue;
                MatchInfo mci = new MatchInfo();
                ActivityMatchInfo aim = new ActivityMatchInfo();
                aim.setAppId(actData.get(0).getAppId());
                aim.setSlotId(actData.get(0).getSlotId());
                aim.setActivityId(normInfo.getActivityId());
                aim.setnPvClick(normInfo.getnPvClick());
                aim.setnPvCost(normInfo.getnPvCost());
                aim.setnCvrForm(normInfo.getnFormCvr());
                aim.setnCvrNotForm(normInfo.getnNotFormCvr());
                aim.setnCvr(normInfo.getnCvr());
                aim.setScore(normInfo.getScore());
                aim.setExcellent(true);
                mci.score = normInfo.getScore();
                mci.act = aim;
                normCandis.add(mci);
            }
            for (int i2 = 0; i2 < exTopN && i2 < normCandis.size(); ++i2) {
                MatchInfo matchInfo = (MatchInfo)normCandis.poll();
                if (idset.contains(matchInfo.act.activityId)) continue;
                result.add(matchInfo.act);
                idset.add(matchInfo.act.activityId);
                --topn;
            }
        }
        return result;
    }

    private static double getMatchScore(ActivityVal num, ActivityVal den, Double thr1, Double thr2, Boolean isUC) {
        double slotScore = WilsonInterval.wilsonCalc((double)num.slotVal, (double)den.slotVal).lowerBound;
        double globalScore = WilsonInterval.wilsonCalc((double)num.globalVal, (double)den.globalVal).lowerBound;
        double appScore = WilsonInterval.wilsonCalc((double)num.appVal, (double)den.appVal).lowerBound;
        if (isUC.booleanValue()) {
            slotScore = WilsonInterval.wilsonCalc((double)(num.slotVal / 100.0), (double)den.slotVal).lowerBound;
            globalScore = WilsonInterval.wilsonCalc((double)(num.globalVal / 100.0), (double)den.globalVal).lowerBound;
            appScore = WilsonInterval.wilsonCalc((double)(num.appVal / 100.0), (double)den.appVal).lowerBound;
        }
        double sconfidence = Math.min(den.slotVal / thr1, 1.0);
        double aconfidence = Math.min(den.appVal / thr1, 1.0);
        double gconfidence = Math.min(den.globalVal / thr2, 1.0);
        double matchscore = sconfidence * slotScore + (1.0 - sconfidence) * aconfidence * appScore * 0.9 + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);
        return matchscore;
    }

    public static RankResult select(List<ActivityRankInfo> actModel, List<ActivityMatchInfo> actData) {
        RankResult rankResult = new RankResult();
        HashMap<Long, ActivityMatchInfo> maps = new HashMap<Long, ActivityMatchInfo>();
        for (ActivityMatchInfo ami : actData) {
            maps.put(ami.activityId, ami);
        }
        if (actModel.size() == 0 || actData.size() == 0) {
            return null;
        }
        if (actModel.size() != actData.size()) {
            rankResult.activityModel = actModel.get(0);
            rankResult.similarCostActivitiesInfo = null;
            return rankResult;
        }
        List<ActivityRankInfo> actModelCopy = actModel.stream().sorted(Comparator.comparing(ActivityRankInfo::getActivityId).reversed()).collect(Collectors.toList());
        List<ActivityMatchInfo> actDataCopy = actData.stream().sorted(Comparator.comparing(ActivityMatchInfo::getActivityId).reversed()).collect(Collectors.toList());
        for (int i = 0; i < actModelCopy.size(); ++i) {
            long activityIdMode = ((ActivityRankInfo)actModelCopy.get((int)i)).activityId;
            long activityIdData = ((ActivityMatchInfo)actDataCopy.get((int)i)).activityId;
            if (activityIdMode == activityIdData) continue;
            rankResult.activityModel = actModel.get(0);
            rankResult.similarCostActivitiesInfo = null;
            return rankResult;
        }
        Map<String, Double> rates = ActivityRec45.getSlotAlgStatus(actData);
        ArrayList<SelectPoolInfo> sinfos = new ArrayList<SelectPoolInfo>();
        List<Object> candiList = new ArrayList();
        ActivityRankInfo result = new ActivityRankInfo();
        try {
            candiList = ActivityRec45.getSingleOptCandis(sinfos, actDataCopy, actModelCopy, Constant.ALG_UC, 100, 100);
            SelectInfoDetail selectInfoDetail = ActivityRec45.selectMultiOptInfo(sinfos, rates, actDataCopy, actModelCopy, result);
            int selectedActivityIndex = selectInfoDetail.index;
            result = (ActivityRankInfo)candiList.get(selectedActivityIndex);
            result.strategyType = selectInfoDetail.strategyType;
            double maxChangeScore = selectInfoDetail.maxChangeScore;
            ArrayList<SimilarCostActivitiesInfo> sameCostActivitiesInfoList = new ArrayList<SimilarCostActivitiesInfo>();
            ArrayList<SelectPoolInfo> sameCostcondi = selectInfoDetail.condi;
            if (sameCostcondi.size() > 0) {
                double selectedActivityReward = sameCostcondi.get(0).getReward();
                int sameCostActivityCnt = sameCostcondi.size();
                for (SelectPoolInfo selectInfo : sameCostcondi) {
                    SimilarCostActivitiesInfo sameCostActivitiesInfo = new SimilarCostActivitiesInfo();
                    Long activityId = selectInfo.getActivityId();
                    Long activityType = selectInfo.getActivityType();
                    int ifSelected = 0;
                    if (selectInfo.getIndex() == selectedActivityIndex) {
                        ifSelected = 1;
                    }
                    int index = selectInfo.getIndex();
                    double mabReward = selectInfo.getReward();
                    double changeScore = selectInfo.getChangeScore();
                    double hrpm = selectInfo.getHrpm();
                    double arpm = selectInfo.getArpm();
                    double grpm = selectInfo.getGrpm();
                    int subType = selectInfo.getSubType();
                    boolean excellent = selectInfo.isExcellent();
                    double diffReward = selectInfo.getReward() - selectedActivityReward;
                    double diffChangeScore = selectInfo.getChangeScore() - maxChangeScore;
                    sameCostActivitiesInfo.activityId = activityId;
                    sameCostActivitiesInfo.sameActivityCnt = sameCostActivityCnt;
                    sameCostActivitiesInfo.activityType = activityType;
                    sameCostActivitiesInfo.ifSelected = ifSelected;
                    sameCostActivitiesInfo.mabReward = mabReward;
                    sameCostActivitiesInfo.changeScore = changeScore;
                    sameCostActivitiesInfo.index = index;
                    sameCostActivitiesInfo.hrpm = hrpm;
                    sameCostActivitiesInfo.arpm = arpm;
                    sameCostActivitiesInfo.grpm = grpm;
                    sameCostActivitiesInfo.diffReward = diffReward;
                    sameCostActivitiesInfo.diffChangeScore = diffChangeScore;
                    sameCostActivitiesInfo.subType = subType;
                    sameCostActivitiesInfo.isExcellent = excellent;
                    sameCostActivitiesInfoList.add(sameCostActivitiesInfo);
                }
            }
            rankResult.activityModel = result;
            rankResult.similarCostActivitiesInfo = sameCostActivitiesInfoList;
            return rankResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            logger.error("error, size:{},candi:{},list:{},", new Object[]{0, JSON.toJSONString(candiList), JSON.toJSONString((Object)result)});
            return null;
        }
    }

    private static Map<String, Double> getSlotAlgStatus(List<ActivityMatchInfo> actData) {
        HashMap<String, Double> rates = new HashMap<String, Double>();
        double cnt = actData.stream().map(f -> f.getHisRequest().slotVal).reduce((a, b) -> a + b).get();
        double algUC = 0.0;
        double algUCK = 0.0;
        double algCVR = 0.0;
        for (ActivityMatchInfo ad : actData) {
            double algCnt = ad.getHisRequest().getAlgSlotVal();
            algUC += ad.hisRequest.slotVal > 0.0 ? ad.hisCost.slotVal / (100.0 * ad.hisRequest.slotVal) * algCnt / cnt : 0.0;
            algUCK += ad.hisRequest.slotVal > 0.0 ? ad.hisClick.slotVal / ad.hisRequest.slotVal * algCnt / cnt : 0.0;
            algCVR += ad.hisClick.slotVal > 0.0 ? ad.hisEffect.slotVal / ad.hisClick.slotVal * algCnt / cnt : 0.0;
        }
        double algUR = algUCK * algCVR;
        double baseUC = actData.get((int)0).uvCost / 100.0;
        double baseUCK = actData.get((int)0).uvClick;
        double baseCVR = actData.get((int)0).cvr;
        double baseUR = baseUCK * baseCVR;
        rates.put(Constant.ALG_UC, baseUC > 0.0 ? algUC / baseUC : 1.0);
        rates.put(Constant.ALG_UCK, baseUCK > 0.0 ? algUCK / baseUCK : 1.0);
        rates.put(Constant.ALG_CVR, baseCVR > 0.0 ? algCVR / baseCVR : 1.0);
        rates.put(Constant.ALG_UR, baseUR > 0.0 ? algUR / baseUR : 1.0);
        return rates;
    }

    private static List<ActivityRankInfo> getSingleOptCandis(List<SelectPoolInfo> sinfos, List<ActivityMatchInfo> actDataCopy, List<ActivityRankInfo> actModelCopy, String oppALg, int hthr, int athr) {
        ArrayList<Double> requests = new ArrayList<Double>();
        ArrayList<Double> rewards = new ArrayList<Double>();
        ArrayList<Double> counts = new ArrayList<Double>();
        ArrayList<Double> alphas = new ArrayList<Double>();
        ArrayList<Double> betas = new ArrayList<Double>();
        ArrayList<Double> changeScores = new ArrayList<Double>();
        ArrayList<Double> cvrBiass = new ArrayList<Double>();
        ArrayList<Long> activityIds = new ArrayList<Long>();
        ArrayList<Long> activityTypes = new ArrayList<Long>();
        ArrayList<Double> grpms = new ArrayList<Double>();
        ArrayList<Double> arpms = new ArrayList<Double>();
        ArrayList<Double> hrpms = new ArrayList<Double>();
        ArrayList<Double> uvClicks = new ArrayList<Double>();
        ArrayList<Double> cvrs = new ArrayList<Double>();
        ArrayList<Boolean> excellents = new ArrayList<Boolean>();
        ArrayList<Integer> subTypes = new ArrayList<Integer>();
        ArrayList<Double> scores = new ArrayList<Double>();
        ArrayList<ActivityRankInfo> candiList = new ArrayList<ActivityRankInfo>();
        HashMap<Long, RankInfo> mMap = new HashMap<Long, RankInfo>();
        double maxG = Constant.MIN_REWARD;
        double maxH = Constant.MIN_REWARD;
        double maxA = Constant.MIN_REWARD;
        double minG = 0.0;
        double minH = Constant.MIN_REWARD;
        double minA = Constant.MIN_REWARD;
        double oppH = 0.0;
        double oppA = 0.0;
        double oppG = 0.0;
        for (int i = 0; i < actDataCopy.size(); ++i) {
            RankInfo info;
            RankInfo rankInfo = info = mMap.containsKey(actDataCopy.get((int)i).activityId) ? (RankInfo)mMap.get(actDataCopy.get((int)i).activityId) : new RankInfo();
            if (oppALg.equals(Constant.ALG_UC)) {
                info.grpm = oppG = actDataCopy.get((int)i).hisRequest.globalVal > 0.0 ? actDataCopy.get((int)i).hisCost.globalVal / (100.0 * actDataCopy.get((int)i).hisRequest.globalVal) : 0.0;
                info.gexp = actDataCopy.get((int)i).hisRequest.globalVal;
                maxG = Math.max(oppG, maxG);
                info.arpm = oppA = actDataCopy.get((int)i).hisRequest.appVal > 0.0 ? actDataCopy.get((int)i).hisCost.appVal / (100.0 * actDataCopy.get((int)i).hisRequest.appVal) : 0.0;
                info.aexp = actDataCopy.get((int)i).hisRequest.appVal;
                if (info.aexp > (double)athr) {
                    maxA = Math.max(oppA, maxA);
                }
                minA = Math.min(oppA, minA);
                info.hrpm = oppH = actDataCopy.get((int)i).hisRequest.slotVal > 0.0 ? actDataCopy.get((int)i).hisCost.slotVal / (100.0 * actDataCopy.get((int)i).hisRequest.slotVal) : 0.0;
                info.hexp = actDataCopy.get((int)i).hisRequest.slotVal;
                if (info.hexp > (double)hthr) {
                    maxH = Math.max(oppH, maxH);
                }
                minH = Math.min(oppH, minH);
            } else if (oppALg.equals(Constant.ALG_UCK)) {
                info.grpm = oppG = actDataCopy.get((int)i).hisRequest.globalVal > 0.0 ? actDataCopy.get((int)i).hisClick.globalVal / actDataCopy.get((int)i).hisRequest.globalVal : 0.0;
                info.gexp = actDataCopy.get((int)i).hisRequest.globalVal;
                maxG = Math.max(oppG, maxG);
                info.arpm = oppA = actDataCopy.get((int)i).hisRequest.appVal > 0.0 ? actDataCopy.get((int)i).hisClick.appVal / actDataCopy.get((int)i).hisRequest.appVal : 0.0;
                info.aexp = actDataCopy.get((int)i).hisRequest.appVal;
                if (info.aexp > (double)athr) {
                    maxA = Math.max(oppA, maxA);
                }
                minA = Math.min(oppA, minA);
                info.hrpm = oppH = actDataCopy.get((int)i).hisRequest.slotVal > 0.0 ? actDataCopy.get((int)i).hisClick.slotVal / actDataCopy.get((int)i).hisRequest.slotVal : 0.0;
                info.hexp = actDataCopy.get((int)i).hisRequest.slotVal;
                if (info.hexp > (double)hthr) {
                    maxH = Math.max(oppH, maxH);
                }
                minH = Math.min(oppH, minH);
            } else if (oppALg.equals(Constant.ALG_CVR)) {
                info.grpm = oppG = actDataCopy.get((int)i).hisClick.globalVal > 0.0 ? actDataCopy.get((int)i).hisEffect.globalVal / actDataCopy.get((int)i).hisClick.globalVal : 0.0;
                info.gexp = actDataCopy.get((int)i).hisClick.globalVal;
                maxG = Math.max(oppG, maxG);
                info.arpm = oppA = actDataCopy.get((int)i).hisClick.appVal > 0.0 ? actDataCopy.get((int)i).hisEffect.appVal / actDataCopy.get((int)i).hisClick.appVal : 0.0;
                info.aexp = actDataCopy.get((int)i).hisClick.appVal;
                if (info.aexp > (double)athr) {
                    maxA = Math.max(oppA, maxA);
                }
                minA = Math.min(oppA, minA);
                info.hrpm = oppH = actDataCopy.get((int)i).hisClick.slotVal > 0.0 ? actDataCopy.get((int)i).hisEffect.slotVal / actDataCopy.get((int)i).hisClick.slotVal : 0.0;
                info.hexp = actDataCopy.get((int)i).hisRequest.slotVal;
                if (info.hexp > (double)hthr) {
                    maxH = Math.max(oppH, maxH);
                }
                minH = Math.min(oppH, minH);
            } else if (oppALg.equals(Constant.ALG_UR)) {
                info.grpm = oppG = actDataCopy.get((int)i).hisRequest.globalVal > 0.0 ? actDataCopy.get((int)i).hisEffect.globalVal / actDataCopy.get((int)i).hisRequest.globalVal : 0.0;
                info.gexp = actDataCopy.get((int)i).hisRequest.globalVal;
                maxG = Math.max(oppG, maxG);
                info.arpm = oppA = actDataCopy.get((int)i).hisRequest.appVal > 0.0 ? actDataCopy.get((int)i).hisEffect.appVal / actDataCopy.get((int)i).hisRequest.appVal : 0.0;
                info.aexp = actDataCopy.get((int)i).hisRequest.appVal;
                if (info.aexp > (double)athr) {
                    maxA = Math.max(oppA, maxA);
                }
                minA = Math.min(oppA, minA);
                info.hrpm = oppH = actDataCopy.get((int)i).hisRequest.slotVal > 0.0 ? actDataCopy.get((int)i).hisEffect.slotVal / actDataCopy.get((int)i).hisRequest.slotVal : 0.0;
                info.hexp = actDataCopy.get((int)i).hisRequest.slotVal;
                if (info.hexp > (double)hthr) {
                    maxH = Math.max(oppH, maxH);
                }
                minH = Math.min(oppH, minH);
            }
            mMap.put(actDataCopy.get((int)i).activityId, info);
        }
        double uc = actDataCopy.get((int)0).uvCost / 100.0;
        double uck = actDataCopy.get((int)0).uvClick;
        double ucvr = actDataCopy.get((int)0).cvr;
        for (int i = 0; i < actDataCopy.size(); ++i) {
            double sUvClick = actDataCopy.get((int)i).hisRequest.slotVal > 0.0 ? actDataCopy.get((int)i).hisClick.slotVal / actDataCopy.get((int)i).hisRequest.slotVal : 0.0;
            double sCvr = actDataCopy.get((int)i).hisClick.slotVal > 0.0 ? actDataCopy.get((int)i).hisEffect.slotVal / actDataCopy.get((int)i).hisClick.slotVal : 0.0;
            uvClicks.add(sUvClick);
            cvrs.add(sCvr);
            requests.add(actDataCopy.get((int)i).hisRequest.slotVal);
            double hrpm = ((RankInfo)mMap.get((Object)Long.valueOf((long)actDataCopy.get((int)i).activityId))).hrpm;
            double arpm = ((RankInfo)mMap.get((Object)Long.valueOf((long)actDataCopy.get((int)i).activityId))).arpm;
            double grpm = ((RankInfo)mMap.get((Object)Long.valueOf((long)actDataCopy.get((int)i).activityId))).grpm;
            hrpms.add(hrpm);
            arpms.add(arpm);
            grpms.add(grpm);
            excellents.add(actDataCopy.get((int)i).isExcellent);
            subTypes.add(actDataCopy.get((int)i).subType);
            scores.add(actDataCopy.get((int)i).score);
            cvrBiass.add(actDataCopy.get((int)i).cvrBias);
            double reward = Constant.MIN_REWARD;
            double sconfidence = Math.min(actDataCopy.get((int)i).hisRequest.slotVal / (double)hthr, 1.0);
            double aconfidence = Math.min(actDataCopy.get((int)i).hisRequest.appVal / (double)athr, 1.0);
            reward = sconfidence * ActivityRec45.normlize(hrpm * 0.8, maxH, 0.8) + (1.0 - sconfidence) * aconfidence * ActivityRec45.normlize(arpm * 0.7, maxA, 0.7) + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * ActivityRec45.normlize(grpm * 0.5, maxG, 0.6);
            reward *= reward;
            reward = Math.max(reward, 0.0);
            actModelCopy.get((int)i).reward = actModelCopy.get((int)i).reward * Constant.DECAY + reward;
            actModelCopy.get((int)i).count = actModelCopy.get((int)i).count * Constant.DECAY + 1.0;
            actModelCopy.get((int)i).alpha = 1.5 + actModelCopy.get((int)i).reward;
            actModelCopy.get((int)i).beta = 2.0 + (actModelCopy.get((int)i).count - actModelCopy.get((int)i).reward);
            rewards.add(actModelCopy.get((int)i).reward);
            counts.add(actModelCopy.get((int)i).count);
            alphas.add(actModelCopy.get((int)i).alpha);
            betas.add(actModelCopy.get((int)i).beta);
            activityIds.add(actModelCopy.get((int)i).activityId);
            activityTypes.add(actDataCopy.get((int)i).activityType);
            changeScores.add(actDataCopy.get((int)i).changeScore);
            candiList.add(actModelCopy.get(i));
        }
        mMap.clear();
        SelectInfoDetail selectInfoDetail = new SelectInfoDetail();
        ActivityRec45.getSinfos(sinfos, candiList.size(), alphas, betas, activityTypes, activityIds, changeScores, hrpms, arpms, grpms, requests, excellents, scores, subTypes, cvrBiass, uvClicks, cvrs, uc, uck, ucvr);
        return candiList;
    }

    public static ActivityCvrInfo calChangeScoreMergeAbsolute(ActivityInfoAd ad, double cvr) {
        double changeScoreBias = 0.05;
        double changeScoreMerge = 0.0;
        double changeScoreForms = 0.0;
        double changeScoreNotForms = 0.0;
        changeScoreForms = ad.sumClickForms > ad.sumEffectPVForms ? WilsonInterval.wilsonCalc((double)ad.sumEffectPVForms, (double)ad.sumClickForms).lowerBound.doubleValue() : WilsonInterval.wilsonCalc((double)ad.sumClickForms, (double)ad.sumClickForms).lowerBound.doubleValue();
        changeScoreNotForms = ad.sumClickNotForms > ad.sumEffectPVNotForms ? WilsonInterval.wilsonCalc((double)ad.sumEffectPVNotForms, (double)ad.sumClickNotForms).lowerBound.doubleValue() : WilsonInterval.wilsonCalc((double)ad.sumClickNotForms, (double)ad.sumClickNotForms).lowerBound.doubleValue();
        double wcvr = cvr > 0.0 ? changeScoreBias / cvr : 1.0;
        changeScoreMerge = changeScoreForms + changeScoreNotForms * 0.2 * Math.min(2.5, wcvr);
        ActivityCvrInfo activityChangeVal = new ActivityCvrInfo();
        activityChangeVal.sumClickForms = ad.sumClickForms;
        activityChangeVal.sumEffectPVForms = ad.sumEffectPVForms;
        activityChangeVal.sumClickNotForms = ad.sumClickNotForms;
        activityChangeVal.sumEffectPVNotForms = ad.sumEffectPVNotForms;
        activityChangeVal.changeScoreForms = changeScoreForms;
        activityChangeVal.changeScoreNotForms = changeScoreNotForms;
        activityChangeVal.changeScoreMerge = changeScoreMerge;
        return activityChangeVal;
    }

    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }

    public static double normlize(double val, double min, double max, double lower, double upper) {
        double norm = upper > lower && upper <= 1.0 && lower >= 0.0 ? (upper - lower) * (val - min) / (max - min) + lower : 0.6 * (val - min) / (max - min) + 0.2;
        return norm;
    }

    private static SelectInfoDetail selectMultiOptInfo(List<SelectPoolInfo> sinfos, Map<String, Double> rates, List<ActivityMatchInfo> actDataCopy, List<ActivityRankInfo> actModelCopy, ActivityRankInfo result) {
        SelectInfoDetail selectInfoDetail = new SelectInfoDetail();
        if (sinfos.size() > 0) {
            List chs = sinfos.stream().sorted(Comparator.comparing(SelectPoolInfo::getChangeScore).reversed()).collect(Collectors.toList());
            double maxChangeScore = ((SelectPoolInfo)chs.get(0)).getChangeScore();
            List<SelectPoolInfo> ranks = sinfos.stream().sorted(Comparator.comparing(SelectPoolInfo::getReward).reversed()).collect(Collectors.toList());
            List lowExRanks = ranks.stream().filter(e -> e.isExcellent() && e.getRequest() <= 500.0).collect(Collectors.toList());
            List lowHcRanks = ranks.subList(1, 3);
            List midExRanks = ranks.subList(3, 9).stream().filter(e -> e.isExcellent() && e.getRequest() > 500.0 && e.getRequest() <= 1000.0).collect(Collectors.toList());
            Random ra = new Random();
            if (Math.random() < 0.1 && lowExRanks.size() > 0) {
                selectInfoDetail.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                ((SelectPoolInfo)lowExRanks.get(ra.nextInt(lowExRanks.size()))).getIndex();
                selectInfoDetail.maxChangeScore = maxChangeScore;
                selectInfoDetail.strategyType = 1;
            } else if (Math.random() < 0.04 && lowHcRanks.size() > 0) {
                selectInfoDetail.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                ((SelectPoolInfo)lowHcRanks.get(ra.nextInt(lowHcRanks.size()))).getIndex();
                selectInfoDetail.maxChangeScore = maxChangeScore;
                selectInfoDetail.strategyType = 2;
            } else if (Math.random() < 0.06 && midExRanks.size() > 0) {
                selectInfoDetail.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                ((SelectPoolInfo)midExRanks.get(ra.nextInt(midExRanks.size()))).getIndex();
                selectInfoDetail.maxChangeScore = maxChangeScore;
                selectInfoDetail.strategyType = 3;
            } else {
                for (int i = 0; i < ranks.size(); ++i) {
                    double uc2;
                    int seffectCnt = (int)(((SelectPoolInfo)ranks.get(i)).getsUvClick() * ((SelectPoolInfo)ranks.get(i)).getsCvr() * ((SelectPoolInfo)ranks.get(i)).getRequest());
                    double cvr1 = seffectCnt >= 20 ? ((SelectPoolInfo)ranks.get(i)).getsCvr() : ((SelectPoolInfo)ranks.get(i)).getRequest() / 100.0 * WilsonInterval.wilsonCalc((double)(((SelectPoolInfo)ranks.get((int)i)).getRequest() * ((SelectPoolInfo)ranks.get((int)i)).getsUvClick() * ((SelectPoolInfo)ranks.get((int)i)).getsCvr()), (double)(((SelectPoolInfo)ranks.get((int)i)).getRequest() * ((SelectPoolInfo)ranks.get((int)i)).getsUvClick())).lowerBound;
                    double cvr2 = ((SelectPoolInfo)ranks.get(i)).getCvr();
                    double ur1 = seffectCnt >= 20 ? (double)seffectCnt / ((SelectPoolInfo)ranks.get(i)).getRequest() : ((SelectPoolInfo)ranks.get(i)).getRequest() / 100.0 * WilsonInterval.wilsonCalc((double)((double)seffectCnt), (double)((SelectPoolInfo)ranks.get((int)i)).getRequest()).lowerBound;
                    double ur2 = ((SelectPoolInfo)ranks.get(i)).getUvClick() * ((SelectPoolInfo)ranks.get(i)).getCvr();
                    double uc1 = ((SelectPoolInfo)ranks.get(i)).getRequest() > 500.0 ? ((SelectPoolInfo)ranks.get(i)).getUvCost() : ((SelectPoolInfo)ranks.get(i)).getRequest() / 500.0 * WilsonInterval.wilsonCalc((double)(((SelectPoolInfo)ranks.get((int)i)).getHrpm() * ((SelectPoolInfo)ranks.get((int)i)).getRequest()), (double)((SelectPoolInfo)ranks.get((int)i)).getUvCost()).lowerBound;
                    if (uc1 > (uc2 = ((SelectPoolInfo)ranks.get(i)).getUvCost())) {
                        if (cvr1 > 0.9 * cvr2 && ur1 > 0.9 * ur2) {
                            selectInfoDetail.condi = new ArrayList<SelectPoolInfo>(ranks.subList(0, Math.min(ranks.size(), 5)));
                            selectInfoDetail.index = ranks.get(i).getIndex();
                            selectInfoDetail.maxChangeScore = maxChangeScore;
                            selectInfoDetail.strategyType = 4;
                            break;
                        }
                    } else {
                        selectInfoDetail = ActivityRec45.getPairWise(actDataCopy, actModelCopy, ranks, maxChangeScore, rates);
                        break;
                    }
                    if (selectInfoDetail != null && selectInfoDetail.strategyType != 0) continue;
                    List rkf = ranks.stream().filter(e -> e.getsCvr() >= 0.8 * e.getCvr()).collect(Collectors.toList());
                    if (rkf.size() > 0) {
                        selectInfoDetail.index = ((SelectPoolInfo)rkf.get(0)).getIndex();
                        selectInfoDetail.strategyType = 13;
                    } else {
                        selectInfoDetail.index = ranks.get(0).getIndex();
                        selectInfoDetail.strategyType = 14;
                    }
                    selectInfoDetail.maxChangeScore = ranks.get(0).getChangeScore();
                    selectInfoDetail.condi = new ArrayList<SelectPoolInfo>(ranks.subList(0, Math.min(ranks.size(), 5)));
                }
            }
        } else {
            selectInfoDetail.index = 0;
            selectInfoDetail.maxChangeScore = sinfos.get(0).getChangeScore();
            selectInfoDetail.condi = new ArrayList();
            selectInfoDetail.strategyType = 0;
        }
        return selectInfoDetail;
    }

    private static void getSinfos(List<SelectPoolInfo> sinfos, int numMachines, List<Double> alphas, List<Double> betas, List<Long> activityTypes, List<Long> activityIds, List<Double> changeScores, List<Double> hrpms, List<Double> arpms, List<Double> grpms, List<Double> requests, List<Boolean> excellents, List<Double> scores, List<Integer> subTypes, List<Double> cvrBiass, List<Double> uvClicks, List<Double> cvrs, double uc, double uck, double ucvr) {
        for (int i = 0; i < numMachines; ++i) {
            if (activityTypes.get(i) == 21L) continue;
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            SelectPoolInfo sinfo = new SelectPoolInfo();
            sinfo.setReward(theta);
            sinfo.setActivityType(activityTypes.get(i));
            sinfo.setIndex(i);
            sinfo.setActivityId(activityIds.get(i));
            sinfo.setChangeScore(changeScores.get(i));
            sinfo.setHrpm(hrpms.get(i));
            sinfo.setArpm(arpms.get(i));
            sinfo.setGrpm(grpms.get(i));
            sinfo.setRequest(requests.get(i));
            sinfo.setExcellent(excellents.get(i));
            sinfo.setScores(scores.get(i));
            sinfo.setSubType(subTypes.get(i));
            sinfo.setCvrBias(cvrBiass.get(i));
            sinfo.setsUvClick(uvClicks.get(i));
            sinfo.setsCvr(cvrs.get(i));
            sinfo.setsUvClick(uvClicks.get(i));
            sinfo.setUvCost(uc);
            sinfo.setUvClick(uck);
            sinfo.setCvr(ucvr);
            sinfos.add(sinfo);
        }
    }

    private static SelectInfoDetail getPairWise(List<ActivityMatchInfo> actDataCopy, List<ActivityRankInfo> actModelCopy, List<SelectPoolInfo> ranks, Double maxChangeScore, Map<String, Double> rates) {
        List<ActivityRankInfo> aris;
        ArrayList<SelectPoolInfo> sinfos;
        SelectInfoDetail selectInfoDetail = new SelectInfoDetail();
        String oppAlg = Constant.ALG_UC;
        double ucAlg = rates.getOrDefault(Constant.ALG_UC, 1.0);
        double minAlg = 1.0;
        if (ucAlg >= 1.2) {
            for (Map.Entry<String, Double> rate : rates.entrySet()) {
                if (!(minAlg > rate.getValue()) || !(rate.getValue() <= 0.8)) continue;
                minAlg = rate.getValue();
                oppAlg = rate.getKey();
            }
        }
        if (oppAlg.equals(Constant.ALG_UC)) {
            List rks = ranks.stream().filter(e -> e.getRequest() > 100.0 ? e.getHrpm() > e.getUvCost() : e.getRequest() / 100.0 * WilsonInterval.wilsonCalc((double)(e.getHrpm() * e.getRequest()), (double)e.getRequest()).lowerBound > e.getUvCost()).collect(Collectors.toList());
            selectInfoDetail.condi = new ArrayList<SelectPoolInfo>(ranks.subList(0, Math.min(ranks.size(), 5)));
            selectInfoDetail.maxChangeScore = maxChangeScore;
            if (rks.size() > 0) {
                selectInfoDetail.index = ((SelectPoolInfo)rks.get(0)).getIndex();
                selectInfoDetail.strategyType = 5;
            } else {
                selectInfoDetail.index = ranks.get(0).getIndex();
                selectInfoDetail.strategyType = 6;
            }
        } else if (oppAlg.equals(Constant.ALG_UCK)) {
            sinfos = new ArrayList<SelectPoolInfo>();
            aris = ActivityRec45.getSingleOptCandis(sinfos, actDataCopy, actModelCopy, Constant.ALG_UCK, 100, 100);
            if (sinfos.size() > 0) {
                List uck_ranks = sinfos.stream().sorted(Comparator.comparing(SelectPoolInfo::getReward).reversed()).collect(Collectors.toList());
                List uck_rks = uck_ranks.stream().filter(e -> e.getRequest() > 100.0 ? e.getsUvClick() > e.getUvClick() : e.getRequest() / 100.0 * WilsonInterval.wilsonCalc((double)(e.getsUvClick() * e.getRequest()), (double)e.getRequest()).lowerBound > e.getUvClick()).collect(Collectors.toList());
                selectInfoDetail.condi = new ArrayList(uck_ranks.subList(0, Math.min(uck_ranks.size(), 5)));
                selectInfoDetail.maxChangeScore = maxChangeScore;
                if (uck_rks.size() > 0) {
                    selectInfoDetail.index = ((SelectPoolInfo)uck_rks.get(0)).getIndex();
                    selectInfoDetail.strategyType = 7;
                } else {
                    selectInfoDetail.index = ((SelectPoolInfo)uck_ranks.get(0)).getIndex();
                    selectInfoDetail.strategyType = 8;
                }
            }
        } else if (oppAlg.equals(Constant.ALG_CVR)) {
            sinfos = new ArrayList();
            aris = ActivityRec45.getSingleOptCandis(sinfos, actDataCopy, actModelCopy, Constant.ALG_CVR, 500, 500);
            if (sinfos.size() > 0) {
                List cvr_ranks = sinfos.stream().sorted(Comparator.comparing(SelectPoolInfo::getReward).reversed()).collect(Collectors.toList());
                List cvr_rks = cvr_ranks.stream().filter(e -> e.getRequest() > 500.0 ? e.getsCvr() > e.getCvr() : e.getRequest() / 500.0 * WilsonInterval.wilsonCalc((double)(e.getRequest() * e.getsUvClick() * e.getsCvr()), (double)(e.getRequest() * e.getsUvClick())).lowerBound > e.getCvr()).collect(Collectors.toList());
                selectInfoDetail.condi = new ArrayList(cvr_ranks.subList(0, Math.min(cvr_ranks.size(), 5)));
                selectInfoDetail.maxChangeScore = maxChangeScore;
                if (cvr_rks.size() > 0) {
                    selectInfoDetail.index = ((SelectPoolInfo)cvr_rks.get(0)).getIndex();
                    selectInfoDetail.strategyType = 9;
                } else {
                    selectInfoDetail.index = ((SelectPoolInfo)cvr_ranks.get(0)).getIndex();
                    selectInfoDetail.strategyType = 10;
                }
            }
        } else if (oppAlg.equals(Constant.ALG_UR)) {
            sinfos = new ArrayList();
            aris = ActivityRec45.getSingleOptCandis(sinfos, actDataCopy, actModelCopy, Constant.ALG_UR, 500, 500);
            if (sinfos.size() > 0) {
                List ur_ranks = sinfos.stream().sorted(Comparator.comparing(SelectPoolInfo::getReward).reversed()).collect(Collectors.toList());
                List ur_rks = ur_ranks.stream().filter(e -> e.getRequest() > 500.0 ? e.getsUvClick() * e.getsCvr() > e.getUvClick() * e.getCvr() : WilsonInterval.wilsonCalc((double)(e.getRequest() * e.getsUvClick() * e.getsCvr()), (double)e.getRequest()).lowerBound > e.getUvClick() * e.getCvr()).collect(Collectors.toList());
                selectInfoDetail.condi = new ArrayList(ur_ranks.subList(0, Math.min(ur_ranks.size(), 5)));
                selectInfoDetail.maxChangeScore = maxChangeScore;
                if (ur_rks.size() > 0) {
                    selectInfoDetail.index = ((SelectPoolInfo)ur_rks.get(0)).getIndex();
                    selectInfoDetail.strategyType = 11;
                } else {
                    selectInfoDetail.index = ((SelectPoolInfo)ur_ranks.get(0)).getIndex();
                    selectInfoDetail.strategyType = 12;
                }
            }
        }
        return selectInfoDetail;
    }

    private static ActivityMatchInfo fillData(ActivityInfoData act, Set<Long> actIds, Map<Long, NormInfo> exHashMap) {
        ActivityMatchInfo actM = new ActivityMatchInfo();
        actM.activityId = act.activityId;
        actM.slotId = act.slotId;
        actM.appId = act.appId;
        actM.hisClick = new ActivityVal();
        actM.hisClick.globalVal = act.click.globalVal;
        actM.hisClick.appVal = act.click.appVal;
        actM.hisClick.slotVal = act.click.slotVal;
        actM.hisClick.algSlotVal = act.click.algSlotVal;
        actM.hisCost = new ActivityVal();
        actM.hisCost.globalVal = act.cost.globalVal;
        actM.hisCost.appVal = act.cost.appVal;
        actM.hisCost.slotVal = act.cost.slotVal;
        actM.hisCost.algSlotVal = act.cost.algSlotVal;
        actM.hisRequest = new ActivityVal();
        actM.hisRequest.globalVal = act.request.globalVal;
        actM.hisRequest.appVal = act.request.appVal;
        actM.hisRequest.slotVal = act.request.slotVal;
        actM.hisRequest.algSlotVal = act.request.algSlotVal;
        actM.hisEffect = new ActivityVal();
        actM.hisEffect.globalVal = act.effect.globalVal;
        actM.hisEffect.appVal = act.effect.appVal;
        actM.hisEffect.slotVal = act.effect.slotVal;
        actM.hisEffect.algSlotVal = act.effect.algSlotVal;
        actM.subType = act.subType;
        actM.isExcellent = actIds.contains(act.activityId);
        actM.nPvClick = exHashMap.getOrDefault(act.activityId, new NormInfo()).getnPvClick();
        actM.nPvCost = exHashMap.getOrDefault(act.activityId, new NormInfo()).getnPvCost();
        actM.nCvrForm = exHashMap.getOrDefault(act.activityId, new NormInfo()).getnFormCvr();
        actM.nCvrNotForm = exHashMap.getOrDefault(act.activityId, new NormInfo()).getnNotFormCvr();
        actM.nCvr = exHashMap.getOrDefault(act.activityId, new NormInfo()).getnCvr();
        actM.score = exHashMap.getOrDefault(act.activityId, new NormInfo()).getScore();
        return actM;
    }

    static class SelectInfoDetail {
        int index;
        ArrayList<SelectPoolInfo> condi;
        double maxChangeScore;
        int strategyType;

        SelectInfoDetail() {
        }
    }

    static class MatchInfo {
        double score = 0.0;
        ActivityMatchInfo act;

        MatchInfo() {
        }
    }

    static class RankInfo {
        double grpm;
        double gexp;
        double hrpm;
        double hexp;
        double arpm;
        double aexp;

        RankInfo() {
        }
    }

    static class Constant {
        static double MIN_REWARD = 0.1;
        static double DECAY = 0.99;
        static int RECALL_SUC_TOPN = 10;
        static int RECALL_GUC_TOPN = 10;
        static int RECALL_SUCK_TOPN = 5;
        static int RECALL_GUCK_TOPN = 5;
        static int RECALL_SCVR_TOPN = 5;
        static int RECALL_GCVR_TOPN = 5;
        static int RECALL_CVR_TOPN = 5;
        static int RECALL_UR_TOPN = 5;
        static int EXCELLENT_TOPN = 10;
        static String ALG_UC = "uc";
        static String ALG_UCK = "uck";
        static String ALG_CVR = "cvr";
        static String ALG_UR = "ur";

        Constant() {
        }
    }
}

