/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.pacing;

import cn.com.duiba.nezha.alg.common.model.deeptarget.ConsumeInfo;
import cn.com.duiba.nezha.alg.common.model.deeptarget.DeepTargetInfo;
import cn.com.duiba.nezha.alg.common.model.pacing.AdvertOrientInfo;
import cn.com.duiba.nezha.alg.common.model.pacing.OrientInfo;
import cn.com.duiba.nezha.alg.common.model.pacing.ResultType;
import cn.com.duiba.nezha.alg.common.model.pacing.SlotRecommender;
import cn.com.duiba.nezha.alg.common.model.pacing.TrusteeshipParams;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Recommender {
    private static final Logger logger = LoggerFactory.getLogger(Recommender.class);

    public static Map<ResultType, Collection<AdvertOrientInfo>> deviceAndSlotRecommend(Collection<OrientInfo> orientlist, Long slotId, TrusteeshipParams trusteeshipParams, Integer flowType) {
        Map<ResultType, Collection<AdvertOrientInfo>> slotRecommendSet = SlotRecommender.recommend(orientlist, slotId, trusteeshipParams, flowType);
        Collection<AdvertOrientInfo> advertOrientInfoSet = slotRecommendSet.get((Object)ResultType.ONTARGET);
        List<OrientInfo> orientlistRecall = orientlist.stream().filter(orient -> orient.recall).collect(Collectors.toList());
        HashSet<AdvertOrientInfo> advertOrientInfoSetMerge = new HashSet<AdvertOrientInfo>();
        orientlistRecall.forEach(orient -> {
            AdvertOrientInfo advertOrientInfo = new AdvertOrientInfo(orient.advertId, orient.orientId, new HashSet<Integer>());
            if (!advertOrientInfoSet.contains(advertOrientInfo)) {
                advertOrientInfo.getMatchType().add(20);
                advertOrientInfoSetMerge.add(advertOrientInfo);
            }
        });
        advertOrientInfoSetMerge.addAll(advertOrientInfoSet);
        slotRecommendSet.put(ResultType.BEFOREFILTER, advertOrientInfoSetMerge);
        Map collect = orientlist.stream().collect(Collectors.toMap(orient -> orient.getAdvertId() + "_" + orient.getOrientId(), Function.identity()));
        HashSet<AdvertOrientInfo> advertOrientInfoSetFilter = new HashSet<AdvertOrientInfo>();
        advertOrientInfoSetFilter.addAll(advertOrientInfoSetMerge);
        Iterator iterator = advertOrientInfoSetFilter.iterator();
        while (iterator.hasNext()) {
            Double preCvr;
            Double preDcvr;
            ConsumeInfo consumeInfo;
            DeepTargetInfo deepTargetInfo;
            boolean isGiveup;
            AdvertOrientInfo orient2 = (AdvertOrientInfo)iterator.next();
            OrientInfo orientInfo = (OrientInfo)collect.get(orient2.getAdvertId() + "_" + orient2.getOrientId());
            if (orientInfo.getDeepTargetinfo() == null || orientInfo.getConsumeInfo() == null || orientInfo.getPreDcvr() == null || !(isGiveup = Recommender.giveUpFlow(deepTargetInfo = orientInfo.getDeepTargetinfo(), consumeInfo = orientInfo.getConsumeInfo(), preDcvr = orientInfo.getPreDcvr(), preCvr = orientInfo.getPreCvr(), flowType))) continue;
            iterator.remove();
            logger.info("deviceAndSlotRecommend giveup :{}", (Object)(orient2.getAdvertId() + "_" + orient2.getOrientId()));
        }
        slotRecommendSet.put(ResultType.AFTERFILTER, advertOrientInfoSetFilter);
        return slotRecommendSet;
    }

    public static boolean giveUpFlow(DeepTargetInfo deepTargetInfo, ConsumeInfo consumeInfo, Double preDcvr, Double preCvr, Integer flowType) {
        boolean ret = false;
        if (AssertUtil.isAnyEmpty(deepTargetInfo, consumeInfo, preDcvr, preCvr)) {
            return ret;
        }
        double selectFactor = deepTargetInfo.getSelectFactor();
        if (flowType == 1) {
            selectFactor = deepTargetInfo.getSdkSelectFactor();
        }
        double consumeFactor = consumeInfo.getConsumeFactor();
        if (preDcvr > selectFactor && preCvr < 0.01) {
            Random r = new Random();
            Double x = r.nextDouble();
            if (x < 0.3) {
                ret = true;
            }
        } else if (preDcvr < selectFactor && consumeFactor >= 1.2) {
            ret = true;
        } else if (consumeFactor < 1.2 && preDcvr < Math.max(selectFactor / 1.4, 0.01)) {
            ret = true;
        }
        return ret;
    }
}

