package cn.com.duiba.nezha.alg.common.model.ocpxControl;

import cn.com.duiba.nezha.alg.common.util.MathUtil;
import org.junit.Test;

public class PidController {

    private double P;
    private double I;
    private double D;
    private static double LEARNING_RATE = 0.3;


    public PidController(){
        P = 1.0;
        I = 0.3;
        D = 0.;
    }

    public double runPid(double target, double actual, double actualSum) {

        double error = 0;
        double signal = 0;
        error = P * (target - actual) + I * (target - actualSum);
        signal = LEARNING_RATE * error;
        signal = MathUtil.stdwithBoundary(signal, -0.05, 0.05);
        return signal;
    }

    public double runPid(double target, double actual) {

        double error = 0;
        double signal = 0;

        error = P * (target - actual) / target;

        signal = LEARNING_RATE * error;
        signal = MathUtil.stdwithBoundary(signal, -0.2, 0.2);

        return signal;
    }

}
