package cn.com.duiba.nezha.alg.common.util;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;

public class LocalDateUtil {

    public static Map<String, DateTimeFormatter> map = new HashMap<>();

    public static void main(String[] args) {

        LocalDateTime localDateTime1 = getLocalDateTime("2018-09-03 11:01:10", DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        LocalDateTime localDateTime2 = getLocalDateTime("2018-09-02 11:01:10", DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());

        System.out.println("localDateTime=" + localDateTime1);
        System.out.println("localDateTime.between=" + getBetweenDuration(localDateTime1, localDateTime2).toHours());


        LocalDate localDate1 = getLocalDate("2018-09-05", DateStyle.YYYY_MM_DD.getValue());
        LocalDate localDate2 = getLocalDate("2018-09-03", DateStyle.YYYY_MM_DD.getValue());

        System.out.println("localDate=" + localDate1);
        System.out.println("localDate.between=" + getBetweenDays(localDate1, localDate2));


        LocalTime localTime1 = getLocalTime("13:02:10", DateStyle.HH_MM_SS.getValue());
        LocalTime localTime2 = getLocalTime("12:02:10", DateStyle.HH_MM_SS.getValue());
        System.out.println("localTime=" + localTime1);
        System.out.println("localTime.between=" + getBetweenSeconds(localTime1, localTime2));


    }

    public static String getCurrentLocalDateTime(String parttern) {
        String ret = null;
        if (parttern != null) {
            ret = LocalDateTime.now().format(DateTimeFormatter.ofPattern(parttern));
        }
        return ret;
    }

//    public static DateTimeFormatter getDateTimeFormatter(String parttern) {
//        DateTimeFormatter ret = null;
//        if (parttern != null) {
//            map.putIfAbsent(parttern, DateTimeFormatter.ofPattern(parttern));
//        }
//        ret = map.get(parttern);
//        return ret;
//    }


    public static java.time.Duration getBetweenDuration(LocalDateTime start, LocalDateTime end) {
        java.time.Duration ret = null;
        if (start != null && end != null) {
            ret = java.time.Duration.between(start, end);
        }
        return ret;
    }

    public static Long getBetweenDays(LocalDate start, LocalDate end) {
        Long ret = null;
        if (start != null && end != null) {
            ret = end.toEpochDay() - start.toEpochDay();
        }
        return ret;
    }

    public static Long getBetweenSeconds(LocalTime start, LocalTime end) {
        Long ret = null;
        if (start != null && end != null) {
            ret = end.toSecondOfDay() - start.toSecondOfDay() + 0L;
        }
        return ret;
    }


    public static LocalDate getLocalDate(String timeString, String parttern) {
        LocalDate ret = null;
        if (timeString != null && parttern != null) {
            ret = LocalDate.parse(timeString,DateTimeFormatter.ofPattern(parttern));

        }

        return ret;
    }

    public static LocalTime getLocalTime(String timeString, String parttern) {
        LocalTime ret = null;
        if (timeString != null && parttern != null) {
            ret = LocalTime.parse(timeString, DateTimeFormatter.ofPattern(parttern));

        }

        return ret;
    }

    public static LocalDateTime getLocalDateTime(String timeString, String parttern) {
        LocalDateTime ret = null;
        if (timeString != null && parttern != null) {
            ret = LocalDateTime.parse(timeString, DateTimeFormatter.ofPattern(parttern));

        }


        return ret;
    }
}
