/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.advertexplore;

import cn.com.duiba.nezha.alg.common.model.advertexplore.AdExploreUcb;
import cn.com.duiba.nezha.alg.common.model.advertexplore.AdExploreUcbData;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreInfo;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreParams;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreResult;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ReasonType;
import cn.com.duiba.nezha.alg.common.model.advertexplore.UcbResult;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvertExplore {
    private static final Logger logger = LoggerFactory.getLogger(AdvertExplore.class);

    public static List<ExploreResult> explore(List<ExploreInfo> exploreInfos, ExploreParams exploreParams, AdExploreUcbData adExploreUcbData) {
        if (AssertUtil.isAnyEmpty(exploreInfos, exploreParams, adExploreUcbData)) {
            return null;
        }
        if (Math.random() < 1.0E-4) {
            logger.info("params AdvertExplore:{}", (Object)exploreParams.toString());
        }
        double minprob = exploreParams.getMinProb();
        double appf1 = exploreParams.getAppf1();
        double appf2 = exploreParams.getAppf2();
        double expratio = exploreParams.getExpratio();
        double bidfactor = exploreParams.getBidfactor();
        double afeefactor = exploreParams.getAfeefactor();
        double ucblimit = exploreParams.getUcblimit();
        double cvr0limit = exploreParams.getCvr0limit();
        double cvr3limit = exploreParams.getCvr3limit();
        double ocpcConsumeLimit = exploreParams.getOcpcConsumeLimit().longValue();
        List<Integer> convbucket = exploreParams.getConvbucket();
        List<Integer> cntbucket = exploreParams.getCntbucket();
        List<Double> cvrBucket = exploreParams.getCvrBucket();
        List<Double> reFactor = exploreParams.getReFactor();
        List<Double> biasBucket = exploreParams.getBiasBucket();
        List<Double> factorBucket = exploreParams.getFactorBucket();
        List<Double> expBiasBucket = exploreParams.getExpBiasBucket();
        List<Double> expFactorBucket = exploreParams.getExpFactorBucket();
        double biasWeight = exploreParams.getBiasWeight();
        ArrayList<ExploreResult> exploreResultList = new ArrayList<ExploreResult>();
        ArrayList<ExploreInfo> exploreSubList = new ArrayList<ExploreInfo>();
        double appCvr = exploreInfos.get((int)0).appDataInfo.data7Day.conv != null && exploreInfos.get((int)0).appDataInfo.data7Day.conv.get(0) != null && exploreInfos.get((int)0).appDataInfo.data7Day.conv.get(0) > 5L && exploreInfos.get((int)0).appDataInfo.data7Day.click > exploreInfos.get((int)0).appDataInfo.data7Day.conv.get(0) ? AdExploreUcb.division(exploreInfos.get((int)0).appDataInfo.data7Day.conv.get(0), exploreInfos.get((int)0).appDataInfo.data7Day.click) : 0.0;
        double costBias = exploreInfos.get((int)0).appDataInfo.data7Day.costBias + 1.0;
        double appProb2 = exploreInfos.get((int)0).appDataInfo.data7Day.consume > 2000L && costBias > 0.0 ? Math.min(appf2 / (costBias * costBias * costBias), 1.0) : 0.1;
        double appProb = appCvr > appf1 ? 1.0 : appProb2;
        appProb = Math.min(appProb, 1.0);
        Random r = new Random();
        if (r.nextDouble() > appProb) {
            for (ExploreInfo exploreInfo2 : exploreInfos) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put(ReasonType.GIVEUP0.getName(), appCvr);
                exploreResultList.add(new ExploreResult(exploreInfo2.getAdvertId(), exploreInfo2.getOrientationId(), hashMap, null));
            }
            return exploreResultList;
        }
        for (ExploreInfo exploreInfo3 : exploreInfos) {
            double cvrlimit;
            double d = AdExploreUcb.division(exploreInfo3.appAdvertInfo.advertExploreConsume, exploreInfo3.appAdvertInfo.advertOcpcConsume);
            long appExposeTime = exploreInfo3.appDataInfo.data3Day.conv.getOrDefault(exploreInfo3.convertType, 0L);
            double cnt = AdvertExplore.getCntLimit(appExposeTime, convbucket, cntbucket).intValue();
            double cvr = exploreInfo3.appOrientConv3day.getOrDefault(exploreInfo3.convertType, 0L) >= 5L ? AdExploreUcb.division(exploreInfo3.appOrientConv3day.getOrDefault(exploreInfo3.convertType, 0L), exploreInfo3.appOrientClick3day) : 0.0;
            double d2 = cvrlimit = exploreInfo3.convertType == 0 ? cvr0limit : cvr3limit;
            if ((double)exploreInfo3.appAdvertInfo.data3day.exposure.longValue() > cnt) {
                HashMap<String, Object> giveUpReason = new HashMap<String, Object>();
                if ((double)exploreInfo3.appAdvertInfo.data3day.ocpcConsume.longValue() >= ocpcConsumeLimit && cvr > cvrlimit) {
                    giveUpReason.put(ReasonType.EXPLOIT.getName(), exploreInfo3.appAdvertInfo.data3day.ocpcConsume);
                    exploreResultList.add(new ExploreResult(exploreInfo3.getAdvertId(), exploreInfo3.getOrientationId(), giveUpReason, null));
                    continue;
                }
                giveUpReason.put(ReasonType.GIVEUP2.getName(), exploreInfo3.appAdvertInfo.data3day.exposure + "_" + appExposeTime);
                exploreResultList.add(new ExploreResult(exploreInfo3.getAdvertId(), exploreInfo3.getOrientationId(), giveUpReason, null));
                continue;
            }
            if (exploreInfo3.appAdvertInfo.advertExploreConsume > 3000L && d > expratio) {
                HashMap<String, Object> giveUpReason = new HashMap<String, Object>();
                if ((double)exploreInfo3.appAdvertInfo.data3day.ocpcConsume.longValue() >= ocpcConsumeLimit && cvr > cvrlimit) {
                    giveUpReason.put(ReasonType.EXPLOIT.getName(), exploreInfo3.appAdvertInfo.data3day.ocpcConsume);
                    exploreResultList.add(new ExploreResult(exploreInfo3.getAdvertId(), exploreInfo3.getOrientationId(), giveUpReason, null));
                    continue;
                }
                giveUpReason.put(ReasonType.GIVEUP1.getName(), d);
                exploreResultList.add(new ExploreResult(exploreInfo3.getAdvertId(), exploreInfo3.getOrientationId(), giveUpReason, null));
                continue;
            }
            double bid = 0.0;
            double orientProb1 = 0.1;
            if (exploreInfo3.convertType == 0 && exploreInfo3.appTradeInfo.data3day.conv != null && exploreInfo3.appTradeInfo.data3day.conv.get(exploreInfo3.convertType) != null) {
                double tradeCvr = AdExploreUcb.division(exploreInfo3.appTradeInfo.data3day.conv.get(exploreInfo3.convertType), exploreInfo3.appTradeInfo.data3day.click);
                bid = (double)exploreInfo3.target.longValue() * tradeCvr;
                orientProb1 = exploreInfo3.appTradeInfo.data3day.conv.get(exploreInfo3.convertType) >= 5L ? bid * bidfactor : 0.1;
            }
            double afee = exploreInfo3.target.longValue();
            double orientProb2 = afee * afeefactor;
            double orientProb = Math.max(orientProb1, orientProb2);
            if ((double)exploreInfo3.isSimiFlow.intValue() == 1.0) {
                orientProb = Math.min(orientProb * 1.25, 1.0);
            }
            orientProb = Math.max(Math.min(orientProb, 1.0), 0.1);
            Random r2 = new Random();
            if (r2.nextDouble() > orientProb) {
                HashMap<String, Object> giveUpReason = new HashMap<String, Object>();
                giveUpReason.put(ReasonType.GIVEUP3.getName(), bid + "_" + afee);
                exploreResultList.add(new ExploreResult(exploreInfo3.getAdvertId(), exploreInfo3.getOrientationId(), giveUpReason, null));
                continue;
            }
            exploreSubList.add(exploreInfo3);
        }
        if (exploreSubList != null && exploreSubList.size() > 0) {
            Map<Long, UcbResult> ucbMap = AdExploreUcb.calcUcb(((ExploreInfo)exploreSubList.get((int)0)).appDataInfo.data3Day, adExploreUcbData, exploreParams);
            for (ExploreInfo exploreInfo4 : exploreSubList) {
                exploreInfo4.setUcbScore(ucbMap.get(exploreInfo4.accountId).getObjUcb().getOrDefault(exploreInfo4.convertType, 0.0));
                exploreInfo4.setObjUcbInfo(ucbMap.get(exploreInfo4.accountId).getObjUcbInfo().getOrDefault(exploreInfo4.convertType, " "));
            }
            List list = exploreSubList.stream().filter(exploreInfo -> exploreInfo.getUcbScore() >= ucblimit).sorted(Comparator.comparing(ExploreInfo::getUcbScore).reversed()).limit(50L).collect(Collectors.toList());
            long l = ((ExploreInfo)exploreSubList.get((int)0)).appDataInfo.data3Day.conv.getOrDefault(0, 0L);
            double appCvr3day = l >= 10L ? AdExploreUcb.division(l, exploreInfos.get((int)0).appDataInfo.data3Day.click) : 1.0;
            Double[] cvrBucket1 = new Double[cvrBucket.size()];
            Double[] reFactor1 = new Double[reFactor.size()];
            cvrBucket1 = cvrBucket.toArray(cvrBucket1);
            reFactor1 = reFactor.toArray(reFactor1);
            Double[] biasBucket1 = new Double[biasBucket.size()];
            Double[] factorBucket1 = new Double[factorBucket.size()];
            biasBucket1 = biasBucket.toArray(biasBucket1);
            factorBucket1 = factorBucket.toArray(factorBucket1);
            Double[] expbiasBucket1 = expBiasBucket.toArray(new Double[expBiasBucket.size()]);
            Double[] expFactorBucket1 = expFactorBucket.toArray(new Double[expFactorBucket.size()]);
            double reduceFactor = AdvertExplore.getConfidenceWeight(appCvr3day, cvrBucket1, reFactor1, 1.0);
            for (ExploreInfo exploreInfo5 : list) {
                HashMap<String, Object> giveUpReason = new HashMap<String, Object>();
                giveUpReason.put(ReasonType.EXPLORE.getName(), "null");
                double factor = AdvertExplore.adjustFactorNew(exploreInfo5, biasBucket1, factorBucket1, expbiasBucket1, expFactorBucket1, biasWeight);
                double factor1 = Math.max(factor * reduceFactor, 1.0);
                exploreResultList.add(new ExploreResult(exploreInfo5.getAdvertId(), exploreInfo5.getOrientationId(), giveUpReason, factor1));
            }
            exploreSubList.removeAll(list);
            for (ExploreInfo exploreInfo6 : exploreSubList) {
                HashMap<String, Object> giveUpReason = new HashMap<String, Object>();
                giveUpReason.put(ReasonType.GIVEUP4.getName(), exploreInfo6.ucbScore + "_" + exploreInfo6.objUcbInfo);
                exploreResultList.add(new ExploreResult(exploreInfo6.getAdvertId(), exploreInfo6.getOrientationId(), giveUpReason, null));
            }
        }
        return exploreResultList;
    }

    public static double adjustFactor(ExploreInfo exploreInfo, Double[] biasBucket, Double[] factor) {
        double f = 1.0;
        long consume = exploreInfo.orientOcpcConsume;
        long conv = exploreInfo.orientConv.getOrDefault(exploreInfo.convertType, 0L);
        double cost = conv >= 5L ? AdExploreUcb.division(AdExploreUcb.division(consume, (Long)conv), exploreInfo.target) : 1.0;
        f = AdvertExplore.getConfidenceWeight(cost, biasBucket, factor, 1.0);
        return f;
    }

    public static double adjustFactorNew(ExploreInfo exploreInfo, Double[] biasBucket, Double[] factor, Double[] expBiasBucket, Double[] expFactor, Double biasWeight) {
        double f = 1.0;
        long consume = exploreInfo.orientOcpcConsume;
        long conv = exploreInfo.orientConv.getOrDefault(exploreInfo.convertType, 0L);
        double cost = conv >= 5L ? AdExploreUcb.division(AdExploreUcb.division(consume, (Long)conv), exploreInfo.target) : 1.0;
        double f1 = AdvertExplore.getConfidenceWeight(cost, biasBucket, factor, 1.0);
        double exploreCost = 1.0;
        if (exploreInfo.orientExpCost != null && exploreInfo.orientExpCost.exploreAdjConsume > 3000L) {
            exploreCost = AdExploreUcb.division(exploreInfo.orientExpCost.exploreConsume, exploreInfo.orientExpCost.exploreAdjConsume);
        } else if (exploreInfo.appAdvertInfo.consume != null && exploreInfo.appAdvertInfo.consume.exploreAdjConsume > 5000L) {
            exploreCost = AdExploreUcb.division(exploreInfo.appAdvertInfo.consume.exploreConsume, exploreInfo.appAdvertInfo.consume.exploreAdjConsume);
        } else if (exploreInfo.appAccountInfo.consume != null && exploreInfo.appAccountInfo.consume.exploreAdjConsume > 5000L) {
            exploreCost = AdExploreUcb.division(exploreInfo.appAccountInfo.consume.exploreConsume, exploreInfo.appAccountInfo.consume.exploreAdjConsume);
        } else {
            biasWeight = 1.0;
        }
        double f2 = AdvertExplore.getConfidenceWeight(exploreCost, expBiasBucket, expFactor, 1.0);
        f = biasWeight * f1 + (1.0 - biasWeight) * f2;
        if (exploreInfo.supportWeight > 1.0) {
            f = 0.5 * (exploreInfo.supportWeight + f);
        }
        return f;
    }

    public static Integer getCntLimit(Long convCnt, List<Integer> convbucket, List<Integer> cntbucket) {
        if (AssertUtil.isAnyEmpty(convCnt, convbucket, cntbucket)) {
            return 10;
        }
        if (convCnt <= (long)convbucket.get(0).intValue()) {
            return cntbucket.get(0);
        }
        if (convCnt <= (long)convbucket.get(1).intValue()) {
            return cntbucket.get(1);
        }
        if (convCnt <= (long)convbucket.get(2).intValue()) {
            return cntbucket.get(2);
        }
        return cntbucket.get(3);
    }

    public static Double getConfidenceWeight(Double value, Double[] bucketList, Double[] weightList, double defaultValue) {
        Double ret = defaultValue;
        if (value != null && bucketList != null && bucketList.length > 0 && weightList != null && weightList.length == bucketList.length) {
            double lastWeight = weightList[0];
            double lastBound = bucketList[0];
            int size = bucketList.length;
            for (int i = 0; i < size; ++i) {
                double curWeight = weightList[i];
                double curBound = bucketList[i];
                double bound = bucketList[i];
                if (value <= bound) {
                    if (i > 0) {
                        ret = lastWeight + (curWeight - lastWeight) * (value - lastBound) / (curBound - lastBound);
                        break;
                    }
                    ret = weightList[0];
                    break;
                }
                if (i == size - 1) {
                    ret = weightList[size - 1];
                }
                lastWeight = weightList[i];
                lastBound = bucketList[i];
            }
        }
        return DataUtil.formatDouble(ret, 3);
    }

    public static void main(String[] args) {
        System.out.println(AdExploreUcb.division(2L, (Long)10L));
        ArrayList a = new ArrayList();
        ArrayList<Integer> b = new ArrayList<Integer>();
        b.add(1);
        b.add(1);
        b.add(2);
        b.add(3);
        b.add(4);
        a.addAll(b);
        a.add(5);
        a.removeAll(b);
        System.out.println(((Object)b).toString());
        System.out.println(((Object)a).toString());
    }
}

