package cn.com.duiba.nezha.alg.common.model.advertexplore;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import static cn.com.duiba.nezha.alg.common.model.advertexplore.AdExploreUcb.calcUcb;
import static cn.com.duiba.nezha.alg.common.model.advertexplore.AdExploreUcb.division;
import static cn.com.duiba.nezha.alg.common.model.deeptarget.DeepTargetControl.getConfidenceWeight;

public class AdvertExplore {


    private static final Logger logger = LoggerFactory.getLogger(AdvertExplore.class);


//    public static Double[] biasBucket = {0.8, 0.9, 1.0, 1.1, 1.2};
//    public static Double[] factor = {1.2, 1.15, 1.1, 1.05, 1.0};

//    public static double[] cvrBucket = {0.03, 0.045, 0.09};
//    public static double[] reFactor = {0.95, 0.97, 1.0};

    /**
     *
     * @param exploreInfos
     * @param exploreParams
     * @param adExploreUcbData
     * @return
     */
    public static List<ExploreResult> explore(List<ExploreInfo> exploreInfos,
                                              ExploreParams exploreParams,
                                              AdExploreUcbData adExploreUcbData) {

        if(AssertUtil.isAnyEmpty(exploreInfos, exploreParams, adExploreUcbData)){
            return null;
        }


        if (Math.random() < 0.0001) {
            logger.info("params AdvertExplore:{}", exploreParams.toString());
        }

        double minprob = exploreParams.getMinProb();//媒体默认探索概率
        double appf1 = exploreParams.getAppf1();//媒体cpm
        double appf2 = exploreParams.getAppf2();//媒体cvr
        double expratio = exploreParams.getExpratio();//
        double bidfactor = exploreParams.getBidfactor();//出价
        double afeefactor = exploreParams.getAfeefactor();
        double ucblimit = exploreParams.getUcblimit();//ucb
        double cvr0limit = exploreParams.getCvr0limit();//cvr0
        double cvr3limit = exploreParams.getCvr3limit();//cvr3
        double ocpcConsumeLimit = exploreParams.getOcpcConsumeLimit();//ocpc消耗阈值
        List<Integer> convbucket = exploreParams.getConvbucket();
        List<Integer> cntbucket = exploreParams.getCntbucket();
        List<Double> cvrBucket = exploreParams.getCvrBucket();
        List<Double> reFactor = exploreParams.getReFactor();
        List<Double> biasBucket = exploreParams.getBiasBucket();
        List<Double> factorBucket = exploreParams.getFactorBucket();
        List<Double> expBiasBucket = exploreParams.getExpBiasBucket();
        List<Double> expFactorBucket = exploreParams.getExpFactorBucket();
        double biasWeight = exploreParams.getBiasWeight();
        double supportLimit = exploreParams.getSupportLimit();


        List<ExploreResult> exploreResultList = new ArrayList<>(); //结果
        List<ExploreInfo> exploreSubList = new ArrayList<>();


//        /**
//         * 媒体质量过滤
//         */
//        double appCvr =  (exploreInfos.get(0).appDataInfo.data7Day.conv != null
//                && exploreInfos.get(0).appDataInfo.data7Day.conv.get(0) != null
//                && exploreInfos.get(0).appDataInfo.data7Day.conv.get(0) > 5
//                && exploreInfos.get(0).appDataInfo.data7Day.click > exploreInfos.get(0).appDataInfo.data7Day.conv.get(0)) ?
//                division(exploreInfos.get(0).appDataInfo.data7Day.conv.get(0),exploreInfos.get(0).appDataInfo.data7Day.click) : 0.0;
//
//        if(exploreInfos.get(0).appDataInfo.data7Day.conv != null && exploreInfos.get(0).appDataInfo.data7Day.conv.get(0) != null) {
//            if (exploreInfos.get(0).appDataInfo.data7Day.conv.get(0) > 5 && exploreInfos.get(0).appDataInfo.data7Day.click > exploreInfos.get(0).appDataInfo.data7Day.conv.get(0)) {
//                appCvr = division(exploreInfos.get(0).appDataInfo.data7Day.conv.get(0),exploreInfos.get(0).appDataInfo.data7Day.click);
//            }
//        }
//        //
//        double appProb1 = appf1 * cpm;//0.001
//        double appProb2 = Math.max(appProb1,appf2 * appCvr);//0.02 * 50
//        appProb = Math.min(Math.max(appProb2, appProb), 1.0);
//        double cpm = (exploreInfos.get(0).appDataInfo.data7Day.consume > 1000 && exploreInfos.get(0).appDataInfo.data7Day.exposure > 100) ?
//            division(exploreInfos.get(0).appDataInfo.data7Day.consume, exploreInfos.get(0).appDataInfo.data7Day.exposure) : 0.0;
//
//        double appProb1 = appf1 * Math.max(cpm, 25) * appCvr;//0.1 * 10
//
//        double appProb = (appCvr > 0.02) ? appf2 * appCvr : appProb1;
//        appProb = Math.min(appProb, 1.0);
//
//        Random r = new Random();
//        if (r.nextDouble() > appProb) { //不满足探索条件,所有配置均放弃探索
//            for (ExploreInfo exploreInfo : exploreInfos) {
//                HashMap<String, Object> giveUpReason = new HashMap<String, Object>();
//                giveUpReason.put(ReasonType.GIVEUP0.getName(), appCvr);
//                exploreResultList.add(new ExploreResult(exploreInfo.getAdvertId(), exploreInfo.getOrientationId(), giveUpReason, null));
//            }
//            return exploreResultList; //直接返回结果
//        }

        /**
         * 媒体质量过滤
         */
        double appCvr =  (exploreInfos.get(0).appDataInfo.data7Day.conv != null
                && exploreInfos.get(0).appDataInfo.data7Day.conv.get(0) != null
                && exploreInfos.get(0).appDataInfo.data7Day.conv.get(0) > 5
                && exploreInfos.get(0).appDataInfo.data7Day.click > exploreInfos.get(0).appDataInfo.data7Day.conv.get(0)) ?
                division(exploreInfos.get(0).appDataInfo.data7Day.conv.get(0),exploreInfos.get(0).appDataInfo.data7Day.click) : 0.0;

        double costBias = exploreInfos.get(0).appDataInfo.data7Day.costBias + 1.0;
        double appProb2 = exploreInfos.get(0).appDataInfo.data7Day.consume > 2000 && costBias > 0 ?
                Math.min(appf2 / (costBias * costBias * costBias), 1.0) : 0.1;//0.2/1=0.2的概率进来

        double appProb = (appCvr > appf1) ? 1.0 : appProb2;
        appProb = Math.min(appProb, 1.0);

        Random r = new Random();
        if (r.nextDouble() > appProb) { //不满足探索条件,所有配置均放弃探索
            for (ExploreInfo exploreInfo : exploreInfos) {
                HashMap<String, Object> giveUpReason = new HashMap<String, Object>();
                giveUpReason.put(ReasonType.GIVEUP0.getName(), appCvr);
                exploreResultList.add(new ExploreResult(exploreInfo.getAdvertId(), exploreInfo.getOrientationId(), giveUpReason, null));
            }
            return exploreResultList; //直接返回结果
        }



        for (ExploreInfo exploreInfo : exploreInfos) {
            /**
             * 广告
             */
            //探索消耗达到10%
            double exploreRatio = division(exploreInfo.appAdvertInfo.advertExploreConsume, exploreInfo.appAdvertInfo.advertOcpcConsume);
            long appExposeTime = exploreInfo.appDataInfo.data3Day.conv.getOrDefault(exploreInfo.convertType,0L);
            double cnt = getCntLimit(appExposeTime,convbucket,cntbucket);
            double cvr = exploreInfo.appOrientConv3day.getOrDefault(exploreInfo.convertType,0L) >= 5 ? division(exploreInfo.appOrientConv3day.getOrDefault(exploreInfo.convertType,0L), exploreInfo.appOrientClick3day) : 0.0;
            double cvrlimit = exploreInfo.convertType == 0 ? cvr0limit : cvr3limit;

            if(exploreInfo.appAdvertInfo.data3day.exposure > cnt) { //发券达到一定量级
                HashMap<String, Object> giveUpReason = new HashMap<String, Object>();
                if(exploreInfo.appAdvertInfo.data3day.ocpcConsume >= ocpcConsumeLimit && cvr > cvrlimit) { // 利用
                    giveUpReason.put(ReasonType.EXPLOIT.getName(), exploreInfo.appAdvertInfo.data3day.ocpcConsume);
                    exploreResultList.add(new ExploreResult(exploreInfo.getAdvertId(), exploreInfo.getOrientationId(), giveUpReason, null));
                } else { // 放弃
                    giveUpReason.put(ReasonType.GIVEUP2.getName(), exploreInfo.appAdvertInfo.data3day.exposure + "_" + appExposeTime);
                    exploreResultList.add(new ExploreResult(exploreInfo.getAdvertId(), exploreInfo.getOrientationId(), giveUpReason, null));
                }
            } else if(exploreInfo.appAdvertInfo.advertExploreConsume > 3000 && exploreRatio > expratio) {
                HashMap<String, Object> giveUpReason = new HashMap<String, Object>();
                if(exploreInfo.appAdvertInfo.data3day.ocpcConsume >= ocpcConsumeLimit && cvr > cvrlimit) { // 利用
                    giveUpReason.put(ReasonType.EXPLOIT.getName(), exploreInfo.appAdvertInfo.data3day.ocpcConsume);
                    exploreResultList.add(new ExploreResult(exploreInfo.getAdvertId(), exploreInfo.getOrientationId(), giveUpReason, null));
                } else {
                    giveUpReason.put(ReasonType.GIVEUP1.getName(), exploreRatio);
                    exploreResultList.add(new ExploreResult(exploreInfo.getAdvertId(), exploreInfo.getOrientationId(), giveUpReason, null));
                }
            } else {
                /**
                 * 出价筛选配置
                 */
                double bid = 0.0;
                double orientProb1 = 0.1;
                if(exploreInfo.convertType == 0 && exploreInfo.appTradeInfo.data3day.conv != null && exploreInfo.appTradeInfo.data3day.conv.get(exploreInfo.convertType) != null) {
                    double tradeCvr = division(exploreInfo.appTradeInfo.data3day.conv.get(exploreInfo.convertType), exploreInfo.appTradeInfo.data3day.click);
                    bid = exploreInfo.target * tradeCvr;
                    orientProb1 = exploreInfo.appTradeInfo.data3day.conv.get(exploreInfo.convertType) >= 5 ? bid * bidfactor : 0.1;// 0.025,40有100%的概率进来

                }
                double afee = exploreInfo.target;

                double orientProb2 = afee * afeefactor;//0.0005,2000有100%的概率进来
                double orientProb = Math.max(orientProb1,orientProb2);
                //新广告的探索加权
                if (exploreInfo.isSimiFlow == 1.0) {
                    orientProb = Math.min(orientProb * 1.25, 1.0);
                }

                orientProb = Math.max(Math.min(orientProb,1.0),0.1);
                Random r2 = new Random();

                if (r2.nextDouble() > orientProb) {
                    HashMap<String, Object> giveUpReason = new HashMap<String, Object>();
                    giveUpReason.put(ReasonType.GIVEUP3.getName(), bid + "_" + afee);
                    exploreResultList.add(new ExploreResult(exploreInfo.getAdvertId(), exploreInfo.getOrientationId(), giveUpReason, null));
                } else {
                    exploreSubList.add(exploreInfo);
                }
            }
        }



        /**
         * ucb计算得分并筛选
         */
        if (exploreSubList != null && exploreSubList.size() > 0) {
            Map<Long, UcbResult> ucbMap = calcUcb(exploreSubList.get(0).appDataInfo.data3Day, adExploreUcbData, exploreParams);

            for (ExploreInfo exploreInfo : exploreSubList) {
                exploreInfo.setUcbScore(ucbMap.get(exploreInfo.accountId).getObjUcb().getOrDefault(exploreInfo.convertType,0.0));
                exploreInfo.setObjUcbInfo(ucbMap.get(exploreInfo.accountId).getObjUcbInfo().getOrDefault(exploreInfo.convertType," "));
            }
            //存储最终用于探索的列表
            List<ExploreInfo> res = exploreSubList.stream()
                    .filter(exploreInfo -> exploreInfo.getUcbScore() >= ucblimit)
                    .sorted(Comparator.comparing(ExploreInfo::getUcbScore).reversed())
                    .limit(50)
                    .collect(Collectors.toList());

            //根据媒体转化率进行加价的调整
            long conv = exploreSubList.get(0).appDataInfo.data3Day.conv.getOrDefault(0,0L);
            double appCvr3day = conv >= 10 ? division(conv,exploreInfos.get(0).appDataInfo.data3Day.click) : 1.0;
            Double[] cvrBucket1 = new Double[cvrBucket.size()];
            Double[] reFactor1 = new Double[reFactor.size()];
            cvrBucket1 = cvrBucket.toArray(cvrBucket1);
            reFactor1 = reFactor.toArray(reFactor1);

            Double[] biasBucket1 = new Double[biasBucket.size()];
            Double[] factorBucket1 = new Double[factorBucket.size()];
            biasBucket1 = biasBucket.toArray(biasBucket1);
            factorBucket1 = factorBucket.toArray(factorBucket1);

            Double[] expbiasBucket1 = expBiasBucket.toArray(new Double[expBiasBucket.size()]);
            Double[] expFactorBucket1 = expFactorBucket.toArray(new Double[expFactorBucket.size()]);


            double reduceFactor = getConfidenceWeight(appCvr3day, cvrBucket1, reFactor1, 1.0);

            for (ExploreInfo info : res) {
                HashMap<String, Object> giveUpReason = new HashMap<String, Object>();
                giveUpReason.put(ReasonType.EXPLORE.getName(), "null");

                //调用加价接口，产生加价系数
//                double factor = adjustFactor(info, biasBucket1,factorBucket1);
                double factor = adjustFactorNew(info, biasBucket1, factorBucket1,expbiasBucket1,expFactorBucket1,biasWeight,supportLimit);
                double factor1 = Math.max(factor * reduceFactor,1.0);
                exploreResultList.add(new ExploreResult(info.getAdvertId(), info.getOrientationId(), giveUpReason, factor1));

            }
            exploreSubList.removeAll(res);
            for (ExploreInfo info : exploreSubList) {
                //ucb过滤掉的结果
                HashMap<String, Object> giveUpReason = new HashMap<String, Object>();
                giveUpReason.put(ReasonType.GIVEUP4.getName(), info.ucbScore + "_" + info.objUcbInfo);
                exploreResultList.add(new ExploreResult(info.getAdvertId(), info.getOrientationId(), giveUpReason, null));

            }
        }
        return exploreResultList;
    }


    /**
     * 加价接口
     */
    public static double adjustFactor(ExploreInfo exploreInfo, Double[] biasBucket,Double[] factor) {
        double f = 1.0;
        long consume = exploreInfo.orientOcpcConsume;//消耗
        long conv = exploreInfo.orientConv.getOrDefault(exploreInfo.convertType,0L);//转化
        double cost = conv >= 5 ? division(division(consume, conv), exploreInfo.target) : 1.0;

        f = getConfidenceWeight(cost, biasBucket, factor, 1.0);

        return f;
    }

    /**
     * 加价接口2
     */
    public static double adjustFactorNew(ExploreInfo exploreInfo,
                                         Double[] biasBucket,
                                         Double[] factor,
                                         Double[] expBiasBucket,
                                         Double[] expFactor,
                                         Double biasWeight,
                                         Double supportLimit) {
        double f = 1.0;
        //配置成本
        long consume = exploreInfo.orientOcpcConsume;//消耗
        long conv = exploreInfo.orientConv.getOrDefault(exploreInfo.convertType,0L);//转化
        double cost = conv >= 5 ? division(division(consume, conv), exploreInfo.target) : 1.0;

        double f1 = getConfidenceWeight(cost, biasBucket, factor, 1.0);

        //拓量成本
        double exploreCost = 1.0;
        if(exploreInfo.orientExpCost != null && exploreInfo.orientExpCost.exploreAdjConsume > 3000) {
            exploreCost = division(exploreInfo.orientExpCost.exploreConsume, exploreInfo.orientExpCost.exploreAdjConsume);
        }else if(exploreInfo.appAdvertInfo.consume != null && exploreInfo.appAdvertInfo.consume.exploreAdjConsume > 5000){
            exploreCost = division(exploreInfo.appAdvertInfo.consume.exploreConsume, exploreInfo.appAdvertInfo.consume.exploreAdjConsume);
        }else if(exploreInfo.appAccountInfo.consume != null && exploreInfo.appAccountInfo.consume.exploreAdjConsume > 5000){
            exploreCost = division(exploreInfo.appAccountInfo.consume.exploreConsume, exploreInfo.appAccountInfo.consume.exploreAdjConsume);
        }else{
            biasWeight = 1.0;
        }
        double f2 = getConfidenceWeight(exploreCost, expBiasBucket, expFactor, 1.0);

        f = biasWeight * f1 + (1 - biasWeight) * f2;

        if(exploreInfo.supportWeight > 1.0){
            f = Math.max(f,Math.min(f * exploreInfo.supportWeight * 0.5,supportLimit));
        }

        return f;
    }


    public static Integer getCntLimit(Long convCnt,
                                      List<Integer> convbucket,
                                      List<Integer> cntbucket) {
        if(AssertUtil.isAnyEmpty(convCnt,convbucket,cntbucket)){
            return 10;
        }
        if(convCnt <= convbucket.get(0)){
            return cntbucket.get(0);
        } else if(convCnt <= convbucket.get(1)){
            return cntbucket.get(1);
        } else if(convCnt <= convbucket.get(2)){
            return cntbucket.get(2);
        } else{
            return cntbucket.get(3);
        }

    }


    public static Double getConfidenceWeight(Double value, Double[] bucketList, Double[] weightList, double defaultValue) {

        Double ret = defaultValue;

        if (value != null && bucketList != null && bucketList.length > 0 && weightList != null && weightList.length == bucketList.length) {

            double lastWeight = weightList[0];
            double lastBound = bucketList[0];

            for (int i = 0, size = bucketList.length; i < size; i++) {
                double curWeight = weightList[i];
                double curBound = bucketList[i];

                double bound = bucketList[i];
                if (value <= bound) {

                    if (i > 0) {
                        ret = lastWeight + (curWeight - lastWeight) * (value - lastBound) / (curBound - lastBound);
                    } else {
                        ret = weightList[0];
                    }
                    break;

                } else if (i == size - 1) {
                    ret = weightList[size - 1];
                }

                lastWeight = weightList[i];
                lastBound = bucketList[i];
            }

        }

        return DataUtil.formatDouble(ret, 3);
    }



    public static void main(String[] args) {
        System.out.println(division(2L,10L));
        List a = new ArrayList();
        List b = new ArrayList();

        b.add(1);
        b.add(1);
        b.add(2);
        b.add(3);
        b.add(4);
        a.addAll(b);
        a.add(5);
        a.removeAll(b);
        System.out.println(b.toString());
        System.out.println(a.toString());


//        System.out.println(getConfidenceWeight(0.15, biasBucket, factor, 1.0));

    }


}
