package cn.com.duiba.nezha.alg.common.model.advertexplore;

import com.alibaba.fastjson.JSON;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class ExploreV1Params {

    private double faithLevel = 2;  // 置信等级

    // 探索过滤
    private long mediaAdExpThreshold = 2000L;    // 周期媒体广告曝光次数阈值
    private double exploreConsumeRatio = 0.15;   // 当日广告探索消耗占比阈值
    private long exploreMaxConsume = 15000L;    // 当日广告最高探索消耗
    private long exploreMinConsume = 3000L;     // 当日广告探索消耗达到这个阈值时，探索比例阈值生效

    // 劣质媒体过滤
    private double appMinRatio = 0.1;   // 最小过滤比例
    private double appCpmRatio = 0.2;   // 媒体cpm过滤比例
    private double appCvrRatio = 0.1;   // 媒体落地页cvr过滤比例
    private double appCpmBase = 23;     // 大盘cpm
    private double appCvrBase = 0.12;   // 大盘落地页cvr

    // 出价过滤
    private double bottomFee = 15;  // 底价
    private double bottomRatio = 0.2;   // 底价比例

    // CTR
    // 默认值按照(150,0.5),(300,0.9)设置，结果高估的不得了，还是把预估值起步0.9了得了，按(0,0.9) (1,0.9)设置
    private double ctrWeightThreshold = 0.9;  // ctr单个维度上的权重阈值
    private double thetaCtr=0.0;   // 线性函数参数
    private double betaCtr=-2.2;    // 偏移参数

    // CVR
    // 默认值按照(150,0.5),(300,0.9)设置
    private double cvrWeightThreshold = 0.9;  // cvr单个维度上的权重阈值
    private double thetaCvr=0.014;   // 线性函数参数
    private double betaCvr=2.2;    // 偏移参数

    // COST
    private long costExpThreshold = Long.MAX_VALUE;  // 成本偏差，数量置信阈值, 默认为Long的最大值，此时成本权重不生效（为1）
    private double costWeightThreshold = 0.1;   // 成本权重上限，取值[1 - value, 1 + value]

    // NUM，默认值按(100, 0.08), (300, 0.001)设置
    private double thetaNum = 0.03;    // sigmoid系数函数
    private double betaNum = 4.5;     // sigmoid偏移函数
    private double numWeightThreshold = 0.001;    // 数量权重上限，最终数量权重取值[1, 1 + value]

    // cvr上限
    private double cvrBoundWeightThreshold=0.5;  // 当预估值权重大于cvrBoundWeightThreshold的时候cvr
    // 上限生效，当预估值权重小的时候用预估值的cvrBoundRatio倍作为上限。
    private double cvrBoundRatio=1.5; // cvr上限生效时，上限为统计值的cvrBoundRatio倍

    //成本控制所用参数
    private double costFactorUpperBound=1.1; //因子的上限
    private double costFactorLowerBound=0.9; //因子的下限
    private double kp=0.3; //前一小时误差的参数
    private double ki=0.7; //前24小时累计误差的参数
    private long costControlClickCntThreshold=100L; //点击次数门槛，对于使用比例误差的controller点击次数大于此值的误差才算数

    // 竞价成功率控制参数
    private double bidFactorUpperBound = 1.1; // 上限
    private double bidFactorLowerBound = 1.0; // 下限
    private double bidKp = 0.3; // 前一小时误差权重
    private double bidKi = 0.7; // 前24小时累计误差权重
    private long bidReqCntThreshold = 500;   // 大盘参与竞价次数阈值，大盘参与竞价次数大于阈值时，pid生效
    private double targetRatio = 0.3;   // 目标竞价成功率比例
}
