package cn.com.duiba.nezha.alg.common.model.advertexplore.expcontroller;

import cn.com.duiba.nezha.alg.common.model.advertexplore.ExpHourData;
import cn.com.duiba.nezha.alg.common.model.advertexplore.HourDto;
import cn.com.duiba.nezha.alg.common.model.advertexplore.WeightDimEnum;
import cn.com.duiba.nezha.alg.common.model.advertexplore.WeightInfo;
import cn.com.duiba.nezha.alg.common.util.DataUtil;

public class BidPidController {
    public static WeightInfo calcControlFactor(ExpHourData expHourData,
                                    ExpHourData baseHourData,
                                    Long bidReqCntThreshold,
                                    Double targetRatio,
                                    Double upperBound, Double lowerBound,
                                    Double kp, Double ki, WeightDimEnum dim) {

        // 比例误差
        double errorCurrent = errorDiff(expHourData, baseHourData, bidReqCntThreshold, targetRatio);
        // 积分比例误差
        double errorIntegral = errorIntegral(expHourData, baseHourData, bidReqCntThreshold, targetRatio);

        double kt = kp * errorCurrent + ki * errorIntegral;

        double unboundK = responseFunc(kt);

        double k = (Double.isInfinite(unboundK) || Double.isNaN(unboundK)) ? 1.0 : bound(unboundK, upperBound, lowerBound);

        return new WeightInfo(dim.getId(), 0L, DataUtil.formatDouble(errorCurrent, 5), DataUtil.formatDouble(k, 5));
    }

    //比率形式算偏差
    static private double errorDiff(ExpHourData expHourData, ExpHourData baseHourData, Long baseBidReqCntThreshold, Double targetRatio) {
        // 拓量部分，前一小时
        HourDto expLastHourDto = expHourData.getHourDtoMap().getOrDefault(expHourData.getLastHour(), new HourDto());
        long bidReqCount = expLastHourDto.getBidReqCount();
        double bidSuccessRatio = expHourData.getBidSuccessRatioLastHour();

        // 大盘，前一小时
        HourDto baseLastHourDto = baseHourData.getHourDtoMap().getOrDefault(baseHourData.getLastHour(), new HourDto());
        Long baseBidReqCount = baseLastHourDto.getBidReqCount();
        double baseBidSuccessRatio = baseHourData.getBidSuccessRatioLastHour();

        // 大盘竞价成功率是否置信
        if (baseBidReqCount <= baseBidReqCntThreshold || bidSuccessRatio == 0) {
            return 0.0;
        }

        // 目标竞价成功率 = 大盘竞价成功率 * 比例参数
        double targetBidSuccessRatio = baseBidSuccessRatio * targetRatio;

        return targetBidSuccessRatio / bidSuccessRatio - 1.0;
    }

    //累计偏差
    static private double errorIntegral(ExpHourData expHourData, ExpHourData baseHourData, Long baseBidReqCntThreshold, Double targetRatio) {
        // 探索部分，24小时
        double bidSuccessRatio = expHourData.getBidSuccessRatio24Hour();

        // 大盘部分，24小时
        long bidReq24Hour = 0L;
        for (HourDto hourDto : baseHourData.getHourDtoMap().values()) {
            bidReq24Hour = bidReq24Hour + hourDto.getBidReqCount();
        }
        double baseBidSuccessRatio = baseHourData.getBidSuccessRatio24Hour();

        // 大盘竞价成功率是否置信
        if (bidReq24Hour <= baseBidReqCntThreshold || bidSuccessRatio == 0) {
            return 0.0;
        }

        // 目标竞价成功率 = 大盘竞价成功率 * 比例参数
        double targetBidSuccessRatio = baseBidSuccessRatio * targetRatio;

        return targetBidSuccessRatio / bidSuccessRatio - 1.0;
    }

    //响应函数
    static private double responseFunc(double kt) {
        return kt + 1.0;
    }

    static private double bound(Double value, Double upperBound, Double lowerBound) {
        if (value > upperBound) {
            return upperBound;
        } else if (value < lowerBound) {
            return lowerBound;
        } else {
            return value;
        }
    }

    public static void main(String[] args) {
        double v = 1 / 0.3;
        System.out.println(v);
        double a = (Double.isInfinite(v) || Double.isNaN(v)) ? 1.0 : bound(v, 1.2D, 0.1D);

        Double aDouble = DataUtil.formatDouble(a, 4);
        System.out.println(aDouble);
    }
}
