package cn.com.duiba.nezha.alg.common.model.advertexplore;


import lombok.Getter;
import lombok.Setter;

import java.util.Map;
import java.util.Objects;

@Getter
@Setter

public class ExploreResult {
    Long advertId;
    Long orientationId;
    Map<String,Object> giveUpReason;//-1 表示探索 -2表示利用
    Double exploreFactor;//探索流量的加价系数


    public ExploreResult() {
    }

    public ExploreResult(Long advertId, Long orientationId, Map<String, Object> giveUpReason, Double exploreFactor) {
        this.advertId = advertId;
        this.orientationId = orientationId;
        this.giveUpReason = giveUpReason;
        this.exploreFactor = exploreFactor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ExploreResult)) return false;
        ExploreResult that = (ExploreResult) o;
        return Objects.equals(getAdvertId(), that.getAdvertId()) &&
                Objects.equals(getOrientationId(), that.getOrientationId());
    }

    @Override
    public int hashCode() {

        return Objects.hash(getAdvertId(), getOrientationId());
    }
}
